/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.alibaba.fastjson.JSON;
import com.aliyun.opensearch.sdk.dependencies.com.google.gson.Gson;
import com.tydic.externalinter.atom.ExterBusinessAtomService;
import com.tydic.externalinter.atom.ExterCallModeAtomService;
import com.tydic.externalinter.atom.ExterSysCallQueryHisAtomService;
import com.tydic.externalinter.atom.ExterSysCallSyncHisAtomService;
import com.tydic.externalinter.atom.ExterSystemDefineAtomService;
import com.tydic.externalinter.atom.bo.ExterBusinessAtomBO;
import com.tydic.externalinter.atom.bo.ExterCallModeAtomBO;
import com.tydic.externalinter.atom.bo.ExterSystemDefineAtomBO;
import com.tydic.externalinter.bo.ExternaLinterResultData;
import com.tydic.externalinter.busi.bo.PublicCallExtReqBO;
import com.tydic.externalinter.busi.service.PublicCallExtService;
import com.tydic.externalinter.thread.SaveExtServiceResultThread;
import com.tydic.externalinter.util.CTMSUtils;
import com.tydic.externalinter.util.CommonAPIServiceUtils;
import com.tydic.externalinter.util.DesUtil;
import com.tydic.externalinter.util.ECSSUtils;
import com.tydic.externalinter.util.EncryptionUtils;
import com.tydic.externalinter.util.ErpServiceUtils;
import com.tydic.externalinter.util.HttpApiUtils;
import com.tydic.externalinter.util.MAGICUtils;
import com.tydic.externalinter.util.ScmServiceUtils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PublicCallExtServiceImpl
implements PublicCallExtService {
    private static Logger logger = LoggerFactory.getLogger(PublicCallExtServiceImpl.class);
    @Autowired
    private ExterBusinessAtomService exterBusinessAtomService;
    @Autowired
    private ExterCallModeAtomService exterCallModeAtomService;
    @Autowired
    private ExterSystemDefineAtomService exterSystemDefineAtomService;
    @Autowired
    private ExterSysCallQueryHisAtomService exterSysCallQueryHisAtomService;
    @Autowired
    private ExterSysCallSyncHisAtomService exterSysCallSyncHisAtomService;

    public ExternaLinterResultData callService(PublicCallExtReqBO reqBO) {
        logger.debug("\u5916\u90e8\u63a5\u53e3\u7edf\u4e00\u8c03\u7528\u670d\u52a1\u5165\u53c2" + JSON.toJSONString((Object)reqBO));
        ExternaLinterResultData resultData = null;
        if (null == reqBO || StringUtils.isBlank((CharSequence)reqBO.getBusiCode()) || null == reqBO.getReqParam()) {
            return new ExternaLinterResultData(Boolean.valueOf(false), "\u5165\u53c2%s\u4e3a\u7a7a", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ExterBusinessAtomBO exterBusinessReqBO = new ExterBusinessAtomBO();
        exterBusinessReqBO.setBusiCode(reqBO.getBusiCode());
        List<ExterBusinessAtomBO> exterBusinessRspBOs = this.exterBusinessAtomService.selectInfoByCondition(exterBusinessReqBO);
        ExterBusinessAtomBO exterBusinessAtomBO = exterBusinessRspBOs.get(0);
        ExterCallModeAtomBO exterCallModeAtomReqBO = new ExterCallModeAtomBO();
        exterCallModeAtomReqBO.setModeId(exterBusinessAtomBO.getModeId());
        ExterCallModeAtomBO exterCallModeAtomRspBO = this.exterCallModeAtomService.selectByPrimaryKey(exterCallModeAtomReqBO);
        if (null == exterCallModeAtomRspBO || StringUtils.isBlank((CharSequence)exterCallModeAtomRspBO.getModeType()) || StringUtils.isBlank((CharSequence)exterCallModeAtomRspBO.getProtocol()) || StringUtils.isBlank((CharSequence)exterCallModeAtomRspBO.getReqType()) || StringUtils.isBlank((CharSequence)exterCallModeAtomRspBO.getDomain())) {
            return new ExternaLinterResultData(Boolean.valueOf(false), "0017", "\u63a5\u5165\u65b9\u5f0f\u914d\u7f6e\u5f02\u5e38");
        }
        ExterSystemDefineAtomBO exterSystemDefineAtomReqBO = new ExterSystemDefineAtomBO();
        exterSystemDefineAtomReqBO.setSystemCode(exterBusinessAtomBO.getSystemCode());
        List<ExterSystemDefineAtomBO> exterSystemDefineAtomRspBOS = this.exterSystemDefineAtomService.selectInfoByCondition(exterSystemDefineAtomReqBO);
        ExterSystemDefineAtomBO exterSystemDefineAtomRspBO = exterSystemDefineAtomRspBOS.get(0);
        String domain = exterCallModeAtomRspBO.getDomain();
        String reqUrl = exterBusinessAtomBO.getReqUrl();
        long startTime = System.currentTimeMillis();
        switch (exterCallModeAtomRspBO.getModeType()) {
            case "1": {
                if ("EX_SYS_12_001".equals(reqBO.getBusiCode()) && null == reqBO.getOldRecordId()) {
                    Gson gson = new Gson();
                    reqBO.setReqParam((Object)gson.toJson(reqBO.getReqParam()));
                } else {
                    reqBO.setReqParam((Object)JSON.toJSON((Object)reqBO.getReqParam()).toString());
                }
                if ("03".equals(exterSystemDefineAtomRspBO.getSystemSource())) {
                    if (StringUtils.isBlank((CharSequence)exterCallModeAtomRspBO.getParam1()) || StringUtils.isBlank((CharSequence)exterCallModeAtomRspBO.getParam2())) {
                        logger.error("\u52a0\u5bc6\u53c2\u6570\u4e3a\u7a7a");
                        return new ExternaLinterResultData(Boolean.valueOf(false), "0011", "\u52a0\u5bc6\u53c2\u6570\u4e3a\u7a7a");
                    }
                    resultData = CommonAPIServiceUtils.commonUIPService(domain, reqUrl, reqBO.getReqParam(), exterCallModeAtomRspBO.getParam1(), exterCallModeAtomRspBO.getParam2(), reqBO);
                    break;
                }
                if ("01".equals(exterSystemDefineAtomRspBO.getSystemSource())) {
                    if (StringUtils.isBlank((CharSequence)exterCallModeAtomRspBO.getParam1()) || StringUtils.isBlank((CharSequence)exterCallModeAtomRspBO.getParam2())) {
                        logger.error("\u52a0\u5bc6\u53c2\u6570\u4e3a\u7a7a");
                        return new ExternaLinterResultData(Boolean.valueOf(false), "0011", "\u52a0\u5bc6\u53c2\u6570\u4e3a\u7a7a");
                    }
                    resultData = ErpServiceUtils.erpService(domain, reqUrl, reqBO.getReqParam(), exterCallModeAtomRspBO.getParam1(), exterCallModeAtomRspBO.getParam2(), reqBO);
                    break;
                }
                if ("POST".equals(exterCallModeAtomRspBO.getReqType())) {
                    ExternaLinterResultData encryptRsp;
                    if ("1".equals(exterCallModeAtomRspBO.getIsEncrypt()) && !(encryptRsp = this.encrypt(reqBO, exterCallModeAtomRspBO)).getSuccess().booleanValue()) {
                        return encryptRsp;
                    }
                    logger.debug("\u53d1\u9001\u8bf7\u6c42\u53c2\u6570\u7c7b\u578b" + JSON.toJSONString((Object)exterCallModeAtomRspBO.getParam7()));
                    resultData = HttpApiUtils.post(domain + reqUrl, reqBO, exterCallModeAtomRspBO.getParam7());
                    break;
                }
                logger.error("\u63a5\u5165\u65b9\u5f0f\u914d\u7f6e\u5f02\u5e38\uff1a\u8bf7\u6c42\u65b9\u5f0f\u5f02\u5e38");
                return new ExternaLinterResultData(Boolean.valueOf(false), "0011", "\u63a5\u5165\u65b9\u5f0f\u914d\u7f6e\u5f02\u5e38\uff1a\u8bf7\u6c42\u65b9\u5f0f\u5f02\u5e38");
            }
            case "2": {
                logger.info("SOAP\u8c03\u7528");
                if (StringUtils.isNotBlank((CharSequence)reqBO.getWhichOne())) {
                    resultData = ScmServiceUtils.callService(reqBO.getWhichOne(), domain, reqUrl, reqBO.getReqParam(), exterCallModeAtomRspBO.getParam1(), reqBO);
                    reqBO.setReqParam(JSON.toJSON((Object)reqBO.getReqParam()));
                    break;
                }
                if (null == reqBO.getOldRecordId()) {
                    resultData = ScmServiceUtils.callService(domain, reqUrl, reqBO.getReqParam(), exterCallModeAtomRspBO.getParam1(), reqBO);
                    reqBO.setReqParam(JSON.toJSON((Object)reqBO.getReqParam()));
                    break;
                }
                resultData = ScmServiceUtils.callService(domain, reqUrl, reqBO.getReqParamE(), exterCallModeAtomRspBO.getParam1());
                break;
            }
            default: {
                logger.error("\u63a5\u5165\u65b9\u5f0f\u914d\u7f6e\u5f02\u5e38\uff1a\u63a5\u5165\u65b9\u5f0f\u7c7b\u578b\u5f02\u5e38");
                return new ExternaLinterResultData(Boolean.valueOf(false), "0011", "\u63a5\u5165\u65b9\u5f0f\u914d\u7f6e\u5f02\u5e38\uff1a\u63a5\u5165\u65b9\u5f0f\u7c7b\u578b\u5f02\u5e38");
            }
        }
        long time = System.currentTimeMillis() - startTime;
        new Thread(new SaveExtServiceResultThread(this.exterSysCallQueryHisAtomService, this.exterSysCallSyncHisAtomService, exterBusinessAtomBO, exterCallModeAtomRspBO, reqBO, resultData, time)).start();
        return resultData;
    }

    private ExternaLinterResultData encrypt(PublicCallExtReqBO reqBO, ExterCallModeAtomBO exterCallModeAtomRspBO) {
        if ("21".equals(exterCallModeAtomRspBO.getEncryptWay())) {
            String reqBoE;
            if (StringUtils.isBlank((CharSequence)exterCallModeAtomRspBO.getParam1()) || StringUtils.isBlank((CharSequence)exterCallModeAtomRspBO.getParam2()) || StringUtils.isBlank((CharSequence)exterCallModeAtomRspBO.getParam3())) {
                logger.error("\u52a0\u5bc6\u53c2\u6570\u4e3a\u7a7a");
                return new ExternaLinterResultData(Boolean.valueOf(false), "0011", "\u52a0\u5bc6\u53c2\u6570\u4e3a\u7a7a");
            }
            try {
                reqBoE = EncryptionUtils.getKDRBReqParam(reqBO.getReqParam(), exterCallModeAtomRspBO.getParam1(), exterCallModeAtomRspBO.getParam2(), exterCallModeAtomRspBO.getParam3());
            }
            catch (Exception e) {
                logger.error("\u52a0\u5bc6\u5904\u7406\u5f02\u5e38" + e.getMessage());
                return new ExternaLinterResultData(Boolean.valueOf(false), "0011", "\u52a0\u5bc6\u5904\u7406\u5f02\u5e38" + e.getMessage());
            }
            reqBO.setReqParamE((Object)reqBoE);
        } else if ("22".equals(exterCallModeAtomRspBO.getEncryptWay())) {
            String reqBoE;
            if (StringUtils.isBlank((CharSequence)exterCallModeAtomRspBO.getParam2())) {
                logger.error("\u52a0\u5bc6\u53c2\u6570\u4e3a\u7a7a");
                return new ExternaLinterResultData(Boolean.valueOf(false), "0011", "\u52a0\u5bc6\u53c2\u6570\u4e3a\u7a7a");
            }
            try {
                reqBoE = EncryptionUtils.getHDTXReqParam(reqBO.getReqParam(), exterCallModeAtomRspBO.getParam2());
            }
            catch (Exception e) {
                logger.error("\u52a0\u5bc6\u5904\u7406\u5f02\u5e38" + e.getMessage());
                return new ExternaLinterResultData(Boolean.valueOf(false), "0011", "\u52a0\u5bc6\u5904\u7406\u5f02\u5e38" + e.getMessage());
            }
            reqBO.setReqParamE((Object)reqBoE);
        } else if ("23".equals(exterCallModeAtomRspBO.getEncryptWay())) {
            String reqBoE;
            if (StringUtils.isBlank((CharSequence)exterCallModeAtomRspBO.getParam2())) {
                logger.error("\u52a0\u5bc6\u53c2\u6570\u4e3a\u7a7a");
                return new ExternaLinterResultData(Boolean.valueOf(false), "0011", "\u52a0\u5bc6\u53c2\u6570\u4e3a\u7a7a");
            }
            try {
                reqBoE = EncryptionUtils.getNUONUOCSReqParam(reqBO.getReqParam(), exterCallModeAtomRspBO.getParam2());
            }
            catch (Exception e) {
                logger.error("\u52a0\u5bc6\u5904\u7406\u5f02\u5e38" + e.getMessage());
                return new ExternaLinterResultData(Boolean.valueOf(false), "0011", "\u52a0\u5bc6\u5904\u7406\u5f02\u5e38" + e.getMessage());
            }
            reqBO.setReqParamE((Object)reqBoE);
        } else if ("24".equals(exterCallModeAtomRspBO.getEncryptWay())) {
            String reqBoE;
            if (StringUtils.isBlank((CharSequence)exterCallModeAtomRspBO.getParam1()) || StringUtils.isBlank((CharSequence)exterCallModeAtomRspBO.getParam2())) {
                logger.error("\u52a0\u5bc6\u53c2\u6570\u4e3a\u7a7a");
                return new ExternaLinterResultData(Boolean.valueOf(false), "0011", "\u52a0\u5bc6\u53c2\u6570\u4e3a\u7a7a");
            }
            try {
                reqBoE = ECSSUtils.getECSSReqParam(reqBO.getReqParam(), exterCallModeAtomRspBO.getParam1(), exterCallModeAtomRspBO.getParam2());
            }
            catch (Exception e) {
                logger.error("\u52a0\u5bc6\u5904\u7406\u5f02\u5e38" + e.getMessage());
                return new ExternaLinterResultData(Boolean.valueOf(false), "0011", "\u52a0\u5bc6\u5904\u7406\u5f02\u5e38" + e.getMessage());
            }
            reqBO.setReqParamE((Object)reqBoE);
        } else if ("25".equals(exterCallModeAtomRspBO.getEncryptWay())) {
            String reqBoE;
            if (StringUtils.isBlank((CharSequence)exterCallModeAtomRspBO.getParam1()) || StringUtils.isBlank((CharSequence)exterCallModeAtomRspBO.getParam2()) || StringUtils.isBlank((CharSequence)exterCallModeAtomRspBO.getParam3())) {
                logger.error("\u52a0\u5bc6\u53c2\u6570\u4e3a\u7a7a");
                return new ExternaLinterResultData(Boolean.valueOf(false), "0011", "\u52a0\u5bc6\u53c2\u6570\u4e3a\u7a7a");
            }
            try {
                reqBoE = MAGICUtils.getMAGICReqParam(reqBO.getReqParam(), exterCallModeAtomRspBO.getParam1(), exterCallModeAtomRspBO.getParam2(), exterCallModeAtomRspBO.getParam3());
            }
            catch (Exception e) {
                logger.error("\u52a0\u5bc6\u5904\u7406\u5f02\u5e38" + e.getMessage());
                return new ExternaLinterResultData(Boolean.valueOf(false), "0011", "\u52a0\u5bc6\u5904\u7406\u5f02\u5e38" + e.getMessage());
            }
            reqBO.setReqParamE((Object)reqBoE);
        } else if ("26".equals(exterCallModeAtomRspBO.getEncryptWay())) {
            String reqBoE;
            if (StringUtils.isBlank((CharSequence)exterCallModeAtomRspBO.getParam1()) || StringUtils.isBlank((CharSequence)exterCallModeAtomRspBO.getParam2())) {
                logger.error("\u52a0\u5bc6\u53c2\u6570\u4e3a\u7a7a");
                return new ExternaLinterResultData(Boolean.valueOf(false), "0011", "\u52a0\u5bc6\u53c2\u6570\u4e3a\u7a7a");
            }
            try {
                reqBoE = CTMSUtils.getCTMSReqParam(reqBO.getReqParam(), exterCallModeAtomRspBO.getParam1(), exterCallModeAtomRspBO.getParam2());
            }
            catch (Exception e) {
                logger.error("\u52a0\u5bc6\u5904\u7406\u5f02\u5e38" + e.getMessage());
                return new ExternaLinterResultData(Boolean.valueOf(false), "0011", "\u52a0\u5bc6\u5904\u7406\u5f02\u5e38" + e.getMessage());
            }
            reqBO.setReqParamE((Object)reqBoE);
        } else if ("27".equals(exterCallModeAtomRspBO.getEncryptWay())) {
            String reqBoE;
            if (StringUtils.isBlank((CharSequence)exterCallModeAtomRspBO.getParam2())) {
                logger.error("\u52a0\u5bc6\u53c2\u6570\u4e3a\u7a7a");
                return new ExternaLinterResultData(Boolean.valueOf(false), "0011", "\u52a0\u5bc6\u53c2\u6570\u4e3a\u7a7a");
            }
            try {
                reqBoE = DesUtil.encrypt_CBC(reqBO.getReqParam(), reqBO.getRetKey());
            }
            catch (Exception e) {
                logger.error("\u52a0\u5bc6\u5904\u7406\u5f02\u5e38" + e.getMessage());
                return new ExternaLinterResultData(Boolean.valueOf(false), "0011", "\u52a0\u5bc6\u5904\u7406\u5f02\u5e38" + e.getMessage());
            }
            reqBO.setReqParamE((Object)reqBoE);
        } else {
            logger.error("\u52a0\u5bc6\u65b9\u5f0f\u914d\u7f6e\u5f02\u5e38");
            return new ExternaLinterResultData(Boolean.valueOf(false), "0011", "\u52a0\u5bc6\u65b9\u5f0f\u914d\u7f6e\u5f02\u5e38");
        }
        return new ExternaLinterResultData(Boolean.valueOf(true));
    }
}

