/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.base.common.util.DateUtil;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.externalinter.ability.bo.QryScmOrderSyncRecordReqBO;
import com.tydic.externalinter.ability.bo.ScmOrderSyncItemBO;
import com.tydic.externalinter.ability.bo.ScmOrderSyncItemImeiBO;
import com.tydic.externalinter.ability.bo.ScmOrderSyncItemRecordReqBO;
import com.tydic.externalinter.ability.bo.ScmOrderSyncItemRecordRsqBO;
import com.tydic.externalinter.ability.bo.ScmOrderSyncItemRecordUnionImeiReqBO;
import com.tydic.externalinter.ability.bo.ScmOrderSyncItemReqBO;
import com.tydic.externalinter.ability.bo.ScmOrderSyncItemRspBO;
import com.tydic.externalinter.ability.bo.ScmOrderSyncRecordBO;
import com.tydic.externalinter.ability.bo.ScmOrderSyncRecordRspBO;
import com.tydic.externalinter.ability.bo.StoreSalesStatisticsRspBO;
import com.tydic.externalinter.atom.ScmOrderSyncItemAtomService;
import com.tydic.externalinter.atom.ScmOrderSyncItemImeiAtomService;
import com.tydic.externalinter.atom.ScmOrderSyncRecordAtomService;
import com.tydic.externalinter.busi.bo.ExtPageRspBO;
import com.tydic.externalinter.busi.bo.RspBaseBO;
import com.tydic.externalinter.busi.service.SynScmOrderRecordBusiService;
import com.tydic.externalinter.dao.po.StoreSalesStatisticsPO;
import com.tydic.externalinter.util.ConvertParamUtils;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.QryEscapeBO;
import com.tydic.newretail.toolkit.bo.RspBatchBaseBO;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import com.tydic.ordunr.ability.UnrQueryScmOrdAbilityService;
import com.tydic.ordunr.ability.bo.DealScmOrderReqBO;
import com.tydic.ordunr.base.bo.OrdUnrRspBaseBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SynScmOrderRecordBusiServiceImpl
implements SynScmOrderRecordBusiService {
    private static final Logger log = LoggerFactory.getLogger(SynScmOrderRecordBusiServiceImpl.class);
    @Autowired
    private ScmOrderSyncRecordAtomService scmOrderSyncRecordAtomService;
    @Autowired
    private ScmOrderSyncItemAtomService scmOrderSyncItemAtomService;
    @Autowired
    private ScmOrderSyncItemImeiAtomService scmOrderSyncItemImeiAtomService;
    @Resource(name="exterQryEscapeAtomService")
    private QryEscapeAtomService qryEscapeAtomService;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private UnrQueryScmOrdAbilityService unrQueryScmOrdAbilityService;

    public ExtPageRspBO<ScmOrderSyncRecordRspBO> listScmSyncOrderRecord(QryScmOrderSyncRecordReqBO reqBO) {
        List<ScmOrderSyncRecordBO> pos;
        log.debug("\u67e5\u8be2scm\u540c\u6b65\u8ba2\u5355\u8bb0\u5f55\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO.toString()));
        Page page = new Page();
        page.setPageNo(reqBO.getPageNo().intValue());
        page.setPageSize(reqBO.getPageSize().intValue());
        page.setLimit(reqBO.getPageSize().intValue());
        page.setOffset(reqBO.getPageSize() * (reqBO.getPageNo() - 1));
        page.setPageNo(reqBO.getPageNo().intValue());
        page.setPageSize(reqBO.getPageSize().intValue());
        ScmOrderSyncRecordBO record = new ScmOrderSyncRecordBO();
        if (StringUtils.isEmpty((CharSequence)reqBO.getOrgTreePath())) {
            reqBO.setOrgTreePath(reqBO.getmOrgPath());
        }
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        try {
            pos = this.scmOrderSyncRecordAtomService.selectByPage(record, (Page<Map<String, Object>>)page);
        }
        catch (Exception e) {
            log.error("\u5206\u9875\u67e5\u8be2scm\u540c\u6b65\u8ba2\u5355\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
            return new ExtPageRspBO("0003", "\u5206\u9875\u67e5\u8be2scm\u540c\u6b65\u8ba2\u5355\u8bb0\u5f55\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(pos)) {
            return new ExtPageRspBO("0000", "\u672a\u67e5\u8be2\u5230\u7ed3\u679c\u96c6");
        }
        ArrayList<ScmOrderSyncRecordRspBO> bos = new ArrayList<ScmOrderSyncRecordRspBO>(pos.size());
        for (ScmOrderSyncRecordBO po : pos) {
            Object cityNmae;
            Object proviceNmae;
            Object shopNmae;
            ScmOrderSyncRecordRspBO bo = new ScmOrderSyncRecordRspBO();
            BeanUtils.copyProperties((Object)po, (Object)bo);
            ConvertParamUtils.escaptScmOrderSyncRecord(bo, this.qryEscapeAtomService);
            if (StringUtils.isNotEmpty((CharSequence)bo.getShopCode()) && null != (shopNmae = this.cacheClient.get("AUTHORITY_TYPE_store_id_" + bo.getShopCode()))) {
                bo.setShopCodeStr(shopNmae.toString());
            }
            if (StringUtils.isNotEmpty((CharSequence)bo.getProvinceCode()) && null != (proviceNmae = this.cacheClient.get("AUTHORITY_TYPE_store_id_" + bo.getProvinceCode()))) {
                bo.setProvinceCodeStr(proviceNmae.toString());
            }
            if (StringUtils.isNotEmpty((CharSequence)bo.getCityCode()) && null != (cityNmae = this.cacheClient.get("AUTHORITY_TYPE_store_id_" + bo.getCityCode()))) {
                bo.setCityCodeStr(cityNmae.toString());
            }
            bos.add(bo);
        }
        return new ExtPageRspBO("0000", "\u64cd\u4f5c\u6210\u529f", bos, page.getTotalCount(), page.getTotalPages());
    }

    public ScmOrderSyncItemRspBO getSynScmOrderDetail(ScmOrderSyncRecordBO reqBO) {
        List<ScmOrderSyncItemBO> rspList;
        Object cityNmae;
        Object proviceNmae;
        Object shopNmae;
        ScmOrderSyncRecordBO rspBO;
        ScmOrderSyncItemRspBO result = new ScmOrderSyncItemRspBO();
        ArrayList<ScmOrderSyncItemBO> detailBOS = new ArrayList<ScmOrderSyncItemBO>();
        log.debug("scm\u540c\u6b65\u8ba2\u5355\u8be6\u60c5\u67e5\u8be2\u5165\u53c2" + reqBO.toString());
        if (null == reqBO.getId()) {
            log.debug("\u5165\u53c2\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u5165\u53c2\u4e3a\u7a7a");
        }
        try {
            rspBO = this.scmOrderSyncRecordAtomService.selectScmOrderSyncRecordByID(reqBO);
        }
        catch (Exception e) {
            log.debug("scm\u540c\u6b65\u8ba2\u5355\u8bb0\u5f55\u8be6\u60c5\u67e5\u8be2\u5f02\u5e38\uff1a" + e.getMessage());
            throw new ResourceException("9999", "scm\u540c\u6b65\u8ba2\u5355\u8bb0\u5f55\u8be6\u60c5\u67e5\u8be2\u5f02\u5e38");
        }
        if (null == rspBO) {
            log.debug("\u672a\u67e5\u8be2\u5230\u7ed3\u679c");
            result.setRespDesc("\u672a\u67e5\u8be2\u5230\u7ed3\u679c");
            result.setRespCode("0000");
            return result;
        }
        BeanUtils.copyProperties((Object)rspBO, (Object)result);
        ConvertParamUtils.escaptScmOrderSyncRecord2(result, this.qryEscapeAtomService);
        if (StringUtils.isNotEmpty((CharSequence)result.getShopCode()) && null != (shopNmae = this.cacheClient.get("AUTHORITY_TYPE_store_id_" + result.getShopCode()))) {
            result.setShopCodeStr(shopNmae.toString());
        }
        if (StringUtils.isNotEmpty((CharSequence)result.getProvinceCode()) && null != (proviceNmae = this.cacheClient.get("AUTHORITY_TYPE_store_id_" + result.getProvinceCode()))) {
            result.setProvinceCodeStr(proviceNmae.toString());
        }
        if (StringUtils.isNotEmpty((CharSequence)result.getCityCode()) && null != (cityNmae = this.cacheClient.get("AUTHORITY_TYPE_store_id_" + result.getCityCode()))) {
            result.setCityCodeStr(cityNmae.toString());
        }
        ScmOrderSyncItemReqBO record = new ScmOrderSyncItemReqBO();
        ArrayList<ScmOrderSyncItemBO> list = new ArrayList<ScmOrderSyncItemBO>();
        ScmOrderSyncItemBO bo = new ScmOrderSyncItemBO();
        bo.setBvbeln(rspBO.getBvbeln());
        list.add(bo);
        record.setItem(list);
        try {
            rspList = this.scmOrderSyncItemAtomService.selectScmOrderSyncItemByList(record);
        }
        catch (Exception e) {
            log.debug("scm\u540c\u6b65\u8ba2\u5355\u8bb0\u5f55\u8be6\u60c5\u67e5\u8be2\u5f02\u5e38\uff1a" + e.getMessage());
            throw new ResourceException("9999", "scm\u540c\u6b65\u8ba2\u5355\u8be6\u60c5\u67e5\u8be2\u5f02\u5e38");
        }
        if (CollectionUtils.isEmpty(rspList)) {
            log.debug("\u672a\u67e5\u8be2\u5230\u7ed3\u679c\u96c6");
            result.setRespDesc("\u672a\u67e5\u8be2\u5230\u7ed3\u679c\u96c6");
            result.setRespCode("0000");
            return result;
        }
        for (ScmOrderSyncItemBO po : rspList) {
            ScmOrderSyncItemBO rspbo = new ScmOrderSyncItemBO();
            BeanUtils.copyProperties((Object)po, (Object)rspbo);
            ConvertParamUtils.escaptScmOrderSyncItem(rspbo, this.qryEscapeAtomService);
            detailBOS.add(rspbo);
            ScmOrderSyncItemImeiBO scmOrderSyncItemImeiBO = new ScmOrderSyncItemImeiBO();
            scmOrderSyncItemImeiBO.setBvbeln(po.getBvbeln());
            scmOrderSyncItemImeiBO.setBposnr(po.getBposnr());
            ArrayList<ScmOrderSyncItemImeiBO> detailMeiBOS = new ArrayList<ScmOrderSyncItemImeiBO>();
            List<ScmOrderSyncItemImeiBO> rspBOS = this.scmOrderSyncItemImeiAtomService.selectByCondition(scmOrderSyncItemImeiBO);
            if (CollectionUtils.isNotEmpty(rspBOS)) {
                for (ScmOrderSyncItemImeiBO po1 : rspBOS) {
                    ScmOrderSyncItemImeiBO bo1 = new ScmOrderSyncItemImeiBO();
                    BeanUtils.copyProperties((Object)po1, (Object)bo1);
                    ConvertParamUtils.escaptScmOrderSyncItemMei(bo1, this.qryEscapeAtomService);
                    detailMeiBOS.add(bo1);
                }
            }
            rspbo.setDetailMeiBOS(detailMeiBOS);
        }
        result.setDetailBOS(detailBOS);
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        result.setRespCode("0000");
        return result;
    }

    public RspBatchBaseBO<QryEscapeBO> listScmOrderRecordStatus() {
        List<QryEscapeBO> list = this.getEscapes("SYN_SCM_ORDER_RECORD_STATUS", true);
        return new RspBatchBaseBO("0000", "\u64cd\u4f5c\u6210\u529f", list);
    }

    public RspBatchBaseBO<QryEscapeBO> listScmOrderRecordType() {
        List<QryEscapeBO> list = this.getEscapes("SYN_SCM_ORDER_TYPE", true);
        return new RspBatchBaseBO("0000", "\u64cd\u4f5c\u6210\u529f", list);
    }

    private List<QryEscapeBO> getEscapes(String parentCode, boolean needAll) {
        ArrayList<QryEscapeBO> list = new ArrayList<QryEscapeBO>();
        List escapeBOS = this.qryEscapeAtomService.listEscapeByParentCode(parentCode);
        if (CollectionUtils.isEmpty((Collection)escapeBOS)) {
            return null;
        }
        list.addAll(escapeBOS);
        return list;
    }

    public RspBatchBaseBO<ScmOrderSyncItemRecordRsqBO> listScmSyncOrderItemRecord(ScmOrderSyncItemRecordReqBO reqBO) {
        RspBatchBaseBO res = new RspBatchBaseBO("0000", "scm\u8ba2\u5355\u540c\u6b65\u660e\u7ec6\u53ca\u8bb0\u5f55\u67e5\u8be2\u6210\u529f");
        log.info("scm\u8ba2\u5355\u540c\u6b65\u660e\u7ec6\u53ca\u8bb0\u5f55\u5165\u53c2------------" + JSON.toJSONString((Object)reqBO));
        try {
            List<ScmOrderSyncItemRecordRsqBO> rsp = this.scmOrderSyncItemAtomService.listScmSyncOrderItemRecord(reqBO);
            if (CollectionUtils.isNotEmpty(rsp)) {
                rsp.forEach(item -> {
                    ConvertParamUtils.escaptScmSyncOrderItemRecord(item, this.qryEscapeAtomService);
                    item.setCreateTime(DateUtil.dateToStr((Date)DateUtil.strToDate((String)item.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyy-MM-dd HH:mm:ss"));
                    item.setUpdateTime(DateUtil.dateToStr((Date)DateUtil.strToDate((String)item.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyy-MM-dd HH:mm:ss"));
                });
                res.setRows(rsp);
            } else {
                res.setRespDesc("scm\u8ba2\u5355\u540c\u6b65\u660e\u7ec6\u53ca\u8bb0\u5f55\u67e5\u8be2\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            log.error("scm\u8ba2\u5355\u540c\u6b65\u660e\u7ec6\u53ca\u8bb0\u5f55\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
            return new RspBatchBaseBO("9999", "scm\u8ba2\u5355\u540c\u6b65\u660e\u7ec6\u53ca\u8bb0\u5f55\u67e5\u8be2\u5931\u8d25");
        }
        return res;
    }

    public RspBaseBO updateSynScmOrderEditResult(ScmOrderSyncItemRecordUnionImeiReqBO reqBO) {
        RspBaseBO res = new RspBaseBO("0000", "\u4fee\u6539\u6210\u529f");
        log.info("\u63d0\u4ea4\u4fee\u6539scm\u8ba2\u5355\u540c\u6b65\u5165\u53c2----------" + JSON.toJSONString((Object)reqBO));
        if (reqBO == null || StringUtils.isBlank((CharSequence)reqBO.getBvbeln()) || StringUtils.isBlank((CharSequence)reqBO.getAuart())) {
            return this.errLogPrint(res, "\u4fee\u6539scm\u8ba2\u5355\u540c\u6b65----\u5165\u53c2\u4e3a\u7a7a");
        }
        boolean itemBosFlag = CollectionUtils.isEmpty((Collection)reqBO.getItemBOS());
        boolean vsartFlag = StringUtils.isBlank((CharSequence)reqBO.getVsart());
        int condition = itemBosFlag ? (vsartFlag ? 0 : 1) : (vsartFlag ? 2 : 3);
        switch (condition) {
            case 0: {
                return this.errLogPrint(res, "\u4fee\u6539\u6761\u4ef6\u4e3a\u7a7a");
            }
            case 1: {
                int recordRes = this.updateScmOrderSyncRecordByBvblen(reqBO);
                if (recordRes != 0) break;
                return this.errLogPrint(res, "\u4e1a\u52a1\u5c42\u4fee\u6539scm\u540c\u6b65\u5931\u8d25");
            }
            case 2: {
                RspBaseBO itemUpdateBO = this.updateScmSyncOrderItemByBo(reqBO);
                if (!StringUtils.equals((CharSequence)itemUpdateBO.getRespCode(), (CharSequence)"9999")) break;
                return this.errLogPrint(res, "\u4e1a\u52a1\u5c42\u4fee\u6539scm\u540c\u6b65\u660e\u7ec6\u5931\u8d25:" + itemUpdateBO.getRespDesc());
            }
            case 3: {
                int recordRes1 = this.updateScmOrderSyncRecordByBvblen(reqBO);
                if (recordRes1 == 0) {
                    return this.errLogPrint(res, "\u4e1a\u52a1\u5c42\u4fee\u6539scm\u540c\u6b65\u5931\u8d25");
                }
                RspBaseBO itemUpdateBo = this.updateScmSyncOrderItemByBo(reqBO);
                if (!StringUtils.equals((CharSequence)itemUpdateBo.getRespCode(), (CharSequence)"9999")) break;
                return this.errLogPrint(res, "\u4e1a\u52a1\u5c42\u4fee\u6539scm\u540c\u6b65\u660e\u7ec6\u5931\u8d25:" + itemUpdateBo.getRespDesc());
            }
        }
        return res;
    }

    public RspBaseBO updateSynScmOrderByBvbeln(ScmOrderSyncItemRecordUnionImeiReqBO reqBO) {
        RspBaseBO res = new RspBaseBO("0000", "\u4fee\u6539\u6210\u529f");
        log.info("\u63d0\u4ea4\u4fee\u6539scm\u8ba2\u5355\u88c5\u8fd0\u5165\u53c2----------" + JSON.toJSONString((Object)reqBO));
        if (reqBO == null || StringUtils.isBlank((CharSequence)reqBO.getBvbeln())) {
            return this.errLogPrint(res, "\u4fee\u6539scm\u8ba2\u5355\u540c\u6b65----\u5165\u53c2\u4e3a\u7a7a");
        }
        int recordRes = this.updateScmOrderSyncRecordByBvblen(reqBO);
        if (recordRes == 0) {
            return this.errLogPrint(res, "\u4e1a\u52a1\u5c42\u4fee\u6539scm\u540c\u6b65\u5931\u8d25");
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getVsart())) {
            DealScmOrderReqBO syncBO = new DealScmOrderReqBO();
            syncBO.setScmOrderCode(reqBO.getBvbeln());
            if ("01".equals(reqBO.getVsart())) {
                syncBO.setPurchaseTypeNew("1");
            }
            if ("02".equals(reqBO.getVsart())) {
                syncBO.setPurchaseTypeNew("2");
            }
            syncBO.setOperateType("01");
            log.debug("\u901a\u77e5\u8ba2\u5355\u5165\u53c2" + JSON.toJSONString((Object)syncBO));
            try {
                this.unrQueryScmOrdAbilityService.dealScmOrder(syncBO);
            }
            catch (Exception e) {
                log.error("\u540c\u6b65scm\u8ba2\u5355\u4fee\u6539\u88c5\u8fd0\u7c7b\u578b\u540c\u6b65\u7ed9\u8ba2\u5355\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return res;
    }

    public RspBaseBO deleteSynScmOrderItemImeiDetail(ScmOrderSyncItemRecordUnionImeiReqBO reqBO) {
        RspBaseBO res = new RspBaseBO("0000", "\u5220\u9664scm\u8ba2\u5355\u540c\u6b65\u8bb0\u5f55\u6210\u529f");
        if (reqBO == null || StringUtils.isBlank((CharSequence)reqBO.getBvbeln()) || StringUtils.isBlank((CharSequence)reqBO.getAuart())) {
            return this.errLogPrint(res, "\u5165\u53c2\u4e3a\u7a7a");
        }
        String bvbeln = reqBO.getBvbeln();
        DealScmOrderReqBO updScmBO = new DealScmOrderReqBO();
        if (reqBO.getDelAllFlag()) {
            try {
                this.scmOrderSyncRecordAtomService.deleteAllRecordByBvblen(bvbeln);
            }
            catch (Exception e) {
                return this.errLogPrint(res, "\u8ba2\u5355\u7f16\u53f7" + bvbeln + "\u5220\u9664\u8ba2\u5355\u5931\u8d25" + e.getMessage());
            }
            try {
                this.scmOrderSyncItemAtomService.deleteAllItemByBvblen(bvbeln);
            }
            catch (Exception e) {
                return this.errLogPrint(res, "\u8ba2\u5355\u7f16\u53f7" + bvbeln + "\u5220\u9664\u8ba2\u5355\u660e\u7ec6\u5931\u8d25" + e.getMessage());
            }
            try {
                int imeiRes = this.scmOrderSyncItemImeiAtomService.deleteAllImeiByBvblen(bvbeln);
                log.info("\u5220\u9664\u4e32\u7801\u660e\u7ec6\u8bb0\u5f55\u5171" + imeiRes + "\u6761");
            }
            catch (Exception e) {
                return this.errLogPrint(res, "\u8ba2\u5355\u7f16\u53f7" + bvbeln + "\u4e1a\u52a1\u5c42\u5220\u9664\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage());
            }
            RspBaseBO syncRes = this.scmSyncOrderMessage(null, updScmBO, bvbeln, null, reqBO.getAuart(), 1);
            if (StringUtils.equals((CharSequence)syncRes.getRespCode(), (CharSequence)"9999")) {
                return this.errLogPrint(res, syncRes.getRespDesc());
            }
        } else {
            if (CollectionUtils.isEmpty((Collection)reqBO.getItemBOS()) || reqBO.getItemBOS().get(0) == null) {
                return this.errLogPrint(res, "\u5165\u53c2\u8ba2\u5355\u884c\u660e\u7ec6\u4e3a\u7a7a");
            }
            List itemBos = reqBO.getItemBOS();
            if (StringUtils.isBlank((CharSequence)reqBO.getBposnr())) {
                return this.errLogPrint(res, "\u5165\u53c2\u8ba2\u5355\u884c\u53f7\u4e3a\u7a7a");
            }
            String bposnr = reqBO.getBposnr();
            int itemRes = this.deleteScmSyncOrderItemByBo(reqBO);
            if (itemRes == 0) {
                return this.errLogPrint(res, "\u8ba2\u5355\u7f16\u53f7" + bvbeln + "\u4e1a\u52a1\u5c42\u5220\u9664scm\u8ba2\u5355\u540c\u6b65\u8bb0\u5f55\u660e\u7ec6\u5931\u8d25\uff1a");
            }
            ScmOrderSyncItemBO itemBO = new ScmOrderSyncItemBO();
            for (ScmOrderSyncItemBO syncItemBO : itemBos) {
                if (!syncItemBO.getBvbeln().equals(reqBO.getBvbeln()) || !syncItemBO.getBposnr().equals(reqBO.getBposnr())) continue;
                BeanUtils.copyProperties((Object)syncItemBO, (Object)itemBO);
            }
            if (CollectionUtils.isNotEmpty((Collection)itemBO.getDelImeiList())) {
                itemBO.setDelImeiList(null);
            }
            try {
                int imeiRes = this.scmOrderSyncItemImeiAtomService.deleteScmOrderSyncItemImeisByimeis(itemBO);
                log.info("\u5220\u9664\u4e32\u7801\u660e\u7ec6\u5171" + imeiRes + "\u6761");
            }
            catch (Exception e) {
                return this.errLogPrint(res, "\u8ba2\u5355\u7f16\u53f7" + bvbeln + "\u4e1a\u52a1\u5c42\u5220\u9664\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage());
            }
            RspBaseBO syncRes = this.scmSyncOrderMessage(itemBO, updScmBO, bvbeln, bposnr, reqBO.getAuart(), 2);
            if (StringUtils.equals((CharSequence)syncRes.getRespCode(), (CharSequence)"9999")) {
                return this.errLogPrint(res, syncRes.getRespDesc());
            }
        }
        return res;
    }

    private RspBaseBO scmSyncOrderMessage(ScmOrderSyncItemBO itemBO, DealScmOrderReqBO updScmBO, String bvbeln, String bposnr, String auart, int delType) {
        RspBaseBO res = new RspBaseBO("0000", "\u66f4\u65b0scm\u540c\u6b65\u8ba2\u5355\u6210\u529f");
        String delTypeStr = "";
        switch (delType) {
            case 1: {
                delTypeStr = "\u6309\u5355\u5220\u9664";
                break;
            }
            case 2: {
                delTypeStr = "\u6309\u884c\u5220\u9664";
                break;
            }
            case 3: {
                delTypeStr = "\u6309\u4e32\u7801\u5220\u9664";
                break;
            }
        }
        try {
            RspBaseBO checkRes = this.checkAuart(itemBO, updScmBO, bvbeln, auart, delType);
            log.info("\u66f4\u65b0scm\u540c\u6b65\u8ba2\u5355\u5165\u53c2\uff1a" + JSON.toJSONString((Object)updScmBO));
            if (StringUtils.equals((CharSequence)checkRes.getRespCode(), (CharSequence)"9999")) {
                return new RspBaseBO("9999", delTypeStr + ":\u8ba2\u5355\u7f16\u53f7" + bvbeln + "\u66f4\u65b0scm\u540c\u6b65\u8ba2\u5355\u4fe1\u606f\u5165\u53c2\u5f02\u5e38\uff1a" + checkRes.getRespDesc());
            }
            OrdUnrRspBaseBO ordUnrRspBaseBO = this.unrQueryScmOrdAbilityService.dealScmOrder(updScmBO);
            if (StringUtils.equals((CharSequence)ordUnrRspBaseBO.getRespCode(), (CharSequence)"9999")) {
                return new RspBaseBO("9999", delTypeStr + ":\u8ba2\u5355\u7f16\u53f7[" + bvbeln + "],\u8ba2\u5355\u884c\u53f7[" + bposnr + "],\u66f4\u65b0scm\u540c\u6b65\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff1a" + ordUnrRspBaseBO.getRespDesc());
            }
        }
        catch (Exception e) {
            return new RspBaseBO("9999", delTypeStr + ":\u8ba2\u5355\u7f16\u53f7[" + bvbeln + "],\u8ba2\u5355\u884c\u53f7[" + bposnr + "],\u66f4\u65b0scm\u540c\u6b65\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
        }
        return res;
    }

    private RspBaseBO checkAuart(ScmOrderSyncItemBO itemBO, DealScmOrderReqBO updScmBO, String bvbeln, String auartStr, Integer delType) {
        int auart = 0;
        if (StringUtils.equals((CharSequence)auartStr, (CharSequence)"Z001") || StringUtils.equals((CharSequence)auartStr, (CharSequence)"Z004")) {
            auart = 1;
        } else if (StringUtils.equals((CharSequence)auartStr, (CharSequence)"Z005")) {
            auart = 5;
        }
        RspBaseBO res = new RspBaseBO("0000", "\u6821\u9a8c\u65e0\u8bef");
        if (auart == 0) {
            return this.errLogPrint(res, "\u8ba2\u5355\u7c7b\u578b\u9519\u8bef");
        }
        if (StringUtils.isBlank((CharSequence)bvbeln)) {
            return this.errLogPrint(res, "\u8ba2\u5355\u884c-\u66f4\u65b0scm\u540c\u6b65\u8ba2\u5355\u4fe1\u606f \u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a");
        }
        switch (delType) {
            case 1: {
                if (auart == 1) {
                    updScmBO.setScmOrderCode(bvbeln);
                    break;
                }
                if (auart != 5) break;
                updScmBO.setScmAfterOrderCode(bvbeln);
                break;
            }
            case 2: {
                if (itemBO == null) {
                    return this.errLogPrint(res, "\u8ba2\u5355\u884c-\u66f4\u65b0scm\u540c\u6b65\u8ba2\u5355\u4fe1\u606f \u8ba2\u5355\u884cbo\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)itemBO.getBposnr())) {
                    return this.errLogPrint(res, "\u8ba2\u5355\u884c-\u66f4\u65b0scm\u540c\u6b65\u8ba2\u5355\u4fe1\u606f \u8ba2\u5355\u884c\u4e3a\u7a7a");
                }
                if (auart == 1) {
                    updScmBO.setScmOrderCode(bvbeln);
                    updScmBO.setScmOrderItemCode(itemBO.getBposnr());
                    break;
                }
                if (auart != 5) break;
                updScmBO.setScmAfterOrderCode(bvbeln);
                updScmBO.setScmAfterOrderItemCode(itemBO.getBposnr());
                break;
            }
            case 3: {
                if (itemBO == null) {
                    return this.errLogPrint(res, "\u8ba2\u5355\u884c-\u66f4\u65b0scm\u540c\u6b65\u8ba2\u5355\u4fe1\u606f \u8ba2\u5355\u884cbo\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)itemBO.getBposnr())) {
                    return this.errLogPrint(res, "\u8ba2\u5355\u884c-\u66f4\u65b0scm\u540c\u6b65\u8ba2\u5355\u4fe1\u606f \u8ba2\u5355\u884c\u4e3a\u7a7a");
                }
                if (CollectionUtils.isEmpty((Collection)itemBO.getDelImeiList())) {
                    return this.errLogPrint(res, "\u8ba2\u5355\u884c-\u66f4\u65b0scm\u540c\u6b65\u8ba2\u5355\u4fe1\u606f \u4e32\u7801\u660e\u7ec6\u4e3a\u7a7a");
                }
                List imeis = itemBO.getDelImeiList().stream().map(ScmOrderSyncItemImeiBO::getCmnum).collect(Collectors.toList());
                if (auart == 1) {
                    updScmBO.setScmOrderCode(bvbeln);
                    updScmBO.setScmOrderItemCode(itemBO.getBposnr());
                    updScmBO.setImeiList(imeis);
                    break;
                }
                if (auart != 5) break;
                updScmBO.setScmAfterOrderCode(bvbeln);
                updScmBO.setScmAfterOrderItemCode(itemBO.getBposnr());
                updScmBO.setImeiList(imeis);
                break;
            }
        }
        return res;
    }

    private RspBaseBO errLogPrint(RspBaseBO res, String desc) {
        log.error(desc);
        res.setRespCode("9999");
        res.setRespDesc(desc);
        return res;
    }

    private int deleteScmOrderSyncItemImeisByimeis(ScmOrderSyncItemRecordUnionImeiReqBO reqBO) {
        int res = 0;
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getItemBOS())) {
            List itemBOS = reqBO.getItemBOS();
            ScmOrderSyncItemBO itemBO = (ScmOrderSyncItemBO)itemBOS.get(0);
            if (StringUtils.isEmpty((CharSequence)itemBO.getBposnr())) {
                log.error("\u4e32\u7801\u8ba2\u5355\u884c\u53f7\u4e3a\u7a7a");
                return 0;
            }
            try {
                res = this.scmOrderSyncItemImeiAtomService.deleteScmOrderSyncItemImeisByimeis(itemBO);
            }
            catch (Exception e) {
                log.error("\u4e1a\u52a1\u5c42\u5220\u9664scm\u4e32\u7801\u5931\u8d25" + e.getMessage());
                res = 0;
            }
        }
        return res;
    }

    private int deleteScmSyncOrderItemByBo(ScmOrderSyncItemRecordUnionImeiReqBO reqBO) {
        int res = 0;
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getItemBOS())) {
            ScmOrderSyncItemBO itemBO = new ScmOrderSyncItemBO();
            itemBO.setBposnr(reqBO.getBposnr());
            itemBO.setBvbeln(reqBO.getBvbeln());
            try {
                res = this.scmOrderSyncItemAtomService.deleteScmSyncOrderItemByBo(itemBO);
            }
            catch (Exception e) {
                log.error("\u4e1a\u52a1\u5c42\u5220\u9664scm\u8ba2\u5355\u540c\u6b65\u8bb0\u5f55\u660e\u7ec6\u5931\u8d25" + e.getMessage());
                res = 0;
            }
        }
        return res;
    }

    private int deleteScmOrderSyncRecordByBo(ScmOrderSyncItemRecordUnionImeiReqBO reqBO) {
        int res = 0;
        ScmOrderSyncRecordBO recordBO = new ScmOrderSyncRecordBO();
        recordBO.setBvbeln(reqBO.getBvbeln());
        try {
            res = this.scmOrderSyncRecordAtomService.deleteScmOrderSyncRecordByBo(recordBO);
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u5c42\u5220\u9664scm\u8ba2\u5355\u540c\u6b65\u8bb0\u5f55\u5931\u8d25" + e.getMessage());
            res = 0;
        }
        return res;
    }

    private int updateScmOrderSyncRecordByBvblen(ScmOrderSyncItemRecordUnionImeiReqBO reqBO) {
        int res = 0;
        ScmOrderSyncRecordBO recordBO = new ScmOrderSyncRecordBO();
        recordBO.setBvbeln(reqBO.getBvbeln());
        recordBO.setVsart(reqBO.getVsart());
        recordBO.setVkorg(reqBO.getVkorg());
        recordBO.setKunnr(reqBO.getKunnr());
        recordBO.setKunwe(reqBO.getKunwe());
        recordBO.setVkbur(reqBO.getVkbur());
        try {
            res = this.scmOrderSyncRecordAtomService.updateScmOrderSyncRecordByBvblen(recordBO);
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u5c42\u4fee\u6539scm\u540c\u6b65\u8bb0\u5f55\u5931\u8d25" + e.getMessage());
        }
        return res;
    }

    private RspBaseBO updateScmSyncOrderItemByBo(ScmOrderSyncItemRecordUnionImeiReqBO reqBO) {
        RspBaseBO res = new RspBaseBO("0000", "\u4fee\u6539\u660e\u7ec6\u8bb0\u5f55\u53ca\u4e32\u7801\u660e\u7ec6\u6210\u529f");
        List itemBOs = reqBO.getItemBOS();
        String bvbeln = reqBO.getBvbeln();
        try {
            this.scmOrderSyncItemAtomService.updateScmSyncOrderItemByBatch(itemBOs);
        }
        catch (Exception e2) {
            log.error("\u4e1a\u52a1\u5c42\u6279\u91cf\u4fee\u6539scm\u540c\u6b65\u660e\u7ec6\u5931\u8d25" + e2.getMessage());
            return this.errLogPrint(res, "\u4e1a\u52a1\u5c42\u4fee\u6539scm\u540c\u6b65\u660e\u7ec6\u5931\u8d25");
        }
        ArrayList<ScmOrderSyncItemImeiBO> imeiReqList = new ArrayList<ScmOrderSyncItemImeiBO>();
        for (ScmOrderSyncItemBO itemBO : itemBOs) {
            if (!CollectionUtils.isNotEmpty((Collection)itemBO.getDelImeiList())) continue;
            imeiReqList.addAll(itemBO.getDelImeiList());
        }
        if (CollectionUtils.isNotEmpty(imeiReqList)) {
            try {
                this.scmOrderSyncItemImeiAtomService.deleteScmOrderSyncItemImeisByBatch(imeiReqList);
            }
            catch (Exception e3) {
                log.error("\u4e1a\u52a1\u5c42\u6279\u91cf\u4fee\u6539\u4e32\u7801\u660e\u7ec6\u5931\u8d25" + e3.getMessage());
                return this.errLogPrint(res, "\u4e1a\u52a1\u5c42\u4fee\u6539\u4e32\u7801\u660e\u7ec6\u5931\u8d25");
            }
            DealScmOrderReqBO updScmBO = new DealScmOrderReqBO();
            if (itemBOs.size() > 1) {
                itemBOs.forEach(e -> {
                    RspBaseBO syncRes;
                    if (CollectionUtils.isNotEmpty((Collection)e.getDelImeiList()) && StringUtils.equals((CharSequence)(syncRes = this.scmSyncOrderMessage((ScmOrderSyncItemBO)e, updScmBO, bvbeln, null, reqBO.getAuart(), 3)).getRespCode(), (CharSequence)"9999")) {
                        TkThrExceptionUtils.thrUpdExce((String)("\u66f4\u65b0scm\u540c\u6b65\u8ba2\u5355\u5931\u8d25" + syncRes.getRespDesc()));
                    }
                });
            } else {
                RspBaseBO syncRes = this.scmSyncOrderMessage((ScmOrderSyncItemBO)itemBOs.get(0), updScmBO, bvbeln, null, reqBO.getAuart(), 3);
                if (StringUtils.equals((CharSequence)syncRes.getRespCode(), (CharSequence)"9999")) {
                    TkThrExceptionUtils.thrUpdExce((String)("\u66f4\u65b0scm\u540c\u6b65\u8ba2\u5355\u5931\u8d25" + syncRes.getRespDesc()));
                }
            }
        }
        return res;
    }

    public RspBatchBaseBO<StoreSalesStatisticsRspBO> storeSalesStatistics(ScmOrderSyncRecordBO recordBO) {
        List<StoreSalesStatisticsPO> salesPOs;
        RspBatchBaseBO res = new RspBatchBaseBO("0000", "\u9500\u5355\u95e8\u5e97\u9500\u552e\u989d\u7edf\u8ba1\u67e5\u8be2\u6210\u529f");
        ArrayList rows = new ArrayList();
        log.info("\u9500\u5355\u95e8\u5e97\u9500\u552e\u989d\u7edf\u8ba1\u5165\u53c2" + JSON.toJSONString((Object)recordBO));
        if (StringUtils.isEmpty((CharSequence)recordBO.getStartTime()) || StringUtils.isEmpty((CharSequence)recordBO.getEndTime())) {
            res.setRespDesc("\u5165\u53c2\u65f6\u95f4\u4e3a\u7a7a");
            res.setRespCode("9999");
            return res;
        }
        try {
            recordBO.setStartTime(DateUtils.dateToStrYYYYMMdd((Date)DateUtils.strToDate((String)recordBO.getStartTime())));
            recordBO.setEndTime(DateUtils.dateToStrYYYYMMdd((Date)DateUtils.strToDate((String)recordBO.getEndTime())));
        }
        catch (Exception e) {
            log.error("\u65f6\u95f4\u5904\u7406\u5f02\u5e38" + e.getMessage());
            res.setRespCode("9999");
            res.setRespDesc("\u65f6\u95f4\u5904\u7406\u5f02\u5e38" + e.getMessage());
            return res;
        }
        log.info("\u5f00\u59cb\u65f6\u95f4" + recordBO.getStartTime());
        log.info("\u7ed3\u675f\u65f6\u95f4" + recordBO.getEndTime());
        try {
            salesPOs = this.scmOrderSyncRecordAtomService.selectSalesAmountByVdatu(recordBO);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u9500\u552e\u989d\u5ea6\u5931\u8d25" + e.getMessage());
            res.setRespCode("9999");
            res.setRespDesc("\u67e5\u8be2\u9500\u552e\u989d\u5ea6\u5931\u8d25" + e.getMessage());
            return res;
        }
        if (CollectionUtils.isEmpty(salesPOs)) {
            res.setRespCode("0000");
            res.setRespDesc("\u67e5\u8be2\u9500\u552e\u989d\u5ea6\u8bb0\u5f55\u4e3a\u7a7a");
            return res;
        }
        Map<String, List<StoreSalesStatisticsPO>> groupMap = salesPOs.stream().collect(Collectors.groupingBy(StoreSalesStatisticsPO::getShopCode));
        log.info("\u6309\u7167\u95e8\u5e97\u5206\u7ec4\u540e\u7684map" + JSON.toJSONString(groupMap));
        groupMap.forEach((shopCode, bos) -> {
            StoreSalesStatisticsRspBO rspBO = new StoreSalesStatisticsRspBO();
            bos.forEach(e -> {
                if (StringUtils.isEmpty((CharSequence)rspBO.getProvinceCode())) {
                    BeanUtils.copyProperties((Object)e, (Object)rspBO);
                }
                if (StringUtils.equals((CharSequence)e.getAuart(), (CharSequence)"Z001")) {
                    rspBO.setSalesAmount(e.getSales());
                } else if (StringUtils.equals((CharSequence)e.getAuart(), (CharSequence)"Z005")) {
                    rspBO.setReturnAmount(e.getSales());
                }
            });
            rows.add(rspBO);
        });
        log.info("\u9500\u5355\u95e8\u5e97\u9500\u552e\u989d\u7edf\u8ba1\u51fa\u53c2" + JSON.toJSONString(rows));
        res.setRows(rows);
        return res;
    }

    public RspBatchBaseBO<QryEscapeBO> listScmOrderRecordVsartType() {
        List<QryEscapeBO> list = this.getEscapes("SYN_SCM_ORDER_SHIPMENT_TYPE", true);
        return new RspBatchBaseBO("0000", "\u64cd\u4f5c\u6210\u529f", list);
    }
}

