/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.authority.organisation.bo.OrganisationBO;
import com.ohaotian.authority.organisation.bo.SelectStoreInfoReqBO;
import com.ohaotian.authority.organisation.bo.SelectStoreInfoRspBO;
import com.ohaotian.authority.organisation.service.SelectStoreInfoListService;
import com.tydic.externalinter.bo.AllocateOrderDetailBO;
import com.tydic.externalinter.bo.OutSkuDetailBO;
import com.tydic.externalinter.busi.bo.SyncAllocateDataReqBO;
import com.tydic.externalinter.busi.bo.SyncAllocateDataRspBO;
import com.tydic.externalinter.busi.service.SyncAllocateDataService;
import com.tydic.smc.api.ability.SmcAllocateSyncConfirmAbilityService;
import com.tydic.smc.api.ability.SmcInStoreBillRefuseForProvSysAbilityService;
import com.tydic.smc.api.ability.SmcOutStoreBillAddForBatchAbilityService;
import com.tydic.smc.api.ability.SmcQryMaterialIdByImsiAbilityService;
import com.tydic.smc.api.ability.SmcQryStockhouseListAbilityService;
import com.tydic.smc.api.ability.bo.SmcAllocateSyncConfirmAbilityReqBO;
import com.tydic.smc.api.ability.bo.SmcAllocateSyncConfirmAbilityRspBO;
import com.tydic.smc.api.ability.bo.SmcInStoreBillConfirmAbilityReqBO;
import com.tydic.smc.api.ability.bo.SmcInStoreBillRefuseForProvSysAbilityReqBO;
import com.tydic.smc.api.ability.bo.SmcInStoreBillRefuseForProvSysAbilityRspBO;
import com.tydic.smc.api.ability.bo.SmcOutStoreBillAddAbilityReqBO;
import com.tydic.smc.api.ability.bo.SmcOutStoreBillAddForBatchAbilityReqBO;
import com.tydic.smc.api.ability.bo.SmcOutStoreBillAddForBatchAbilityRspBO;
import com.tydic.smc.api.ability.bo.SmcQryMaterialIdByImsiAbilityReqBO;
import com.tydic.smc.api.ability.bo.SmcQryMaterialIdByImsiAbilityRspBO;
import com.tydic.smc.api.ability.bo.SmcQryStockhouseListAbilityReqBO;
import com.tydic.smc.api.ability.bo.SmcQryStockhouseListAbilityRspBO;
import com.tydic.smc.api.common.bo.SmcBillSkuBO;
import com.tydic.smc.api.common.bo.SmcInStoreBillRefuseBO;
import com.tydic.smc.api.common.bo.SmcSkuImsiInfoBO;
import com.tydic.smc.api.common.bo.SmcStockhouseInfoBO;
import com.xls.commodity.busi.sku.SelectSkuAndSupListService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SyncAllocateDataServiceImpl
implements SyncAllocateDataService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncAllocateDataServiceImpl.class);
    private static final Set<String> SIGN_STATE_SET = new HashSet<String>();
    private static final String SIGN_STATE_ALLOCATE = "1";
    private static final String SIGN_STATE_CONFIRM = "0";
    private static final String SUCCEED = "1000";
    private static final String FAIL = "2";
    private static final String COMMON_SUCCEED_RESP_CODE = "0000";
    private static final String STOREHOUSE_TYPE_IN = "01";
    private static final String STOREHOUSE_TYPE_OUT = "01";
    private static final String INV_STATE_TRANS = "0";
    private static final String INV_STATE_INSTOCK = "1";
    private static final String ALLOCATE_STATE_UNSIGN = "0";
    private static final String ALLOCATE_STATE_FINISH = "1";
    private static final String ALLOCATE_STATE_REJECT = "3";
    @Autowired
    private SelectStoreInfoListService selectStoreInfoListService;
    @Autowired
    private SelectSkuAndSupListService selectSkuAndSupListService;
    @Autowired
    private SmcQryStockhouseListAbilityService smcQryStockhouseListAbilityService;
    @Autowired
    private SmcOutStoreBillAddForBatchAbilityService smcOutStoreBillAddForBatchAbilityService;
    @Autowired
    private SmcAllocateSyncConfirmAbilityService smcAllocateSyncConfirmAbilityService;
    @Autowired
    private SmcQryMaterialIdByImsiAbilityService smcQryMaterialIdByImsiAbilityService;
    @Autowired
    private SmcInStoreBillRefuseForProvSysAbilityService smcInStoreBillRefuseForProvSysAbilityService;

    private static void initialize() {
        SIGN_STATE_SET.add("1");
        SIGN_STATE_SET.add("0");
    }

    public SyncAllocateDataRspBO dealAllocateSync(SyncAllocateDataReqBO reqBO) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u94fa\u8d27\u673a\u578b\u8c03\u62e8\u6570\u636e\u540c\u6b65\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        }
        SyncAllocateDataRspBO rspBO = new SyncAllocateDataRspBO();
        String checkMsg = this.checkReqParams(reqBO);
        if (!StringUtils.isEmpty((Object)checkMsg)) {
            rspBO.setBizCode(FAIL);
            rspBO.setBizDesc(checkMsg);
            return rspBO;
        }
        AllocateOrderDetailBO orderDetailBO = (AllocateOrderDetailBO)reqBO.getOrderDetail().get(0);
        String signState = orderDetailBO.getSignState();
        String allocateState = orderDetailBO.getAllocationState();
        String ivnState = orderDetailBO.getInvState();
        if ("1".equals(signState) && "0".equals(ivnState) && "0".equals(allocateState)) {
            SmcOutStoreBillAddForBatchAbilityRspBO smcOutStoreBillAddForBatchAbilityRspBO;
            SmcOutStoreBillAddForBatchAbilityReqBO smcOutStoreBillAddForBatchAbilityReqBO = this.setSmcOutStoreBillAddForBatchAbilityReqBO(reqBO, rspBO);
            if (FAIL.equals(rspBO.getBizCode())) {
                return rspBO;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u8c03\u62e8\u51fa\u5e93\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)smcOutStoreBillAddForBatchAbilityReqBO));
            }
            try {
                smcOutStoreBillAddForBatchAbilityRspBO = this.smcOutStoreBillAddForBatchAbilityService.addOutStoreBill(smcOutStoreBillAddForBatchAbilityReqBO);
            }
            catch (Exception e) {
                rspBO.setBizCode(FAIL);
                rspBO.setBizDesc("\u8c03\u62e8\u51fa\u5e93\u5f02\u5e38\uff1a" + e);
                return rspBO;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u8c03\u62e8\u51fa\u5e93\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)smcOutStoreBillAddForBatchAbilityRspBO));
            }
            if (!COMMON_SUCCEED_RESP_CODE.equals(smcOutStoreBillAddForBatchAbilityRspBO.getRespCode())) {
                rspBO.setBizCode(FAIL);
                rspBO.setBizDesc(smcOutStoreBillAddForBatchAbilityRspBO.getRespDesc());
                return rspBO;
            }
        } else if ("0".equals(signState) && "1".equals(ivnState) && "1".equals(allocateState) || "1".equals(signState) && "1".equals(ivnState) && "0".equals(allocateState)) {
            SmcAllocateSyncConfirmAbilityRspBO smcAllocateSyncConfirmAbilityRspBO;
            SmcAllocateSyncConfirmAbilityReqBO smcAllocateSyncConfirmAbilityReqBO = this.setSmcAllocateSyncConfirmAbilityReqBO(reqBO, rspBO);
            if (FAIL.equals(rspBO.getBizCode())) {
                return rspBO;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u8c03\u62e8\u51fa\u5e93\u5165\u5e93\u786e\u8ba4\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)smcAllocateSyncConfirmAbilityReqBO));
            }
            try {
                smcAllocateSyncConfirmAbilityRspBO = this.smcAllocateSyncConfirmAbilityService.commitConfirm(smcAllocateSyncConfirmAbilityReqBO);
            }
            catch (Exception e) {
                rspBO.setBizCode(FAIL);
                rspBO.setBizDesc("\u8c03\u62e8\u51fa\u5e93\u5165\u5e93\u786e\u8ba4\u5f02\u5e38\uff1a" + e);
                return rspBO;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u8c03\u62e8\u51fa\u5e93\u5165\u5e93\u786e\u8ba4\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)smcAllocateSyncConfirmAbilityRspBO));
            }
            if (!COMMON_SUCCEED_RESP_CODE.equals(smcAllocateSyncConfirmAbilityRspBO.getRespCode())) {
                rspBO.setBizCode(FAIL);
                rspBO.setBizDesc(smcAllocateSyncConfirmAbilityRspBO.getRespDesc());
                return rspBO;
            }
        } else if (ALLOCATE_STATE_REJECT.equals(allocateState) && "1".equals(ivnState) && "1".equals(signState)) {
            SmcInStoreBillRefuseForProvSysAbilityRspBO smcInStoreBillRefuseForProvSysAbilityRspBO;
            SmcInStoreBillRefuseForProvSysAbilityReqBO smcInStoreBillRefuseForProvSysAbilityReqBO = this.setSmcInStoreBillRefuseForProvSysAbilityReqBO(reqBO, rspBO);
            if (FAIL.equals(rspBO.getBizCode())) {
                return rspBO;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u8c03\u62e8\u51fa\u5e93\u5355\u62d2\u6536\uff08\u7701\u4efd\u7cfb\u7edf\u8c03\u7528\uff09\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)smcInStoreBillRefuseForProvSysAbilityReqBO));
            }
            try {
                smcInStoreBillRefuseForProvSysAbilityRspBO = this.smcInStoreBillRefuseForProvSysAbilityService.commitRefuse(smcInStoreBillRefuseForProvSysAbilityReqBO);
            }
            catch (Exception e) {
                rspBO.setBizCode(FAIL);
                rspBO.setBizDesc("\u8c03\u62e8\u51fa\u5e93\u5355\u62d2\u6536\uff08\u7701\u4efd\u7cfb\u7edf\u8c03\u7528\uff09\u5f02\u5e38\uff1a" + e);
                return rspBO;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u8c03\u62e8\u51fa\u5e93\u5355\u62d2\u6536\uff08\u7701\u4efd\u7cfb\u7edf\u8c03\u7528\uff09\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)smcInStoreBillRefuseForProvSysAbilityRspBO));
            }
            if (!COMMON_SUCCEED_RESP_CODE.equals(smcInStoreBillRefuseForProvSysAbilityRspBO.getRespCode())) {
                rspBO.setBizCode(FAIL);
                rspBO.setBizDesc(smcInStoreBillRefuseForProvSysAbilityRspBO.getRespDesc());
                return rspBO;
            }
        } else {
            rspBO.setBizCode(FAIL);
            rspBO.setBizDesc("\u8c03\u62e8\u6570\u636e\u72b6\u6001\u4e0d\u7b26\uff0c\u672a\u5b8c\u6210\u540c\u6b65");
            return rspBO;
        }
        rspBO.setBizCode(SUCCEED);
        rspBO.setBizDesc("\u6210\u529f");
        return rspBO;
    }

    private SmcInStoreBillRefuseForProvSysAbilityReqBO setSmcInStoreBillRefuseForProvSysAbilityReqBO(SyncAllocateDataReqBO reqBO, SyncAllocateDataRspBO rspBO) {
        SmcInStoreBillRefuseForProvSysAbilityReqBO smcInStoreBillRefuseForProvSysAbilityReqBO = new SmcInStoreBillRefuseForProvSysAbilityReqBO();
        ArrayList<SmcInStoreBillRefuseBO> smcInStoreBillBOs = new ArrayList<SmcInStoreBillRefuseBO>();
        for (AllocateOrderDetailBO bo : reqBO.getOrderDetail()) {
            String provinceCode;
            String startTime = bo.getStartTime();
            String inHallCode = bo.getInHallCode();
            String outHallCode = bo.getOutHallCode();
            String inHallName = bo.getInHallName();
            String outHallName = bo.getOutHallName();
            String inBossMchtCodeGroup = bo.getInBossMchtCodeGroup();
            String outBossMchtCodeGroup = bo.getOutBossMchtCodeGroup();
            String allocationId = bo.getAllocationId();
            String signState = bo.getSignState();
            String allocateState = bo.getAllocationState();
            String ivnState = bo.getInvState();
            SelectStoreInfoReqBO selectStoreInfoReqBO = new SelectStoreInfoReqBO();
            selectStoreInfoReqBO.setQryType("11");
            ArrayList<String> bossStoreIds = new ArrayList<String>(1);
            bossStoreIds.add(inHallCode);
            bossStoreIds.add(outHallCode);
            selectStoreInfoReqBO.setBossStoreIds(bossStoreIds);
            ArrayList<String> corpStoreIds = new ArrayList<String>();
            corpStoreIds.add(inBossMchtCodeGroup);
            corpStoreIds.add(outBossMchtCodeGroup);
            selectStoreInfoReqBO.setCorpStoreIds(corpStoreIds);
            switch (provinceCode = StringUtils.isEmpty((Object)reqBO.getProvinceFlag()) ? "240000" : reqBO.getProvinceFlag()) {
                case "240000": {
                    break;
                }
                case "110000": {
                    ArrayList<String> storeAttrs = new ArrayList<String>();
                    storeAttrs.add("02");
                    storeAttrs.add("04");
                    selectStoreInfoReqBO.setStoreAttrs(storeAttrs);
                    break;
                }
            }
            selectStoreInfoReqBO.setProvinceCode(provinceCode);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u6839\u636eboss\u95e8\u5e97\u7f16\u7801\u83b7\u53d6\u95e8\u5e97\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)selectStoreInfoReqBO));
            }
            SelectStoreInfoRspBO selectStoreInfoRspBO = this.selectStoreInfoListService.selectStoreInfoList(selectStoreInfoReqBO);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u6839\u636eboss\u95e8\u5e97\u7f16\u7801\u83b7\u53d6\u95e8\u5e97\u4fe1\u606f\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)selectStoreInfoRspBO));
            }
            if (selectStoreInfoRspBO == null) {
                rspBO.setBizCode(FAIL);
                rspBO.setBizDesc("\u6839\u636eboss\u95e8\u5e97\u7f16\u7801\u83b7\u53d6\u95e8\u5e97\u8f6c\u6362\u5931\u8d25");
                return null;
            }
            if (!COMMON_SUCCEED_RESP_CODE.equals(selectStoreInfoRspBO.getRespCode())) {
                rspBO.setBizCode(FAIL);
                rspBO.setBizDesc("\u6839\u636eboss\u95e8\u5e97\u7f16\u7801\u83b7\u53d6\u95e8\u5e97\u8f6c\u6362\u5931\u8d25\uff0c\u5931\u8d25\u63cf\u8ff0\uff1a" + selectStoreInfoRspBO.getRespDesc());
                return null;
            }
            if (CollectionUtils.isEmpty((Collection)selectStoreInfoRspBO.getStoreInfoList())) {
                rspBO.setBizCode(FAIL);
                rspBO.setBizDesc("\u6839\u636eboss\u95e8\u5e97\u7f16\u7801\u83b7\u53d6\u95e8\u5e97\u8f6c\u6362\u65e0\u6570\u636e");
                return null;
            }
            Long inShopId = null;
            Long outShopId = null;
            for (OrganisationBO shop : selectStoreInfoRspBO.getStoreInfoList()) {
                if (inBossMchtCodeGroup.equals(shop.getCorpStoreId())) {
                    inShopId = Long.valueOf(shop.getField2());
                }
                if (!outBossMchtCodeGroup.equals(shop.getCorpStoreId())) continue;
                outShopId = Long.valueOf(shop.getField2());
            }
            if (outShopId == null) {
                rspBO.setBizCode(FAIL);
                rspBO.setBizDesc("\u6839\u636eboss\u8c03\u51fa\u5385\u5e97\u7f16\u7801\u83b7\u53d6\u4e0d\u5230\u95e8\u5e97\uff01");
                return null;
            }
            if (inShopId == null) {
                rspBO.setBizCode(FAIL);
                rspBO.setBizDesc("\u6839\u636eboss\u8c03\u5165\u5385\u5e97\u7f16\u7801\u83b7\u53d6\u4e0d\u5230\u95e8\u5e97\uff01");
                return null;
            }
            Long inStoreNo = this.getStockhouseId(inShopId, "01");
            if (inStoreNo == null) {
                rspBO.setBizCode(FAIL);
                rspBO.setBizDesc("\u83b7\u53d6\u79fb\u5165\u4ed3\u5e93\u5931\u8d25\uff01");
                return null;
            }
            Long outStoreNo = this.getStockhouseId(outShopId, "01");
            if (outStoreNo == null) {
                rspBO.setBizCode(FAIL);
                rspBO.setBizDesc("\u83b7\u53d6\u79fb\u51fa\u4ed3\u5e93\u5931\u8d25\uff01");
                return null;
            }
            ArrayList<SmcBillSkuBO> skuList = new ArrayList<SmcBillSkuBO>();
            for (OutSkuDetailBO bo1 : bo.getOutDetail()) {
                List<String> imsiList = Arrays.asList(bo1.getInvids().split(","));
                if (CollectionUtils.isEmpty(imsiList)) {
                    rspBO.setBizCode(FAIL);
                    rspBO.setBizDesc("\u7269\u6599[" + bo1.getScmCode() + "]\u7684\u4e32\u7801\u96c6\u5408\u4e3a\u7a7a");
                    return null;
                }
                Map<String, SmcSkuImsiInfoBO> materialImsiMap = this.getImsiMaterialId(imsiList);
                for (int j = 0; j < imsiList.size(); ++j) {
                    SmcBillSkuBO smcBillSkuBO = new SmcBillSkuBO();
                    skuList.add(smcBillSkuBO);
                    smcBillSkuBO.setImsi(imsiList.get(j));
                    smcBillSkuBO.setBillDetailNum(Long.valueOf(1L));
                    SmcSkuImsiInfoBO smcSkuImsiInfoBO = materialImsiMap.get(imsiList.get(j));
                    if (StringUtils.isEmpty((Object)smcSkuImsiInfoBO)) {
                        smcBillSkuBO.setMaterialCode(bo1.getScmCode());
                        smcBillSkuBO.setSkuId(Long.valueOf(999999999L));
                    } else {
                        smcBillSkuBO.setMaterialCode(smcSkuImsiInfoBO.getMaterialCode());
                        smcBillSkuBO.setSkuId(smcSkuImsiInfoBO.getSkuId());
                    }
                    if (!"1".equals(bo.getInvState())) continue;
                    smcBillSkuBO.setScanImsi(imsiList.get(j));
                }
            }
            SmcInStoreBillRefuseBO smcInStoreBillRefuseBO = new SmcInStoreBillRefuseBO();
            smcInStoreBillRefuseBO.setInStoreNo(inStoreNo);
            smcInStoreBillRefuseBO.setOutStoreNo(outStoreNo);
            smcInStoreBillRefuseBO.setBossAllocateId(allocationId);
            smcInStoreBillRefuseBO.setSkuList(skuList);
            smcInStoreBillBOs.add(smcInStoreBillRefuseBO);
        }
        smcInStoreBillRefuseForProvSysAbilityReqBO.setSmcInStoreBillBOs(smcInStoreBillBOs);
        return smcInStoreBillRefuseForProvSysAbilityReqBO;
    }

    private SmcAllocateSyncConfirmAbilityReqBO setSmcAllocateSyncConfirmAbilityReqBO(SyncAllocateDataReqBO reqBO, SyncAllocateDataRspBO rspBO) {
        SmcAllocateSyncConfirmAbilityReqBO smcAllocateSyncConfirmAbilityReqBO = new SmcAllocateSyncConfirmAbilityReqBO();
        ArrayList<SmcInStoreBillConfirmAbilityReqBO> smcInStoreBillConfirmAbilityReqBOList = new ArrayList<SmcInStoreBillConfirmAbilityReqBO>();
        for (AllocateOrderDetailBO bo : reqBO.getOrderDetail()) {
            String provinceCode;
            String startTime = bo.getStartTime();
            String inHallCode = bo.getInHallCode();
            String outHallCode = bo.getOutHallCode();
            String inHallName = bo.getInHallName();
            String outHallName = bo.getOutHallName();
            String inBossMchtCodeGroup = bo.getInBossMchtCodeGroup();
            String outBossMchtCodeGroup = bo.getOutBossMchtCodeGroup();
            String allocationId = bo.getAllocationId();
            String signState = bo.getSignState();
            String allocateState = bo.getAllocationState();
            String ivnState = bo.getInvState();
            SelectStoreInfoReqBO selectStoreInfoReqBO = new SelectStoreInfoReqBO();
            selectStoreInfoReqBO.setQryType("11");
            ArrayList<String> bossStoreIds = new ArrayList<String>(1);
            bossStoreIds.add(inHallCode);
            bossStoreIds.add(outHallCode);
            selectStoreInfoReqBO.setBossStoreIds(bossStoreIds);
            ArrayList<String> corpStoreIds = new ArrayList<String>();
            corpStoreIds.add(inBossMchtCodeGroup);
            corpStoreIds.add(outBossMchtCodeGroup);
            selectStoreInfoReqBO.setCorpStoreIds(corpStoreIds);
            switch (provinceCode = StringUtils.isEmpty((Object)reqBO.getProvinceFlag()) ? "240000" : reqBO.getProvinceFlag()) {
                case "240000": {
                    break;
                }
                case "110000": {
                    ArrayList<String> storeAttrs = new ArrayList<String>();
                    storeAttrs.add("02");
                    storeAttrs.add("04");
                    selectStoreInfoReqBO.setStoreAttrs(storeAttrs);
                    break;
                }
            }
            selectStoreInfoReqBO.setProvinceCode(provinceCode);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u6839\u636eboss\u95e8\u5e97\u7f16\u7801\u83b7\u53d6\u95e8\u5e97\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)selectStoreInfoReqBO));
            }
            SelectStoreInfoRspBO selectStoreInfoRspBO = this.selectStoreInfoListService.selectStoreInfoList(selectStoreInfoReqBO);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u6839\u636eboss\u95e8\u5e97\u7f16\u7801\u83b7\u53d6\u95e8\u5e97\u4fe1\u606f\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)selectStoreInfoRspBO));
            }
            if (selectStoreInfoRspBO == null) {
                rspBO.setBizCode(FAIL);
                rspBO.setBizDesc("\u6839\u636eboss\u95e8\u5e97\u7f16\u7801\u83b7\u53d6\u95e8\u5e97\u8f6c\u6362\u5931\u8d25");
                return null;
            }
            if (!COMMON_SUCCEED_RESP_CODE.equals(selectStoreInfoRspBO.getRespCode())) {
                rspBO.setBizCode(FAIL);
                rspBO.setBizDesc("\u6839\u636eboss\u95e8\u5e97\u7f16\u7801\u83b7\u53d6\u95e8\u5e97\u8f6c\u6362\u5931\u8d25\uff0c\u5931\u8d25\u63cf\u8ff0\uff1a" + selectStoreInfoRspBO.getRespDesc());
                return null;
            }
            if (CollectionUtils.isEmpty((Collection)selectStoreInfoRspBO.getStoreInfoList())) {
                rspBO.setBizCode(FAIL);
                rspBO.setBizDesc("\u6839\u636eboss\u95e8\u5e97\u7f16\u7801\u83b7\u53d6\u95e8\u5e97\u8f6c\u6362\u65e0\u6570\u636e");
                return null;
            }
            Long inShopId = null;
            Long outShopId = null;
            for (OrganisationBO shop : selectStoreInfoRspBO.getStoreInfoList()) {
                if (inBossMchtCodeGroup.equals(shop.getCorpStoreId())) {
                    inShopId = Long.valueOf(shop.getField2());
                }
                if (!outBossMchtCodeGroup.equals(shop.getCorpStoreId())) continue;
                outShopId = Long.valueOf(shop.getField2());
            }
            if (outShopId == null) {
                rspBO.setBizCode(FAIL);
                rspBO.setBizDesc("\u6839\u636eboss\u8c03\u51fa\u5385\u5e97\u7f16\u7801\u83b7\u53d6\u4e0d\u5230\u95e8\u5e97\uff01");
                return null;
            }
            if (inShopId == null) {
                rspBO.setBizCode(FAIL);
                rspBO.setBizDesc("\u6839\u636eboss\u8c03\u5165\u5385\u5e97\u7f16\u7801\u83b7\u53d6\u4e0d\u5230\u95e8\u5e97\uff01");
                return null;
            }
            Long inStoreNo = this.getStockhouseId(inShopId, "01");
            if (inStoreNo == null) {
                rspBO.setBizCode(FAIL);
                rspBO.setBizDesc("\u83b7\u53d6\u79fb\u5165\u4ed3\u5e93\u5931\u8d25\uff01");
                return null;
            }
            Long outStoreNo = this.getStockhouseId(outShopId, "01");
            if (outStoreNo == null) {
                rspBO.setBizCode(FAIL);
                rspBO.setBizDesc("\u83b7\u53d6\u79fb\u51fa\u4ed3\u5e93\u5931\u8d25\uff01");
                return null;
            }
            ArrayList<SmcBillSkuBO> skuList = new ArrayList<SmcBillSkuBO>();
            for (OutSkuDetailBO bo1 : bo.getOutDetail()) {
                List<String> imsiList = Arrays.asList(bo1.getInvids().split(","));
                if (CollectionUtils.isEmpty(imsiList)) {
                    rspBO.setBizCode(FAIL);
                    rspBO.setBizDesc("\u7269\u6599[" + bo1.getScmCode() + "]\u7684\u4e32\u7801\u96c6\u5408\u4e3a\u7a7a");
                    return null;
                }
                Map<String, SmcSkuImsiInfoBO> materialImsiMap = this.getImsiMaterialId(imsiList);
                for (int j = 0; j < imsiList.size(); ++j) {
                    SmcBillSkuBO smcBillSkuBO = new SmcBillSkuBO();
                    skuList.add(smcBillSkuBO);
                    smcBillSkuBO.setImsi(imsiList.get(j));
                    smcBillSkuBO.setBillDetailNum(Long.valueOf(1L));
                    SmcSkuImsiInfoBO smcSkuImsiInfoBO = materialImsiMap.get(imsiList.get(j));
                    if (StringUtils.isEmpty((Object)smcSkuImsiInfoBO)) {
                        smcBillSkuBO.setMaterialCode(bo1.getScmCode());
                        smcBillSkuBO.setSkuId(Long.valueOf(999999999L));
                    } else {
                        smcBillSkuBO.setMaterialCode(smcSkuImsiInfoBO.getMaterialCode());
                        smcBillSkuBO.setSkuId(smcSkuImsiInfoBO.getSkuId());
                    }
                    if (!"1".equals(bo.getInvState())) continue;
                    smcBillSkuBO.setScanImsi(imsiList.get(j));
                }
            }
            SmcInStoreBillConfirmAbilityReqBO smcInStoreBillConfirmAbilityReqBO = new SmcInStoreBillConfirmAbilityReqBO();
            smcInStoreBillConfirmAbilityReqBO.setInStoreNo(inStoreNo);
            smcInStoreBillConfirmAbilityReqBO.setOutStoreNo(outStoreNo);
            smcInStoreBillConfirmAbilityReqBO.setBossAllocateId(allocationId);
            smcInStoreBillConfirmAbilityReqBO.setDealByOutIdFlag("1");
            smcInStoreBillConfirmAbilityReqBO.setNotCheckAuditStateFlag("1");
            smcInStoreBillConfirmAbilityReqBO.setSkuList(skuList);
            smcInStoreBillConfirmAbilityReqBO.setAllocationState(allocateState);
            smcInStoreBillConfirmAbilityReqBOList.add(smcInStoreBillConfirmAbilityReqBO);
        }
        smcAllocateSyncConfirmAbilityReqBO.setSmcInStoreBillConfirmAbilityReqBOList(smcInStoreBillConfirmAbilityReqBOList);
        return smcAllocateSyncConfirmAbilityReqBO;
    }

    private SmcOutStoreBillAddForBatchAbilityReqBO setSmcOutStoreBillAddForBatchAbilityReqBO(SyncAllocateDataReqBO reqBO, SyncAllocateDataRspBO rspBO) {
        SmcOutStoreBillAddForBatchAbilityReqBO smcOutStoreBillAddForBatchAbilityReqBO = new SmcOutStoreBillAddForBatchAbilityReqBO();
        ArrayList<SmcOutStoreBillAddAbilityReqBO> smcOutStoreBillAddAbilityReqBOList = new ArrayList<SmcOutStoreBillAddAbilityReqBO>();
        for (AllocateOrderDetailBO bo : reqBO.getOrderDetail()) {
            String provinceCode;
            String startTime = bo.getStartTime();
            String inHallCode = bo.getInHallCode();
            String outHallCode = bo.getOutHallCode();
            String inHallName = bo.getInHallName();
            String outHallName = bo.getOutHallName();
            String inBossMchtCodeGroup = bo.getInBossMchtCodeGroup();
            String outBossMchtCodeGroup = bo.getOutBossMchtCodeGroup();
            String allocationId = bo.getAllocationId();
            String signState = bo.getSignState();
            String allocateState = bo.getAllocationState();
            String ivnState = bo.getInvState();
            SelectStoreInfoReqBO selectStoreInfoReqBO = new SelectStoreInfoReqBO();
            selectStoreInfoReqBO.setQryType("11");
            ArrayList<String> bossStoreIds = new ArrayList<String>(1);
            bossStoreIds.add(inHallCode);
            bossStoreIds.add(outHallCode);
            selectStoreInfoReqBO.setBossStoreIds(bossStoreIds);
            ArrayList<String> corpStoreIds = new ArrayList<String>();
            corpStoreIds.add(inBossMchtCodeGroup);
            corpStoreIds.add(outBossMchtCodeGroup);
            selectStoreInfoReqBO.setCorpStoreIds(corpStoreIds);
            switch (provinceCode = StringUtils.isEmpty((Object)reqBO.getProvinceFlag()) ? "240000" : reqBO.getProvinceFlag()) {
                case "240000": {
                    break;
                }
                case "110000": {
                    ArrayList<String> storeAttrs = new ArrayList<String>();
                    storeAttrs.add("02");
                    storeAttrs.add("04");
                    selectStoreInfoReqBO.setStoreAttrs(storeAttrs);
                    break;
                }
            }
            selectStoreInfoReqBO.setProvinceCode(provinceCode);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u6839\u636eboss\u95e8\u5e97\u7f16\u7801\u83b7\u53d6\u95e8\u5e97\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)selectStoreInfoReqBO));
            }
            SelectStoreInfoRspBO selectStoreInfoRspBO = this.selectStoreInfoListService.selectStoreInfoList(selectStoreInfoReqBO);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u6839\u636eboss\u95e8\u5e97\u7f16\u7801\u83b7\u53d6\u95e8\u5e97\u4fe1\u606f\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)selectStoreInfoRspBO));
            }
            if (selectStoreInfoRspBO == null) {
                rspBO.setBizCode(FAIL);
                rspBO.setBizDesc("\u6839\u636eboss\u95e8\u5e97\u7f16\u7801\u83b7\u53d6\u95e8\u5e97\u8f6c\u6362\u5931\u8d25");
                return null;
            }
            if (!COMMON_SUCCEED_RESP_CODE.equals(selectStoreInfoRspBO.getRespCode())) {
                rspBO.setBizCode(FAIL);
                rspBO.setBizDesc("\u6839\u636eboss\u95e8\u5e97\u7f16\u7801\u83b7\u53d6\u95e8\u5e97\u8f6c\u6362\u5931\u8d25\uff0c\u5931\u8d25\u63cf\u8ff0\uff1a" + selectStoreInfoRspBO.getRespDesc());
                return null;
            }
            if (CollectionUtils.isEmpty((Collection)selectStoreInfoRspBO.getStoreInfoList())) {
                rspBO.setBizCode(FAIL);
                rspBO.setBizDesc("\u6839\u636eboss\u95e8\u5e97\u7f16\u7801\u83b7\u53d6\u95e8\u5e97\u8f6c\u6362\u65e0\u6570\u636e");
                return null;
            }
            Long inShopId = null;
            Long outShopId = null;
            for (OrganisationBO shop : selectStoreInfoRspBO.getStoreInfoList()) {
                if (inBossMchtCodeGroup.equals(shop.getCorpStoreId())) {
                    inShopId = Long.valueOf(shop.getField2());
                }
                if (!outBossMchtCodeGroup.equals(shop.getCorpStoreId())) continue;
                outShopId = Long.valueOf(shop.getField2());
            }
            if (outShopId == null) {
                rspBO.setBizCode(FAIL);
                rspBO.setBizDesc("\u6839\u636eboss\u8c03\u51fa\u5385\u5e97\u7f16\u7801\u83b7\u53d6\u4e0d\u5230\u95e8\u5e97\uff01");
                return null;
            }
            if (inShopId == null) {
                rspBO.setBizCode(FAIL);
                rspBO.setBizDesc("\u6839\u636eboss\u8c03\u5165\u5385\u5e97\u7f16\u7801\u83b7\u53d6\u4e0d\u5230\u95e8\u5e97\uff01");
                return null;
            }
            Long inStoreNo = this.getStockhouseId(inShopId, "01");
            if (inStoreNo == null) {
                rspBO.setBizCode(FAIL);
                rspBO.setBizDesc("\u83b7\u53d6\u79fb\u5165\u4ed3\u5e93\u5931\u8d25\uff01");
                return null;
            }
            Long outStoreNo = this.getStockhouseId(outShopId, "01");
            if (outStoreNo == null) {
                rspBO.setBizCode(FAIL);
                rspBO.setBizDesc("\u83b7\u53d6\u79fb\u51fa\u4ed3\u5e93\u5931\u8d25\uff01");
                return null;
            }
            ArrayList<SmcBillSkuBO> skuList = new ArrayList<SmcBillSkuBO>();
            for (OutSkuDetailBO bo1 : bo.getOutDetail()) {
                List<String> imsiList = Arrays.asList(bo1.getInvids().split(","));
                if (CollectionUtils.isEmpty(imsiList)) {
                    rspBO.setBizCode(FAIL);
                    rspBO.setBizDesc("\u7269\u6599[" + bo1.getScmCode() + "]\u7684\u4e32\u7801\u96c6\u5408\u4e3a\u7a7a");
                    return null;
                }
                Map<String, SmcSkuImsiInfoBO> materialImsiMap = this.getImsiMaterialId(imsiList);
                for (int j = 0; j < imsiList.size(); ++j) {
                    SmcBillSkuBO smcBillSkuBO = new SmcBillSkuBO();
                    smcBillSkuBO.setImsi(imsiList.get(j));
                    smcBillSkuBO.setBillDetailNum(Long.valueOf(1L));
                    SmcSkuImsiInfoBO smcSkuImsiInfoBO = materialImsiMap.get(imsiList.get(j));
                    if (StringUtils.isEmpty((Object)smcSkuImsiInfoBO)) {
                        smcBillSkuBO.setSkuId(Long.valueOf(999999999L));
                        smcBillSkuBO.setMaterialCode(bo1.getScmCode());
                    } else {
                        smcBillSkuBO.setSkuId(smcSkuImsiInfoBO.getSkuId());
                        smcBillSkuBO.setMaterialCode(smcSkuImsiInfoBO.getMaterialCode());
                    }
                    if ("1".equals(bo.getInvState())) {
                        smcBillSkuBO.setScanImsi(imsiList.get(j));
                    }
                    skuList.add(smcBillSkuBO);
                }
            }
            SmcOutStoreBillAddAbilityReqBO smcOutStoreBillAddAbilityReqBO = new SmcOutStoreBillAddAbilityReqBO();
            smcOutStoreBillAddAbilityReqBO.setAllocateNeedApprovalFlag(FAIL);
            smcOutStoreBillAddAbilityReqBO.setAllocateSource("1");
            smcOutStoreBillAddAbilityReqBO.setIdempotentByOutId("1");
            smcOutStoreBillAddAbilityReqBO.setObjSource("1");
            smcOutStoreBillAddAbilityReqBO.setBossAllocateId(allocationId);
            smcOutStoreBillAddAbilityReqBO.setObjectType("06");
            smcOutStoreBillAddAbilityReqBO.setInStoreNo(inStoreNo);
            smcOutStoreBillAddAbilityReqBO.setOutStoreNo(outStoreNo);
            smcOutStoreBillAddAbilityReqBO.setStorehouseId(outStoreNo);
            smcOutStoreBillAddAbilityReqBO.setInShopId(inShopId);
            smcOutStoreBillAddAbilityReqBO.setAllocateType("01");
            smcOutStoreBillAddAbilityReqBO.setInHallCode(inHallCode);
            smcOutStoreBillAddAbilityReqBO.setInHallName(inHallName);
            smcOutStoreBillAddAbilityReqBO.setInBossGroup(inBossMchtCodeGroup);
            smcOutStoreBillAddAbilityReqBO.setOutHallCode(outHallCode);
            smcOutStoreBillAddAbilityReqBO.setOutHallName(outHallName);
            smcOutStoreBillAddAbilityReqBO.setOutBossGroup(outBossMchtCodeGroup);
            smcOutStoreBillAddAbilityReqBO.setCreateDate(startTime);
            smcOutStoreBillAddAbilityReqBO.setSkuList(skuList);
            smcOutStoreBillAddAbilityReqBOList.add(smcOutStoreBillAddAbilityReqBO);
        }
        smcOutStoreBillAddForBatchAbilityReqBO.setSmcOutStoreBillAddAbilityReqBOList(smcOutStoreBillAddAbilityReqBOList);
        return smcOutStoreBillAddForBatchAbilityReqBO;
    }

    private Long getStockhouseId(Long shopId, String storehouseType) {
        SmcQryStockhouseListAbilityReqBO smcQryStockhouseListAbilityReqBO = new SmcQryStockhouseListAbilityReqBO();
        smcQryStockhouseListAbilityReqBO.setShopId(shopId);
        smcQryStockhouseListAbilityReqBO.setStorehouseType(storehouseType);
        smcQryStockhouseListAbilityReqBO.setStatus("1");
        smcQryStockhouseListAbilityReqBO.setPageNo(Integer.valueOf(-1));
        smcQryStockhouseListAbilityReqBO.setPageSize(Integer.valueOf(-1));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u6839\u636e\u95e8\u5e97\u548c\u7c7b\u578b\u83b7\u53d6\u4ed3\u5e93\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)smcQryStockhouseListAbilityReqBO));
        }
        SmcQryStockhouseListAbilityRspBO smcQryStockhouseListAbilityRspBO = this.smcQryStockhouseListAbilityService.qryStockhouseList(smcQryStockhouseListAbilityReqBO);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u6839\u636e\u95e8\u5e97\u548c\u7c7b\u578b\u83b7\u53d6\u4ed3\u5e93\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)smcQryStockhouseListAbilityRspBO));
        }
        if (!COMMON_SUCCEED_RESP_CODE.equals(smcQryStockhouseListAbilityRspBO.getRespCode())) {
            LOGGER.debug("\u6839\u636e\u95e8\u5e97\u548c\u7c7b\u578b\u83b7\u53d6\u4ed3\u5e93\u5931\u8d25");
            return null;
        }
        if (CollectionUtils.isEmpty((Collection)smcQryStockhouseListAbilityRspBO.getRows())) {
            LOGGER.debug("\u6839\u636e\u95e8\u5e97\u548c\u7c7b\u578b\u83b7\u53d6\u4ed3\u5e93\u65e0\u6570\u636e");
            return null;
        }
        return ((SmcStockhouseInfoBO)smcQryStockhouseListAbilityRspBO.getRows().get(0)).getStorehouseId();
    }

    private String checkReqParams(SyncAllocateDataReqBO reqBO) {
        if (reqBO == null) {
            return "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01";
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getOrderDetail())) {
            return "\u5165\u53c2\u8c03\u62e8\u6570\u636e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a";
        }
        List orderDetailBOList = reqBO.getOrderDetail();
        for (int i = 0; i < orderDetailBOList.size(); ++i) {
            AllocateOrderDetailBO v = (AllocateOrderDetailBO)orderDetailBOList.get(i);
            if (StringUtils.isEmpty((Object)v.getAllocationId())) {
                return "\u5165\u53c2\u8c03\u62e8\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01";
            }
            if (StringUtils.isEmpty((Object)v.getOutHallCode())) {
                return "\u5165\u53c2\u8c03\u51fa\u5385\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01";
            }
            if (StringUtils.isEmpty((Object)v.getOutBossMchtCodeGroup())) {
                return "\u5165\u53c2\u8c03\u51fa\u5385\u5e97\u96c6\u56e2\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01";
            }
            if (StringUtils.isEmpty((Object)v.getInHallCode())) {
                return "\u5165\u53c2\u8c03\u5165\u5385\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01";
            }
            if (StringUtils.isEmpty((Object)v.getInBossMchtCodeGroup())) {
                return "\u5165\u53c2\u8c03\u5165\u5385\u5e97\u96c6\u56e2\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01";
            }
            if (!SIGN_STATE_SET.contains(v.getSignState())) {
                return "\u5165\u53c2\u7b7e\u6536\u72b6\u6001\u503c\u6709\u8bef\uff01";
            }
            if (StringUtils.isEmpty((Object)v.getAllocationState())) {
                return "\u5165\u53c2\u8c03\u62e8\u5355\u72b6\u6001\u503c\u6709\u8bef\uff01";
            }
            if (CollectionUtils.isEmpty((Collection)v.getOutDetail())) {
                return "\u5165\u53c2\u5f53\u524d\u8c03\u51fa\u5385\u5e97\u8ba2\u5355\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a\uff01";
            }
            for (OutSkuDetailBO bo : v.getOutDetail()) {
                if (!StringUtils.isEmpty((Object)bo.getInvids())) continue;
                return "\u5165\u53c2\u8c03\u62e8\u4e32\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01";
            }
        }
        return "";
    }

    Map<String, SmcSkuImsiInfoBO> getImsiMaterialId(List<String> imsiList) {
        HashedMap retMap = new HashedMap();
        SmcQryMaterialIdByImsiAbilityReqBO qryReqBO = new SmcQryMaterialIdByImsiAbilityReqBO();
        qryReqBO.setImsiList(imsiList);
        SmcQryMaterialIdByImsiAbilityRspBO qryRspBO = this.smcQryMaterialIdByImsiAbilityService.qryMaterialIdByImsi(qryReqBO);
        if (qryRspBO != null && COMMON_SUCCEED_RESP_CODE.equals(qryRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)qryRspBO.getImsiList())) {
            for (SmcSkuImsiInfoBO bo : qryRspBO.getImsiList()) {
                retMap.put(bo.getImsi(), bo);
            }
        }
        return retMap;
    }

    static {
        SyncAllocateDataServiceImpl.initialize();
    }
}

