/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.externalinter.ability.bo.BillingBO;
import com.tydic.externalinter.ability.bo.BillingReqBO;
import com.tydic.externalinter.ability.bo.BillingRspBO;
import com.tydic.externalinter.bo.ExternaLinterResultData;
import com.tydic.externalinter.busi.bo.PublicCallExtReqBO;
import com.tydic.externalinter.busi.bo.ZJBillingBO;
import com.tydic.externalinter.busi.bo.ZJBillingReqBO;
import com.tydic.externalinter.busi.service.InvoiceServices.ZJBilllingRequestBusiService;
import com.tydic.externalinter.busi.service.PublicCallExtService;
import com.tydic.externalinter.scm.ws.bo.SendRecord;
import com.tydic.externalinter.util.ExterPropertiesUtils;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.QryEscapeBO;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ZJBilllingRequestBusiServiceImpl
implements ZJBilllingRequestBusiService {
    private static Logger logger = LoggerFactory.getLogger(ZJBilllingRequestBusiServiceImpl.class);
    @Autowired
    private PublicCallExtService publicCallExtService;
    @Resource(name="exterQryEscapeAtomService")
    private QryEscapeAtomService qryEscapeAtomService;

    public BillingRspBO billingRequestZJ(BillingReqBO reqBO) {
        ExternaLinterResultData externaLinterResultData;
        BillingRspBO rspBO = new BillingRspBO();
        logger.debug("\u5916\u90e8\u63a5\u53e3-\u6d59\u6c5f\u5f00\u7968\u8bf7\u6c42\u63a5\u53e3-\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        ZJBillingReqBO reqBaseBO = new ZJBillingReqBO();
        RspBaseBO checkRsp = this.checkParams(reqBO, reqBaseBO);
        if (!"0000".equals(checkRsp.getRespCode())) {
            rspBO.setRespCode(checkRsp.getRespCode());
            rspBO.setRespDesc(checkRsp.getRespDesc());
            return rspBO;
        }
        SendRecord sendRecord = new SendRecord();
        sendRecord.setData(JSON.toJSONString((Object)reqBaseBO));
        PublicCallExtReqBO publicCallExtReqBO = new PublicCallExtReqBO();
        publicCallExtReqBO.setBusiCode("EX_SYS_9_001");
        publicCallExtReqBO.setReqParam((Object)sendRecord);
        logger.debug("\u6d59\u6c5f\u5f00\u7968\u8bf7\u6c42\u63a5\u53e3-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5-\u5165\u53c2\uff1a" + JSON.toJSONString((Object)publicCallExtReqBO));
        try {
            externaLinterResultData = this.publicCallExtService.callService(publicCallExtReqBO);
        }
        catch (Exception e) {
            logger.error("\u6d59\u6c5f\u5f00\u7968\u8bf7\u6c42\u63a5\u53e3-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38\uff1a" + e.getMessage());
            rspBO.setRespCode("0020");
            rspBO.setRespDesc("\u6d59\u6c5f\u5f00\u7968\u8bf7\u6c42\u63a5\u53e3-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38");
            return rspBO;
        }
        logger.debug("\u6d59\u6c5f\u5f00\u7968\u8bf7\u6c42\u63a5\u53e3-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5-\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)externaLinterResultData));
        if (!externaLinterResultData.getSuccess().booleanValue()) {
            logger.debug("\u6d59\u6c5f\u5f00\u7968\u8bf7\u6c42\u63a5\u53e3-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5-\u5931\u8d25");
            rspBO.setRespCode(externaLinterResultData.getRespCode());
            rspBO.setRespDesc(externaLinterResultData.getRespDesc());
            return rspBO;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)externaLinterResultData.getRespData().toString());
        JSONObject response = jsonObject.getJSONObject("SendRecordResponse");
        JSONObject aReturn = response.getJSONObject("return");
        rspBO.setFpqqlsh(aReturn.getString("orderNum"));
        rspBO.setResultCode(aReturn.getString("retCode"));
        rspBO.setResultDesc(aReturn.getString("retMsg"));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private RspBaseBO checkParams(BillingReqBO reqBO, ZJBillingReqBO reqBaseBO) {
        RspBaseBO rspBO = new RspBaseBO();
        rspBO.setRespCode("0001");
        if (null == reqBO) {
            rspBO.setRespDesc("\u5165\u53c2\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getOrderNo())) {
            rspBO.setRespDesc("\u5165\u53c2-orderNum-\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getInvoiceDate())) {
            rspBO.setRespDesc("\u5165\u53c2-orderDate-\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getInvKind())) {
            rspBO.setRespDesc("\u5165\u53c2-invKind-\u4e3a\u7a7a");
            return rspBO;
        }
        if ("1".equals(reqBO.getInvKind())) {
            reqBO.setInvKind("51");
        } else if ("2".equals(reqBO.getInvKind())) {
            reqBO.setInvKind("51");
        } else if ("3".equals(reqBO.getInvKind())) {
            reqBO.setInvKind("0");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getBuyerName())) {
            rspBO.setRespDesc("\u5165\u53c2-getBuyerName-\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getDeptCode())) {
            rspBO.setRespDesc("\u5165\u53c2-deptCode-\u4e3a\u7a7a");
            return rspBO;
        }
        if ("0".equals(reqBO.getInvoiceLine())) {
            if (StringUtils.isBlank((CharSequence)reqBO.getTaxNum())) {
                rspBO.setRespDesc("\u5165\u53c2-clientTaxCode-\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getAddress())) {
                rspBO.setRespDesc("\u5165\u53c2-clientAddressTel-\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getTelePhone())) {
                rspBO.setRespDesc("\u5165\u53c2-clientAddressTel-\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getAccount())) {
                rspBO.setRespDesc("\u5165\u53c2-clientBankAccount-\u4e3a\u7a7a");
                return rspBO;
            }
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getIssuer())) {
            rspBO.setRespDesc("\u5165\u53c2-issuer-\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getPhone())) {
            rspBO.setRespDesc("\u5165\u53c2-getPhone-\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getTsfs())) {
            rspBO.setRespDesc("\u5165\u53c2-pushType-\u4e3a\u7a7a");
            return rspBO;
        }
        if ("2".equals(reqBO.getKpType())) {
            if (StringUtils.isBlank((CharSequence)reqBO.getFphm())) {
                rspBO.setRespDesc("\u5165\u53c2-pushType-\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getFphm())) {
                rspBO.setRespDesc("\u5165\u53c2-getFpdm-\u4e3a\u7a7a");
                return rspBO;
            }
            if ("3".equals(reqBO.getInvKind()) && StringUtils.isBlank((CharSequence)reqBO.getBillInfoNo())) {
                rspBO.setRespDesc("\u5165\u53c2-getBillInfoNo-\u4e3a\u7a7a");
                return rspBO;
            }
        }
        ArrayList<ZJBillingBO> details = new ArrayList<ZJBillingBO>();
        for (BillingBO bo : reqBO.getDetail()) {
            ZJBillingBO zjbo = new ZJBillingBO();
            if (StringUtils.isBlank((CharSequence)bo.getGoodsName())) {
                rspBO.setRespDesc("\u5165\u53c2-prodName-\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isBlank((CharSequence)bo.getGoodsType())) {
                rspBO.setRespDesc("\u5165\u53c2-getGoodsType-\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isBlank((CharSequence)bo.getTaxAmt())) {
                rspBO.setRespDesc("\u5165\u53c2-taxAmount-\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isBlank((CharSequence)bo.getSpbm())) {
                if ("7".equals(bo.getGoodsType())) {
                    zjbo.setGoodsTaxNum(ExterPropertiesUtils.getProperty("ZJ_GOODS_TAX_NUM_SEC"));
                } else {
                    zjbo.setGoodsTaxNum(ExterPropertiesUtils.getProperty("ZJ_GOODS_TAX_NUM_OTHER"));
                }
            } else {
                zjbo.setGoodsTaxNum(bo.getSpbm());
            }
            if (StringUtils.isBlank((CharSequence)bo.getYhzcbs())) {
                bo.setYhzcbs("0");
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getPrice())) {
                bo.setPrice(new BigDecimal(bo.getPrice()).divide(new BigDecimal("10000")).setScale(2, 4).toString());
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getKce())) {
                bo.setKce(new BigDecimal(bo.getKce()).divide(new BigDecimal("10000")).setScale(2, 4).toString());
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getTaxAmt())) {
                bo.setTaxAmt(new BigDecimal(bo.getTaxAmt()).divide(new BigDecimal("10000")).setScale(2, 4).toString());
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getDiscountAmount())) {
                bo.setDiscountAmount(new BigDecimal(bo.getDiscountAmount()).divide(new BigDecimal("10000")).setScale(2, 4).toString());
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getDiscountTax())) {
                bo.setDiscountTax(new BigDecimal(bo.getDiscountTax()).divide(new BigDecimal("10000")).setScale(2, 4).toString());
            }
            if (StringUtils.isBlank((CharSequence)bo.getTaxRate())) {
                List qryEscapeBOS = this.qryEscapeAtomService.listEscapeByParentCode("TAX_RATE");
                QryEscapeBO qryEscapeBO = new QryEscapeBO();
                for (QryEscapeBO item : qryEscapeBOS) {
                    if (!item.getEscapeCode().equals(reqBO.getProvinceCode())) continue;
                    BeanUtils.copyProperties((Object)item, (Object)qryEscapeBO);
                }
                if ("7".equals(bo.getGoodsType())) {
                    zjbo.setTaxRate(qryEscapeBO.getEscapeValue());
                } else {
                    zjbo.setTaxRate(qryEscapeBO.getRemark());
                }
            } else {
                zjbo.setTaxRate(bo.getTaxRate());
            }
            zjbo.setProdName(bo.getGoodsName());
            zjbo.setSpecification(bo.getSpec());
            zjbo.setUnit(bo.getUnit());
            zjbo.setQuantity(bo.getNum());
            zjbo.setTaxPrice(bo.getPrice());
            zjbo.setTaxAmount(bo.getTaxAmt());
            zjbo.setDiscountAmount(bo.getDiscountAmount());
            zjbo.setDiscountTax(bo.getDiscountTax());
            zjbo.setTaxPre(bo.getYhzcbs());
            zjbo.setTaxPreCon(bo.getTaxPreCon());
            zjbo.setZeroTax(bo.getLslbs());
            zjbo.setCorpGoodsNo(bo.getZsbm());
            zjbo.setTaxDeduction(bo.getKce());
            details.add(zjbo);
        }
        reqBaseBO.setOrderNum(Sequence.getInstance().nextId() + reqBO.getOrderNo());
        reqBaseBO.setOrderDate(reqBO.getInvoiceDate());
        reqBaseBO.setInvKind(reqBO.getInvKind());
        reqBaseBO.setDeptCode(reqBO.getDeptCode());
        reqBaseBO.setClientName(reqBO.getBuyerName());
        reqBaseBO.setClientTaxCode(reqBO.getTaxNum());
        reqBaseBO.setClientAddressTel(reqBO.getAddress() + " " + reqBO.getTelePhone());
        reqBaseBO.setClientBankAccount(reqBO.getAccount());
        reqBaseBO.setIssuer(reqBO.getIssuer());
        reqBaseBO.setChecker(reqBO.getChecker());
        reqBaseBO.setPayee(reqBO.getPayee());
        reqBaseBO.setRemark(this.subRemark(reqBO.getOrderNo(), reqBO.getRemark()));
        reqBaseBO.setRefInvCode(reqBO.getFpdm());
        reqBaseBO.setRefInvNumber(reqBO.getFphm());
        reqBaseBO.setRefNoticeNumber(reqBO.getBillInfoNo());
        reqBaseBO.setPushType(reqBO.getTsfs());
        reqBaseBO.setPushPhone(reqBO.getPhone());
        reqBaseBO.setPushEmail(reqBO.getEmail());
        reqBaseBO.setDetails(details);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String subRemark(String orderNo, String remark) {
        int length1 = orderNo.length();
        StringBuilder newRemark = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)remark)) {
            int left = 200 - length1 - 2;
            String tempStr = null;
            int len = 0;
            int sum2 = 0;
            for (int i = 0; i < remark.length(); ++i) {
                tempStr = String.valueOf(remark.charAt(i));
                len = tempStr.getBytes().length;
                if (len > 1) {
                    if ((sum2 += len) >= left) break;
                    newRemark.append(tempStr);
                    continue;
                }
                if (++sum2 >= left) break;
                newRemark.append(tempStr);
            }
        }
        return orderNo + "," + newRemark.toString();
    }
}

