/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.util;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DesUtil {
    private static Logger logger = LoggerFactory.getLogger(DesUtil.class);
    private static final String ALGORITHM = "DES";
    private static final String ALGORITHM_CBC = "DES/CBC/PKCS5Padding";

    private static byte[] encrypt(byte[] data, byte[] key) throws Exception {
        SecureRandom sr = new SecureRandom();
        DESKeySpec dks = new DESKeySpec(key);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(ALGORITHM);
        SecretKey secretKey = keyFactory.generateSecret(dks);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, (Key)secretKey, sr);
        return cipher.doFinal(data);
    }

    private static byte[] decrypt(byte[] data, byte[] key) throws Exception {
        SecureRandom sr = new SecureRandom();
        DESKeySpec dks = new DESKeySpec(key);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(ALGORITHM);
        SecretKey secretKey = keyFactory.generateSecret(dks);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, (Key)secretKey, sr);
        return cipher.doFinal(data);
    }

    public static String decrypt_CBC(String data, String key, String iv) throws Exception {
        return new String(DesUtil.decrypt(ALGORITHM_CBC, DesUtil.hex2byte(data.getBytes()), key.getBytes(), iv.getBytes()));
    }

    public static String encrypt_CBC(Object json, String appsecret) throws Exception {
        Map map = (Map)JSONObject.parseObject((String)json.toString(), (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        String orderStr = map.get("order").toString();
        String key = appsecret.substring(0, 8);
        String iv = appsecret.substring(8, 16);
        String order = DesUtil.byte2hex(DesUtil.encrypt(ALGORITHM_CBC, orderStr.getBytes(), key.getBytes(), iv.getBytes()));
        return "identity=" + map.get("identity") + "&order=" + order;
    }

    public static byte[] hex2byte(byte[] hex) {
        if (hex.length % 2 != 0) {
            throw new IllegalArgumentException("\u957f\u5ea6\u4e0d\u662f\u5076\u6570");
        }
        byte[] result = new byte[hex.length / 2];
        for (int i = 0; i < hex.length; i += 2) {
            String s = new String(hex, i, 2);
            result[i / 2] = (byte)Integer.parseInt(s, 16);
        }
        return result;
    }

    public static String byte2hex(byte[] bytes) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte b : bytes) {
            String s = Integer.toHexString(b & 0xFF);
            if (s.length() == 1) {
                stringBuilder.append("0").append(s);
                continue;
            }
            stringBuilder.append(s);
        }
        return stringBuilder.toString().toUpperCase();
    }

    private static byte[] encrypt(String algorithm, byte[] data, byte[] key, byte[] iv) throws Exception {
        DESKeySpec dks = new DESKeySpec(key);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(ALGORITHM);
        SecretKey secretKey = keyFactory.generateSecret(dks);
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(1, (Key)secretKey, ivSpec);
        return cipher.doFinal(data);
    }

    private static byte[] decrypt(String algorithm, byte[] data, byte[] key, byte[] iv) throws Exception {
        DESKeySpec dks = new DESKeySpec(key);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(ALGORITHM);
        SecretKey secretKey = keyFactory.generateSecret(dks);
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(2, (Key)secretKey, ivSpec);
        return cipher.doFinal(data);
    }

    public static void main(String[] args) throws Exception {
        String appsecret = "ERhkQBl6BIio08c4";
        String s = DesUtil.decrypt_CBC("654352512A479AE269CD286701C9B07A610ADA0D51E6838EB5C5E1742FC241F3E2AD21ECDDC614A5B86AD4598E6D6A1B4BA3696AB9B42DC1B371988A2488D9CD4C3268EEB1933836A0B740D9C7D6F5B0194DC52A600728CC7E136FBD79B8107BBE4E13DFBEF981271BB656CB214E0E993A7A6E1E60B78651AC8F59A87A8FE498454F9FB26B0AA355F381CA0564D4856860C5B04D257E345942F6437DA79EDDFE00745A5BD5F072EC38AF52D138FEB1F2E9FB305040CEF9B43AA3677C69716DF09E1B15213AF5C1C9AE528A59C4D3B62B56F373C5C32BF51E2350D2D98ECC11E9499A09B2486D3F4DACFEEE35C35EC826A6C8B6FB929D35F9E00FB7234A5AF139A74A755BF440B81129E6A2CF6E45FD6D93E2F67BBC9A4913BD70569589DC6366EB4C05BC24867E163581C998C507E967F5EA7F8351222A1D3419625A9393AE6DB95BF8275C9B7B54BAC58285486A384439A3226D2142D61EF04B4901CA99EE7B3640C3E1CDCE983E08254977FCF7EE3FC068C5A926CB7D515F5C0E41E8A947E11BBCE02A9CC9027598F814AB7698877A2D7738661E259AEA4E0C70C60553A373F863111516F4CCDDFB502E27D8761045B609DB04A45F07579C867ECDAF05DC4835E036E38C012B1CD7BA864C9A04B1CD78A8E8374F15C1330A642FF6EF44A441D2A05404F485E28F", appsecret.substring(0, 8), appsecret.substring(8, 16));
        System.out.println(s);
    }
}

