/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.util;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

public class Rsa {
    public static void main(String[] args) {
        Rsa r = new Rsa();
        new Generator();
        Keys key = Generator.generate();
        String pri = key.getPrivateKey();
        String pub = key.getPublicKey();
        System.out.println(pri);
        System.out.println("-----");
        System.out.println(pub);
    }

    public static class Decoder {
        private PublicKey mPublicKey;
        private Cipher cipher;

        public Decoder(String publicKey) {
            Security.addProvider((Provider)new BouncyCastleProvider());
            X509EncodedKeySpec publicX509 = new X509EncodedKeySpec(Base64.decode((byte[])publicKey.getBytes()));
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
                this.mPublicKey = keyFactory.generatePublic(publicX509);
                this.cipher = Cipher.getInstance("RSA", "BC");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public String decode(String source) {
            try {
                this.cipher.init(2, this.mPublicKey);
                byte[] output = this.cipher.doFinal(Base64.decode((byte[])source.getBytes()));
                return new String(output, "utf-8");
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static class Encoder {
        private PrivateKey mPrivateKey;
        private Cipher cipher;

        public Encoder(String privateKey) {
            Security.addProvider((Provider)new BouncyCastleProvider());
            PKCS8EncodedKeySpec privatePKCS8 = new PKCS8EncodedKeySpec(Base64.decode((byte[])privateKey.getBytes()));
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
                this.mPrivateKey = keyFactory.generatePrivate(privatePKCS8);
                this.cipher = Cipher.getInstance("RSA", "BC");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public String encode(String source) {
            try {
                this.cipher.init(1, this.mPrivateKey);
                byte[] cipherText = this.cipher.doFinal(source.getBytes("utf-8"));
                return new String(Base64.encode((byte[])cipherText));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static class Generator {
        public static Keys generate() {
            Security.addProvider((Provider)new BouncyCastleProvider());
            try {
                KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA", "BC");
                generator.initialize(2048, new SecureRandom());
                KeyPair pair = generator.generateKeyPair();
                PublicKey publicKey = pair.getPublic();
                PrivateKey privateKey = pair.getPrivate();
                return new Keys(new String(Base64.encode((byte[])privateKey.getEncoded())), new String(Base64.encode((byte[])publicKey.getEncoded())));
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (NoSuchProviderException e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static class Keys {
        private String privateKey;
        private String publicKey;

        public Keys(String privateKey, String publicKey) {
            this.privateKey = privateKey;
            this.publicKey = publicKey;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }

        public String getPublicKey() {
            return this.publicKey;
        }
    }
}

