/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.atom.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.ohaotian.plugin.db.Page;
import com.tydic.externalinter.ability.bo.CtmsOrderSyncRecordBO;
import com.tydic.externalinter.atom.CtmsOrderSyncRecordAtomService;
import com.tydic.externalinter.dao.CtmsOrderSyncRecordDao;
import com.tydic.externalinter.dao.po.CtmsOrderSyncRecordPO;
import com.tydic.externalinter.dao.po.OrderDetailsPO;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CtmsOrderSyncRecordAtomServiceImpl
implements CtmsOrderSyncRecordAtomService {
    private static final Logger log = LoggerFactory.getLogger(CtmsOrderSyncRecordAtomServiceImpl.class);
    @Autowired
    private CtmsOrderSyncRecordDao ctmsOrderSyncRecordDao;

    @Override
    public List<CtmsOrderSyncRecordBO> saveRecordBatch(List<CtmsOrderSyncRecordBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            log.error("\u8ba2\u5355\u540c\u6b65ctms\u8bb0\u5f55\u8868\u539f\u5b50\u5c42\u5165\u53c2\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u8ba2\u5355\u540c\u6b65ctms\u8bb0\u5f55\u8868\u539f\u5b50\u5c42\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<CtmsOrderSyncRecordPO> pos = new ArrayList<CtmsOrderSyncRecordPO>(reqBOs.size());
        for (CtmsOrderSyncRecordBO reqBO : reqBOs) {
            this.checkParam(reqBO);
            CtmsOrderSyncRecordPO ctmsOrderSyncRecordPO = new CtmsOrderSyncRecordPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)ctmsOrderSyncRecordPO);
            ctmsOrderSyncRecordPO.setCreateTime(new Date());
            pos.add(ctmsOrderSyncRecordPO);
        }
        try {
            this.ctmsOrderSyncRecordDao.batchInsert(pos);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u65b0\u589e\u8ba2\u5355\u540c\u6b65ctms\u8bb0\u5f55\u8868\u539f\u5b50\u5c42\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0006", "\u6279\u91cf\u65b0\u589e\u8ba2\u5355\u540c\u6b65ctms\u8bb0\u5f55\u8868\u539f\u5b50\u5c42\u5931\u8d25");
        }
        ArrayList<CtmsOrderSyncRecordBO> bos = new ArrayList<CtmsOrderSyncRecordBO>(pos.size());
        for (CtmsOrderSyncRecordPO po : pos) {
            CtmsOrderSyncRecordBO ctmsOrderSyncRecordBO = new CtmsOrderSyncRecordBO();
            BeanUtils.copyProperties((Object)po, (Object)ctmsOrderSyncRecordBO);
            bos.add(ctmsOrderSyncRecordBO);
        }
        return bos;
    }

    @Override
    public List<OrderDetailsPO> selectByPage(CtmsOrderSyncRecordBO recordPO, Page<Map<String, Object>> page) {
        List<OrderDetailsPO> pos;
        log.info("\u8ba2\u5355\u540c\u6b65ctms\u8bb0\u5f55\u8868\u539f\u5b50\u5c42\u5165\u53c2" + JSON.toJSONString((Object)recordPO) + JSON.toJSONString(page));
        if (null == recordPO) {
            log.error("\u8ba2\u5355\u540c\u6b65ctms\u8bb0\u5f55\u8868\u539f\u5b50\u5c42\u5165\u53c2\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u8ba2\u5355\u540c\u6b65ctms\u8bb0\u5f55\u8868\u539f\u5b50\u5c42\u5165\u53c2\u4e3a\u7a7a");
        }
        CtmsOrderSyncRecordPO po = new CtmsOrderSyncRecordPO();
        BeanUtils.copyProperties((Object)recordPO, (Object)po);
        try {
            pos = this.ctmsOrderSyncRecordDao.selectByPage(page, po);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u67e5\u8be2\u8ba2\u5355\u540c\u6b65ctms\u8bb0\u5f55\u8868\u539f\u5b50\u5c42\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0006", "\u6279\u91cf\u67e5\u8be2\u8ba2\u5355\u540c\u6b65ctms\u8bb0\u5f55\u8868\u539f\u5b50\u5c42\u5931\u8d25");
        }
        log.info("\u8ba2\u5355\u540c\u6b65ctms\u8bb0\u5f55\u8868\u539f\u5b50\u5c42\u51fa\u53c2" + JSON.toJSONString(pos));
        if (CollectionUtils.isEmpty(pos)) {
            return null;
        }
        return pos;
    }

    @Override
    public List<CtmsOrderSyncRecordBO> selectCtmsOrderSyncRecord(List<CtmsOrderSyncRecordBO> ctmsOrderSyncRecordPOS) {
        List<CtmsOrderSyncRecordPO> syncRecordPOS;
        log.info("\u8ba2\u5355\u540c\u6b65ctms\u8bb0\u5f55\u8868\u539f\u5b50\u5c42\u5165\u53c2" + JSON.toJSONString(ctmsOrderSyncRecordPOS));
        if (CollectionUtils.isEmpty(ctmsOrderSyncRecordPOS)) {
            log.error("\u539f\u5b50\u5c42\u9500\u552e\u8ba2\u5355\u53f7\u5165\u53c2\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u539f\u5b50\u5c42\u9500\u552e\u8ba2\u5355\u53f7\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<CtmsOrderSyncRecordPO> pos = new ArrayList<CtmsOrderSyncRecordPO>(ctmsOrderSyncRecordPOS.size());
        for (CtmsOrderSyncRecordBO ctmsOrderSyncRecordPO : ctmsOrderSyncRecordPOS) {
            CtmsOrderSyncRecordPO orderSyncRecordPO = new CtmsOrderSyncRecordPO();
            BeanUtils.copyProperties((Object)ctmsOrderSyncRecordPO, (Object)orderSyncRecordPO);
            pos.add(orderSyncRecordPO);
        }
        try {
            syncRecordPOS = this.ctmsOrderSyncRecordDao.selectCtmsOrderSyncRecord(pos);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u67e5\u8be2\u8ba2\u5355\u540c\u6b65ctms\u8bb0\u5f55\u8868\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u6279\u91cf\u67e5\u8be2\u8ba2\u5355\u540c\u6b65ctms\u8bb0\u5f55\u8868\u4fe1\u606f\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(syncRecordPOS)) {
            return null;
        }
        ArrayList<CtmsOrderSyncRecordBO> bos = new ArrayList<CtmsOrderSyncRecordBO>(syncRecordPOS.size());
        for (CtmsOrderSyncRecordPO syncRecordPO : syncRecordPOS) {
            CtmsOrderSyncRecordBO ctmsOrderSyncRecordBO = new CtmsOrderSyncRecordBO();
            BeanUtils.copyProperties((Object)syncRecordPO, (Object)ctmsOrderSyncRecordBO);
            bos.add(ctmsOrderSyncRecordBO);
        }
        return bos;
    }

    @Override
    public void batchUpdate(List<CtmsOrderSyncRecordBO> recordBOS) {
        if (CollectionUtils.isEmpty(recordBOS)) {
            log.error("\u539f\u5b50\u5c42\u9500\u552e\u8ba2\u5355\u53f7\u5165\u53c2\u96c6\u5408\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u539f\u5b50\u5c42\u9500\u552e\u8ba2\u5355\u53f7\u5165\u53c2\u96c6\u5408\u4e3a\u7a7a");
        }
        ArrayList<CtmsOrderSyncRecordPO> pos = new ArrayList<CtmsOrderSyncRecordPO>();
        recordBOS.forEach(item -> {
            if (StringUtils.isBlank((CharSequence)item.getOrderCode())) {
                log.error("\u539f\u5b50\u5c42\u9500\u552e\u8ba2\u5355\u53f7\u5165\u53c2\u4e3a\u7a7a");
                TkThrExceptionUtils.thrEmptyExce((String)"\u539f\u5b50\u5c42\u9500\u552e\u8ba2\u5355\u53f7\u5165\u53c2\u4e3a\u7a7a");
            }
            CtmsOrderSyncRecordPO ctmsOrderSyncRecordPO = new CtmsOrderSyncRecordPO();
            BeanUtils.copyProperties((Object)item, (Object)ctmsOrderSyncRecordPO);
            pos.add(ctmsOrderSyncRecordPO);
        });
        try {
            this.ctmsOrderSyncRecordDao.batchUpdate(pos);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u66f4\u65b0\u8ba2\u5355\u540c\u6b65ctms\u8bb0\u5f55\u8868\u5931\u8d25:" + e.getMessage());
            TkThrExceptionUtils.thrEmptyExce((String)"\u6279\u91cf\u66f4\u65b0\u8ba2\u5355\u540c\u6b65ctms\u8bb0\u5f55\u8868\u5931\u8d25");
        }
    }

    private void checkParam(CtmsOrderSyncRecordBO bo) {
        if (StringUtils.isBlank((CharSequence)bo.getOrderCode())) {
            log.error("\u9500\u552e\u8ba2\u5355\u53f7\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u9500\u552e\u8ba2\u5355\u53f7\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getIsSale())) {
            log.error("\u9500\u552e\u9000\u9500\u552e\u6807\u5fd7\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u9500\u552e\u9000\u9500\u552e\u6807\u5fd7\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getSaleType())) {
            log.error("\u9500\u552e\u7c7b\u578b\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u9500\u552e\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getSalesKind())) {
            log.error("\u9500\u552e\u5b50\u7c7b\u578b\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u9500\u552e\u5b50\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (null == bo.getSaleDate()) {
            log.error("\u9500\u552e\u65f6\u95f4\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u9500\u552e\u65f6\u95f4\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getEmployeeId())) {
            log.error("\u64cd\u4f5c\u5458\u7f16\u7801\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u64cd\u4f5c\u5458\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getShopCode())) {
            log.error("\u95e8\u5e97\u7f16\u7801\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u95e8\u5e97\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getOrgCode())) {
            log.error("boss\u673a\u6784\u7f16\u7801\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"boss\u673a\u6784\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getPayment())) {
            log.error("\u652f\u4ed8\u65b9\u5f0f\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u652f\u4ed8\u65b9\u5f0f\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getOrderStatus())) {
            log.error("\u8ba2\u5355\u72b6\u6001\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u8ba2\u5355\u72b6\u6001\u4e3a\u7a7a");
        }
    }
}

