/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.atom.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.externalinter.ability.bo.ScmOrderSyncItemBO;
import com.tydic.externalinter.ability.bo.ScmOrderSyncItemRecordReqBO;
import com.tydic.externalinter.ability.bo.ScmOrderSyncItemRecordRsqBO;
import com.tydic.externalinter.ability.bo.ScmOrderSyncItemReqBO;
import com.tydic.externalinter.atom.ScmOrderSyncItemAtomService;
import com.tydic.externalinter.dao.ScmOrderSyncItemDAO;
import com.tydic.externalinter.dao.po.ScmOrderSyncItemPO;
import com.tydic.externalinter.dao.po.ScmOrderSyncItemRecordPO;
import com.tydic.newretail.toolkit.util.TkThrExceptionUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScmOrderSyncItemAtomServiceImpl
implements ScmOrderSyncItemAtomService {
    private static final Logger log = LoggerFactory.getLogger(ScmOrderSyncItemAtomServiceImpl.class);
    @Autowired
    private ScmOrderSyncItemDAO scmOrderSyncItemDAO;

    @Override
    public List<ScmOrderSyncItemBO> saveRecordBatch(List<ScmOrderSyncItemBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            log.error("scm\u9500\u552e\u8ba2\u5355\u540c\u6b65\u660e\u7ec6\u96c6\u5408\u539f\u5b50\u5c42\u5165\u53c2\u4e3a\u7a7a");
            throw new ResourceException("0001", "scm\u9500\u552e\u8ba2\u5355\u540c\u6b65\u660e\u7ec6\u96c6\u5408\u539f\u5b50\u5c42\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<ScmOrderSyncItemPO> pos = new ArrayList<ScmOrderSyncItemPO>(reqBOs.size());
        for (ScmOrderSyncItemBO bo : reqBOs) {
            this.checkParams(bo);
            ScmOrderSyncItemPO po = new ScmOrderSyncItemPO();
            BeanUtils.copyProperties((Object)bo, (Object)po);
            po.setCreateTime(new Date());
            pos.add(po);
        }
        try {
            this.scmOrderSyncItemDAO.insertBatch(pos);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u65b0\u589escm\u9500\u552e\u8ba2\u5355\u540c\u6b65\u660e\u7ec6\u539f\u5b50\u5c42\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0006", "\u6279\u91cf\u65b0\u589escm\u9500\u552e\u8ba2\u5355\u540c\u6b65\u660e\u7ec6\u539f\u5b50\u5c42\u5931\u8d25");
        }
        ArrayList<ScmOrderSyncItemBO> rspList = new ArrayList<ScmOrderSyncItemBO>(pos.size());
        for (ScmOrderSyncItemPO po : pos) {
            ScmOrderSyncItemBO bo = new ScmOrderSyncItemBO();
            BeanUtils.copyProperties((Object)po, (Object)bo);
            rspList.add(bo);
        }
        return rspList;
    }

    @Override
    public void modifyBatchByKey(List<ScmOrderSyncItemBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            log.error("\u6279\u91cf\u66f4\u65b0scm\u9500\u552e\u8ba2\u5355\u540c\u6b65\u660e\u7ec6\u5165\u53c2\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u6279\u91cf\u66f4\u65b0scm\u9500\u552e\u8ba2\u5355\u540c\u6b65\u660e\u7ec6\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<ScmOrderSyncItemPO> list = new ArrayList<ScmOrderSyncItemPO>(reqBOs.size());
        for (ScmOrderSyncItemBO bo : reqBOs) {
            ScmOrderSyncItemPO po = new ScmOrderSyncItemPO();
            BeanUtils.copyProperties((Object)bo, (Object)po);
            po.setUpdateTime(new Date());
            list.add(po);
        }
        try {
            this.scmOrderSyncItemDAO.updateByBatch(list);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u66f4\u65b0scm\u9500\u552e\u8ba2\u5355\u540c\u6b65\u660e\u7ec6\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrUpdExce((String)"\u6279\u91cf\u66f4\u65b0scm\u9500\u552e\u8ba2\u5355\u540c\u6b65\u660e\u7ec6\u5931\u8d25");
        }
    }

    @Override
    public List<ScmOrderSyncItemBO> selectScmOrderSyncItemByList(ScmOrderSyncItemReqBO reqBOs) {
        List<ScmOrderSyncItemPO> bos;
        log.debug("\u6279\u91cf\u67e5\u8be2scm\u9500\u552e\u8ba2\u5355\u540c\u6b65\u660e\u7ec6\u8868\u539f\u5b50\u5c42\u5165\u53c2" + reqBOs.toString());
        ArrayList<ScmOrderSyncItemPO> pos = new ArrayList<ScmOrderSyncItemPO>(reqBOs.getItem().size());
        for (ScmOrderSyncItemBO bo : reqBOs.getItem()) {
            ScmOrderSyncItemPO po = new ScmOrderSyncItemPO();
            BeanUtils.copyProperties((Object)bo, (Object)po);
            pos.add(po);
        }
        try {
            bos = this.scmOrderSyncItemDAO.selectScmOrderSyncItemByList(pos);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u67e5\u8be2scm\u9500\u552e\u8ba2\u5355\u540c\u6b65\u660e\u7ec6\u8868\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u6279\u91cf\u67e5\u8be2scm\u9500\u552e\u8ba2\u5355\u540c\u6b65\u660e\u7ec6\u8868\u4fe1\u606f\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(bos)) {
            return null;
        }
        ArrayList<ScmOrderSyncItemBO> rspBOs = new ArrayList<ScmOrderSyncItemBO>(bos.size());
        for (ScmOrderSyncItemPO po : bos) {
            ScmOrderSyncItemBO bo = new ScmOrderSyncItemBO();
            BeanUtils.copyProperties((Object)po, (Object)bo);
            rspBOs.add(bo);
        }
        return rspBOs;
    }

    @Override
    public List<ScmOrderSyncItemBO> selectByBvbelns(Set<String> bvbelns) {
        if (CollectionUtils.isEmpty(bvbelns)) {
            return new ArrayList<ScmOrderSyncItemBO>();
        }
        ArrayList<ScmOrderSyncItemBO> bos = new ArrayList<ScmOrderSyncItemBO>();
        List<ScmOrderSyncItemPO> pos = null;
        try {
            pos = this.scmOrderSyncItemDAO.selectByBvbelns(bvbelns);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (CollectionUtils.isNotEmpty(pos)) {
            for (ScmOrderSyncItemPO po : pos) {
                ScmOrderSyncItemBO bo = new ScmOrderSyncItemBO();
                BeanUtils.copyProperties((Object)po, (Object)bo);
                bos.add(bo);
            }
        }
        return bos;
    }

    private void checkParams(ScmOrderSyncItemBO bo) {
        if (StringUtils.isBlank((CharSequence)bo.getBvbeln())) {
            log.error("\u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getBposnr())) {
            log.error("\u8ba2\u5355\u884c\u53f7\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u8ba2\u5355\u884c\u53f7\u4e3a\u7a7a");
        }
        if (null == bo.getKwmeng()) {
            log.error("\u8ba2\u5355\u6570\u91cf\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u8ba2\u5355\u6570\u91cf\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getMatnr())) {
            log.error("SCM\u7269\u6599\u53f7\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"SCM\u7269\u6599\u53f7\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getWerks())) {
            log.error("\u5de5\u5382\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5de5\u5382\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getLgort())) {
            log.error("\u5e93\u5b58\u5730\u70b9\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u5e93\u5b58\u5730\u70b9\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getItemStatus())) {
            log.error("\u660e\u7ec6\u72b6\u6001\u4e3a\u7a7a");
            TkThrExceptionUtils.thrEmptyExce((String)"\u660e\u7ec6\u72b6\u6001\u4e3a\u7a7a");
        }
    }

    @Override
    public List<ScmOrderSyncItemRecordRsqBO> listScmSyncOrderItemRecord(ScmOrderSyncItemRecordReqBO reqBO) {
        log.info("scm\u8ba2\u5355\u540c\u6b65\u660e\u7ec6\u53ca\u8bb0\u5f55\u539f\u5b50\u5c42\u5165\u53c2-------------" + reqBO);
        ArrayList<ScmOrderSyncItemRecordRsqBO> res = new ArrayList<ScmOrderSyncItemRecordRsqBO>();
        try {
            List<ScmOrderSyncItemRecordPO> pos = this.scmOrderSyncItemDAO.listScmSyncOrderItemRecord(reqBO);
            if (CollectionUtils.isNotEmpty(pos)) {
                pos.forEach(item -> {
                    ScmOrderSyncItemRecordRsqBO rspBo = new ScmOrderSyncItemRecordRsqBO();
                    BeanUtils.copyProperties((Object)item, (Object)rspBo);
                    res.add(rspBo);
                });
            }
        }
        catch (Exception e) {
            log.error("scm\u8ba2\u5355\u540c\u6b65\u660e\u7ec6\u53ca\u8bb0\u5f55\u539f\u5b50\u5c42\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
            TkThrExceptionUtils.thrQryRspEmptyExce((String)"scm\u8ba2\u5355\u540c\u6b65\u660e\u7ec6\u53ca\u8bb0\u5f55\u539f\u5b50\u5c42\u67e5\u8be2\u5931\u8d25");
        }
        return res;
    }

    @Override
    public int updateScmSyncOrderItemByBo(ScmOrderSyncItemBO reqBO) {
        log.info("\u4fee\u6539\u8ba2\u5355\u660e\u7ec6\u5165\u53c2--------" + JSON.toJSONString((Object)reqBO));
        ScmOrderSyncItemPO po = new ScmOrderSyncItemPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        int res = 0;
        try {
            res = this.scmOrderSyncItemDAO.updateByPo(po);
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u8ba2\u5355\u660e\u7ec6\u5931\u8d25" + e.getMessage());
            TkThrExceptionUtils.thrUpdExce((String)"\u539f\u5b50\u5c42\u4fee\u6539\u8ba2\u5355\u660e\u7ec6\u5931\u8d25");
        }
        return res;
    }

    @Override
    public int deleteScmSyncOrderItemByBo(ScmOrderSyncItemBO itemBO) {
        log.info("\u539f\u5b50\u5c42\u5220\u9664scm\u540c\u6b65\u8ba2\u5355\u660e\u7ec6----------" + JSON.toJSONString((Object)itemBO));
        ScmOrderSyncItemPO po = new ScmOrderSyncItemPO();
        BeanUtils.copyProperties((Object)itemBO, (Object)po);
        int itemRes = 0;
        try {
            itemRes = this.scmOrderSyncItemDAO.deleteScmSyncOrderItemByPo(po);
        }
        catch (Exception e) {
            log.error("\u539f\u5b50\u5c42\u5220\u9664scm\u540c\u6b65\u8ba2\u5355\u660e\u7ec6\u5931\u8d25---" + e.getMessage());
            TkThrExceptionUtils.thrDelExce((String)"\u539f\u5b50\u5c42\u5220\u9664scm\u540c\u6b65\u8ba2\u5355\u660e\u7ec6\u5931\u8d25");
        }
        return itemRes;
    }

    @Override
    public int deleteAllItemByBvblen(String bvbeln) {
        log.info("\u5220\u9664\u8be5\u8ba2\u5355\u7f16\u53f7" + bvbeln + "\u4e0b\u6240\u6709\u7684\u660e\u7ec6\u8bb0\u5f55");
        ScmOrderSyncItemPO po = new ScmOrderSyncItemPO();
        po.setBvbeln(bvbeln);
        int itemRes = 0;
        try {
            itemRes = this.scmOrderSyncItemDAO.deleteAllItemByBvblen(po);
        }
        catch (Exception e) {
            log.error("\u539f\u5b50\u5c42\u5220\u9664\u8be5\u8ba2\u5355\u7f16\u53f7" + bvbeln + "\u4e0bscm\u540c\u6b65\u8ba2\u5355\u660e\u7ec6\u5931\u8d25---" + e.getMessage());
            TkThrExceptionUtils.thrDelExce((String)("\u539f\u5b50\u5c42\u5220\u9664\u8be5\u8ba2\u5355\u7f16\u53f7" + bvbeln + "\u4e0bscm\u540c\u6b65\u8ba2\u5355\u660e\u7ec6\u5931\u8d25---"));
        }
        return itemRes;
    }

    @Override
    public void updateScmSyncOrderItemByBatch(List<ScmOrderSyncItemBO> itemBOs) {
        log.info("\u4fee\u6539\u8ba2\u5355\u660e\u7ec6\u5165\u53c2--------" + JSON.toJSONString(itemBOs));
        if (CollectionUtils.isEmpty(itemBOs)) {
            TkThrExceptionUtils.thrEmptyExce((String)"\u4fee\u6539\u8ba2\u5355\u660e\u7ec6\u5165\u53c2\u4e3a\u7a7a");
        }
        List<ScmOrderSyncItemPO> pos = itemBOs.stream().map(e -> {
            ScmOrderSyncItemPO po = new ScmOrderSyncItemPO();
            BeanUtils.copyProperties((Object)e, (Object)po);
            po.setUpdateTime(new Date());
            return po;
        }).collect(Collectors.toList());
        try {
            this.scmOrderSyncItemDAO.updateItemByBatch(pos);
        }
        catch (Exception e2) {
            log.error("\u539f\u5b50\u5c42\u6279\u91cf\u4fee\u6539\u8ba2\u5355\u660e\u7ec6\u5931\u8d25" + e2.getMessage());
            TkThrExceptionUtils.thrUpdExce((String)"\u539f\u5b50\u5c42\u6279\u91cf\u4fee\u6539\u8ba2\u5355\u660e\u7ec6\u5931\u8d25");
        }
    }

    @Override
    public Set<String> selectBvbelnsByOldOrder(Set<String> zyul2s) {
        HashSet<String> result = new HashSet();
        try {
            result = this.scmOrderSyncItemDAO.selectBvbelnsByOldOrder(zyul2s);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u672a\u6210\u529f\u9500\u5355\u5931\u8d25\uff01\uff01");
            TkThrExceptionUtils.thrQryExce((String)("\u67e5\u8be2\u672a\u6210\u529f\u9500\u5355\u5931\u8d25" + e));
        }
        return result;
    }

    @Override
    public void updateStatusBybvbelns(Set<String> bvbelns) {
        try {
            this.scmOrderSyncItemDAO.updateStatusBybvbelns(bvbelns);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u9500\u5355\u662f\u5426\u62c6\u5355\u72b6\u6001\u5931\u8d25\uff01" + e);
        }
    }
}

