/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.atom.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.externalinter.atom.SpecialSalesAtomService;
import com.tydic.externalinter.atom.bo.SpecialSalesRecordBO;
import com.tydic.externalinter.constant.ExtExceptionConstant;
import com.tydic.externalinter.dao.SpecialSalesRecordDao;
import com.tydic.externalinter.dao.SpecialSalesRecordDetailsDao;
import com.tydic.externalinter.dao.po.SpecialSalesRecordDetailsPO;
import com.tydic.externalinter.dao.po.SpecialSalesRecordPO;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SpecialSalesAtomServiceImpl
implements SpecialSalesAtomService {
    private static final Logger logger = LoggerFactory.getLogger(SpecialSalesAtomServiceImpl.class);
    private static final Boolean isDebug = logger.isDebugEnabled();
    @Autowired
    private SpecialSalesRecordDao specialSalesRecordDao;
    @Autowired
    private SpecialSalesRecordDetailsDao specialSalesRecordDetailsDao;

    @Override
    public SpecialSalesRecordBO addSpecialSalesRecord(SpecialSalesRecordBO recordBO, List<SpecialSalesRecordDetailsPO> detailsPOs) {
        if (isDebug.booleanValue()) {
            logger.debug("\u65b0\u589e\u7279\u4ef7\u7533\u8bf7\u8bb0\u5f55");
        }
        recordBO.setCreateTime(new Date());
        SpecialSalesRecordPO po = SpecialSalesRecordPO.specialSalesRecordBOToPO(recordBO);
        try {
            this.specialSalesRecordDao.insertSelective(po);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u7279\u4ef7\u7533\u8bf7\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0005", "\u65b0\u589e\u7279\u4ef7\u7533\u8bf7\u5931\u8d25");
        }
        recordBO = po.specialSalesRecordPOToBO();
        if (CollectionUtils.isEmpty(detailsPOs)) {
            return recordBO;
        }
        try {
            this.specialSalesRecordDetailsDao.insertByBatch(detailsPOs, po.getSalesRecordId());
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u65b0\u589e\u7279\u4ef7\u7533\u8bf7\u8be6\u60c5\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0005", "\u6279\u91cf\u65b0\u589e\u7279\u4ef7\u7533\u8bf7\u8be6\u60c5\u5931\u8d25");
        }
        return recordBO;
    }

    @Override
    public Integer updateSpecialSalesRecord(SpecialSalesRecordBO recordBO) {
        SpecialSalesRecordPO po = SpecialSalesRecordPO.specialSalesRecordBOToPO(recordBO);
        int result = 0;
        try {
            result = this.specialSalesRecordDao.updateByPrimaryKeySelective(po);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u7279\u4ef7\u7533\u8bf7\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u66f4\u65b0\u7279\u4ef7\u7533\u8bf7\u5931\u8d25");
        }
        return result;
    }

    @Override
    public SpecialSalesRecordBO querySpecialSalesByBillId(Long billId) {
        SpecialSalesRecordPO specialSalesRecordPO = null;
        try {
            specialSalesRecordPO = this.specialSalesRecordDao.selectByBillId(billId);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7279\u4ef7\u7533\u8bf7\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0006", "\u67e5\u8be2\u7279\u4ef7\u7533\u8bf7\u8bb0\u5f55\u5931\u8d25");
        }
        if (null == specialSalesRecordPO) {
            return null;
        }
        return specialSalesRecordPO.specialSalesRecordPOToBO();
    }

    @Override
    public SpecialSalesRecordBO getSpecialSalesRecord(SpecialSalesRecordBO recordBO, List<SpecialSalesRecordDetailsPO> detailsPOs) {
        if (isDebug.booleanValue()) {
            logger.debug("\u67e5\u8be2\u7279\u4ef7\u7533\u8bf7\u8bb0\u5f55");
        }
        SpecialSalesRecordPO specialSalesRecordPO = null;
        try {
            specialSalesRecordPO = this.specialSalesRecordDao.selectByOrderId(recordBO.getOrderId());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7279\u4ef7\u7533\u8bf7\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0006", "\u6839\u636e\u3010" + recordBO.getOrderId() + "\u3011\u67e5\u8be2\u7279\u4ef7\u7533\u8bf7\u8bb0\u5f55\u5931\u8d25");
        }
        if (null != specialSalesRecordPO) {
            if ("1".equals(specialSalesRecordPO.getState()) || "0".equals(specialSalesRecordPO.getState())) {
                logger.error("\u5f53\u524d\u8ba2\u5355\u72b6\u6001\u4e0d\u5141\u8bb8\u91cd\u65b0\u7533\u8bf7");
                throw new ResourceException("0007", (String)ExtExceptionConstant.codeMap.get("0007"));
            }
            SpecialSalesRecordBO modifyBO = new SpecialSalesRecordBO();
            modifyBO.setSalesRecordId(specialSalesRecordPO.getSalesRecordId());
            modifyBO.setRecordStatus("0");
            this.updateSpecialSalesRecord(modifyBO);
        }
        if (isDebug.booleanValue()) {
            logger.debug("\u65b0\u589e\u8bb0\u5f55");
        }
        String reqBillId = UUID.randomUUID().toString().replace("-", "");
        recordBO.setReqBillId(reqBillId);
        recordBO.setRecordStatus("1");
        SpecialSalesRecordBO rspBO = this.addSpecialSalesRecord(recordBO, detailsPOs);
        return rspBO;
    }

    public static void main(String[] args) {
    }
}

