/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.atom.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.externalinter.atom.StockChangeCallHisAtomService;
import com.tydic.externalinter.dao.StockChangeCallHistoryDao;
import com.tydic.externalinter.dao.po.StockChangeCallHistoryPO;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StockChangeCallHisAtomServiceImpl
implements StockChangeCallHisAtomService {
    private static final Logger logger = LoggerFactory.getLogger(StockChangeCallHisAtomServiceImpl.class);
    @Autowired
    private StockChangeCallHistoryDao stockChangeErrorHistoryDao;

    @Override
    public StockChangeCallHistoryPO getAndSaveStockChangeCallHistory(StockChangeCallHistoryPO reqPO, Boolean saveFlag) {
        StockChangeCallHistoryPO stockChangeCallHistoryPO = null;
        try {
            StockChangeCallHistoryPO record = new StockChangeCallHistoryPO();
            record.setOrderId(reqPO.getOrderId());
            record.setOperType(reqPO.getOperType());
            record.setTaskExecStatus(reqPO.getTaskExecStatus());
            stockChangeCallHistoryPO = this.stockChangeErrorHistoryDao.selectByOrderIdAndOprType(record);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0006", "\u67e5\u8be2\u8bb0\u5f55\u5931\u8d25");
        }
        if (!saveFlag.booleanValue()) {
            return stockChangeCallHistoryPO;
        }
        if (null != stockChangeCallHistoryPO) {
            if ("05".equals(stockChangeCallHistoryPO.getTaskExecStatus()) || "02".equals(stockChangeCallHistoryPO.getTaskExecStatus()) || "03".equals(stockChangeCallHistoryPO.getTaskExecStatus()) || "04".equals(stockChangeCallHistoryPO.getTaskExecStatus())) {
                logger.error("\u5e93\u5b58\u6263\u51cf\u5df2\u5b8c\u6210\u6216\u6682\u505c\u6267\u884c");
                stockChangeCallHistoryPO.setRecordId(null);
                stockChangeCallHistoryPO.setRespCode("0014");
                stockChangeCallHistoryPO.setRespDesc("\u5e93\u5b58\u6263\u51cf\u5df2\u5b8c\u6210\u6216\u6682\u505c\u6267\u884c");
                stockChangeCallHistoryPO.setRecordStatus("0");
                this.saveStockChangeCallHistory(stockChangeCallHistoryPO);
                throw new ResourceException("0014", "\u5e93\u5b58\u6263\u52a1\u5df2\u5b8c\u6210\u6216\u6682\u505c\u6267\u884c");
            }
            stockChangeCallHistoryPO.setRecordStatus("0");
            this.modifyStockChangeCallHistory(stockChangeCallHistoryPO);
        } else {
            stockChangeCallHistoryPO = new StockChangeCallHistoryPO();
        }
        this.toModifyRecord(stockChangeCallHistoryPO, reqPO);
        stockChangeCallHistoryPO.setCreateTime(new Date());
        this.saveStockChangeCallHistory(stockChangeCallHistoryPO);
        return stockChangeCallHistoryPO;
    }

    private void toModifyRecord(StockChangeCallHistoryPO target, StockChangeCallHistoryPO source) {
        target.setRecordId(null);
        if (StringUtils.isNotBlank((CharSequence)source.getOrderId())) {
            target.setOrderId(source.getOrderId());
        }
        if (StringUtils.isNotBlank((CharSequence)source.getOrderTime())) {
            target.setOrderTime(source.getOrderTime());
        }
        if (StringUtils.isNotBlank((CharSequence)source.getOrderType())) {
            target.setOrderType(source.getOrderType());
        }
        if (null != source.getOperNum()) {
            target.setOperNum(source.getOperNum());
        }
        if (StringUtils.isNotBlank((CharSequence)source.getOperType())) {
            target.setOperType(source.getOperType());
        }
        if (StringUtils.isNotBlank((CharSequence)source.getRespCode())) {
            target.setRespCode(source.getRespCode());
        }
        if (null != source.getCreateTime()) {
            target.setCreateTime(source.getCreateTime());
        }
        if (StringUtils.isNotBlank((CharSequence)source.getTaskExecStatus())) {
            target.setTaskExecStatus(source.getTaskExecStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)source.getReservedContent())) {
            target.setReservedContent(source.getReservedContent());
        }
        if (StringUtils.isNotBlank((CharSequence)source.getRespDesc())) {
            target.setRespDesc(source.getRespDesc());
        }
        if (StringUtils.isNotBlank((CharSequence)source.getInputParams())) {
            target.setInputParams(source.getInputParams());
        }
        if (StringUtils.isNotBlank((CharSequence)source.getErpInputParams())) {
            target.setErpInputParams(source.getErpInputParams());
        }
        if (StringUtils.isNotBlank((CharSequence)source.getErpOutputParams())) {
            target.setErpOutputParams(source.getErpOutputParams());
        }
        if (StringUtils.isNotBlank((CharSequence)source.getErpReqUrl())) {
            target.setErpReqUrl(source.getErpReqUrl());
        }
        if (StringUtils.isNotBlank((CharSequence)source.getRecordStatus())) {
            target.setRecordStatus(source.getRecordStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)source.getParentOrderId())) {
            target.setParentOrderId(source.getParentOrderId());
        }
        if (StringUtils.isNotBlank((CharSequence)source.getAdjustFlag())) {
            target.setAdjustFlag(source.getAdjustFlag());
        }
    }

    @Override
    public StockChangeCallHistoryPO saveStockChangeCallHistory(StockChangeCallHistoryPO reqPO) {
        if (null == reqPO) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u5165\u53c2\u4e3a\u7a7a");
        }
        try {
            this.stockChangeErrorHistoryDao.insertSelective(reqPO);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0005", "\u66f4\u65b0\u8bb0\u5f55\u8868\u5931\u8d25");
        }
        return reqPO;
    }

    @Override
    public void modifyStockChangeCallHistory(StockChangeCallHistoryPO reqPO) {
        if (null == reqPO || null == reqPO.getRecordId()) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u5165\u53c2\u4e3a\u7a7a");
        }
        try {
            this.stockChangeErrorHistoryDao.updateByPrimaryKeySelective(reqPO);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u8bb0\u5f55\u8868\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u66f4\u65b0\u8bb0\u5f55\u8868\u5931\u8d25");
        }
    }

    @Override
    public void modifyStockChangeCallHisByOrderId(StockChangeCallHistoryPO reqPO) {
        if (null == reqPO || StringUtils.isBlank((CharSequence)reqPO.getOrderId()) || StringUtils.isBlank((CharSequence)reqPO.getOperType())) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u5165\u53c2\u4e3a\u7a7a");
        }
        try {
            this.stockChangeErrorHistoryDao.updateByOrderIdAnOperType(reqPO);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u8bb0\u5f55\u8868\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u66f4\u65b0\u8bb0\u5f55\u8868\u5931\u8d25");
        }
    }

    @Override
    public List<StockChangeCallHistoryPO> listChildOrders(String orderId, String operType) {
        StockChangeCallHistoryPO recrod = new StockChangeCallHistoryPO();
        recrod.setParentOrderId(orderId);
        recrod.setOperType(operType);
        List<StockChangeCallHistoryPO> list = null;
        try {
            list = this.stockChangeErrorHistoryDao.selectByParentOrderId(recrod);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5b50\u8ba2\u5355\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0006", "\u67e5\u8be2\u5b50\u8ba2\u5355\u5931\u8d25");
        }
        return list;
    }
}

