/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.tydic.externalinter.bo.CheckImeiReqBO;
import com.tydic.externalinter.bo.CheckImeiRspBO;
import com.tydic.externalinter.bo.CheckResultImeiBO;
import com.tydic.externalinter.bo.ExternaLinterResultData;
import com.tydic.externalinter.busi.bo.PublicCallExtReqBO;
import com.tydic.externalinter.busi.service.PublicCallExtService;
import com.tydic.externalinter.service.CheckImeiService;
import java.util.ArrayList;
import java.util.Collection;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CheckImeiServiceImpl
implements CheckImeiService {
    private static Logger logger = LoggerFactory.getLogger(CheckImeiServiceImpl.class);
    @Autowired
    private PublicCallExtService publicCallExtService;

    public CheckImeiRspBO checkImeiList(CheckImeiReqBO checkImeiReqBO) {
        CheckImeiRspBO checkImeiRspBO = new CheckImeiRspBO();
        logger.info("CheckImeiService\u5165\u53c2\uff1acheckImeiReqBO" + checkImeiReqBO.toString());
        String urlProperity = "OSPB010";
        if (!CollectionUtils.isNotEmpty((Collection)checkImeiReqBO.getImeiIds())) {
            logger.info("IMEI\u6821\u9a8c\u63a5\u53e3\uff0c\u5165\u53c2\u4e32\u53f7\u5217\u8868\u4e3a\u7a7a");
            checkImeiRspBO.setRespCode("9999");
            checkImeiRspBO.setRespDesc("IMEI\u6821\u9a8c\u63a5\u53e3\uff0c\u5165\u53c2\u4e32\u53f7\u5217\u8868\u4e3a\u7a7a");
            return checkImeiRspBO;
        }
        logger.info("\u4e32\u53f7ID\u5217\u8868\u5165\u53c2\uff1a" + checkImeiReqBO.getImeiIds().toString());
        JSONArray jsonArray = new JSONArray();
        for (String imeiId : checkImeiReqBO.getImeiIds()) {
            jsonArray.add((Object)imeiId);
        }
        logger.info("CheckImeiService\uff1ajsonArray.toString()=" + jsonArray.toString());
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)"imeiList", (Object)jsonArray);
        logger.info("CheckImeiService\uff1ajsonObj.toString()=" + jsonObj.toString());
        PublicCallExtReqBO publicCallExtReqBO = new PublicCallExtReqBO();
        publicCallExtReqBO.setBusiCode("EX_SYS_6_012");
        publicCallExtReqBO.setReqParam((Object)jsonObj);
        ExternaLinterResultData externaLinterResultData = this.publicCallExtService.callService(publicCallExtReqBO);
        logger.info("CheckImeiService\uff1aexternaLinterResultData=" + externaLinterResultData);
        if (externaLinterResultData.getSuccess().booleanValue()) {
            checkImeiRspBO.setRespCode(externaLinterResultData.getRespCode());
            checkImeiRspBO.setRespDesc(externaLinterResultData.getRespDesc());
            logger.info("CheckImeiService\uff1aexternaLinterResultData.getRespData().toString()=" + externaLinterResultData.getRespData().toString());
            JSONArray jsonArrayResult = JSONArray.fromObject((Object)externaLinterResultData.getRespData());
            logger.info("CheckImeiService\uff1ajsonArrayResult.toString()=" + jsonArrayResult.toString());
            if (jsonArrayResult != null && !jsonArrayResult.isEmpty()) {
                ArrayList<CheckResultImeiBO> resultImeiList = new ArrayList<CheckResultImeiBO>();
                for (int i = 0; i < jsonArrayResult.size(); ++i) {
                    JSONObject objTemp = jsonArrayResult.getJSONObject(i);
                    CheckResultImeiBO checkResultImeiBO = new CheckResultImeiBO();
                    checkResultImeiBO.setImeiId(objTemp.getString("imei"));
                    checkResultImeiBO.setCheckCode(objTemp.getString("bizCode"));
                    checkResultImeiBO.setCheckDesc(objTemp.getString("bizDesc"));
                    resultImeiList.add(checkResultImeiBO);
                }
                if (CollectionUtils.isNotEmpty(resultImeiList)) {
                    checkImeiRspBO.setResultImeiList(resultImeiList);
                }
            }
        } else {
            checkImeiRspBO.setRespCode(externaLinterResultData.getRespCode());
            checkImeiRspBO.setRespDesc(externaLinterResultData.getRespDesc());
        }
        logger.info("CheckImeiService\u51fa\u53c2\uff1acheckImeiRspBO.toString()=" + checkImeiRspBO.toString());
        return checkImeiRspBO;
    }
}

