/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.authority.organisation.bo.OrganisationBO;
import com.ohaotian.authority.organisation.bo.SelectStoreInfoReqBO;
import com.ohaotian.authority.organisation.bo.SelectStoreInfoRspBO;
import com.ohaotian.authority.organisation.service.SelectStoreInfoListService;
import com.tydic.externalinter.ability.bo.BillingBO;
import com.tydic.externalinter.ability.bo.BillingReqBO;
import com.tydic.externalinter.ability.bo.BillingRspBO;
import com.tydic.externalinter.bo.ExternaLinterResultData;
import com.tydic.externalinter.busi.bo.FjBillingRequestBO;
import com.tydic.externalinter.busi.bo.FjBillingRequestReqBO;
import com.tydic.externalinter.busi.bo.FjBillingRequestReqInfoBO;
import com.tydic.externalinter.busi.bo.FjBillingRequestRspBO;
import com.tydic.externalinter.busi.bo.PublicCallExtReqBO;
import com.tydic.externalinter.busi.service.InvoiceServices.FjBillingRequestBusiService;
import com.tydic.externalinter.busi.service.PublicCallExtService;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.QryEscapeBO;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FjBillingRequestBusiServiceImpl
implements FjBillingRequestBusiService {
    private static Logger logger = LoggerFactory.getLogger(FjBillingRequestBusiServiceImpl.class);
    @Autowired
    private PublicCallExtService publicCallExtService;
    @Resource(name="exterQryEscapeAtomService")
    private QryEscapeAtomService qryEscapeAtomService;
    @Autowired
    SelectStoreInfoListService selectStoreInfoListService;

    public BillingRspBO billingRequest(BillingReqBO reqBO) {
        ExternaLinterResultData externaLinterResultData;
        BillingRspBO rspBO = new BillingRspBO();
        logger.debug("\u5916\u90e8\u63a5\u53e3-\u5f00\u7968\u8bf7\u6c42\u63a5\u53e3-\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        FjBillingRequestReqInfoBO reqBaseBO = new FjBillingRequestReqInfoBO();
        RspBaseBO checkRsp = this.checkParams(reqBO, reqBaseBO);
        if (!"0000".equals(checkRsp.getRespCode())) {
            rspBO.setRespCode(checkRsp.getRespCode());
            rspBO.setRespDesc(checkRsp.getRespDesc());
            return rspBO;
        }
        PublicCallExtReqBO publicCallExtReqBO = new PublicCallExtReqBO();
        publicCallExtReqBO.setBusiCode("EX_SYS_7_001");
        if ("300000".equals(reqBO.getProvinceCode())) {
            publicCallExtReqBO.setBusiCode("EX_SYS_7_0011");
        }
        publicCallExtReqBO.setReqParam((Object)reqBaseBO);
        logger.debug("\u5f00\u7968\u8bf7\u6c42\u63a5\u53e3-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5-\u5165\u53c2\uff1a" + JSON.toJSONString((Object)publicCallExtReqBO));
        try {
            externaLinterResultData = this.publicCallExtService.callService(publicCallExtReqBO);
        }
        catch (Exception e) {
            logger.error("\u5f00\u7968\u8bf7\u6c42\u63a5\u53e3-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38\uff1a" + e.getMessage());
            rspBO.setRespCode("0020");
            rspBO.setRespDesc("\u5f00\u7968\u8bf7\u6c42\u63a5\u53e3-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38");
            return rspBO;
        }
        logger.debug("\u5f00\u7968\u8bf7\u6c42\u63a5\u53e3-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5-\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)externaLinterResultData));
        if (!externaLinterResultData.getSuccess().booleanValue()) {
            logger.debug("\u5f00\u7968\u8bf7\u6c42\u63a5\u53e3-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5-\u5931\u8d25");
            rspBO.setRespCode(externaLinterResultData.getRespCode());
            rspBO.setRespDesc(externaLinterResultData.getRespDesc());
            return rspBO;
        }
        FjBillingRequestRspBO requestRspBO = (FjBillingRequestRspBO)JSONObject.parseObject((String)externaLinterResultData.getRespData().toString(), FjBillingRequestRspBO.class);
        BeanUtils.copyProperties((Object)requestRspBO, (Object)rspBO);
        rspBO.setResultCode(requestRspBO.getStatus());
        rspBO.setResultDesc(requestRspBO.getMessage());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private RspBaseBO checkParams(BillingReqBO reqBO, FjBillingRequestReqInfoBO reqBaseBO) {
        RspBaseBO rspBO = new RspBaseBO();
        rspBO.setRespCode("0001");
        if (null == reqBO) {
            rspBO.setRespDesc("\u5165\u53c2\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getBuyerName())) {
            rspBO.setRespDesc("\u5165\u53c2-getBuyerName-\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getPhone())) {
            rspBO.setRespDesc("\u5165\u53c2-getPhone-\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getOrderNo())) {
            rspBO.setRespDesc("\u5165\u53c2-getOrderNo-\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getInvoiceDate())) {
            rspBO.setRespDesc("\u5165\u53c2-getInvoiceDate-\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getClerk())) {
            rspBO.setRespDesc("\u5165\u53c2-getClerk-\u4e3a\u7a7a");
            return rspBO;
        }
        SelectStoreInfoReqBO selectStoreInfoReqBO = new SelectStoreInfoReqBO();
        ArrayList<String> storeIds = new ArrayList<String>();
        storeIds.add(reqBO.getClerk());
        selectStoreInfoReqBO.setStoreIds(storeIds);
        SelectStoreInfoRspBO storeInfoRspBO = this.selectStoreInfoListService.selectStoreInfoList(selectStoreInfoReqBO);
        if ("0000".equals(storeInfoRspBO.getRespCode()) && CollectionUtils.isNotEmpty((Collection)storeInfoRspBO.getStoreInfoList())) {
            reqBO.setClerk(((OrganisationBO)storeInfoRspBO.getStoreInfoList().get(0)).getAlias());
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getClerk())) {
            rspBO.setRespDesc("\u5165\u53c2-getAlias-\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getSaleTaxNum())) {
            rspBO.setRespDesc("\u5165\u53c2-getSaleTaxNum-\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getKpType())) {
            rspBO.setRespDesc("\u5165\u53c2-getKpType-\u4e3a\u7a7a");
            return rspBO;
        }
        if ("2".equals(reqBO.getKpType())) {
            if (StringUtils.isBlank((CharSequence)reqBO.getMessage())) {
                rspBO.setRespDesc("\u5165\u53c2-getMessage-\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getFpdm())) {
                rspBO.setRespDesc("\u5165\u53c2-getFpdm-\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getFphm())) {
                rspBO.setRespDesc("\u5165\u53c2-getFphm-\u4e3a\u7a7a");
                return rspBO;
            }
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getDetail())) {
            rspBO.setRespDesc("\u5165\u53c2-getDetail-\u4e3a\u7a7a");
            return rspBO;
        }
        FjBillingRequestReqBO order = FjBillingRequestReqBO.toBO((BillingReqBO)reqBO);
        List qryEscapeBOS = this.qryEscapeAtomService.listEscapeByParentCode("FJ_CITY_CODE");
        for (QryEscapeBO item : qryEscapeBOS) {
            if (!item.getEscapeCode().equals(reqBO.getSaleTaxNum())) continue;
            order.setSaletaxnum(item.getEscapeValue());
            reqBaseBO.setIdentity(item.getRemark());
        }
        if (StringUtils.isBlank((CharSequence)order.getSaletaxnum())) {
            rspBO.setRespDesc("\u5165\u53c2-getSaletaxnum-\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBaseBO.getIdentity())) {
            rspBO.setRespDesc("\u5165\u53c2-getIdentity-\u4e3a\u7a7a");
            return rspBO;
        }
        ArrayList<FjBillingRequestBO> fjBillingRequestBOList = new ArrayList<FjBillingRequestBO>();
        for (BillingBO bo : reqBO.getDetail()) {
            FjBillingRequestBO po = FjBillingRequestBO.toBO((BillingBO)bo);
            if (StringUtils.isBlank((CharSequence)bo.getGoodsName())) {
                rspBO.setRespDesc("\u5165\u53c2-getGoodsName-\u4e3a\u7a7a");
                return rspBO;
            }
            if ("340000".equals(reqBO.getProvinceCode()) && "7".equals(bo.getGoodsType())) {
                po.setGoodsname("\u7ef4\u4fee\u8d39");
            }
            if (StringUtils.isBlank((CharSequence)bo.getNum())) {
                if (StringUtils.isNotBlank((CharSequence)bo.getPrice())) {
                    rspBO.setRespDesc("\u5165\u53c2-getPrice-\u5e94\u4e3a\u7a7a");
                    return rspBO;
                }
                if (StringUtils.isBlank((CharSequence)bo.getTaxFreeAmt())) {
                    rspBO.setRespDesc("\u5165\u53c2-getTaxFreeAmt-\u4e3a\u7a7a");
                    return rspBO;
                }
                if (StringUtils.isBlank((CharSequence)bo.getTax())) {
                    rspBO.setRespDesc("\u5165\u53c2-getTax-\u4e3a\u7a7a");
                    return rspBO;
                }
                if (StringUtils.isBlank((CharSequence)bo.getTaxAmt())) {
                    rspBO.setRespDesc("\u5165\u53c2-getTaxAmt-\u4e3a\u7a7a");
                    return rspBO;
                }
            } else if (StringUtils.isBlank((CharSequence)bo.getPrice())) {
                rspBO.setRespDesc("\u5165\u53c2-getPrice-\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isBlank((CharSequence)bo.getHsbz())) {
                po.setHsbz("1");
            }
            if (StringUtils.isBlank((CharSequence)bo.getTaxRate())) {
                rspBO.setRespDesc("\u5165\u53c2-getTaxRate-\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isBlank((CharSequence)bo.getFphxz())) {
                rspBO.setRespDesc("\u5165\u53c2-getFphxz-\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isNotBlank((CharSequence)po.getPrice())) {
                po.setPrice(new BigDecimal(po.getPrice()).divide(new BigDecimal("10000")).setScale(2, 4).toString());
            }
            if (StringUtils.isNotBlank((CharSequence)po.getTaxfreeamt())) {
                po.setTaxfreeamt(new BigDecimal(po.getTaxfreeamt()).divide(new BigDecimal("10000")).setScale(2, 4).toString());
            }
            if (StringUtils.isNotBlank((CharSequence)po.getTax())) {
                po.setTax(new BigDecimal(po.getTax()).divide(new BigDecimal("10000")).setScale(2, 4).toString());
            }
            if (StringUtils.isNotBlank((CharSequence)po.getTaxAmt())) {
                po.setTaxAmt(new BigDecimal(po.getTaxAmt()).divide(new BigDecimal("10000")).setScale(2, 4).toString());
            }
            if ("330000".equals(reqBO.getProvinceCode())) {
                List qryEscapeBOList = this.qryEscapeAtomService.listEscapeByParentCode("TAX_RATE");
                QryEscapeBO qryEscapeBO = new QryEscapeBO();
                for (QryEscapeBO item : qryEscapeBOList) {
                    if (!item.getEscapeCode().equals(reqBO.getProvinceCode())) continue;
                    BeanUtils.copyProperties((Object)item, (Object)qryEscapeBO);
                }
                if ("7".equals(bo.getGoodsType())) {
                    if (StringUtils.isBlank((CharSequence)bo.getBusiType())) {
                        rspBO.setRespDesc("\u5165\u53c2 - getBusiType - \u4e3a\u7a7a");
                        return rspBO;
                    }
                    if ("01".equals(bo.getBusiType())) {
                        po.setGoodsname("\u788e\u5c4f\u9669");
                    }
                    if ("02".equals(bo.getBusiType())) {
                        po.setGoodsname("\u5ef6\u4fdd\u670d\u52a1");
                    }
                    if ("03".equals(bo.getBusiType())) {
                        po.setGoodsname("\u610f\u5916\u6362\u65b0");
                    }
                    po.setTaxrate(qryEscapeBO.getEscapeValue());
                    if (StringUtils.isNotBlank((CharSequence)po.getPrice())) {
                        BigDecimal taxAmt = new BigDecimal(po.getPrice()).multiply(new BigDecimal(po.getNum()));
                        BigDecimal tax = taxAmt.multiply(new BigDecimal(po.getTaxrate())).divide(new BigDecimal(po.getTaxrate()).add(new BigDecimal(1)), 2, 4);
                        BigDecimal taxFreeAmt = taxAmt.subtract(tax);
                        po.setTax(tax.toString());
                        po.setTaxAmt(taxAmt.toString());
                        po.setTaxfreeamt(taxFreeAmt.toString());
                    }
                }
            }
            if (StringUtils.isBlank((CharSequence)po.getYhzcbs())) {
                po.setYhzcbs("0");
            }
            if ("1".equals(po.getYhzcbs()) && StringUtils.isBlank((CharSequence)po.getZzstsgl())) {
                rspBO.setRespDesc("\u5165\u53c2-getZzstsgl-\u4e3a\u7a7a");
                return rspBO;
            }
            fjBillingRequestBOList.add(po);
        }
        if (StringUtils.isBlank((CharSequence)order.getTsfs())) {
            order.setTsfs("1");
        }
        if (("0".equals(order.getTsfs()) || "2".equals(order.getTsfs())) && StringUtils.isBlank((CharSequence)order.getEmail())) {
            rspBO.setRespDesc("\u5165\u53c2-getEmail-\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)order.getQdbz())) {
            order.setQdbz("0");
        }
        if ("1".equals(order.getQdbz()) && StringUtils.isBlank((CharSequence)order.getQdxmmc())) {
            rspBO.setRespDesc("\u5165\u53c2-getQdxmmc-\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)order.getDkbz())) {
            order.setDkbz("0");
        }
        if (StringUtils.isBlank((CharSequence)order.getInvoiceLine())) {
            order.setInvoiceLine("p");
        }
        order.setDetail(fjBillingRequestBOList);
        reqBaseBO.setOrder(order);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

