/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.externalinter.ability.bo.BillingBO;
import com.tydic.externalinter.ability.bo.BillingReqBO;
import com.tydic.externalinter.ability.bo.BillingRspBO;
import com.tydic.externalinter.ability.bo.GDBillingReceivingDataDetailReqBO;
import com.tydic.externalinter.ability.bo.GDBillingReceivingDataReqBO;
import com.tydic.externalinter.ability.bo.GDBillingReceivingDataRspBO;
import com.tydic.externalinter.bo.ExternaLinterResultData;
import com.tydic.externalinter.busi.bo.PublicCallExtReqBO;
import com.tydic.externalinter.busi.service.InvoiceServices.GDBillingInventoryQueryBusiService;
import com.tydic.externalinter.busi.service.InvoiceServices.GDBillingReceivingDataBusiService;
import com.tydic.externalinter.busi.service.PublicCallExtService;
import com.tydic.externalinter.scm.ws.bo.QueryEliStock;
import com.tydic.externalinter.util.ExterPropertiesUtils;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.QryEscapeBO;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import com.tydic.newretail.toolkit.bo.RspBaseTBO;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GDBillingInventoryQueryBusiServiceImpl
implements GDBillingInventoryQueryBusiService {
    private static Logger logger = LoggerFactory.getLogger(GDBillingInventoryQueryBusiServiceImpl.class);
    @Autowired
    private PublicCallExtService publicCallExtService;
    @Resource(name="exterQryEscapeAtomService")
    private QryEscapeAtomService qryEscapeAtomService;
    @Autowired
    private GDBillingReceivingDataBusiService gdBillingReceivingDataBusiService;

    public BillingRspBO billingInventoryQuery(BillingReqBO reqBO) {
        ExternaLinterResultData externaLinterResultData;
        BillingRspBO rspBO = new BillingRspBO();
        QueryEliStock queryEliStock = new QueryEliStock();
        QryEscapeBO item = new QryEscapeBO();
        RspBaseBO checkRsp = this.checkParams(reqBO, queryEliStock, item);
        if (!"0000".equals(checkRsp.getRespCode())) {
            rspBO.setRespDesc(checkRsp.getRespDesc());
            rspBO.setRespCode(checkRsp.getRespCode());
            return rspBO;
        }
        PublicCallExtReqBO publicCallExtReqBO = new PublicCallExtReqBO();
        publicCallExtReqBO.setBusiCode("EX_SYS_10_001");
        publicCallExtReqBO.setReqParam((Object)queryEliStock);
        publicCallExtReqBO.setWhichOne("GD");
        logger.debug("\u53d1\u7968\u5e93\u5b58\u67e5\u8be2\u63a5\u53e3-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5-\u5165\u53c2\uff1a" + JSON.toJSONString((Object)queryEliStock));
        try {
            externaLinterResultData = this.publicCallExtService.callService(publicCallExtReqBO);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5\u53e3\u5931\u8d25\uff1a" + e.getMessage());
            rspBO.setRespCode("0020");
            rspBO.setRespDesc("\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5\u53e3\u5931\u8d25");
            return rspBO;
        }
        logger.debug("\u53d1\u7968\u5e93\u5b58\u67e5\u8be2\u63a5\u53e3-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5-\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)externaLinterResultData));
        JSONObject jsonObject = JSONObject.parseObject((String)externaLinterResultData.getRespData().toString());
        JSONObject response = jsonObject.getJSONObject("queryEliStockResponse");
        JSONObject out = response.getJSONObject("out");
        String count = out.getString("SYFPFS");
        if (!"0".equals(count)) {
            logger.debug("\u53ef\u4ee5\u5f00\u7968");
            GDBillingReceivingDataReqBO gdBillingReceivingDataReqBO = new GDBillingReceivingDataReqBO();
            RspBaseBO checkReqRsp = null;
            try {
                checkReqRsp = this.checkReqParams(reqBO, gdBillingReceivingDataReqBO, item);
            }
            catch (Exception e) {
                logger.error("\u5e7f\u4e1c\u53d1\u7968\u5165\u53c2\u8f6c\u6362\u5f02\u5e38" + e.getMessage());
                rspBO.setRespDesc("\u5e7f\u4e1c\u53d1\u7968\u5165\u53c2\u8f6c\u6362\u5f02\u5e38");
                rspBO.setRespCode("9999");
                return rspBO;
            }
            if (!"0000".equals(checkReqRsp.getRespCode())) {
                rspBO.setRespCode(checkReqRsp.getRespCode());
                rspBO.setRespDesc(checkReqRsp.getRespDesc());
                return rspBO;
            }
            RspBaseTBO rspBaseTBO = null;
            try {
                rspBaseTBO = this.gdBillingReceivingDataBusiService.billingReceivingData(gdBillingReceivingDataReqBO);
            }
            catch (Exception e) {
                logger.error("\u5e7f\u4e1c\u53d1\u7968\u63a5\u6536\u63a5\u53e3\u8c03\u7528\u5f02\u5e38" + e.getMessage());
                rspBO.setRespDesc("\u5e7f\u4e1c\u53d1\u7968\u63a5\u6536\u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
                rspBO.setRespCode("9999");
                return rspBO;
            }
            rspBO.setFpqqlsh(((GDBillingReceivingDataRspBO)rspBaseTBO.getData()).getFpqqlsh());
            if ("0".equals(((GDBillingReceivingDataRspBO)rspBaseTBO.getData()).getReturnCode())) {
                rspBO.setResultCode("0000");
            } else {
                rspBO.setResultCode("9999");
            }
            rspBO.setResultDesc(((GDBillingReceivingDataRspBO)rspBaseTBO.getData()).getReturnMsg());
            rspBO.setRespCode(rspBaseTBO.getRespCode());
            rspBO.setRespDesc(rspBaseTBO.getRespDesc());
        } else {
            logger.debug("\u53d1\u7968\u5e93\u5b58\u4e0d\u8db3\uff0c\u4e0d\u53ef\u4ee5\u5f00\u7968");
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u53d1\u7968\u5e93\u5b58\u4e0d\u8db3\uff0c\u4e0d\u53ef\u4ee5\u5f00\u7968");
        }
        return rspBO;
    }

    private RspBaseBO checkParams(BillingReqBO reqBO, QueryEliStock queryEliStock, QryEscapeBO qryEscapeBO) {
        RspBaseBO rspBO = new RspBaseBO();
        rspBO.setRespCode("0001");
        if (null == reqBO) {
            rspBO.setRespDesc("\u5165\u53c2\u4e3a\u7a7a");
            return rspBO;
        }
        List qryEscapeBOS = this.qryEscapeAtomService.listEscapeByParentCode("CITY_CODE");
        for (QryEscapeBO item : qryEscapeBOS) {
            if (!item.getEscapeCode().equals(reqBO.getSaleTaxNum())) continue;
            BeanUtils.copyProperties((Object)item, (Object)qryEscapeBO);
            String in0 = item.getRemark();
            JSONObject jsonObject = JSONObject.parseObject((String)in0);
            String kpnsrsbh = jsonObject.getString("kpnsrsbh");
            queryEliStock.setIn0(kpnsrsbh);
        }
        if (StringUtils.isBlank((CharSequence)queryEliStock.getIn0())) {
            rspBO.setRespDesc("\u5165\u53c2-getIn0-\u4e3a\u7a7a");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private RspBaseBO checkReqParams(BillingReqBO reqBO, GDBillingReceivingDataReqBO gdBillingReceivingDataReqBO, QryEscapeBO item) throws SQLException {
        RspBaseBO rspBO = new RspBaseBO();
        rspBO.setRespCode("0001");
        if (null == reqBO) {
            rspBO.setRespDesc("\u5165\u53c2\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getOrderNo())) {
            rspBO.setRespDesc("\u5165\u53c2-DDH-\u4e3a\u7a7a");
            return rspBO;
        }
        String in0 = item.getRemark();
        JSONObject jsonObject = JSONObject.parseObject((String)in0);
        String kpnsrsbh = jsonObject.getString("kpnsrsbh");
        String kpnsrmc = jsonObject.getString("kpnsrmc");
        String xhfnsrsbh = jsonObject.getString("xhfnsrsbh");
        String xhfmc = jsonObject.getString("xhfmc");
        String xhfdz = jsonObject.getString("xhfdz");
        String xhfdh = jsonObject.getString("xhfdh");
        String xhfyhzh = jsonObject.getString("xhfyhzh");
        String fhr = jsonObject.getString("fhr");
        if (StringUtils.isBlank((CharSequence)reqBO.getBuyerName())) {
            rspBO.setRespDesc("\u5165\u53c2-GHF_MC-\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getIssuer())) {
            rspBO.setRespDesc("\u5165\u53c2-KPR-\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getPayee())) {
            rspBO.setRespDesc("\u5165\u53c2-SKR-\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getChecker())) {
            rspBO.setRespDesc("\u5165\u53c2-FHR-\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getKpType())) {
            rspBO.setRespDesc("\u5165\u53c2-KPLX-\u4e3a\u7a7a");
            return rspBO;
        }
        if ("1".equals(reqBO.getKpType())) {
            reqBO.setCzdm("10");
        } else {
            reqBO.setCzdm("20");
        }
        if ("20".equals(reqBO.getCzdm())) {
            if (StringUtils.isBlank((CharSequence)reqBO.getFpdm())) {
                rspBO.setRespDesc("\u5165\u53c2-YFP_DM-\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getFphm())) {
                rspBO.setRespDesc("\u5165\u53c2-YFP_HM-\u4e3a\u7a7a");
                return rspBO;
            }
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getKphjje())) {
            rspBO.setRespDesc("\u5165\u53c2-KPHJJE-\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getKphjje())) {
            gdBillingReceivingDataReqBO.setKphjje(Double.valueOf(new BigDecimal(reqBO.getKphjje()).divide(new BigDecimal("10000")).setScale(2, 4).doubleValue()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getHjbhsje())) {
            gdBillingReceivingDataReqBO.setHjbhsje(Double.valueOf(new BigDecimal(reqBO.getHjbhsje()).divide(new BigDecimal("10000")).setScale(2, 4).doubleValue()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getHjse())) {
            gdBillingReceivingDataReqBO.setHjse(Double.valueOf(new BigDecimal(reqBO.getHjse()).divide(new BigDecimal("10000")).setScale(2, 4).doubleValue()));
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getBmbBbh())) {
            reqBO.setBmbBbh("36.0");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getDetail())) {
            rspBO.setRespDesc("\u5165\u53c2-details-\u4e3a\u7a7a");
            return rspBO;
        }
        if ("2".equals(reqBO.getInvKind())) {
            // empty if block
        }
        ArrayList<GDBillingReceivingDataDetailReqBO> detail = new ArrayList<GDBillingReceivingDataDetailReqBO>(reqBO.getDetail().size());
        for (BillingBO bo : reqBO.getDetail()) {
            GDBillingReceivingDataDetailReqBO po = new GDBillingReceivingDataDetailReqBO();
            if (StringUtils.isBlank((CharSequence)bo.getGoodsName())) {
                rspBO.setRespDesc("\u5165\u53c2-XMMC-\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isBlank((CharSequence)bo.getHsbz())) {
                rspBO.setRespDesc("\u5165\u53c2-HSBZ-\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isBlank((CharSequence)bo.getPrice())) {
                rspBO.setRespDesc("\u5165\u53c2-XMDJ-\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getPrice())) {
                po.setXmdj(Double.valueOf(new BigDecimal(bo.getPrice()).divide(new BigDecimal("10000")).setScale(2, 4).doubleValue()));
            }
            if (StringUtils.isBlank((CharSequence)bo.getGoodsType())) {
                rspBO.setRespDesc("\u5165\u53c2-getGoodsType-\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isBlank((CharSequence)bo.getTaxRate())) {
                if ("7".equals(bo.getGoodsType())) {
                    po.setSl("0.13");
                } else {
                    po.setSl("0.09");
                }
            } else {
                po.setSl(bo.getTaxRate());
            }
            if (StringUtils.isBlank((CharSequence)bo.getTaxAmt())) {
                rspBO.setRespDesc("\u5165\u53c2-XMJE-\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getTaxAmt())) {
                po.setXmje(Double.valueOf(new BigDecimal(bo.getTaxAmt()).divide(new BigDecimal("10000")).setScale(2, 4).doubleValue()));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getTax())) {
                po.setSe(Double.valueOf(new BigDecimal(bo.getTax()).divide(new BigDecimal("10000")).setScale(2, 4).doubleValue()));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getKce())) {
                po.setKce(Double.valueOf(new BigDecimal(bo.getKce()).divide(new BigDecimal("10000")).setScale(2, 4).doubleValue()));
            }
            if (StringUtils.isBlank((CharSequence)bo.getSpbm())) {
                if ("7".equals(bo.getGoodsType())) {
                    po.setSpbm(ExterPropertiesUtils.getProperty("GD_SPBM_CODE_BAOXIAN"));
                } else {
                    po.setSpbm(ExterPropertiesUtils.getProperty("GD_SPBM_CODE_OTHER"));
                }
            } else {
                po.setSpbm(bo.getSpbm());
            }
            po.setDw(bo.getUnit());
            po.setGgxh(bo.getSpec());
            po.setHsbz(bo.getHsbz());
            po.setLslbs(bo.getLslbs());
            po.setXmbm(bo.getXmbm());
            po.setXmmc(bo.getGoodsName());
            po.setXmsl(Double.valueOf(bo.getNum()));
            po.setYhzcbs("0");
            po.setZxbm(bo.getZsbm());
            po.setZzstsgl(bo.getZzstsgl());
            detail.add(po);
        }
        gdBillingReceivingDataReqBO.setBmbbbh(reqBO.getBmbBbh());
        gdBillingReceivingDataReqBO.setBz(reqBO.getBz());
        gdBillingReceivingDataReqBO.setChyy(reqBO.getChyy());
        gdBillingReceivingDataReqBO.setCzdm(reqBO.getCzdm());
        gdBillingReceivingDataReqBO.setDdh(reqBO.getOrderNo());
        gdBillingReceivingDataReqBO.setDkbz("0");
        gdBillingReceivingDataReqBO.setEmail(reqBO.getEmail());
        gdBillingReceivingDataReqBO.setFhr(fhr);
        gdBillingReceivingDataReqBO.setFpqqlsh(Sequence.getInstance().nextId() + kpnsrsbh);
        gdBillingReceivingDataReqBO.setYfpdm(reqBO.getFpdm());
        gdBillingReceivingDataReqBO.setYfphm(reqBO.getFphm());
        gdBillingReceivingDataReqBO.setGhfdz(reqBO.getAddress());
        gdBillingReceivingDataReqBO.setGhfemail(reqBO.getEmail());
        gdBillingReceivingDataReqBO.setGhfgddh(reqBO.getTelePhone());
        gdBillingReceivingDataReqBO.setGhfmc(reqBO.getBuyerName());
        gdBillingReceivingDataReqBO.setGhfnsrsbh(reqBO.getTaxNum());
        gdBillingReceivingDataReqBO.setGhfsj(reqBO.getPhone());
        gdBillingReceivingDataReqBO.setGhfyhzh(reqBO.getAccount());
        gdBillingReceivingDataReqBO.setKplx(reqBO.getKpType());
        gdBillingReceivingDataReqBO.setKpr(reqBO.getIssuer());
        gdBillingReceivingDataReqBO.setKpnsrmc(kpnsrmc);
        gdBillingReceivingDataReqBO.setKpnsrsbh(kpnsrsbh);
        gdBillingReceivingDataReqBO.setSkr(reqBO.getPayee());
        gdBillingReceivingDataReqBO.setXhfdh(xhfdh);
        gdBillingReceivingDataReqBO.setXhfdz(xhfdz);
        gdBillingReceivingDataReqBO.setXhfmc(xhfmc);
        gdBillingReceivingDataReqBO.setXhfnsrsbh(xhfnsrsbh);
        gdBillingReceivingDataReqBO.setXhfyhzh(xhfyhzh);
        gdBillingReceivingDataReqBO.setDetails(detail);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

