/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.ohaotian.base.common.bo.RspInfoBO;
import com.tydic.externalinter.bo.ExternaLinterResultData;
import com.tydic.externalinter.busi.bo.PublicCallExtReqBO;
import com.tydic.externalinter.busi.bo.PullScmMaterialReqBO;
import com.tydic.externalinter.busi.bo.PullScmMaterialRspBO;
import com.tydic.externalinter.busi.service.GetScmMaterialService;
import com.tydic.externalinter.busi.service.PublicCallExtService;
import com.tydic.externalinter.busi.service.ScmexterCommService;
import com.tydic.externalinter.scm.ws.bo.GetScmMaterialReqBO;
import com.tydic.externalinter.scm.ws.bo.GetScmMaterialReqTableBO;
import com.tydic.newretail.toolkit.util.TkDateUtils;
import com.xls.commodity.busi.sku.CreateDMaterialService;
import com.xls.commodity.busi.sku.bo.CreateDmaterialReqBO;
import com.xls.commodity.busi.sku.bo.DmaterialReqBO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetScmMaterialServiceImpl
implements GetScmMaterialService {
    private static Logger logger = LoggerFactory.getLogger(GetScmMaterialServiceImpl.class);
    @Autowired
    private CreateDMaterialService createDMaterialService;
    @Autowired
    private ScmexterCommService scmexterCommService;
    @Autowired
    private PublicCallExtService publicCallExtService;

    public PullScmMaterialRspBO getScmMaterial(PullScmMaterialReqBO pullScmMaterialReqBO) {
        PullScmMaterialRspBO getScmMaterialRspBO = new PullScmMaterialRspBO();
        logger.debug("\u83b7\u53d6SCM\u7269\u6599\u63a5\u53e3\u670d\u52a1\u5165\u53c2=" + JSON.toJSONString((Object)pullScmMaterialReqBO));
        String imDate = pullScmMaterialReqBO.getImDate();
        String imFlag = pullScmMaterialReqBO.getImFlag();
        if (StringUtils.isBlank((String)imDate) && StringUtils.isBlank((String)imFlag)) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            calendar.add(5, -1);
            imDate = TkDateUtils.formatDate((Date)calendar.getTime(), (String)"yyyyMMdd");
        }
        if (StringUtils.isBlank((String)imFlag)) {
            imFlag = "";
        }
        GetScmMaterialReqBO ser = new GetScmMaterialReqBO();
        ser.setImDate(imDate);
        ser.setImFlag(imFlag);
        ser.setTOutput(new GetScmMaterialReqTableBO());
        PublicCallExtReqBO publicCallExtReqBO = new PublicCallExtReqBO();
        publicCallExtReqBO.setBusiCode("EX_SYS_4_010");
        publicCallExtReqBO.setReqParam((Object)ser);
        ExternaLinterResultData result = null;
        try {
            result = this.publicCallExtService.callService(publicCallExtReqBO);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528SCM\u83b7\u53d6\u7269\u6599\u670d\u52a1\u5f02\u5e38\uff1a" + e.getMessage());
            getScmMaterialRspBO.setRespCode("0011");
            getScmMaterialRspBO.setRespDesc("\u8c03\u7528SCM\u83b7\u53d6\u7269\u6599\u670d\u52a1\u5f02\u5e38");
            return getScmMaterialRspBO;
        }
        if (result == null) {
            String desc = "\u8c03\u7528SCM\u83b7\u53d6\u7269\u6599\u670d\u52a1\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a";
            getScmMaterialRspBO.setRespCode("9999");
            getScmMaterialRspBO.setRespDesc(desc);
            return getScmMaterialRspBO;
        }
        logger.debug("\u8c03\u7528scm\u83b7\u53d6\u7269\u6599\u4fe1\u606f\u51fa\u53c2=" + result.toString());
        JSONObject jsonObject = JSONObject.parseObject((String)result.getRespData().toString());
        JSONObject response = jsonObject.getJSONObject("Zsdif007RfcResponse");
        JSONObject JsonTData = response.getJSONObject("TOutput");
        if (JsonTData == null) {
            getScmMaterialRspBO.setRespCode("0000");
            getScmMaterialRspBO.setRespDesc(response.getString("ExMsg"));
            return getScmMaterialRspBO;
        }
        JSONArray jsonItem = new JSONArray();
        Object itemObj = JsonTData.get((Object)"item");
        if (itemObj instanceof JSONObject) {
            JSONObject itemJson = JsonTData.getJSONObject("item");
            jsonItem.add((Object)itemJson);
        } else if (itemObj instanceof JSONArray) {
            jsonItem = JsonTData.getJSONArray("item");
        } else {
            logger.error("\u89e3\u6790\u51fa\u53c2\u5931\u8d25\uff0citem\u7c7b\u578b\u9519\u8bef");
            getScmMaterialRspBO.setRespCode("9999");
            getScmMaterialRspBO.setRespDesc("\u89e3\u6790\u51fa\u53c2\u5931\u8d25\uff0citem\u7c7b\u578b\u9519\u8bef");
            return getScmMaterialRspBO;
        }
        if (jsonItem.size() <= 0) {
            logger.error("\u7269\u6599\u4fe1\u606f\u96c6\u5408\u4e3a\u7a7a");
            getScmMaterialRspBO.setRespCode("0000");
            getScmMaterialRspBO.setRespDesc("\u7269\u6599\u4fe1\u606f\u96c6\u5408\u4e3a\u7a7a");
            return getScmMaterialRspBO;
        }
        ArrayList<DmaterialReqBO> dmaterialBOS = new ArrayList<DmaterialReqBO>();
        for (int i = 0; i < jsonItem.size(); ++i) {
            JSONObject job = jsonItem.getJSONObject(i);
            DmaterialReqBO dmaterialReqBO = new DmaterialReqBO();
            dmaterialReqBO.setMaterialId(job.getString("Matnr"));
            dmaterialReqBO.setScmMaterialId(job.getString("Matnr"));
            dmaterialReqBO.setMaterialDesc(job.getString("Maktx"));
            dmaterialReqBO.setErpMaterialId(job.getString("Bismt"));
            dmaterialReqBO.setMaterialGroup(job.getString("Matkl"));
            dmaterialReqBO.setProductType(job.getString("Class"));
            dmaterialReqBO.setProductTypeName(job.getString("Cdesc"));
            dmaterialBOS.add(dmaterialReqBO);
        }
        CreateDmaterialReqBO createDmaterialReqBO = new CreateDmaterialReqBO();
        createDmaterialReqBO.setDmaterialBOS(dmaterialBOS);
        try {
            logger.debug("\u540c\u6b65\u6761\u6570" + dmaterialBOS.size());
            logger.error("\u8c03\u7528\u65b0\u589e\u7269\u6599\u5546\u54c1\u5165\u53c2=" + JSON.toJSONString((Object)createDmaterialReqBO));
            RspInfoBO rspInfoBO = this.createDMaterialService.createDMaterials(createDmaterialReqBO);
            logger.error("\u8c03\u7528\u65b0\u589e\u7269\u6599\u5546\u54c1\u51fa\u53c2=" + JSON.toJSONString((Object)rspInfoBO));
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u65b0\u589e\u7269\u6599\u5546\u54c1\u62a5\u9519");
            e.printStackTrace();
            logger.error(e.getMessage());
            getScmMaterialRspBO.setRespCode("9999");
            getScmMaterialRspBO.setRespDesc("\u8c03\u7528\u65b0\u589e\u7269\u6599\u5546\u54c1\u62a5\u9519");
            return getScmMaterialRspBO;
        }
        getScmMaterialRspBO.setRespCode("0000");
        getScmMaterialRspBO.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return getScmMaterialRspBO;
    }
}

