/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.externalinter.ability.bo.CreatePolicyReqBO;
import com.tydic.externalinter.ability.bo.CreatePolicyRspBO;
import com.tydic.externalinter.bo.ExternaLinterResultData;
import com.tydic.externalinter.busi.bo.HDCreatePolicyReqBO;
import com.tydic.externalinter.busi.bo.HDCreatePolicyRspBO;
import com.tydic.externalinter.busi.bo.PublicCallExtReqBO;
import com.tydic.externalinter.busi.service.PublicCallExtService;
import com.tydic.externalinter.busi.service.SecurityServices.HDCreatePolicyBusiService;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HDCreatePolicyBusiServiceImpl
implements HDCreatePolicyBusiService {
    private static Logger logger = LoggerFactory.getLogger(HDCreatePolicyBusiServiceImpl.class);
    @Autowired
    private PublicCallExtService publicCallExtService;
    @Autowired
    private CacheClient cacheClient;

    public CreatePolicyRspBO createPolicy(CreatePolicyReqBO reqBO) {
        ExternaLinterResultData externaLinterResultData;
        CreatePolicyRspBO rspBO = new CreatePolicyRspBO();
        logger.debug("\u5916\u90e8\u63a5\u53e3-HD\u521b\u5efa\u4fdd\u5355\u63a5\u53e3-\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        HDCreatePolicyReqBO reqBaseBO = new HDCreatePolicyReqBO();
        RspBaseBO checkRsp = this.checkParams(reqBO, reqBaseBO);
        if (!"0000".equals(checkRsp.getRespCode())) {
            rspBO.setRespCode(checkRsp.getRespCode());
            rspBO.setRespDesc(checkRsp.getRespDesc());
            return rspBO;
        }
        PublicCallExtReqBO publicCallExtReqBO = new PublicCallExtReqBO();
        publicCallExtReqBO.setBusiCode("EX_SYS_2_001");
        publicCallExtReqBO.setReqParam((Object)reqBaseBO);
        logger.debug("HD\u521b\u5efa\u4fdd\u5355\u63a5\u53e3-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5-\u5165\u53c2\uff1a" + JSON.toJSONString((Object)publicCallExtReqBO));
        try {
            externaLinterResultData = this.publicCallExtService.callService(publicCallExtReqBO);
        }
        catch (Exception e) {
            logger.error("HD\u521b\u5efa\u4fdd\u5355\u63a5\u53e3-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38\uff1a" + e.getMessage());
            rspBO.setRespCode("0020");
            rspBO.setRespDesc("HD\u521b\u5efa\u4fdd\u5355\u63a5\u53e3-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38");
            return rspBO;
        }
        logger.debug("HD\u521b\u5efa\u4fdd\u5355\u63a5\u53e3-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5-\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)externaLinterResultData));
        if (!externaLinterResultData.getSuccess().booleanValue()) {
            logger.debug("HD\u521b\u5efa\u4fdd\u5355\u63a5\u53e3-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5-\u5931\u8d25");
            rspBO.setRespCode(externaLinterResultData.getRespCode());
            rspBO.setRespDesc(externaLinterResultData.getRespDesc());
            return rspBO;
        }
        HDCreatePolicyRspBO receivingRspBO = (HDCreatePolicyRspBO)JSONObject.parseObject((String)externaLinterResultData.getRespData().toString(), HDCreatePolicyRspBO.class);
        this.changeParams(receivingRspBO, rspBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private RspBaseBO checkParams(CreatePolicyReqBO reqBO, HDCreatePolicyReqBO reqBaseBO) {
        RspBaseBO rspBO = new RspBaseBO();
        rspBO.setRespCode("0001");
        if (null == reqBO) {
            rspBO.setRespDesc("\u5165\u53c2\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getInsuranceCode())) {
            rspBO.setRespDesc("\u5165\u53c2-getInsuranceCode-\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getBrand())) {
            rspBO.setRespDesc("\u5165\u53c2-getBrand-\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getModel())) {
            rspBO.setRespDesc("\u5165\u53c2-getModel-\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getCustomerProvince())) {
            rspBO.setRespDesc("\u5165\u53c2-getCity-\u4e3a\u7a7a");
            return rspBO;
        }
        try {
            String proKey = "AUTHORITY_TYPE_area_code_" + reqBO.getCustomerProvince();
            Object proValue = this.cacheClient.get(proKey);
            reqBO.setCity(proValue.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.debug("\u51fa\u53c2" + e.getMessage());
            rspBO.setRespCode("0016");
            rspBO.setRespDesc("\u6839\u636e\u7f16\u7801\u67e5\u8be2\u540d\u79f0\u5f02\u5e38");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getCustName())) {
            rspBO.setRespDesc("\u5165\u53c2-getCustName-\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getPrice())) {
            rspBO.setRespDesc("\u5165\u53c2-getPrice-\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getPhone())) {
            rspBO.setRespDesc("\u5165\u53c2-getPhone-\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getImei())) {
            rspBO.setRespDesc("\u5165\u53c2-getImei-\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getIdcard())) {
            rspBO.setRespDesc("\u5165\u53c2-getIdcard-\u4e3a\u7a7a");
            return rspBO;
        }
        BeanUtils.copyProperties((Object)reqBO, (Object)reqBaseBO);
        reqBaseBO.setName(reqBO.getCustName());
        reqBaseBO.setChannelType(reqBO.getInsuranceCode());
        reqBaseBO.setPrice(new BigDecimal(reqBO.getPrice()).divide(new BigDecimal("10000")).setScale(0, 4).toString());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void changeParams(HDCreatePolicyRspBO receivingRspBO, CreatePolicyRspBO rspBO) {
        logger.debug("\u51fa\u53c2" + JSON.toJSONString((Object)receivingRspBO));
        BeanUtils.copyProperties((Object)receivingRspBO, (Object)rspBO);
        if ("success".equals(receivingRspBO.getStatus())) {
            rspBO.setResultCode("0000");
        } else {
            rspBO.setResultCode(receivingRspBO.getStatus());
        }
        rspBO.setResultDesc(receivingRspBO.getDes());
        if (null != receivingRspBO.getData()) {
            rspBO.setPolicyNo(receivingRspBO.getData().getPolicyId());
            if (StringUtils.isNotBlank((CharSequence)receivingRspBO.getData().getServicePrice())) {
                rspBO.setServicePrice(new BigDecimal(receivingRspBO.getData().getServicePrice()).multiply(new BigDecimal("10000")).toString());
            } else {
                rspBO.setServicePrice(receivingRspBO.getData().getServicePrice());
            }
            rspBO.setEwsStartDate(receivingRspBO.getData().getEffectiveDate());
            rspBO.setEwsEndDate(receivingRspBO.getData().getEndDate());
            rspBO.setProductSN(receivingRspBO.getData().getImei());
        }
        logger.debug("\u51fa\u53c2" + JSON.toJSONString((Object)rspBO));
    }
}

