/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.externalinter.bo.ExternaLinterResultData;
import com.tydic.externalinter.busi.bo.LogisticsInfoQueryBO;
import com.tydic.externalinter.busi.bo.LogisticsInfoQueryReqBO;
import com.tydic.externalinter.busi.bo.PublicCallExtReqBO;
import com.tydic.externalinter.busi.service.LogisticsInfoQueryBusiService;
import com.tydic.externalinter.busi.service.PublicCallExtService;
import com.tydic.externalinter.scm.ws.bo.ShippOrderSearch;
import com.tydic.externalinter.scm.ws.bo.ShippOrderSearchReqBO;
import com.tydic.externalinter.scm.ws.bo.ShippOrderSearchReqDetailBO;
import com.tydic.externalinter.scm.ws.bo.ShippOrderSearchRspBO;
import com.tydic.externalinter.scm.ws.bo.ShippOrderSearchRspDetailBO;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import com.tydic.newretail.toolkit.bo.RspBatchBaseBO;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogisticsInfoQueryBusiServiceImpl
implements LogisticsInfoQueryBusiService {
    private static Logger logger = LoggerFactory.getLogger(LogisticsInfoQueryBusiServiceImpl.class);
    @Autowired
    private PublicCallExtService publicCallExtService;

    public RspBatchBaseBO<ShippOrderSearchRspDetailBO> logisticsInfoQuery(LogisticsInfoQueryReqBO reqBO) {
        RspBatchBaseBO rspBO = new RspBatchBaseBO();
        logger.debug("\u8def\u7531\u67e5\u8be2\uff08\u7269\u6d41\u4fe1\u606f\u67e5\u8be2\uff09-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5-\u5165\u53c2" + JSON.toJSONString((Object)reqBO));
        ShippOrderSearch shippOrderSearch = new ShippOrderSearch();
        RspBaseBO checkRsp = this.checkParam(reqBO, shippOrderSearch);
        if (!"0000".equals(checkRsp.getRespCode())) {
            rspBO.setRespCode(checkRsp.getRespCode());
            rspBO.setRespDesc(checkRsp.getRespDesc());
            return rspBO;
        }
        PublicCallExtReqBO publicCallExtReqBO = new PublicCallExtReqBO();
        publicCallExtReqBO.setBusiCode("EX_SYS_5_001");
        publicCallExtReqBO.setReqParam((Object)shippOrderSearch);
        ExternaLinterResultData externaLinterResultData = null;
        try {
            externaLinterResultData = this.publicCallExtService.callService(publicCallExtReqBO);
        }
        catch (Exception e) {
            logger.error("\u8def\u7531\u67e5\u8be2\uff08\u7269\u6d41\u4fe1\u606f\u67e5\u8be2\uff09-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38\uff1a" + e.getMessage());
            rspBO.setRespCode("0020");
            rspBO.setRespDesc("\u8def\u7531\u67e5\u8be2\uff08\u7269\u6d41\u4fe1\u606f\u67e5\u8be2\uff09-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38");
            return rspBO;
        }
        if (!externaLinterResultData.getSuccess().booleanValue()) {
            logger.debug("\u8def\u7531\u67e5\u8be2\uff08\u7269\u6d41\u4fe1\u606f\u67e5\u8be2\uff09-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5-\u5931\u8d25");
            rspBO.setRespCode(externaLinterResultData.getRespCode());
            rspBO.setRespDesc(externaLinterResultData.getRespDesc());
            return rspBO;
        }
        ShippOrderSearchRspBO searchRspBO = (ShippOrderSearchRspBO)JSONObject.parseObject((String)externaLinterResultData.getRespData().toString(), ShippOrderSearchRspBO.class);
        this.reParam(searchRspBO, (RspBatchBaseBO<ShippOrderSearchRspDetailBO>)rspBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private RspBaseBO checkParam(LogisticsInfoQueryReqBO reqBO, ShippOrderSearch shippOrderSearch) {
        RspBaseBO rspBO = new RspBaseBO();
        rspBO.setRespCode("0001");
        if (null == reqBO) {
            rspBO.setRespDesc("\u5165\u53c2\u4e3a\u7a7a");
            return rspBO;
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getInfoQueryBOList())) {
            rspBO.setRespDesc("\u5165\u53c2-getInfoQueryBOList-\u4e3a\u7a7a");
            return rspBO;
        }
        ArrayList<ShippOrderSearchReqDetailBO> shippOrderSearchReqDetailBO = new ArrayList<ShippOrderSearchReqDetailBO>();
        for (LogisticsInfoQueryBO logisticsInfoQueryBO : reqBO.getInfoQueryBOList()) {
            if (StringUtils.isBlank((CharSequence)logisticsInfoQueryBO.getOrderNo()) && StringUtils.isBlank((CharSequence)logisticsInfoQueryBO.getShippNo())) {
                rspBO.setRespDesc("\u5165\u53c2-getOrderNo-\u548c-getShippNo-\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
                return rspBO;
            }
            ShippOrderSearchReqDetailBO bo = new ShippOrderSearchReqDetailBO();
            BeanUtils.copyProperties((Object)logisticsInfoQueryBO, (Object)bo);
            shippOrderSearchReqDetailBO.add(bo);
        }
        ShippOrderSearchReqBO shippOrderSearchReqBO = new ShippOrderSearchReqBO();
        shippOrderSearchReqBO.setShippInfoData(shippOrderSearchReqDetailBO);
        shippOrderSearch.setLisShippData(shippOrderSearchReqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void reParam(ShippOrderSearchRspBO searchRspBO, RspBatchBaseBO<ShippOrderSearchRspDetailBO> rspBO) {
        logger.debug("\u51fa\u53c2" + JSON.toJSONString((Object)searchRspBO));
        if (CollectionUtils.isNotEmpty((Collection)searchRspBO.getShippOrderSearchRspDetailBO())) {
            rspBO.setRows(searchRspBO.getShippOrderSearchRspDetailBO());
        }
        logger.debug("\u51fa\u53c2" + JSON.toJSONString(rspBO));
    }
}

