/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.externalinter.bo.ExternaLinterResultData;
import com.tydic.externalinter.busi.bo.MAGICCreateDeliveryOrderBO;
import com.tydic.externalinter.busi.bo.MAGICCreateDeliveryOrderReqBO;
import com.tydic.externalinter.busi.bo.MAGICCreateDeliveryOrderRspBO;
import com.tydic.externalinter.busi.bo.PublicCallExtReqBO;
import com.tydic.externalinter.busi.service.MAGICCreateDeliveryOrderBusiService;
import com.tydic.externalinter.busi.service.PublicCallExtService;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MAGICCreateDeliveryOrderBusiServiceImpl
implements MAGICCreateDeliveryOrderBusiService {
    private static Logger logger = LoggerFactory.getLogger(MAGICCreateDeliveryOrderBusiServiceImpl.class);
    @Autowired
    private PublicCallExtService publicCallExtService;
    private static final String STR_FORMAT = "000000000000000000";

    public MAGICCreateDeliveryOrderRspBO createDeliveryOrder(MAGICCreateDeliveryOrderReqBO reqBO) {
        ExternaLinterResultData externaLinterResultData;
        MAGICCreateDeliveryOrderRspBO rspBO = new MAGICCreateDeliveryOrderRspBO();
        logger.debug("\u5916\u90e8\u63a5\u53e3-\u521b\u5efa\u51fa\u5e93\u5355\u63a5\u53e3-\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        MAGICCreateDeliveryOrderReqBO reqBaseBO = new MAGICCreateDeliveryOrderReqBO();
        RspBaseBO checkRsp = this.checkParams(reqBO, reqBaseBO);
        if (!"0000".equals(checkRsp.getRespCode())) {
            rspBO.setRespCode(checkRsp.getRespCode());
            rspBO.setRespDesc(checkRsp.getRespDesc());
            return rspBO;
        }
        PublicCallExtReqBO publicCallExtReqBO = new PublicCallExtReqBO();
        publicCallExtReqBO.setBusiCode("EX_SYS_11_001");
        publicCallExtReqBO.setReqParam((Object)reqBaseBO);
        logger.debug("\u521b\u5efa\u51fa\u5e93\u5355\u63a5\u53e3-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5-\u5165\u53c2\uff1a" + JSON.toJSONString((Object)publicCallExtReqBO));
        try {
            externaLinterResultData = this.publicCallExtService.callService(publicCallExtReqBO);
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u51fa\u5e93\u5355\u63a5\u53e3-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38\uff1a" + e.getMessage());
            rspBO.setRespCode("0020");
            rspBO.setRespDesc("\u521b\u5efa\u51fa\u5e93\u5355\u63a5\u53e3-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38");
            return rspBO;
        }
        logger.debug("\u521b\u5efa\u51fa\u5e93\u5355\u63a5\u53e3-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5-\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)externaLinterResultData));
        if (!externaLinterResultData.getSuccess().booleanValue()) {
            logger.debug("\u521b\u5efa\u51fa\u5e93\u5355\u63a5\u53e3-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5-\u5931\u8d25");
            rspBO.setRespCode(externaLinterResultData.getRespCode());
            rspBO.setRespDesc(externaLinterResultData.getRespDesc());
            return rspBO;
        }
        MAGICCreateDeliveryOrderRspBO queryRspBO = (MAGICCreateDeliveryOrderRspBO)JSONObject.parseObject((String)externaLinterResultData.getRespData().toString(), MAGICCreateDeliveryOrderRspBO.class);
        this.changeParams(queryRspBO, rspBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private RspBaseBO checkParams(MAGICCreateDeliveryOrderReqBO reqBO, MAGICCreateDeliveryOrderReqBO reqBaseBO) {
        RspBaseBO rspBO = new RspBaseBO();
        rspBO.setRespCode("0001");
        if (null == reqBO) {
            rspBO.setRespDesc("\u5165\u53c2\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getShopId())) {
            rspBO.setRespDesc("\u5165\u53c2-getShopId-\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getOutboundType())) {
            rspBO.setRespDesc("\u5165\u53c2-getOutboundType-\u4e3a\u7a7a");
            return rspBO;
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getCommodityList())) {
            rspBO.setRespDesc("\u5165\u53c2-getCommodityList-\u4e3a\u7a7a");
            return rspBO;
        }
        for (MAGICCreateDeliveryOrderBO item : reqBO.getCommodityList()) {
            if (StringUtils.isBlank((CharSequence)item.getCode())) {
                rspBO.setRespDesc("\u5165\u53c2-getCode-\u4e3a\u7a7a");
                return rspBO;
            }
            if (Pattern.compile("^[-\\+]?[\\d]*$").matcher(item.getCode()).matches() && 18 == item.getCode().length()) {
                item.setCode(item.getCode().substring(2, item.getCode().length()));
            }
            if (!StringUtils.isBlank((CharSequence)item.getCount())) continue;
            rspBO.setRespDesc("\u5165\u53c2-getCount-\u4e3a\u7a7a");
            return rspBO;
        }
        BeanUtils.copyProperties((Object)reqBO, (Object)reqBaseBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void changeParams(MAGICCreateDeliveryOrderRspBO queryRspBO, MAGICCreateDeliveryOrderRspBO rspBO) {
        BeanUtils.copyProperties((Object)queryRspBO, (Object)rspBO);
        logger.debug("\u51fa\u53c2" + JSON.toJSONString((Object)queryRspBO));
        if (null != rspBO.getData() && CollectionUtils.isNotEmpty((Collection)rspBO.getData().getData())) {
            rspBO.getData().getData().forEach(item -> {
                String zeroStr = STR_FORMAT;
                String numStr = item.getCode();
                if (Pattern.compile("^[-\\+]?[\\d]*$").matcher(numStr).matches() && numStr.length() == 16) {
                    zeroStr = zeroStr.substring(0, zeroStr.length() - numStr.length());
                    item.setCode(zeroStr + numStr);
                }
            });
        }
        logger.debug("\u51fa\u53c2" + JSON.toJSONString((Object)rspBO));
    }
}

