/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.externalinter.busi.bo.MAGICFeedBackDeliveryOrderBO;
import com.tydic.externalinter.busi.bo.MAGICFeedBackDeliveryOrderReqBO;
import com.tydic.externalinter.busi.bo.MAGICFeedBackDeliveryOrderRspBO;
import com.tydic.externalinter.busi.service.MAGICFeedBackDeliveryOrderBusiService;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import com.tydic.ordunr.ability.SelfLiftingFeedBackService;
import com.tydic.ordunr.ability.bo.SelfLiftingCommodityBO;
import com.tydic.ordunr.ability.bo.SelfLiftingFeedBackReqBO;
import com.tydic.ordunr.ability.bo.SelfLiftingFeedBackRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MAGICFeedBackDeliveryOrderBusiServiceImpl
implements MAGICFeedBackDeliveryOrderBusiService {
    private static Logger logger = LoggerFactory.getLogger(MAGICFeedBackDeliveryOrderBusiServiceImpl.class);
    @Autowired
    private SelfLiftingFeedBackService selfLiftingFeedBackService;
    private static final String STR_FORMAT = "000000000000000000";

    public MAGICFeedBackDeliveryOrderRspBO feedBackDeliveryOrder(MAGICFeedBackDeliveryOrderReqBO reqBO) {
        MAGICFeedBackDeliveryOrderRspBO rspBO = new MAGICFeedBackDeliveryOrderRspBO();
        SelfLiftingFeedBackReqBO reqBaseBO = new SelfLiftingFeedBackReqBO();
        RspBaseBO chek = this.checkParams(reqBO, reqBaseBO);
        if (!"0000".equals(chek.getRespCode())) {
            rspBO.setRespCode(chek.getRespCode());
            rspBO.setRespDesc(chek.getRespDesc());
            rspBO.setCode("0");
            rspBO.setMessage(chek.getRespDesc());
            return rspBO;
        }
        logger.debug("\u5916\u90e8\u63a5\u53e3-\u51fa\u5e93\u5355\u53cd\u9988\u63a5\u53e3-\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        SelfLiftingFeedBackRspBO selfLiftingFeedBackRspBO = null;
        try {
            selfLiftingFeedBackRspBO = this.selfLiftingFeedBackService.selfLiftingFeedBack(reqBaseBO);
            logger.debug("\u51fa\u5e93\u5355\u53cd\u9988\u63a5\u53e3-\u8c03\u7528\u8ba2\u5355\u53cd\u9988\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)selfLiftingFeedBackRspBO));
        }
        catch (Exception e) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5931\u8d25");
            rspBO.setCode("0");
            rspBO.setMessage("\u51fa\u5e93\u5355\u53cd\u9988\u63a5\u53e3-\u8c03\u7528\u8ba2\u5355\u5f02\u5e38" + e.getMessage());
            return rspBO;
        }
        if (null == selfLiftingFeedBackRspBO) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5931\u8d25");
            rspBO.setCode("0");
            rspBO.setMessage("\u5931\u8d25");
            return rspBO;
        }
        if (!"0000".equals(selfLiftingFeedBackRspBO.getRespCode())) {
            rspBO.setRespCode(selfLiftingFeedBackRspBO.getRespCode());
            rspBO.setRespDesc(selfLiftingFeedBackRspBO.getRespDesc());
            rspBO.setCode("0");
            rspBO.setMessage(selfLiftingFeedBackRspBO.getRespDesc());
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setCode("1");
        rspBO.setMessage("\u6210\u529f");
        return rspBO;
    }

    private RspBaseBO checkParams(MAGICFeedBackDeliveryOrderReqBO reqBO, SelfLiftingFeedBackReqBO reqBaseBO) {
        RspBaseBO rspBO = new RspBaseBO();
        rspBO.setRespCode("0001");
        if (null == reqBO) {
            rspBO.setRespDesc("\u5165\u53c2\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getOrderCode())) {
            rspBO.setRespDesc("\u5165\u53c2-getOrderCode-\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getOrderStatus())) {
            rspBO.setRespDesc("\u5165\u53c2-getOrderStatus-\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getOutboundCount())) {
            rspBO.setRespDesc("\u5165\u53c2-getOutboundCount-\u4e3a\u7a7a");
            return rspBO;
        }
        if (null == reqBO.getOutboundTime()) {
            rspBO.setRespDesc("\u5165\u53c2-getOutboundTime-\u4e3a\u7a7a");
            return rspBO;
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getCommodityList())) {
            rspBO.setRespDesc("\u5165\u53c2-getCommodityList-\u4e3a\u7a7a");
            return rspBO;
        }
        ArrayList<SelfLiftingCommodityBO> commodityList = new ArrayList<SelfLiftingCommodityBO>();
        for (MAGICFeedBackDeliveryOrderBO item : reqBO.getCommodityList()) {
            SelfLiftingCommodityBO bo = new SelfLiftingCommodityBO();
            if (StringUtils.isBlank((CharSequence)item.getCode())) {
                rspBO.setRespDesc("\u5165\u53c2-getCode-\u4e3a\u7a7a");
                return rspBO;
            }
            String zeroStr = STR_FORMAT;
            String numStr = item.getCode();
            if (Pattern.compile("^[-\\+]?[\\d]*$").matcher(numStr).matches() && numStr.length() == 16) {
                zeroStr = zeroStr.substring(0, zeroStr.length() - numStr.length());
                item.setCode(zeroStr + numStr);
            }
            if (StringUtils.isBlank((CharSequence)item.getIsOutbound())) {
                rspBO.setRespDesc("\u5165\u53c2-getIsOutbound-\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isBlank((CharSequence)item.getSerialCode())) {
                rspBO.setRespDesc("\u5165\u53c2-getSerialCode-\u4e3a\u7a7a");
                return rspBO;
            }
            BeanUtils.copyProperties((Object)item, (Object)bo);
            commodityList.add(bo);
        }
        reqBaseBO.setOutboundCount(reqBO.getOutboundCount());
        reqBaseBO.setOrderStatus(reqBO.getOrderStatus());
        reqBaseBO.setOrderCode(reqBO.getOrderCode());
        reqBaseBO.setFailReason(reqBO.getFailReason());
        reqBaseBO.setOutboundTime(reqBO.getOutboundTime());
        reqBaseBO.setCommodityList(commodityList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void changeParams(MAGICFeedBackDeliveryOrderRspBO queryRspBO, MAGICFeedBackDeliveryOrderRspBO rspBO) {
        BeanUtils.copyProperties((Object)queryRspBO, (Object)rspBO);
        logger.debug("\u51fa\u53c2" + JSON.toJSONString((Object)queryRspBO));
        logger.debug("\u51fa\u53c2" + JSON.toJSONString((Object)rspBO));
    }
}

