/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.fastjson.JSON;
import com.tydic.externalinter.busi.bo.MAGICUpdateDeliveryBO;
import com.tydic.externalinter.busi.bo.MAGICUpdateDeliveryCommBO;
import com.tydic.externalinter.busi.bo.MAGICUpdateDeliveryReqBO;
import com.tydic.externalinter.busi.bo.MAGICUpdateDeliveryRspBO;
import com.tydic.externalinter.busi.service.MAGICUpdateDeliveryBusiService;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import com.tydic.smc.api.ability.SmcMagicStoreAddAbilityService;
import com.tydic.smc.api.ability.bo.SmcMagicListBO;
import com.tydic.smc.api.ability.bo.SmcMagicStockAddReqBO;
import com.tydic.smc.api.ability.bo.SmcMagieGoodsBO;
import com.tydic.smc.api.base.SmcRspBaseBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MAGICUpdateDeliveryBusiServiceImpl
implements MAGICUpdateDeliveryBusiService {
    private static Logger logger = LoggerFactory.getLogger(MAGICUpdateDeliveryBusiServiceImpl.class);
    @Autowired
    private SmcMagicStoreAddAbilityService smcMagicStoreAddAbilityService;
    private static final String STR_FORMAT = "000000000000000000";

    public MAGICUpdateDeliveryRspBO updateDelivery(MAGICUpdateDeliveryReqBO reqBO) {
        MAGICUpdateDeliveryRspBO rspBO = new MAGICUpdateDeliveryRspBO();
        SmcMagicStockAddReqBO reqBaseBO = new SmcMagicStockAddReqBO();
        RspBaseBO chek = this.checkParams(reqBO, reqBaseBO);
        if (!"0000".equals(chek.getRespCode())) {
            rspBO.setRespCode(chek.getRespCode());
            rspBO.setRespDesc(chek.getRespDesc());
            rspBO.setCode("1");
            rspBO.setMessage(chek.getRespDesc());
            return rspBO;
        }
        logger.debug("\u5916\u90e8\u63a5\u53e3-\u5e93\u5b58\u66f4\u65b0\u63a8\u9001\u63a5\u53e3-\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBaseBO));
        SmcRspBaseBO smcRspBaseBO = null;
        try {
            smcRspBaseBO = this.smcMagicStoreAddAbilityService.stockChange(reqBaseBO);
            logger.debug("\u5e93\u5b58\u66f4\u65b0\u63a8\u9001\u63a5\u53e3-\u8c03\u7528\u5e93\u5b58\u51fa\u53c2" + JSON.toJSONString((Object)smcRspBaseBO));
        }
        catch (Exception e) {
            logger.error("\u5e93\u5b58\u66f4\u65b0\u63a8\u9001\u63a5\u53e3-\u8c03\u7528\u5e93\u5b58\u5f02\u5e38" + e.getMessage());
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5e93\u5b58\u66f4\u65b0\u63a8\u9001\u63a5\u53e3-\u8c03\u7528\u5e93\u5b58\u5f02\u5e38" + e.getMessage());
            rspBO.setCode("0");
            rspBO.setMessage("\u5e93\u5b58\u66f4\u65b0\u63a8\u9001\u63a5\u53e3-\u8c03\u7528\u5e93\u5b58\u5f02\u5e38" + e.getMessage());
            return rspBO;
        }
        if (null == smcRspBaseBO) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5931\u8d25");
            rspBO.setCode("0");
            rspBO.setMessage("\u5931\u8d25");
            return rspBO;
        }
        if (!"0000".equals(smcRspBaseBO.getRespCode())) {
            rspBO.setRespCode(smcRspBaseBO.getRespCode());
            rspBO.setRespDesc(smcRspBaseBO.getRespDesc());
            rspBO.setCode("0");
            rspBO.setMessage(smcRspBaseBO.getRespDesc());
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setCode("1");
        rspBO.setMessage("\u6210\u529f");
        return rspBO;
    }

    private RspBaseBO checkParams(MAGICUpdateDeliveryReqBO reqBO, SmcMagicStockAddReqBO reqBaseBO) {
        RspBaseBO rspBO = new RspBaseBO();
        rspBO.setRespCode("0001");
        if (null == reqBO) {
            rspBO.setRespDesc("\u5165\u53c2\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getPushType())) {
            rspBO.setRespDesc("\u5165\u53c2-getPushType-\u4e3a\u7a7a");
            return rspBO;
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getList())) {
            rspBO.setRespDesc("\u5165\u53c2-getList-\u4e3a\u7a7a");
            return rspBO;
        }
        ArrayList<SmcMagicListBO> smcMagicListBOS = new ArrayList<SmcMagicListBO>();
        for (MAGICUpdateDeliveryBO item : reqBO.getList()) {
            SmcMagicListBO smcMagicListBO = new SmcMagicListBO();
            if (StringUtils.isBlank((CharSequence)item.getShopId())) {
                rspBO.setRespDesc("\u5165\u53c2-getShopId-\u4e3a\u7a7a");
                return rspBO;
            }
            if (CollectionUtils.isEmpty((Collection)item.getCommodityList())) {
                rspBO.setRespDesc("\u5165\u53c2-getCommodityList-\u4e3a\u7a7a");
                return rspBO;
            }
            ArrayList<SmcMagieGoodsBO> smcMagieGoodsBOS = new ArrayList<SmcMagieGoodsBO>();
            for (MAGICUpdateDeliveryCommBO obj : item.getCommodityList()) {
                SmcMagieGoodsBO smcMagieGoodsBO = new SmcMagieGoodsBO();
                if (StringUtils.isBlank((CharSequence)obj.getChangeType())) {
                    rspBO.setRespDesc("\u5165\u53c2-getChangeType-\u4e3a\u7a7a");
                    return rspBO;
                }
                if (StringUtils.isBlank((CharSequence)obj.getCode())) {
                    rspBO.setRespDesc("\u5165\u53c2-getCode-\u4e3a\u7a7a");
                    return rspBO;
                }
                String zeroStr = STR_FORMAT;
                String numStr = obj.getCode();
                if (Pattern.compile("^[-\\+]?[\\d]*$").matcher(numStr).matches() && numStr.length() == 16) {
                    zeroStr = zeroStr.substring(0, zeroStr.length() - numStr.length());
                    obj.setCode(zeroStr + numStr);
                }
                if (StringUtils.isBlank((CharSequence)obj.getCount())) {
                    rspBO.setRespDesc("\u5165\u53c2-getCount-\u4e3a\u7a7a");
                    return rspBO;
                }
                BeanUtils.copyProperties((Object)obj, (Object)smcMagieGoodsBO);
                smcMagieGoodsBOS.add(smcMagieGoodsBO);
                smcMagieGoodsBO.setCount(Long.valueOf(obj.getCount()));
            }
            BeanUtils.copyProperties((Object)item, (Object)smcMagicListBO);
            smcMagicListBO.setCommodityList(smcMagieGoodsBOS);
            smcMagicListBOS.add(smcMagicListBO);
        }
        reqBaseBO.setList(smcMagicListBOS);
        reqBaseBO.setPushType(reqBO.getPushType());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

