/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.externalinter.bo.ExternaLinterResultData;
import com.tydic.externalinter.busi.bo.GoodsInfoBO;
import com.tydic.externalinter.busi.bo.OrderInfoBO;
import com.tydic.externalinter.busi.bo.OrderSyncReqBO;
import com.tydic.externalinter.busi.bo.OrderSyncRspBO;
import com.tydic.externalinter.busi.bo.PaymentInfoBO;
import com.tydic.externalinter.busi.bo.PublicCallExtReqBO;
import com.tydic.externalinter.busi.bo.SubOrderBO;
import com.tydic.externalinter.busi.bo.SubOrderInfoBO;
import com.tydic.externalinter.busi.service.OrderSyncService;
import com.tydic.externalinter.busi.service.PublicCallExtService;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OrderSyncServiceImpl
implements OrderSyncService {
    private static Logger logger = LoggerFactory.getLogger(OrderSyncServiceImpl.class);
    @Value(value="${order_call_back_url}")
    private String feedBackUrl;
    @Autowired
    private PublicCallExtService publicCallExtService;

    public OrderSyncRspBO sync(OrderSyncReqBO orderSyncReqBO) {
        OrderSyncRspBO rspBaseBO = new OrderSyncRspBO();
        logger.debug("\u8ba2\u5355\u540c\u6b65\u5165\u53c2\uff1a" + JSON.toJSONString((Object)orderSyncReqBO));
        RspBaseBO checkRsp = this.checkParams(orderSyncReqBO);
        if (!"0000".equals(checkRsp.getRespCode())) {
            rspBaseBO.setRespCode(checkRsp.getRespCode());
            rspBaseBO.setRespDesc(checkRsp.getRespDesc());
            return rspBaseBO;
        }
        PublicCallExtReqBO publicCallExtReqBO = new PublicCallExtReqBO();
        publicCallExtReqBO.setBusiCode("EX_SYS_6_014");
        publicCallExtReqBO.setReqParam((Object)orderSyncReqBO);
        ExternaLinterResultData externaLinterResultData = this.publicCallExtService.callService(publicCallExtReqBO);
        logger.debug("\u8ba2\u5355\u540c\u6b65\u7edf\u4e00\u5e73\u53f0\u63a5\u53e3\u8c03\u7528\u51fa\u53c2\uff1a" + externaLinterResultData.toString());
        if (externaLinterResultData.getSuccess().booleanValue()) {
            JSONObject body = (JSONObject)externaLinterResultData.getRespData();
            if (body.containsKey((Object)"bizCode")) {
                rspBaseBO.setBizCode(body.getString("bizCode"));
            }
            if (body.containsKey((Object)"bizDesc")) {
                rspBaseBO.setBizDesc(body.getString("bizDesc"));
            }
            if (body.containsKey((Object)"bizCode") && "1".equals(body.getString("bizCode"))) {
                rspBaseBO.setRespCode("0000");
                rspBaseBO.setRespDesc("\u6210\u529f");
                OrderInfoBO orderInfoBO = new OrderInfoBO();
                if (body.containsKey((Object)"orderInfo") && body.getJSONObject("orderInfo") != null) {
                    JSONObject orderInfo = body.getJSONObject("orderInfo");
                    orderInfoBO.setOrderId(orderInfo.containsKey((Object)"orderId") ? orderInfo.getString("orderId") : "");
                    orderInfoBO.setOspOrderId(orderInfo.containsKey((Object)"ospOrderId") ? orderInfo.getString("ospOrderId") : "");
                    ArrayList<SubOrderBO> subOrderBOS = new ArrayList<SubOrderBO>();
                    if (orderInfo.containsKey((Object)"subOrderList") && orderInfo.getJSONArray("subOrderList") != null) {
                        JSONArray jsonArray = orderInfo.getJSONArray("subOrderList");
                        for (int i = 0; i < jsonArray.size(); ++i) {
                            JSONObject object = jsonArray.getJSONObject(i);
                            SubOrderBO subOrderBO = new SubOrderBO();
                            subOrderBO.setSubOrderId(object.getString("subOrderId"));
                            subOrderBO.setOspsubOrderId(object.getString("ospsubOrderId"));
                            subOrderBOS.add(subOrderBO);
                        }
                        orderInfoBO.setSubOrderList(subOrderBOS);
                    } else {
                        orderInfoBO.setSubOrderList(subOrderBOS);
                    }
                }
                rspBaseBO.setOrderInfo(orderInfoBO);
            } else {
                rspBaseBO.setRespCode(body.containsKey((Object)"bizCode") ? body.getString("bizCode") : "9999");
                rspBaseBO.setRespDesc(body.containsKey((Object)"bizDesc") ? body.getString("bizDesc") : "\u5931\u8d25");
            }
        } else {
            rspBaseBO.setRespCode(externaLinterResultData.getRespCode());
            rspBaseBO.setRespDesc(externaLinterResultData.getRespDesc());
        }
        logger.debug("\u8ba2\u5355\u540c\u6b65\u7edf\u4e00\u5e73\u53f0\u63a5\u53e3\u8c03\u7528\u51fa\u53c2" + JSON.toJSONString((Object)rspBaseBO));
        return rspBaseBO;
    }

    private RspBaseBO checkParams(OrderSyncReqBO reqBO) {
        PaymentInfoBO pay;
        RspBaseBO rspBO = new RspBaseBO();
        rspBO.setRespCode("0001");
        if (null != reqBO.getPaymentInfo() && null != (pay = reqBO.getPaymentInfo()).getPayment()) {
            pay.setPayment(Long.valueOf(new BigDecimal(pay.getPayment()).divide(new BigDecimal("100")).setScale(0, 4).longValue()));
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSubOrderList())) {
            rspBO.setRespDesc("\u5165\u53c2-getSubOrderList-\u4e3a\u7a7a");
            return rspBO;
        }
        for (SubOrderInfoBO item : reqBO.getSubOrderList()) {
            GoodsInfoBO goods;
            if (null != item.getGoodsInfo() && null != (goods = item.getGoodsInfo()).getPrice()) {
                goods.setPrice(Long.valueOf(new BigDecimal(goods.getPrice()).divide(new BigDecimal("100")).setScale(0, 4).longValue()));
            }
            if (null == item.getSubtotalFee()) continue;
            item.setSubtotalFee(Long.valueOf(new BigDecimal(item.getSubtotalFee()).divide(new BigDecimal("100")).setScale(0, 4).longValue()));
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getFeedbackUrl())) {
            reqBO.setFeedbackUrl(this.feedBackUrl);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

