/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.ohaotian.commodity.busi.sku.QuerySkuDetailBusiService;
import com.ohaotian.commodity.busi.sku.bo.QuerySkuDetailReqBO;
import com.ohaotian.commodity.busi.sku.bo.QuerySkuDetailRspBO;
import com.ohaotian.commodity.busi.sku.bo.SkuSpecBO;
import com.ohaotian.plugin.db.Page;
import com.tydic.externalinter.busi.bo.ExtPageRspBO;
import com.tydic.externalinter.busi.bo.QrySpecialSalesDetailsRspBO;
import com.tydic.externalinter.busi.bo.QrySpecialSalesReqBO;
import com.tydic.externalinter.busi.bo.QrySpecialSalesRspBO;
import com.tydic.externalinter.busi.bo.RspBatchInfoBO;
import com.tydic.externalinter.busi.bo.SelectCodeRspBO;
import com.tydic.externalinter.busi.service.QuerySpecialSalesService;
import com.tydic.externalinter.constant.CommodityConstants;
import com.tydic.externalinter.dao.SpecialSalesRecordDao;
import com.tydic.externalinter.dao.SpecialSalesRecordDetailsDao;
import com.tydic.externalinter.dao.po.QrySpecialSalesRecordPO;
import com.tydic.externalinter.dao.po.SpecialSalesRecordDetailsPO;
import com.tydic.externalinter.dao.po.SpecialSalesRecordPO;
import com.tydic.externalinter.util.ExtDateUtils;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.QryEscapeBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuerySpecialSalesServiceImpl
implements QuerySpecialSalesService {
    private static final Logger log = LoggerFactory.getLogger(QuerySpecialSalesServiceImpl.class);
    private static final Boolean isDebug = log.isDebugEnabled();
    private static final String TIME_PATTERN = "^[1-9]\\d{3}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])\\s+(20|21|22|23|[0-1]\\d):[0-5]\\d:[0-5]\\d$";
    @Resource
    private QuerySkuDetailBusiService querySkuDetailBusiService;
    @Autowired
    private SpecialSalesRecordDao specialSalesRecordDao;
    @Autowired
    private SpecialSalesRecordDetailsDao specialSalesRecordDetailsDao;
    @Autowired
    private QryEscapeAtomService exterQryEscapeAtomService;
    private Map<String, QuerySkuDetailRspBO> commodityMap = new HashMap<String, QuerySkuDetailRspBO>();

    public ExtPageRspBO<QrySpecialSalesRspBO> listSpecialSalesByPage(QrySpecialSalesReqBO reqBO) {
        if (null == reqBO.getShopId()) {
            log.error("\u95e8\u5e97ID\u4e0d\u80fd\u4e3a\u7a7a");
            return new ExtPageRspBO("0001", "\u95e8\u5e97ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotBlank((String)reqBO.getStartTime()) && !Pattern.matches(TIME_PATTERN, reqBO.getStartTime())) {
            log.error("\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff0c\u6b63\u786e\u683c\u5f0f\u5e94\u4e3a\uff1ayyyy-MM-dd HH:mm:ss");
            return new ExtPageRspBO("0002", "\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff0c\u6b63\u786e\u683c\u5f0f\u5e94\u4e3a\uff1ayyyy-MM-dd HH:mm:ss");
        }
        if (StringUtils.isNotBlank((String)reqBO.getEndTime()) && !Pattern.matches(TIME_PATTERN, reqBO.getEndTime())) {
            log.error("\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff0c\u6b63\u786e\u683c\u5f0f\u5e94\u4e3a\uff1ayyyy-MM-dd HH:mm:ss");
            return new ExtPageRspBO("0002", "\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff0c\u6b63\u786e\u683c\u5f0f\u5e94\u4e3a\uff1ayyyy-MM-dd HH:mm:ss");
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<SpecialSalesRecordPO> recordPOS = null;
        try {
            recordPOS = this.specialSalesRecordDao.selectByPage((Page<SpecialSalesRecordPO>)page, QrySpecialSalesRecordPO.toQrySpecialSalesRecordPO(reqBO));
        }
        catch (Exception e) {
            log.error("\u5206\u9875\u67e5\u8be2\u7279\u4ef7\u7533\u8bf7\u5355\u5931\u8d25\uff1a" + e.getMessage());
            return new ExtPageRspBO("0006", "\u5206\u9875\u67e5\u8be2\u7279\u4ef7\u7533\u8bf7\u5355\u5931\u8d25");
        }
        ArrayList<QrySpecialSalesRspBO> rspList = null;
        if (CollectionUtils.isNotEmpty(recordPOS)) {
            rspList = new ArrayList<QrySpecialSalesRspBO>(recordPOS.size());
            for (SpecialSalesRecordPO po : recordPOS) {
                QrySpecialSalesRspBO bo = po.toQrySpecialSalesRspBO();
                this.escapeSpecialSalesRecord(bo);
                rspList.add(bo);
            }
        }
        if (isDebug.booleanValue()) {
            log.debug("\u7279\u4ef7\u7533\u8bf7\u67e5\u8be2\u6210\u529f");
        }
        ExtPageRspBO rsp = new ExtPageRspBO("0000", "\u6210\u529f");
        rsp.setRows(rspList);
        rsp.setTotal(page.getTotalPages());
        rsp.setRecordsTotal(page.getTotalCount());
        rsp.setPageNo(reqBO.getPageNo().intValue());
        return rsp;
    }

    private void escapeSpecialSalesRecord(QrySpecialSalesRspBO bo) {
        if (null != bo.getOrderTime()) {
            bo.setOrderTimeStr(ExtDateUtils.formatDate(bo.getOrderTime(), "yyyy-MM-dd HH:mm:ss"));
        }
        if (null != bo.getCheckTime()) {
            bo.setCheckTimeStr(ExtDateUtils.formatDate(bo.getCheckTime(), "yyyy-MM-dd HH:mm:ss"));
        }
        if (null != bo.getCreateTime()) {
            bo.setCreateTimeStr(ExtDateUtils.formatDate(bo.getCreateTime(), "yyyy-MM-dd HH:mm:ss"));
        }
        if (null != bo.getUpdateTime()) {
            bo.setUpdateTimeStr(ExtDateUtils.formatDate(bo.getUpdateTime(), "yyyy-MM-dd HH:mm:ss"));
        }
        if (StringUtils.isNotBlank((String)bo.getIsInvoice()) && "1".equals(bo.getIsInvoice())) {
            bo.setIsInvoiceStr("\u662f");
        } else {
            bo.setIsInvoiceStr("\u5426");
        }
        if (StringUtils.isNotBlank((String)bo.getPayMode())) {
            String payModeStr = this.exterQryEscapeAtomService.getCodeTitle("payMode", bo.getPayMode());
            bo.setPayModeStr(null == payModeStr ? bo.getPayMode() : payModeStr);
        }
        if (StringUtils.isNotBlank((String)bo.getState())) {
            String stateStr = this.exterQryEscapeAtomService.getCodeTitle("specialSalesCheckStatus", bo.getState());
            bo.setStateStr(null == stateStr ? bo.getState() : stateStr);
        } else {
            bo.setStateStr("\u5f85\u5ba1\u6838");
        }
        if (StringUtils.isNotBlank((String)bo.getRecordStatus())) {
            String recordStatusStr = this.exterQryEscapeAtomService.getCodeTitle("specialSalesRecordStatus", bo.getRecordStatus());
            bo.setRecordStatusStr(null == recordStatusStr ? bo.getRecordStatus() : recordStatusStr);
        }
        if (null != bo.getSaleAmount()) {
            try {
                BigDecimal bg = new BigDecimal(bo.getSaleAmount());
                bo.setSaleAmountStr(bg.divide(new BigDecimal(10000)).toString());
            }
            catch (Exception e) {
                log.error("\u4ef7\u683c\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
                bo.setSaleAmountStr(bo.getSaleAmount().toString());
            }
        }
    }

    public RspBatchInfoBO<QrySpecialSalesDetailsRspBO> listSpecailSalesDetails(QrySpecialSalesReqBO reqBO) {
        RspBatchInfoBO rsp = new RspBatchInfoBO();
        if (null == reqBO.getSalesRecordId() || null == reqBO.getShopId()) {
            log.error("\u7533\u8bf7\u5355ID\u548c\u95e8\u5e97ID\u4e0d\u80fd\u4e3a\u7a7a");
            rsp.setRespCode("0001");
            rsp.setRespDesc("\u7533\u8bf7\u5355ID\u548c\u95e8\u5e97ID\u4e0d\u80fd\u4e3a\u7a7a");
            return rsp;
        }
        List<SpecialSalesRecordDetailsPO> detailsPOS = null;
        try {
            detailsPOS = this.specialSalesRecordDetailsDao.selectBySpecialSalesId(reqBO.getSalesRecordId());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u7279\u4ef7\u7533\u8bf7\u8be6\u60c5\u5931\u8d25\uff1a" + e.getMessage());
            rsp.setRespCode("0006");
            rsp.setRespDesc("\u67e5\u8be2\u7279\u4ef7\u7533\u8bf7\u8be6\u60c5\u5931\u8d25");
        }
        ArrayList<QrySpecialSalesDetailsRspBO> rspList = null;
        if (CollectionUtils.isNotEmpty(detailsPOS)) {
            this.commodityMap = new HashMap<String, QuerySkuDetailRspBO>();
            rspList = new ArrayList<QrySpecialSalesDetailsRspBO>(detailsPOS.size());
            for (SpecialSalesRecordDetailsPO po : detailsPOS) {
                BigDecimal bg;
                QrySpecialSalesDetailsRspBO bo = po.toQrySpecialSalesDetailsRspBO();
                if (StringUtils.isNotBlank((String)bo.getMnemCode())) {
                    this.getCommodityDetail(reqBO.getShopId(), bo.getMnemCode(), bo);
                }
                if (null != bo.getAgreementPrice()) {
                    try {
                        bg = new BigDecimal(bo.getAgreementPrice());
                        bo.setAgreementPriceStr(bg.divide(new BigDecimal(10000)).toString());
                    }
                    catch (Exception e) {
                        log.error("\u4ef7\u683c\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
                        bo.setAgreementPriceStr(bo.getAgreementPrice().toString());
                    }
                }
                if (null != bo.getSalePrice()) {
                    try {
                        bg = new BigDecimal(bo.getSalePrice());
                        bo.setSalePriceStr(bg.divide(new BigDecimal(10000)).toString());
                    }
                    catch (Exception e) {
                        log.error("\u4ef7\u683c\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
                        bo.setSalePriceStr(bo.getSalePrice().toString());
                    }
                }
                if (null != bo.getDealPrice()) {
                    try {
                        bg = new BigDecimal(bo.getDealPrice());
                        bo.setDealPriceStr(bg.divide(new BigDecimal(10000)).toString());
                    }
                    catch (Exception e) {
                        log.error("\u4ef7\u683c\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
                        bo.setDealPriceStr(bo.getDealPrice().toString());
                    }
                }
                rspList.add(bo);
            }
        }
        if (isDebug.booleanValue()) {
            log.debug("\u7279\u4ef7\u7533\u8bf7\u8be6\u60c5\u67e5\u8be2\u6210\u529f");
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6210\u529f");
        rsp.setRows(rspList);
        return rsp;
    }

    public RspBatchInfoBO<SelectCodeRspBO> listSpecialSalesCheckStatus() {
        RspBatchInfoBO rsp = new RspBatchInfoBO();
        List escapeCodeBOs = null;
        try {
            escapeCodeBOs = this.exterQryEscapeAtomService.listEscapeByParentCode("specialSalesCheckStatus");
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5ba1\u6838\u72b6\u6001\u5931\u8d25\uff1a" + e.getMessage());
            rsp.setRespCode("0006");
            rsp.setRespDesc("\u67e5\u8be2\u5ba1\u6838\u72b6\u6001\u5931\u8d25");
            return rsp;
        }
        if (CollectionUtils.isEmpty((Collection)escapeCodeBOs)) {
            log.error("\u672a\u914d\u7f6e\u5ba1\u6838\u72b6\u6001\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            rsp.setRespCode("0008");
            rsp.setRespDesc("\u672a\u914d\u7f6e\u5ba1\u6838\u72b6\u6001\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return rsp;
        }
        ArrayList<SelectCodeRspBO> rspList = new ArrayList<SelectCodeRspBO>(escapeCodeBOs.size());
        for (QryEscapeBO escapeBO : escapeCodeBOs) {
            SelectCodeRspBO bo = new SelectCodeRspBO();
            bo.setSelectCode(escapeBO.getEscapeCode());
            bo.setSelectValue(escapeBO.getEscapeValue());
            rspList.add(bo);
        }
        if (isDebug.booleanValue()) {
            log.debug("\u5ba1\u6838\u72b6\u6001\u67e5\u8be2\u5b8c\u6210");
        }
        rsp.setRows(rspList);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6210\u529f");
        return rsp;
    }

    public void getCommodityDetail(Long shopId, String mnemCode, QrySpecialSalesDetailsRspBO bo) {
        QuerySkuDetailRspBO rsp = null;
        if (this.commodityMap.containsKey(mnemCode)) {
            rsp = this.commodityMap.get(mnemCode);
        } else {
            QuerySkuDetailReqBO req = new QuerySkuDetailReqBO();
            req.setSupplierId(shopId);
            req.setExtSkuId(mnemCode);
            try {
                rsp = this.querySkuDetailBusiService.querySkuDetail(req);
            }
            catch (Exception e) {
                log.error("\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u5931\u8d25\uff1a" + e.getMessage());
                return;
            }
            if (!"0000".equals(rsp.getRespCode())) {
                log.error("\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u5931\u8d25\uff1a" + rsp.getRespDesc());
                return;
            }
            if (isDebug.booleanValue()) {
                log.debug("\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u51fa\u53c2\uff1a" + rsp);
            }
            this.commodityMap.put(mnemCode, rsp);
        }
        if (null != rsp) {
            bo.setBrandName(rsp.getBrandName());
            bo.setMfgSku(rsp.getMfgSku());
            bo.setSkuName(rsp.getSkuLongName());
            bo.setSkuLongName(rsp.getSkuLongName());
            String color = null;
            String ram = null;
            List list = rsp.getSpecs();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                for (SkuSpecBO spe : list) {
                    if (CommodityConstants.SKU_SPEC_YS.equals(spe.getCommodityPropGrpId())) {
                        color = spe.getPropValue();
                    }
                    if (!CommodityConstants.SKU_SPEC_NC.equals(spe.getCommodityPropGrpId())) continue;
                    ram = spe.getPropValue();
                }
            }
            bo.setSkuColor(color);
            bo.setSkuRam(ram);
        }
    }

    public static void main(String[] args) {
        BigDecimal bg = new BigDecimal(155000);
        System.out.println(bg.divide(new BigDecimal(10000)).toString());
    }
}

