/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.externalinter.bo.ExternaLinterResultData;
import com.tydic.externalinter.bo.ScmCollectionBO;
import com.tydic.externalinter.busi.bo.PublicCallExtReqBO;
import com.tydic.externalinter.busi.bo.ScmQryCollectionInfoBusiReqBO;
import com.tydic.externalinter.busi.bo.ScmQryCollectionInfoBusiRspBO;
import com.tydic.externalinter.busi.service.PublicCallExtService;
import com.tydic.externalinter.busi.service.ScmQryCollectionInfoBusiService;
import com.tydic.externalinter.dao.ExterAreaMappingDAO;
import com.tydic.externalinter.dao.po.ExterAreaMappingPO;
import com.tydic.externalinter.scm.ws.bo.QryCollectionInfo01BO;
import com.tydic.externalinter.scm.ws.bo.QryCollectionInfoBusiReqBO;
import com.tydic.externalinter.scm.ws.bo.QryCollectionInfoBusiRspBO;
import com.tydic.externalinter.scm.ws.bo.QryCollectionInfoTable02BO;
import com.tydic.externalinter.scm.ws.bo.QryCollectionInfoTable02DetailBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ScmQryCollectionInfoBusiServiceImpl
implements ScmQryCollectionInfoBusiService {
    private static Logger logger = LoggerFactory.getLogger(ScmQryCollectionInfoBusiServiceImpl.class);
    @Autowired
    private PublicCallExtService publicCallExtService;
    @Autowired
    private ExterAreaMappingDAO exterAreaMappingDAO;

    public ScmQryCollectionInfoBusiRspBO qryCollectionInfo(ScmQryCollectionInfoBusiReqBO busiReqBO) {
        ExternaLinterResultData externaLinterResultData;
        ScmQryCollectionInfoBusiRspBO rsp = new ScmQryCollectionInfoBusiRspBO();
        logger.debug("\u6536\u6b3e\u4fe1\u606f\u63a5\u53e3\u670d\u52a1\u5165\u53c2=" + JSON.toJSONString((Object)busiReqBO));
        QryCollectionInfoBusiReqBO qryCollectionInfoBusiReqBO = this.setReqParam(busiReqBO);
        PublicCallExtReqBO publicCallExtReqBO = new PublicCallExtReqBO();
        publicCallExtReqBO.setBusiCode("EX_SYS_4_007");
        publicCallExtReqBO.setReqParam((Object)qryCollectionInfoBusiReqBO);
        logger.debug("\u6536\u6b3e\u4fe1\u606f-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5-\u5165\u53c2\uff1a" + JSON.toJSONString((Object)publicCallExtReqBO));
        try {
            externaLinterResultData = this.publicCallExtService.callService(publicCallExtReqBO);
        }
        catch (Exception e) {
            logger.error("\u6536\u6b3e\u4fe1\u606f\u63a5\u53e3-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38\uff1a" + e.getMessage());
            rsp.setRespCode("0020");
            rsp.setRespDesc("\u6536\u6b3e\u4fe1\u606f\u63a5\u53e3-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38");
            return rsp;
        }
        logger.debug("\u6536\u6b3e\u4fe1\u606f\u63a5\u53e3-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5-\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)externaLinterResultData));
        if (!externaLinterResultData.getSuccess().booleanValue()) {
            logger.debug("\u6536\u6b3e\u4fe1\u606f\u63a5\u53e3-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5-\u5931\u8d25");
            rsp.setRespCode(externaLinterResultData.getRespCode());
            rsp.setRespDesc(externaLinterResultData.getRespDesc());
            return rsp;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)externaLinterResultData.getRespData().toString());
        JSONObject response = jsonObject.getJSONObject("Zfiif125Response");
        String obj2 = response.toJSONString();
        QryCollectionInfoBusiRspBO qryCollectionInfoBusiRspBO = (QryCollectionInfoBusiRspBO)JSONArray.parseObject((String)obj2, QryCollectionInfoBusiRspBO.class);
        this.setRspParam(rsp, qryCollectionInfoBusiRspBO);
        if (!CollectionUtils.isEmpty((Collection)rsp.getScmCollectionBOList())) {
            this.setProvId(rsp);
        }
        logger.debug("\u6536\u6b3e\u4fe1\u606f\u63a5\u53e3\u670d\u52a1\u51fa\u53c2=" + JSON.toJSONString((Object)rsp));
        return rsp;
    }

    private void setProvId(ScmQryCollectionInfoBusiRspBO rsp) {
        try {
            HashSet<String> scmAreaCodes = new HashSet<String>();
            for (ScmCollectionBO bo : rsp.getScmCollectionBOList()) {
                scmAreaCodes.add(bo.getBukrs().substring(0, 2));
            }
            HashMap<String, ExterAreaMappingPO> provMap = new HashMap<String, ExterAreaMappingPO>();
            for (String scmAreaCodeLike : scmAreaCodes) {
                ExterAreaMappingPO exterAreaMappingPO = new ExterAreaMappingPO();
                exterAreaMappingPO.setAreaLevel("2");
                exterAreaMappingPO.setScmAreaCodeLike(scmAreaCodeLike);
                ExterAreaMappingPO exterAreaMapping = this.exterAreaMappingDAO.getModelBy(exterAreaMappingPO);
                if (null == exterAreaMapping) continue;
                provMap.put(exterAreaMapping.getScmAreaCode().substring(0, 2), exterAreaMapping);
            }
            for (ScmCollectionBO bo : rsp.getScmCollectionBOList()) {
                String scmAreaCodeLike = bo.getBukrs().substring(0, 2);
                ExterAreaMappingPO exterAreaMappingPO = (ExterAreaMappingPO)provMap.get(scmAreaCodeLike);
                if (null == exterAreaMappingPO) continue;
                bo.setProvId(exterAreaMappingPO.getAreaCode());
            }
        }
        catch (Exception e) {
            logger.debug("\u8bbe\u7f6e\u7701\u4efd\u7f16\u7801\u5f02\u5e38\uff1a" + e);
        }
    }

    private void setRspParam(ScmQryCollectionInfoBusiRspBO rsp, QryCollectionInfoBusiRspBO qryCollectionInfoBusiRspBO) {
        if (null == qryCollectionInfoBusiRspBO.getEsMsg()) {
            rsp.setRespCode("0011");
            rsp.setRespDesc("\u6536\u6b3e\u4fe1\u606f\u63a5\u53e3\u8fd4\u56de\u72b6\u6001\u4e3a\u7a7a\uff01");
        } else if (!"S".equals(qryCollectionInfoBusiRspBO.getEsMsg().getRetyp())) {
            rsp.setRespCode("0011");
            rsp.setRespDesc(qryCollectionInfoBusiRspBO.getEsMsg().getRemsg());
        } else {
            QryCollectionInfoTable02BO etOut;
            if (null != qryCollectionInfoBusiRspBO.getEtOut() && !CollectionUtils.isEmpty((Collection)(etOut = qryCollectionInfoBusiRspBO.getEtOut()).getItem())) {
                ArrayList<ScmCollectionBO> scmCollectionBOList = new ArrayList<ScmCollectionBO>();
                for (QryCollectionInfoTable02DetailBO bo : etOut.getItem()) {
                    ScmCollectionBO scmCollectionBO = new ScmCollectionBO();
                    scmCollectionBO.setBukrs(bo.getBukrs());
                    scmCollectionBO.setGjahr(bo.getGjahr());
                    scmCollectionBO.setBelnr(bo.getBelnr());
                    scmCollectionBO.setBuzei(bo.getBuzei());
                    scmCollectionBO.setKxxz(bo.getKxxz());
                    scmCollectionBO.setKunnr(bo.getKunnr());
                    scmCollectionBO.setCpudt(bo.getCpudt());
                    scmCollectionBO.setBudat(bo.getBudat());
                    scmCollectionBO.setDmbtr(bo.getDmbtr());
                    scmCollectionBO.setYl1(bo.getYl1());
                    scmCollectionBO.setYl2(bo.getYl2());
                    scmCollectionBO.setYl3(bo.getYl3());
                    scmCollectionBOList.add(scmCollectionBO);
                }
                rsp.setScmCollectionBOList(scmCollectionBOList);
            }
            rsp.setRespCode("0000");
            rsp.setRespDesc(qryCollectionInfoBusiRspBO.getEsMsg().getRemsg());
        }
    }

    private QryCollectionInfoBusiReqBO setReqParam(ScmQryCollectionInfoBusiReqBO busiReqBO) {
        QryCollectionInfoBusiReqBO qryCollectionInfoBusiReqBO = new QryCollectionInfoBusiReqBO();
        QryCollectionInfo01BO isIn = new QryCollectionInfo01BO();
        isIn.setBukrsF(busiReqBO.getBukrsF());
        isIn.setBukrsT(busiReqBO.getBukrsT());
        isIn.setCpudtF(busiReqBO.getCpudtF());
        isIn.setCpudtT(busiReqBO.getCpudtT());
        isIn.setKunnrF(busiReqBO.getKunnrF());
        isIn.setKunnrT(busiReqBO.getKunnrT());
        qryCollectionInfoBusiReqBO.setIsIn(isIn);
        qryCollectionInfoBusiReqBO.setEtOut(new QryCollectionInfoTable02BO());
        return qryCollectionInfoBusiReqBO;
    }
}

