/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.externalinter.ability.bo.BackPolicyReqBO;
import com.tydic.externalinter.ability.bo.BackPolicyRspBO;
import com.tydic.externalinter.bo.ExternaLinterResultData;
import com.tydic.externalinter.busi.bo.PublicCallExtReqBO;
import com.tydic.externalinter.busi.bo.TPSurrenderReqBO;
import com.tydic.externalinter.busi.bo.TPSurrenderRsqBO;
import com.tydic.externalinter.busi.service.PublicCallExtService;
import com.tydic.externalinter.busi.service.SecurityServices.TPSurrenderBusiService;
import com.tydic.externalinter.util.ExterPropertiesUtils;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TPSurrenderBusiServiceImpl
implements TPSurrenderBusiService {
    private static Logger logger = LoggerFactory.getLogger(TPSurrenderBusiServiceImpl.class);
    @Autowired
    private PublicCallExtService publicCallExtService;

    public BackPolicyRspBO surrender(BackPolicyReqBO reqBO) {
        ExternaLinterResultData externaLinterResultData;
        BackPolicyRspBO rspBO = new BackPolicyRspBO();
        logger.debug("\u5916\u90e8\u63a5\u53e3-TP\u9000\u4fdd\u63a5\u53e3-\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        TPSurrenderReqBO reqBaseBO = new TPSurrenderReqBO();
        RspBaseBO checkRsp = this.checkParams(reqBO, reqBaseBO);
        if (!"0000".equals(checkRsp.getRespCode())) {
            rspBO.setRespCode(checkRsp.getRespCode());
            rspBO.setRespDesc(checkRsp.getRespDesc());
            return rspBO;
        }
        PublicCallExtReqBO publicCallExtReqBO = new PublicCallExtReqBO();
        publicCallExtReqBO.setBusiCode("EX_SYS_3_002");
        publicCallExtReqBO.setReqParam((Object)reqBaseBO);
        logger.debug("TP\u9000\u4fdd\u63a5\u53e3-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5-\u5165\u53c2\uff1a" + JSON.toJSONString((Object)publicCallExtReqBO));
        try {
            externaLinterResultData = this.publicCallExtService.callService(publicCallExtReqBO);
        }
        catch (Exception e) {
            logger.error("TP\u9000\u4fdd\u63a5\u53e3-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38\uff1a" + e.getMessage());
            rspBO.setRespCode("0020");
            rspBO.setRespDesc("TP\u9000\u4fdd\u63a5\u53e3-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38");
            return rspBO;
        }
        logger.debug("TP\u9000\u4fdd\u63a5\u53e3-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5-\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)externaLinterResultData));
        if (!externaLinterResultData.getSuccess().booleanValue()) {
            logger.debug("TP\u9000\u4fdd\u63a5\u53e3-\u8c03\u7528\u7edf\u4e00\u5e73\u53f0\u63a5-\u5931\u8d25");
            rspBO.setRespCode(externaLinterResultData.getRespCode());
            rspBO.setRespDesc(externaLinterResultData.getRespDesc());
            return rspBO;
        }
        TPSurrenderRsqBO unsubscribeRspBO = (TPSurrenderRsqBO)JSONObject.parseObject((String)externaLinterResultData.getRespData().toString(), TPSurrenderRsqBO.class);
        this.changeParams(unsubscribeRspBO, rspBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private RspBaseBO checkParams(BackPolicyReqBO reqBO, TPSurrenderReqBO reqBaseBO) {
        RspBaseBO rspBO = new RspBaseBO();
        rspBO.setRespCode("0001");
        if (null == reqBO) {
            rspBO.setRespDesc("\u5165\u53c2\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getPolicyId())) {
            rspBO.setRespDesc("\u5165\u53c2-getPolicyId-\u4e3a\u7a7a");
            return rspBO;
        }
        reqBaseBO.setProjectCode(ExterPropertiesUtils.getProperty("topbs.projectCode"));
        reqBaseBO.setPolicyNo(reqBO.getPolicyId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void changeParams(TPSurrenderRsqBO unsubscribeRspBO, BackPolicyRspBO rspBO) {
        BeanUtils.copyProperties((Object)unsubscribeRspBO, (Object)rspBO);
        if ("1".equals(unsubscribeRspBO.getStatus())) {
            rspBO.setResultCode("0000");
        } else {
            rspBO.setResultCode(unsubscribeRspBO.getStatus());
        }
        rspBO.setResultDesc(unsubscribeRspBO.getMsg());
    }
}

