/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.util;

import com.tydic.externalinter.bo.ExternaLinterResultData;
import com.tydic.externalinter.busi.bo.PublicCallExtReqBO;
import com.tydic.externalinter.config.HttpUntil;
import com.tydic.externalinter.config.MyX509TrustManager;
import com.tydic.externalinter.config.PropertiesReaderUtils;
import com.tydic.externalinter.constant.ExtExceptionConstant;
import com.tydic.externalinter.util.B2BMD5;
import com.tydic.externalinter.util.ExterPropertiesUtils;
import com.tydic.externalinter.util.HttpRequestUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonAPIServiceUtils {
    private static Logger logger = LoggerFactory.getLogger(CommonAPIServiceUtils.class);
    private static SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    private static final String CHARSET = "UTF-8";

    public static ExternaLinterResultData commonUIPService(String inputJsonStr, String urlProperty) {
        String respDesc;
        JSONObject inputJson = null;
        try {
            inputJson = JSONObject.fromObject((Object)inputJsonStr);
        }
        catch (Exception e) {
            logger.error("\u5165\u53c2\u683c\u5f0f\u9519\u8bef\uff1a" + e.getMessage());
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u5165\u53c2\u683c\u5f0f\u9519\u8bef");
        }
        logger.debug("commonUIPService:inputJson\uff1a" + inputJson);
        String url = ExterPropertiesUtils.getProperty(urlProperty).trim();
        String appId = null;
        String appKey = null;
        try {
            appId = PropertiesReaderUtils.getUIPAppId();
            logger.debug("appId\u5730\u5740\uff1a" + appId);
            appKey = PropertiesReaderUtils.getUIPAppKey();
            if (StringUtils.isBlank((String)url)) {
                logger.error("\u672a\u83b7\u53d6\u5230\u8bf7\u6c42\u5730\u5740");
                return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u672a\u83b7\u53d6\u5230\u8bf7\u6c42\u5730\u5740");
            }
            if (!url.startsWith("http")) {
                url = PropertiesReaderUtils.getUIPHost() + url;
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u7edf\u4e00\u63a5\u53e3\u5e73\u53f0\u53c2\u6570\u5931\u8d25\uff1a" + e.getMessage());
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u83b7\u53d6\u7edf\u4e00\u63a5\u53e3\u5e73\u53f0\u53c2\u6570\u5931\u8d25");
        }
        Date now = new Date();
        String timestamp = fmt.format(now);
        if (null == inputJson) {
            inputJson = new JSONObject();
        }
        String sign = B2BMD5.sign(inputJson.toString(), appKey, CHARSET);
        JSONObject input = new JSONObject();
        input.put((Object)"appid", (Object)appId);
        input.put((Object)"timestamp", (Object)timestamp);
        input.put((Object)"sign", (Object)sign);
        input.put((Object)"content", (Object)inputJson.toString());
        logger.info("url\u5730\u5740\uff1a" + url + "------------\u8bf7\u6c42\u62a5\u6587\uff1a" + input.toString());
        String comeBack = null;
        try {
            if (url.contains("/mock/")) {
                comeBack = HttpRequestUtils.httpGet(url);
            } else if (url.startsWith("https")) {
                MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                comeBack = myX509TrustManager.httpsRequest(url, "POST", input.toString());
            } else {
                HttpUntil httpUntil = new HttpUntil();
                comeBack = httpUntil.httpPost(url, input.toString());
            }
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42\u7edf\u4e00\u63a5\u53e3\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38\uff1a" + e.getMessage());
            return new ExternaLinterResultData(Boolean.valueOf(false), "0020", (String)ExtExceptionConstant.codeMap.get("0020"));
        }
        logger.debug("\u8fd4\u56de\u4fe1\u606f\uff1a" + comeBack);
        if (null == comeBack) {
            logger.error("\u8c03\u7528\u7edf\u4e00\u63a5\u53e3\u5e73\u53f0\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            return new ExternaLinterResultData(Boolean.valueOf(false), "0021", "\u8c03\u7528\u7edf\u4e00\u63a5\u53e3\u5e73\u53f0\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        JSONObject json = null;
        try {
            json = JSONObject.fromObject((Object)comeBack);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u7edf\u4e00\u63a5\u53e3\u5e73\u53f0\u51fa\u53c2\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
            return new ExternaLinterResultData(Boolean.valueOf(false), "0020", "\u8c03\u7528\u7edf\u4e00\u63a5\u53e3\u5e73\u53f0\u8fd4\u56de\u51fa\u53c2\u683c\u5f0f\u9519\u8bef");
        }
        JSONObject body = null;
        JSONArray bodyArray = null;
        try {
            if (json.containsKey((Object)"content")) {
                if (json.get("content") instanceof JSONObject) {
                    body = json.getJSONObject("content");
                } else if (json.get("content") instanceof JSONArray) {
                    bodyArray = json.getJSONArray("content");
                }
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u54cd\u5e94\u62a5\u6587\u4f53\u5931\u8d25\uff1a" + e.getMessage());
            return new ExternaLinterResultData(Boolean.valueOf(false), "0009", "\u83b7\u53d6\u54cd\u5e94\u62a5\u6587\u4f53\u5931\u8d25");
        }
        if (null == body && null == bodyArray) {
            logger.error("\u672a\u83b7\u53d6\u54cd\u5e94\u62a5\u6587\u4f53\uff0c\u7edf\u4e00\u63a5\u53e3\u5e73\u53f0\u51fa\u53c2\uff1a" + comeBack);
            return new ExternaLinterResultData(Boolean.valueOf(false), "0009", "\u672a\u83b7\u53d6\u54cd\u5e94\u62a5\u6587\u4f53\uff0c\u7edf\u4e00\u63a5\u53e3\u5e73\u53f0\u51fa\u53c2\uff1a" + comeBack);
        }
        String respCode = json.containsKey((Object)"status") ? json.getString("status") : null;
        String string = respDesc = json.containsKey((Object)"message") ? json.getString("message") : null;
        if (null == respCode || !"1000".equals(respCode)) {
            String desc = "\u7edf\u4e00\u63a5\u53e3\u5e73\u53f0\u5931\u8d25\uff0c\u51fa\u53c2\uff1a" + comeBack;
            if (StringUtils.isNotBlank((String)respDesc)) {
                desc = respDesc;
            }
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", desc);
        }
        if (body != null) {
            return new ExternaLinterResultData(Boolean.valueOf(true), "0000", "\u6210\u529f", (Object)body);
        }
        return new ExternaLinterResultData(Boolean.valueOf(true), "0000", "\u6210\u529f", (Object)bodyArray);
    }

    public static ExternaLinterResultData commonUIPService(String domain, String reqUrl, Object inputJsonStr, String appId, String appKey, PublicCallExtReqBO reqBO) {
        String respDesc;
        JSONObject inputJson;
        try {
            inputJson = JSONObject.fromObject((Object)inputJsonStr);
        }
        catch (Exception e) {
            logger.error("\u5165\u53c2\u683c\u5f0f\u9519\u8bef\uff1a" + e.getMessage());
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u5165\u53c2\u683c\u5f0f\u9519\u8bef");
        }
        logger.debug("commonUIPService:inputJson\uff1a" + inputJson);
        String url = domain + reqUrl;
        logger.debug("appId\u5730\u5740\uff1a" + appId);
        if (StringUtils.isBlank((String)url)) {
            logger.error("\u672a\u83b7\u53d6\u5230\u8bf7\u6c42\u5730\u5740");
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", "\u672a\u83b7\u53d6\u5230\u8bf7\u6c42\u5730\u5740");
        }
        Date now = new Date();
        String timestamp = fmt.format(now);
        if (null == inputJson) {
            inputJson = new JSONObject();
        }
        String sign = B2BMD5.sign(inputJson.toString(), appKey, CHARSET);
        JSONObject input = new JSONObject();
        input.put((Object)"appid", (Object)appId);
        input.put((Object)"timestamp", (Object)timestamp);
        input.put((Object)"sign", (Object)sign);
        input.put((Object)"content", (Object)inputJson.toString());
        logger.info("url\u5730\u5740\uff1a" + url + "------------\u8bf7\u6c42\u62a5\u6587\uff1a" + input.toString());
        reqBO.setReqParamE((Object)input);
        String comeBack = null;
        try {
            if (url.contains("/mock/")) {
                comeBack = HttpRequestUtils.httpGet(url);
            } else if (url.startsWith("https")) {
                MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                comeBack = myX509TrustManager.httpsRequest(url, "POST", input.toString());
            } else {
                HttpUntil httpUntil = new HttpUntil();
                comeBack = httpUntil.httpPost(url, input.toString());
            }
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42\u7edf\u4e00\u63a5\u53e3\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38\uff1a" + e.getMessage());
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", e.getMessage());
        }
        logger.debug("\u8fd4\u56de\u4fe1\u606f\uff1a" + comeBack);
        if (null == comeBack) {
            logger.error("\u8c03\u7528\u7edf\u4e00\u63a5\u53e3\u5e73\u53f0\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            return new ExternaLinterResultData(Boolean.valueOf(false), "0021", "\u8c03\u7528\u7edf\u4e00\u63a5\u53e3\u5e73\u53f0\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        JSONObject json = null;
        try {
            json = JSONObject.fromObject((Object)comeBack);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u7edf\u4e00\u63a5\u53e3\u5e73\u53f0\u51fa\u53c2\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
            return new ExternaLinterResultData(Boolean.valueOf(false), "0020", "\u8c03\u7528\u7edf\u4e00\u63a5\u53e3\u5e73\u53f0\u8fd4\u56de\u51fa\u53c2\u683c\u5f0f\u9519\u8bef");
        }
        JSONObject body = null;
        JSONArray bodyArray = null;
        try {
            if (json.containsKey((Object)"content")) {
                if (json.get("content") instanceof JSONObject) {
                    body = json.getJSONObject("content");
                } else if (json.get("content") instanceof JSONArray) {
                    bodyArray = json.getJSONArray("content");
                }
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u54cd\u5e94\u62a5\u6587\u4f53\u5931\u8d25\uff1a" + e.getMessage());
            return new ExternaLinterResultData(Boolean.valueOf(false), "0009", "\u83b7\u53d6\u54cd\u5e94\u62a5\u6587\u4f53\u5931\u8d25");
        }
        if (null == body && null == bodyArray) {
            logger.error("\u672a\u83b7\u53d6\u54cd\u5e94\u62a5\u6587\u4f53\uff0c\u7edf\u4e00\u63a5\u53e3\u5e73\u53f0\u51fa\u53c2\uff1a" + comeBack);
            return new ExternaLinterResultData(Boolean.valueOf(false), "0009", "\u672a\u83b7\u53d6\u54cd\u5e94\u62a5\u6587\u4f53\uff0c\u7edf\u4e00\u63a5\u53e3\u5e73\u53f0\u51fa\u53c2\uff1a" + comeBack);
        }
        String respCode = json.containsKey((Object)"status") ? json.getString("status") : null;
        String string = respDesc = json.containsKey((Object)"message") ? json.getString("message") : null;
        if (null == respCode || !"1000".equals(respCode)) {
            String desc = "\u7edf\u4e00\u63a5\u53e3\u5e73\u53f0\u5931\u8d25\uff0c\u51fa\u53c2\uff1a" + comeBack;
            if (StringUtils.isNotBlank((String)respDesc)) {
                desc = respDesc;
            }
            return new ExternaLinterResultData(Boolean.valueOf(false), "9999", desc);
        }
        if (body != null) {
            return new ExternaLinterResultData(Boolean.valueOf(true), "0000", "\u6210\u529f", (Object)body);
        }
        return new ExternaLinterResultData(Boolean.valueOf(true), "0000", "\u6210\u529f", (Object)bodyArray);
    }
}

