/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.util;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.tydic.externalinter.util.MD5;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class EncryptionUtils {
    private static Logger logger = LoggerFactory.getLogger(EncryptionUtils.class);
    private static final String CHARSET = "UTF-8";

    public static String getKDRBReqParam(Object jsonString, String appId, String key, String method) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("a", appId);
        req.put("f", "json");
        req.put("l", "zh_CN");
        req.put("m", method);
        req.put("v", "1.0");
        req.put("i", "" + System.currentTimeMillis());
        req.put("params", jsonString.toString());
        req.put("s", EncryptionUtils.sign(req, null, key));
        StringBuilder param = new StringBuilder();
        for (Map.Entry e : req.entrySet()) {
            param.append("&").append((String)e.getKey()).append("=").append(URLEncoder.encode((String)e.getValue(), CHARSET));
        }
        return param.toString().substring(1);
    }

    public static String getHDTXReqParam(Object jsonString, String key) throws UnsupportedEncodingException {
        String timestamp = "" + System.currentTimeMillis();
        Map map = (Map)JSONObject.parseObject((String)jsonString.toString(), (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        map.put("timestamp", timestamp);
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getValue() == "") continue;
            list.add((String)entry.getKey() + "=" + entry.getValue() + "&");
        }
        int size = list.size();
        String[] arrayToSort = list.toArray(new String[size]);
        Arrays.sort(arrayToSort, String.CASE_INSENSITIVE_ORDER);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append(arrayToSort[i]);
        }
        String reqBO = sb.toString();
        sb.append("key=").append(key);
        String sign = MD5.MD5Encode(sb.toString()).toUpperCase();
        return reqBO + "sign=" + sign.toUpperCase();
    }

    public static String getNUONUOCSReqParam(Object jsonString, String key) throws UnsupportedEncodingException {
        byte[] encrypt = new byte[]{};
        try {
            if (jsonString != null) {
                encrypt = jsonString.toString().getBytes("utf-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        byte[] md5Hasn = null;
        try {
            md5Hasn = EncryptionUtils.MD5Hash(encrypt, 0, encrypt.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        byte[] totalByte = EncryptionUtils.addMD5(md5Hasn, encrypt);
        byte[] key1 = new byte[8];
        byte[] iv = new byte[8];
        EncryptionUtils.getKeyIV(key, key1, iv);
        SecretKeySpec deskey = new SecretKeySpec(key1, "DES");
        IvParameterSpec ivParam = new IvParameterSpec(iv);
        byte[] temp = null;
        try {
            temp = EncryptionUtils.DES_CBC_Encrypt(totalByte, deskey, ivParam);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "order=" + new BASE64Encoder().encode(temp);
    }

    private static String sign(Map<String, String> paramValues, List<String> ignoreParamNames, String secret) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> paramNames = new ArrayList<String>(paramValues.size());
        paramNames.addAll(paramValues.keySet());
        if (ignoreParamNames != null && ignoreParamNames.size() > 0) {
            for (String ignoreParamName : ignoreParamNames) {
                paramNames.remove(ignoreParamName);
            }
        }
        Collections.sort(paramNames);
        sb.append(secret);
        for (String paramName : paramNames) {
            sb.append(paramName).append(paramValues.get(paramName));
        }
        sb.append(secret);
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        return EncryptionUtils.byte2hex(md.digest(sb.toString().getBytes(CHARSET)));
    }

    private static String byte2hex(byte[] bytes) {
        StringBuilder sign = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex.toUpperCase());
        }
        return sign.toString();
    }

    public static String getSign(Map<String, Object> map, String key) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() == "") continue;
            list.add(entry.getKey() + "=" + entry.getValue() + "&");
        }
        int size = list.size();
        String[] arrayToSort = list.toArray(new String[size]);
        Arrays.sort(arrayToSort, String.CASE_INSENSITIVE_ORDER);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append(arrayToSort[i]);
        }
        String result = sb.toString();
        result = result + "key=" + key;
        return result;
    }

    public String convertParas(Object o) throws IllegalArgumentException, IllegalAccessException {
        Field[] fields;
        StringBuilder sb = new StringBuilder();
        Class<?> cls = o.getClass();
        for (Field f : fields = cls.getDeclaredFields()) {
            f.setAccessible(true);
            if (f.get(o) == null || f.get(o) == "") continue;
            sb.append(f.getName() + "=" + f.get(o) + "&");
        }
        return sb.toString();
    }

    public static byte[] DES_CBC_Encrypt(byte[] sourceBuf, SecretKeySpec deskey, IvParameterSpec ivParam) throws Exception {
        Cipher encrypt = Cipher.getInstance("DES/CBC/PKCS5Padding");
        encrypt.init(1, (Key)deskey, ivParam);
        byte[] cipherByte = encrypt.doFinal(sourceBuf, 0, sourceBuf.length);
        return cipherByte;
    }

    public static byte[] MD5Hash(byte[] buf, int offset, int length) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(buf, offset, length);
        return md.digest();
    }

    public static byte[] addMD5(byte[] md5Byte, byte[] bodyByte) {
        int length = bodyByte.length + md5Byte.length;
        byte[] resutlByte = new byte[length];
        for (int i = 0; i < length; ++i) {
            resutlByte[i] = i < md5Byte.length ? md5Byte[i] : bodyByte[i - md5Byte.length];
        }
        return resutlByte;
    }

    public static void getKeyIV(String encryptKey, byte[] key, byte[] iv) {
        int i;
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] buf = null;
        try {
            buf = decoder.decodeBuffer(encryptKey);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (i = 0; i < key.length; ++i) {
            key[i] = buf[i];
        }
        for (i = 0; i < iv.length; ++i) {
            iv[i] = buf[i + 8];
        }
    }
}

