/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.externalinter.util;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestUtils {
    private static Logger logger = LoggerFactory.getLogger(HttpRequestUtils.class);
    private static HttpClient client = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpGet(String url) {
        String jsonStr = null;
        HttpGet httpGet = new HttpGet(url);
        try {
            HttpResponse response = client.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200) {
                jsonStr = EntityUtils.toString((HttpEntity)response.getEntity());
            } else {
                logger.error("get\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + httpGet.getURI());
            }
        }
        catch (IOException e) {
            logger.error("get\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + url, (Throwable)e);
        }
        finally {
            if (null != httpGet) {
                httpGet.releaseConnection();
            }
        }
        return jsonStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPost(String url, JSONObject param) {
        String jsonStr = null;
        HttpPost httpPost = new HttpPost(url);
        try {
            HttpResponse response;
            if (null != param) {
                StringEntity entity = new StringEntity(param.toString(), "utf-8");
                entity.setContentEncoding("UTF-8");
                entity.setContentType("application/json");
                httpPost.setEntity((HttpEntity)entity);
            }
            if ((response = client.execute((HttpUriRequest)httpPost)).getStatusLine().getStatusCode() == 200) {
                jsonStr = EntityUtils.toString((HttpEntity)response.getEntity());
            } else {
                logger.error("post\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + httpPost.getURI());
            }
        }
        catch (IOException e) {
            logger.error("post\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + url, (Throwable)e);
        }
        finally {
            if (null != httpPost) {
                httpPost.releaseConnection();
            }
        }
        return jsonStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPostHB(String url, JSONObject param) {
        Date time = new Date();
        String jsonStr = null;
        long startTime = System.currentTimeMillis();
        HttpPost httpPost = new HttpPost(url);
        try {
            HttpResponse response;
            if (null != param) {
                StringEntity entity = new StringEntity(param.toString(), "utf-8");
                httpPost.setHeader("Content-Type", "application/json;");
                entity.setContentType("text/json");
                entity.setContentEncoding((Header)new BasicHeader("Content-Type", "application/json"));
                entity.setContentEncoding((Header)new BasicHeader("Accept-Encoding", ""));
                httpPost.setEntity((HttpEntity)entity);
            }
            if ((response = client.execute((HttpUriRequest)httpPost)).getStatusLine().getStatusCode() == 200) {
                jsonStr = EntityUtils.toString((HttpEntity)response.getEntity());
                long l = System.currentTimeMillis() - startTime;
            } else {
                logger.error("post\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + httpPost.getURI());
            }
        }
        catch (IOException e) {
            logger.error("post\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + url, (Throwable)e);
        }
        finally {
            if (null != httpPost) {
                httpPost.releaseConnection();
            }
        }
        return jsonStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JSONObject request(String restUrl, String requestdata, String inputCharset, String outputCharset, String clientOutputCharset, String requestMode, String contentType, Map<String, String> headers) {
        String error;
        HttpEntity entity;
        HttpPost httpPost;
        HttpGet httpGet;
        CloseableHttpClient httpClient;
        block24: {
            httpClient = HttpClients.createDefault();
            httpGet = null;
            httpPost = null;
            JSONObject result = new JSONObject();
            entity = null;
            HttpResponse response = null;
            try {
                if ("POST".equalsIgnoreCase(requestMode)) {
                    httpPost = new HttpPost(restUrl);
                    StringEntity reqEntity = new StringEntity(requestdata, inputCharset);
                    reqEntity.setContentType(contentType);
                    reqEntity.setContentEncoding(inputCharset);
                    httpPost.setEntity((HttpEntity)reqEntity);
                    for (Map.Entry<String, String> entry : headers.entrySet()) {
                        httpPost.addHeader(entry.getKey(), entry.getValue());
                    }
                    httpPost.removeHeaders("Content-Length");
                    logger.info("post\u8bf7\u6c42url\uff1a" + restUrl + "\uff0c\u5165\u53c2" + requestdata.toString());
                    response = httpClient.execute((HttpUriRequest)httpPost);
                } else {
                    httpGet = new HttpGet(restUrl);
                    for (Map.Entry jSONObject : headers.entrySet()) {
                        httpGet.addHeader((String)jSONObject.getKey(), (String)jSONObject.getValue());
                    }
                    logger.info("get\u8bf7\u6c42url\uff1a" + restUrl);
                    response = httpClient.execute((HttpUriRequest)httpGet);
                }
                int status = response.getStatusLine().getStatusCode();
                logger.info("\u7f51\u7edc\u72b6\u6001:status=" + status);
                String string = "";
                if (200 == status) {
                    void var15_22;
                    entity = response.getEntity();
                    if (entity != null) {
                        String string2 = new String(EntityUtils.toString((HttpEntity)entity).getBytes(outputCharset), clientOutputCharset);
                    }
                    result.put((Object)"HTTPCODE", (Object)200);
                    result.put((Object)"respDesc", (Object)"SUCCESS");
                    result.put((Object)"Data", (Object)var15_22);
                } else {
                    entity = response.getEntity();
                    error = new String(EntityUtils.toString((HttpEntity)entity).getBytes(outputCharset), clientOutputCharset);
                    String string3 = "\u7f51\u7edc\u9519\u8bef:\u9519\u8bef\u4ee3\u7801" + status + "," + error;
                    result.put((Object)"HTTPCODE", (Object)status);
                    result.put((Object)"respDesc", (Object)"FAIL");
                    result.put((Object)"Data", (Object)string3);
                }
                logger.info("http\u8bf7\u6c42\u8fd4\u56de\uff1a" + result);
                error = result;
                if (null == entity) break block24;
            }
            catch (Exception e) {
                e.printStackTrace();
                result.put((Object)"HTTPCODE", (Object)500);
                result.put((Object)"respDesc", (Object)"EXCEPTION");
                JSONObject jSONObject = result;
                return jSONObject;
            }
            try {
                EntityUtils.consume((HttpEntity)entity);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (null != httpGet && httpGet.isAborted()) {
            httpGet.abort();
        }
        if (null != httpPost && httpPost.isAborted()) {
            httpPost.abort();
        }
        if (null == httpClient) return error;
        httpClient.getConnectionManager().shutdown();
        return error;
        finally {
            if (null != entity) {
                try {
                    EntityUtils.consume(entity);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != httpGet && httpGet.isAborted()) {
                httpGet.abort();
            }
            if (null != httpPost && httpPost.isAborted()) {
                httpPost.abort();
            }
            if (null != httpClient) {
                httpClient.getConnectionManager().shutdown();
            }
        }
    }

    static {
        if (null == client) {
            client = HttpClients.createDefault();
        }
    }
}

