/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fcm.busi;

import com.tydic.fcm.bo.FcmCreateFreightTemplateReqBO;
import com.tydic.fcm.bo.FcmCreateFreightTemplateRspBO;
import com.tydic.fcm.bo.FreightAreaAttrBO;
import com.tydic.fcm.bo.FreightExtAttrBO;
import com.tydic.fcm.bo.FreightRelationalBO;
import com.tydic.fcm.bo.FreightTemplateLadderBO;
import com.tydic.fcm.busi.FcmCreateFreightTemplateBusiService;
import com.tydic.fcm.constant.BusinessException;
import com.tydic.fcm.dao.FreightAreaAttrMapper;
import com.tydic.fcm.dao.FreightExtAttrMapper;
import com.tydic.fcm.dao.FreightRelationalMapper;
import com.tydic.fcm.dao.FreightTemplateLadderMapper;
import com.tydic.fcm.dao.FreightTemplateMapper;
import com.tydic.fcm.dao.MatchingRulesMapper;
import com.tydic.fcm.dao.po.FreightAreaAttrPO;
import com.tydic.fcm.dao.po.FreightExtAttrPO;
import com.tydic.fcm.dao.po.FreightRelationalPO;
import com.tydic.fcm.dao.po.FreightTemplateLadderPO;
import com.tydic.fcm.dao.po.FreightTemplatePO;
import com.tydic.fcm.dao.po.MatchingRulesPO;
import com.tydic.fcm.utils.FcmGenerateIdUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional
public class FcmCreateFreightTemplateBusiServiceImpl
implements FcmCreateFreightTemplateBusiService {
    @Autowired
    private FreightAreaAttrMapper freightAreaAttrMapper;
    @Autowired
    private FreightExtAttrMapper freightExtAttrMapper;
    @Autowired
    private FreightTemplateLadderMapper freightTemplateLadderMapper;
    @Autowired
    private FreightTemplateMapper freightTemplateMapper;
    @Autowired
    private MatchingRulesMapper matchingRulesMapper;
    @Autowired
    private FreightRelationalMapper freightRelationalMapper;
    @Autowired
    private FcmGenerateIdUtil idUtil;

    public FcmCreateFreightTemplateRspBO createFreightTemplate(FcmCreateFreightTemplateReqBO reqBO) {
        this.val(reqBO);
        FreightTemplatePO templatePO = new FreightTemplatePO();
        BeanUtils.copyProperties((Object)reqBO, (Object)templatePO);
        templatePO.setTemplateId(this.idUtil.nextId());
        if (StringUtils.isBlank((CharSequence)reqBO.getTemplateNo())) {
            templatePO.setTemplateNo("FCM-" + templatePO.getTemplateId());
        }
        templatePO.setTemplateName(reqBO.getTemplateName());
        templatePO.setTemplateType(reqBO.getTemplateType());
        templatePO.setCreateTime(new Date());
        templatePO.setUpdateTime(new Date());
        MatchingRulesPO matchingRulesPO = new MatchingRulesPO();
        BeanUtils.copyProperties((Object)reqBO.getMatchingRules(), (Object)matchingRulesPO);
        matchingRulesPO.setTemplateId(templatePO.getTemplateId());
        matchingRulesPO.setCreateTime(new Date());
        matchingRulesPO.setUpdateTime(new Date());
        matchingRulesPO.setId(this.idUtil.nextId());
        if (reqBO.getMatchingRules().getMatchLevel() == null) {
            matchingRulesPO.setMatchLevel(0);
        }
        ArrayList<FreightAreaAttrPO> areaAttrPOS = new ArrayList<FreightAreaAttrPO>();
        ArrayList<FreightExtAttrPO> extAttrPOS = new ArrayList<FreightExtAttrPO>();
        ArrayList<FreightTemplateLadderPO> ladderPOS = new ArrayList<FreightTemplateLadderPO>();
        ArrayList<FreightRelationalPO> relationalPOS = new ArrayList<FreightRelationalPO>();
        for (FreightRelationalBO relationalBO : reqBO.getFreightRelational()) {
            FreightRelationalPO freightRelationalPO = new FreightRelationalPO();
            freightRelationalPO.setId(this.idUtil.nextId());
            freightRelationalPO.setUpdateTime(new Date());
            freightRelationalPO.setCreateTime(new Date());
            freightRelationalPO.setTemplateId(templatePO.getTemplateId());
            relationalPOS.add(freightRelationalPO);
            for (FreightAreaAttrBO areaAttrBO : relationalBO.getFreightAreaAttr()) {
                FreightAreaAttrPO attrPO = new FreightAreaAttrPO();
                BeanUtils.copyProperties((Object)areaAttrBO, (Object)attrPO);
                attrPO.setId(this.idUtil.nextId());
                attrPO.setTemplateId(templatePO.getTemplateId());
                attrPO.setFreId(freightRelationalPO.getId());
                areaAttrPOS.add(attrPO);
            }
            if (!CollectionUtils.isEmpty((Collection)relationalBO.getFreightExtAttr())) {
                for (FreightExtAttrBO extAttrBO : relationalBO.getFreightExtAttr()) {
                    FreightExtAttrPO extAttrPO = new FreightExtAttrPO();
                    BeanUtils.copyProperties((Object)extAttrBO, (Object)extAttrPO);
                    extAttrPO.setId(this.idUtil.nextId());
                    extAttrPO.setFreId(freightRelationalPO.getId());
                    extAttrPO.setCreateTime(new Date());
                    extAttrPO.setUpdateTime(new Date());
                    if (extAttrPO.getMatchLevel() == null) {
                        extAttrPO.setMatchLevel(0);
                    }
                    extAttrPOS.add(extAttrPO);
                }
            }
            if (CollectionUtils.isEmpty((Collection)relationalBO.getFreightTemplateLadder())) continue;
            for (FreightTemplateLadderBO ladderBO : relationalBO.getFreightTemplateLadder()) {
                FreightTemplateLadderPO ladderPO = new FreightTemplateLadderPO();
                BeanUtils.copyProperties((Object)ladderBO, (Object)ladderPO);
                ladderPO.setId(this.idUtil.nextId());
                ladderPO.setFreId(freightRelationalPO.getId());
                if (ladderPO.getMatchLevel() == null) {
                    ladderPO.setMatchLevel(0);
                }
                ladderPO.setCreateTime(new Date());
                ladderPO.setUpdateTime(new Date());
                ladderPOS.add(ladderPO);
            }
        }
        this.freightTemplateMapper.insert(templatePO);
        this.matchingRulesMapper.insert(matchingRulesPO);
        this.freightRelationalMapper.insertBatch(relationalPOS);
        this.freightAreaAttrMapper.insertBatch(areaAttrPOS);
        if (!CollectionUtils.isEmpty(extAttrPOS)) {
            this.freightExtAttrMapper.insertBatch(extAttrPOS);
        }
        if (!CollectionUtils.isEmpty(ladderPOS)) {
            this.freightTemplateLadderMapper.insertBatch(ladderPOS);
        }
        FcmCreateFreightTemplateRspBO rspBO = new FcmCreateFreightTemplateRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void val(FcmCreateFreightTemplateReqBO reqBO) {
        if (reqBO.getTemplateType() == null) {
            throw new BusinessException("7777", "\u5165\u53c2\u6a21\u677f\u7c7b\u578btemplateType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getMatchingRules() == null) {
            throw new BusinessException("7777", "\u5165\u53c2matchingRules\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getFreightRelational() == null) {
            throw new BusinessException("7777", "\u5165\u53c2freightRelational\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

