/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fcm.busi;

import com.tydic.fcm.bo.FcmFreightCalculationReqBO;
import com.tydic.fcm.bo.FcmFreightCalculationRspBO;
import com.tydic.fcm.bo.FreightItemBO;
import com.tydic.fcm.bo.MatchingRulesBO;
import com.tydic.fcm.busi.FcmFreightCalculationBusiService;
import com.tydic.fcm.constant.BusinessException;
import com.tydic.fcm.dao.FreightAreaAttrMapper;
import com.tydic.fcm.dao.FreightExtAttrMapper;
import com.tydic.fcm.dao.FreightRelationalMapper;
import com.tydic.fcm.dao.FreightTemplateLadderMapper;
import com.tydic.fcm.dao.FreightTemplateMapper;
import com.tydic.fcm.dao.MatchingRulesMapper;
import com.tydic.fcm.dao.po.FreightAreaAttrPO;
import com.tydic.fcm.dao.po.FreightTemplateLadderPO;
import com.tydic.fcm.dao.po.FreightTemplatePO;
import com.tydic.fcm.dao.po.MatchingRulesPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FcmFreightCalculationBusiServiceImpl
implements FcmFreightCalculationBusiService {
    @Autowired
    private FreightAreaAttrMapper freightAreaAttrMapper;
    @Autowired
    private FreightExtAttrMapper freightExtAttrMapper;
    @Autowired
    private FreightTemplateLadderMapper freightTemplateLadderMapper;
    @Autowired
    private FreightTemplateMapper freightTemplateMapper;
    @Autowired
    private MatchingRulesMapper matchingRulesMapper;
    @Autowired
    private FreightRelationalMapper freightRelationalMapper;

    public FcmFreightCalculationRspBO freightCalculation(FcmFreightCalculationReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getMatchingRules())) {
            throw new BusinessException("7777", "\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<FreightItemBO> itemInfo = new ArrayList<FreightItemBO>();
        for (MatchingRulesBO rulesBO : reqBO.getMatchingRules()) {
            Object matchingRulesPO = new MatchingRulesPO();
            BeanUtils.copyProperties((Object)rulesBO, (Object)matchingRulesPO);
            ((MatchingRulesPO)matchingRulesPO).setOrderBy("matchLevel asc,createTime desc");
            matchingRulesPO = this.matchingRulesMapper.selectOne((MatchingRulesPO)matchingRulesPO);
            if (matchingRulesPO == null) {
                rulesBO.setTemplateId(Long.valueOf(0L));
                continue;
            }
            BeanUtils.copyProperties((Object)matchingRulesPO, (Object)rulesBO);
        }
        Map<Long, List<MatchingRulesBO>> map = reqBO.getMatchingRules().stream().collect(Collectors.groupingBy(MatchingRulesBO::getTemplateId));
        BigDecimal total = BigDecimal.ZERO;
        for (Long key : map.keySet()) {
            FreightItemBO itemBO = new FreightItemBO();
            itemBO.setId(key);
            if (key == 0L) {
                itemBO.setFreight(BigDecimal.ZERO);
                continue;
            }
            List<MatchingRulesBO> list = map.get(key);
            FreightTemplatePO templatePO = new FreightTemplatePO();
            templatePO.setTemplateId(key);
            templatePO = this.freightTemplateMapper.selectByCondition(templatePO).get(0);
            itemBO.setMatchingRules(list);
            itemBO.setTemplateName(templatePO.getTemplateName());
            itemBO.setTemplateNo(templatePO.getTemplateNo());
            itemInfo.add(itemBO);
            if (templatePO.getTemplateType() == 0) {
                itemBO.setFreight(BigDecimal.ZERO);
                continue;
            }
            BigDecimal amount = BigDecimal.ZERO;
            for (MatchingRulesBO bo : list) {
                amount = amount.add(bo.getSalePrice());
            }
            FreightAreaAttrPO areaAttrPO = new FreightAreaAttrPO();
            areaAttrPO.setTemplateId(key);
            List<FreightAreaAttrPO> attrPOS = this.freightAreaAttrMapper.selectByCondition(areaAttrPO);
            int max = 0;
            FreightAreaAttrPO fa = null;
            for (FreightAreaAttrPO attrPO : attrPOS) {
                if (attrPO.getProvinceId() == null || !attrPO.getProvinceId().equals(reqBO.getProvinceId())) continue;
                int sc = 1;
                if (max <= sc) {
                    fa = attrPO;
                    max = sc;
                }
                if (attrPO.getCityId() == null || !attrPO.getCityId().equals(reqBO.getCityId())) continue;
                sc = 2;
                if (max <= sc) {
                    fa = attrPO;
                    max = sc;
                }
                if (attrPO.getCountyId() == null || !attrPO.getCountyId().equals(reqBO.getCountyId())) continue;
                fa = attrPO;
                max = 3;
                if (attrPO.getTownId() == null || !attrPO.getTownId().equals(reqBO.getTownId())) continue;
                break;
            }
            if (fa == null) {
                fa = attrPOS.get(0);
            }
            FreightTemplateLadderPO ladderPO = new FreightTemplateLadderPO();
            ladderPO.setStartAmount(amount);
            ladderPO.setEndAmount(amount);
            ladderPO.setTemplateId(fa.getTemplateId());
            ladderPO.setFreId(fa.getFreId());
            ladderPO = this.freightTemplateLadderMapper.selectOne(ladderPO);
            if (ladderPO == null) {
                itemBO.setFreight(BigDecimal.ZERO);
                continue;
            }
            itemBO.setFreight(ladderPO.getFeight());
            total = total.add(ladderPO.getFeight());
        }
        FcmFreightCalculationRspBO rspBO = new FcmFreightCalculationRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setFreight(total);
        rspBO.setItemInfo(itemInfo);
        return rspBO;
    }
}

