/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fcm.busi;

import com.tydic.fcm.bo.FcmUpdateFreightTemplateReqBO;
import com.tydic.fcm.bo.FcmUpdateFreightTemplateRspBO;
import com.tydic.fcm.bo.FreightAreaAttrBO;
import com.tydic.fcm.bo.FreightExtAttrBO;
import com.tydic.fcm.bo.FreightRelationalBO;
import com.tydic.fcm.bo.FreightTemplateLadderBO;
import com.tydic.fcm.busi.FcmUpdateFreightTemplateBusiService;
import com.tydic.fcm.constant.FcmConstant;
import com.tydic.fcm.dao.FreightAreaAttrMapper;
import com.tydic.fcm.dao.FreightExtAttrMapper;
import com.tydic.fcm.dao.FreightRelationalMapper;
import com.tydic.fcm.dao.FreightTemplateLadderMapper;
import com.tydic.fcm.dao.FreightTemplateMapper;
import com.tydic.fcm.dao.MatchingRulesMapper;
import com.tydic.fcm.dao.po.FreightAreaAttrPO;
import com.tydic.fcm.dao.po.FreightExtAttrPO;
import com.tydic.fcm.dao.po.FreightRelationalPO;
import com.tydic.fcm.dao.po.FreightTemplateLadderPO;
import com.tydic.fcm.dao.po.FreightTemplatePO;
import com.tydic.fcm.dao.po.MatchingRulesPO;
import com.tydic.fcm.utils.FcmGenerateIdUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional
public class FcmUpdateFreightTemplateBusiServiceImpl
implements FcmUpdateFreightTemplateBusiService {
    @Autowired
    private FreightAreaAttrMapper freightAreaAttrMapper;
    @Autowired
    private FreightExtAttrMapper freightExtAttrMapper;
    @Autowired
    private FreightTemplateLadderMapper freightTemplateLadderMapper;
    @Autowired
    private FreightTemplateMapper freightTemplateMapper;
    @Autowired
    private MatchingRulesMapper matchingRulesMapper;
    @Autowired
    private FcmGenerateIdUtil idUtil;
    @Autowired
    private FreightRelationalMapper freightRelationalMapper;

    public FcmUpdateFreightTemplateRspBO updateFreightTemplate(FcmUpdateFreightTemplateReqBO reqBO) {
        FcmUpdateFreightTemplateRspBO rspBO = new FcmUpdateFreightTemplateRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        MatchingRulesPO matchingRulesPO = new MatchingRulesPO();
        BeanUtils.copyProperties((Object)reqBO.getMatchingRules(), (Object)matchingRulesPO);
        matchingRulesPO.setUpdateTime(new Date());
        if (reqBO.getTemplateType() != null) {
            FreightTemplatePO templatePO = new FreightTemplatePO();
            templatePO.setTemplateId(reqBO.getTemplateId());
            templatePO.setTemplateType(reqBO.getTemplateType());
            this.freightTemplateMapper.update(templatePO);
        }
        this.matchingRulesMapper.update(matchingRulesPO);
        if (CollectionUtils.isEmpty((Collection)reqBO.getFreightRelational())) {
            return rspBO;
        }
        for (FreightRelationalBO relationalBO : reqBO.getFreightRelational()) {
            if (relationalBO.getId() == null) {
                this.saveArea(relationalBO, reqBO);
                continue;
            }
            if (FcmConstant.DELETE.equals(relationalBO.getIsDelete())) {
                FreightRelationalPO freightRelationalPO = new FreightRelationalPO();
                freightRelationalPO.setId(relationalBO.getId());
                this.freightRelationalMapper.delete(freightRelationalPO);
                FreightAreaAttrPO areaAttrPO = new FreightAreaAttrPO();
                areaAttrPO.setFreId(freightRelationalPO.getId());
                this.freightAreaAttrMapper.delete(areaAttrPO);
                FreightTemplateLadderPO ladderPO = new FreightTemplateLadderPO();
                ladderPO.setFreId(freightRelationalPO.getId());
                this.freightTemplateLadderMapper.delete(ladderPO);
                FreightExtAttrPO extAttrPO = new FreightExtAttrPO();
                extAttrPO.setFreId(freightRelationalPO.getId());
                this.freightExtAttrMapper.delete(extAttrPO);
                continue;
            }
            this.updateArea(relationalBO, reqBO);
        }
        return rspBO;
    }

    private void updateArea(FreightRelationalBO relationalBO, FcmUpdateFreightTemplateReqBO reqBO) {
        if (!CollectionUtils.isEmpty((Collection)relationalBO.getFreightAreaAttr())) {
            for (FreightAreaAttrBO areaAttrBO : relationalBO.getFreightAreaAttr()) {
                FreightAreaAttrPO areaAttrPO;
                if (FcmConstant.DELETE.equals(areaAttrBO.getIsDelete())) {
                    areaAttrPO = new FreightAreaAttrPO();
                    areaAttrPO.setId(areaAttrBO.getId());
                    this.freightAreaAttrMapper.delete(areaAttrPO);
                    continue;
                }
                if (areaAttrBO.getId() == null) {
                    areaAttrPO = new FreightAreaAttrPO();
                    BeanUtils.copyProperties((Object)areaAttrBO, (Object)areaAttrPO);
                    areaAttrPO.setId(this.idUtil.nextId());
                    areaAttrPO.setFreId(relationalBO.getId());
                    areaAttrPO.setTemplateId(relationalBO.getTemplateId());
                    this.freightAreaAttrMapper.insert(areaAttrPO);
                    continue;
                }
                areaAttrPO = new FreightAreaAttrPO();
                BeanUtils.copyProperties((Object)areaAttrBO, (Object)areaAttrPO);
                this.freightAreaAttrMapper.update(areaAttrPO);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)relationalBO.getFreightTemplateLadder())) {
            for (FreightTemplateLadderBO ladderBO : relationalBO.getFreightTemplateLadder()) {
                FreightTemplateLadderPO ladderPO;
                if (FcmConstant.DELETE.equals(ladderBO.getIsDelete())) {
                    ladderPO = new FreightTemplateLadderPO();
                    ladderPO.setId(ladderBO.getId());
                    ladderPO.setFreId(relationalBO.getId());
                    this.freightTemplateLadderMapper.delete(ladderPO);
                    continue;
                }
                if (ladderBO.getId() == null) {
                    ladderPO = new FreightTemplateLadderPO();
                    BeanUtils.copyProperties((Object)ladderBO, (Object)ladderPO);
                    ladderPO.setFreId(relationalBO.getId());
                    ladderPO.setTemplateId(relationalBO.getTemplateId());
                    ladderPO.setId(this.idUtil.nextId());
                    this.freightTemplateLadderMapper.insert(ladderPO);
                    continue;
                }
                ladderPO = new FreightTemplateLadderPO();
                BeanUtils.copyProperties((Object)ladderBO, (Object)ladderPO);
                this.freightTemplateLadderMapper.update(ladderPO);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)relationalBO.getFreightExtAttr())) {
            for (FreightExtAttrBO extAttr : relationalBO.getFreightExtAttr()) {
                FreightExtAttrPO extAttrPO;
                if (FcmConstant.DELETE.equals(extAttr.getIsDelete())) {
                    extAttrPO = new FreightExtAttrPO();
                    extAttrPO.setId(extAttr.getId());
                    extAttrPO.setFreId(relationalBO.getId());
                    this.freightExtAttrMapper.delete(extAttrPO);
                    continue;
                }
                if (extAttr.getId() == null) {
                    extAttrPO = new FreightExtAttrPO();
                    BeanUtils.copyProperties((Object)extAttr, (Object)extAttrPO);
                    extAttrPO.setFreId(relationalBO.getId());
                    extAttrPO.setTemplateId(relationalBO.getTemplateId());
                    extAttrPO.setId(this.idUtil.nextId());
                    this.freightExtAttrMapper.update(extAttrPO);
                    continue;
                }
                extAttrPO = new FreightExtAttrPO();
                BeanUtils.copyProperties((Object)extAttr, (Object)extAttrPO);
                this.freightExtAttrMapper.update(extAttrPO);
            }
        }
    }

    private void saveArea(FreightRelationalBO relationalBO, FcmUpdateFreightTemplateReqBO reqBO) {
        FreightRelationalPO freightRelationalPO = new FreightRelationalPO();
        freightRelationalPO.setId(this.idUtil.nextId());
        freightRelationalPO.setUpdateTime(new Date());
        freightRelationalPO.setCreateTime(new Date());
        freightRelationalPO.setTemplateId(reqBO.getTemplateId());
        this.freightRelationalMapper.insert(freightRelationalPO);
        ArrayList<FreightAreaAttrPO> areaAttrPOS = new ArrayList<FreightAreaAttrPO>();
        ArrayList<FreightExtAttrPO> extAttrPOS = new ArrayList<FreightExtAttrPO>();
        ArrayList<FreightTemplateLadderPO> ladderPOS = new ArrayList<FreightTemplateLadderPO>();
        for (FreightAreaAttrBO areaAttrBO : relationalBO.getFreightAreaAttr()) {
            FreightAreaAttrPO attrPO = new FreightAreaAttrPO();
            BeanUtils.copyProperties((Object)areaAttrBO, (Object)attrPO);
            attrPO.setTemplateId(reqBO.getTemplateId());
            attrPO.setId(this.idUtil.nextId());
            attrPO.setFreId(freightRelationalPO.getId());
            areaAttrPOS.add(attrPO);
        }
        if (!CollectionUtils.isEmpty((Collection)relationalBO.getFreightExtAttr())) {
            for (FreightExtAttrBO extAttrBO : relationalBO.getFreightExtAttr()) {
                FreightExtAttrPO extAttrPO = new FreightExtAttrPO();
                BeanUtils.copyProperties((Object)extAttrBO, (Object)extAttrPO);
                extAttrPO.setId(this.idUtil.nextId());
                extAttrPO.setCreateTime(new Date());
                extAttrPO.setFreId(freightRelationalPO.getId());
                extAttrPO.setTemplateId(reqBO.getTemplateId());
                extAttrPO.setUpdateTime(new Date());
                if (extAttrPO.getMatchLevel() == null) {
                    extAttrPO.setMatchLevel(0);
                }
                extAttrPOS.add(extAttrPO);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)relationalBO.getFreightTemplateLadder())) {
            for (FreightTemplateLadderBO ladderBO : relationalBO.getFreightTemplateLadder()) {
                FreightTemplateLadderPO ladderPO = new FreightTemplateLadderPO();
                BeanUtils.copyProperties((Object)ladderBO, (Object)ladderPO);
                ladderPO.setFreId(freightRelationalPO.getId());
                ladderPO.setTemplateId(reqBO.getTemplateId());
                ladderPO.setId(this.idUtil.nextId());
                if (ladderPO.getMatchLevel() == null) {
                    ladderPO.setMatchLevel(0);
                }
                ladderPO.setCreateTime(new Date());
                ladderPO.setUpdateTime(new Date());
                ladderPOS.add(ladderPO);
            }
        }
        this.freightAreaAttrMapper.insertBatch(areaAttrPOS);
        if (!CollectionUtils.isEmpty(extAttrPOS)) {
            this.freightExtAttrMapper.insertBatch(extAttrPOS);
        }
        if (!CollectionUtils.isEmpty(ladderPOS)) {
            this.freightTemplateLadderMapper.insertBatch(ladderPOS);
        }
    }
}

