/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.atom;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.SequenceNoService;
import com.tydic.fsc.settle.enums.BillType;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.stereotype.Service;

@Service(value="payBillSNService")
public class BillSNService {
    private SequenceNoService invoiceNotificationSeq;
    private SequenceNoService payableSeq;
    private SequenceNoService recvableSeq;
    private SequenceNoService payApplicationSeq;
    private SequenceNoService purchaseStorageSeq;
    private SequenceNoService materialSeq;
    private SequenceNoService invoiceApplicationSeq;
    private SequenceNoService stockOutSeq;
    private SequenceNoService orderIdSeq;
    private SequenceNoService publicSeqNoService;
    private SequenceNoService publicSeqNoService2;

    public String getSnAsString(BillType billType) {
        Long sn = this.getSn(billType);
        if (billType != null) {
            if (billType == BillType.SERVICE_REQ_LOG) {
                return String.valueOf(sn);
            }
            return billType.getCode() + sn;
        }
        return "";
    }

    public Long getSn(BillType billType) {
        if (billType == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5355\u636e\u7c7b\u578b\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        long seqNo = 0L;
        SequenceNoService service = null;
        if (billType == BillType.SERVICE_REQ_LOG) {
            service = this.publicSeqNoService;
            seqNo = this.dateToLong() * 10000000000L + service.generateSeqNo();
        } else {
            if (billType == BillType.INVOICE_NOTIFYCATION) {
                service = this.invoiceNotificationSeq;
            } else if (billType == BillType.PAYABLE_ACCOUNT) {
                service = this.payableSeq;
            } else if (billType == BillType.RECVABLE_ACCOUNT) {
                service = this.recvableSeq;
            } else if (billType == BillType.PAY_APPLICATION) {
                service = this.payApplicationSeq;
            } else if (billType == BillType.PURCHASE_STORAGE) {
                service = this.purchaseStorageSeq;
            } else if (billType == BillType.MATERIAL_COLLECT) {
                service = this.materialSeq;
            } else if (billType == BillType.INVOICE_APPLICATION) {
                service = this.invoiceApplicationSeq;
            } else if (billType == BillType.STOCK_OUT) {
                service = this.stockOutSeq;
            } else if (billType == BillType.ORDER_ID) {
                service = this.orderIdSeq;
            } else if (billType == BillType.INCOME_CALC) {
                service = this.publicSeqNoService2;
            } else if (billType == BillType.INVOICE_RETURN) {
                service = this.publicSeqNoService2;
            }
            seqNo = this.dateToLong() * 1000000L + service.generateSeqNo();
        }
        return seqNo;
    }

    private long dateToLong() {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
        String dt = fmt.format(new Date());
        return Long.valueOf(dt);
    }
}

