/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.atom;

import com.tydic.fsc.settle.atom.bo.CacheInfo;
import com.tydic.fsc.settle.enums.BaseEnums;
import com.tydic.fsc.settle.enums.OrderSource;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="enumsService")
public class EnumsService {
    private static final Logger logger = LoggerFactory.getLogger(EnumsService.class);
    private Map<String, CacheInfo> descrCaches = new HashMap<String, CacheInfo>();

    public int queryTaxOrgQueryPageSize() {
        int taxOrgQueryPageSize = 50;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            try {
                taxOrgQueryPageSize = Integer.valueOf(payCenterSystemConfig.get("TAX_ORG_QUERY_PAGE_SIZE"));
            }
            catch (Exception e) {
                logger.error("\u8bfb\u53d6\u5b57\u5178\u503c\u51fa\u9519", (Throwable)e);
            }
        }
        return taxOrgQueryPageSize;
    }

    public String querySupplierPaySaleContactNo() {
        String supplierPaySaleContactNo = null;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            supplierPaySaleContactNo = payCenterSystemConfig.get("SUPPLIER_PAY_SALE_CONTACT_NO");
        }
        if (!StringUtils.hasText(supplierPaySaleContactNo)) {
            supplierPaySaleContactNo = "xbjfwf";
        }
        return supplierPaySaleContactNo;
    }

    public String querySaleContactNo4ConsultPrice() {
        String saleContactNo = null;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            saleContactNo = payCenterSystemConfig.get("SALE_CONTACT_NO_4_CONSULT_PRICE");
        }
        if (!StringUtils.hasText(saleContactNo)) {
            saleContactNo = "xbjht-pszy";
        }
        return saleContactNo;
    }

    public Long querySupplierPayIncomeCalcUserId(Long operUnitNo) {
        Long userId = null;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            String code = "INCOME_CALC_USERID_";
            if (operUnitNo != null && operUnitNo > 0L) {
                code = code + operUnitNo;
            }
            try {
                userId = Long.valueOf(payCenterSystemConfig.get(code));
            }
            catch (Exception e) {
                logger.error("\u8bfb\u53d6\u5b57\u5178\u503c\u51fa\u9519", (Throwable)e);
            }
        }
        if (userId == null) {
            userId = 1L;
        }
        return userId;
    }

    public String queryObtainCheckingFileSwitch() {
        String obtainCheckingFileSwitch = null;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            obtainCheckingFileSwitch = payCenterSystemConfig.get("OBTAIN_CHECKING_FILE_SWITCH");
        }
        if (!StringUtils.hasText(obtainCheckingFileSwitch)) {
            obtainCheckingFileSwitch = "1";
        }
        return obtainCheckingFileSwitch;
    }

    public String queryObtainCheckingFileSavePath() {
        String path = null;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            path = payCenterSystemConfig.get("OBTAIN_CHECKING_FILE_SAVE_PATH");
        }
        if (!StringUtils.hasText(path)) {
            path = "/opt/tecent";
        }
        return path;
    }

    public Integer queryObtainCheckingFileSaveDays() {
        Integer days = null;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            try {
                days = Integer.valueOf(payCenterSystemConfig.get("OBTAIN_CHECKING_FILE_SAVE_DAYS"));
            }
            catch (Exception e) {
                logger.error("\u8bfb\u53d6\u5b57\u5178\u503c\u51fa\u9519", (Throwable)e);
            }
        }
        if (days == null || days < 0) {
            days = 30;
        }
        return days;
    }

    private Map<String, String> queryPayCenterSystemConfig() {
        return null;
    }

    public String getDescr(BaseEnums dictEnums) {
        return null;
    }

    private CacheInfo getMapInCache(String grpName) {
        CacheInfo inf = this.descrCaches.get(grpName);
        if (inf != null && inf.isExpired()) {
            inf = null;
        }
        return inf;
    }

    private CacheInfo putMapToCache(String grpName, Map<String, String> descrMap) {
        if (grpName == null) {
            return null;
        }
        CacheInfo inf = new CacheInfo(descrMap, 120);
        this.descrCaches.put(grpName, inf);
        return inf;
    }

    public String queryLikeSupplierPayTransferAcctName() {
        String transferAcctName = "";
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            try {
                transferAcctName = payCenterSystemConfig.get("SUPPLIER_PAY_TRANSFER_ACCT_NAME");
            }
            catch (Exception e) {
                logger.error("\u8bfb\u53d6\u5b57\u5178\u503c\u51fa\u9519", (Throwable)e);
            }
        }
        return transferAcctName;
    }

    public Boolean splitBySupplierInvoiceLimit() {
        Boolean isSplit = false;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            try {
                String result = payCenterSystemConfig.get("SPLIT_BY_SUPPLIER_INVOICE_LIMIT");
                if ("1".equals(result)) {
                    isSplit = true;
                }
            }
            catch (Exception e) {
                logger.error("\u8bfb\u53d6\u5b57\u5178\u503c\u51fa\u9519", (Throwable)e);
            }
        }
        return isSplit;
    }

    public BigDecimal queryDefaultTaxRate() {
        BigDecimal taxRate = new BigDecimal("0.16");
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            try {
                taxRate = new BigDecimal(payCenterSystemConfig.get("DEFAULT_TAX_RATE"));
            }
            catch (Exception e) {
                logger.error("\u8bfb\u53d6\u5b57\u5178\u503c\u51fa\u9519", (Throwable)e);
            }
        }
        return taxRate;
    }

    public BigDecimal queryDefaultServiceFeeTaxRate() {
        BigDecimal taxRate = new BigDecimal("0.06");
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            try {
                taxRate = new BigDecimal(payCenterSystemConfig.get("DEFAULT_SERVICE_FEE_TAX_RATE"));
            }
            catch (Exception e) {
                logger.error("\u8bfb\u53d6\u5b57\u5178\u503c\u51fa\u9519", (Throwable)e);
            }
        }
        return taxRate;
    }

    public int queryOstGroupByOsdLimit() {
        int limit = 400;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            String result = payCenterSystemConfig.get("OST_GROUP_BY_OSD_LIMIT");
            try {
                if (result != null) {
                    limit = Integer.valueOf(result);
                }
            }
            catch (Exception e) {
                logger.error("\u8bfb\u53d6\u5b57\u5178\u503c\u51fa\u9519", (Throwable)e);
            }
        }
        return limit;
    }

    public String queryEmApplyIsolateOrderSwitch() {
        String emApplyIsolateOrderSwitch = null;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            emApplyIsolateOrderSwitch = payCenterSystemConfig.get("EM_APPLY_ISOLATE_ORDER_SWITCH");
        }
        if (!StringUtils.hasText(emApplyIsolateOrderSwitch)) {
            emApplyIsolateOrderSwitch = "1";
        }
        return emApplyIsolateOrderSwitch;
    }

    public String queryPlatUseFeeMaterialName() {
        String materialName = null;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            materialName = payCenterSystemConfig.get("PLAT_USE_FEE_MATERIAL_NAME");
        }
        if (!StringUtils.hasText(materialName)) {
            materialName = "\u5e73\u53f0\u4f7f\u7528\u670d\u52a1\u8d39";
        }
        return materialName;
    }

    public String queryPlatUseFeeTaxClassCode() {
        String taxClassCode = null;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            taxClassCode = payCenterSystemConfig.get("PLAT_USE_FEE_TAX_CLASS_CODE");
        }
        if (!StringUtils.hasText(taxClassCode)) {
            taxClassCode = "3040205";
        }
        return taxClassCode;
    }

    public String queryTradeServiceFeeMaterialName() {
        String materialName = null;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            materialName = payCenterSystemConfig.get("TRADE_SERVICE_FEE_MATERIAL_NAME");
        }
        if (!StringUtils.hasText(materialName)) {
            materialName = "\u670d\u52a1\u8d39";
        }
        return materialName;
    }

    public String queryTradeServiceFeeTaxClassCode() {
        String taxClassCode = null;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            taxClassCode = payCenterSystemConfig.get("TRADE_SERVICE_FEE_TAX_CLASS_CODE");
        }
        if (!StringUtils.hasText(taxClassCode)) {
            taxClassCode = "30499";
        }
        return taxClassCode;
    }

    public String queryAddAdvanceReceiveSwitch() {
        String addAdvanceReceiveSwitch = null;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            addAdvanceReceiveSwitch = payCenterSystemConfig.get("ADD_ADVANCE_RECEIVE_SWITCH");
        }
        if (!StringUtils.hasText(addAdvanceReceiveSwitch)) {
            addAdvanceReceiveSwitch = "0";
        }
        return addAdvanceReceiveSwitch;
    }

    public String queryReceiptMustSwitch() {
        String receiptMustSwitch = null;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            receiptMustSwitch = payCenterSystemConfig.get("RECEIPT_MUST_SWITCH");
        }
        if (!StringUtils.hasText(receiptMustSwitch)) {
            receiptMustSwitch = "1";
        }
        return receiptMustSwitch;
    }

    public String queryShowOrderCodeSwitch() {
        String showOrderCodeSwitch = null;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            showOrderCodeSwitch = payCenterSystemConfig.get("SHOW_ORDER_CODE_SWITCH");
        }
        if (!StringUtils.hasText(showOrderCodeSwitch)) {
            showOrderCodeSwitch = "1";
        }
        return showOrderCodeSwitch;
    }

    public String queryElectronicInvoiceKpr() {
        String kpr = "";
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            kpr = payCenterSystemConfig.get("ELECTRONIC_INVOICE_KPR");
        }
        return kpr;
    }

    public String queryElectronicInvoiceSkr() {
        String skr = "";
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            skr = payCenterSystemConfig.get("ELECTRONIC_INVOICE_SKR");
        }
        return skr;
    }

    public String queryElectronicInvoiceFhr() {
        String fhr = "";
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            fhr = payCenterSystemConfig.get("ELECTRONIC_INVOICE_FHR");
        }
        return fhr;
    }

    public String queryReceiveInvoiceEmail() {
        String receiveInvoiceEmail = "";
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            receiveInvoiceEmail = payCenterSystemConfig.get("RECEIVE_INVOICE_EMAIL");
        }
        return receiveInvoiceEmail;
    }

    public String queryOpenSwitch(Long supplierId) {
        String openSwitch = "1";
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            openSwitch = payCenterSystemConfig.get("OPEN_SWITCH_" + supplierId);
        }
        return openSwitch;
    }

    public String queryReceiveInvoicePhone() {
        String receiveInvoicePhone = "";
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            receiveInvoicePhone = payCenterSystemConfig.get("RECEIVE_INVOICE_PHONE");
        }
        return receiveInvoicePhone;
    }

    public String queryElectronicInvoiceTestSwitch() {
        String electronicInvoiceTestSwitch = "";
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            electronicInvoiceTestSwitch = payCenterSystemConfig.get("ELECTRONIC_INVOICE_TEST_SWITCH");
        }
        return electronicInvoiceTestSwitch;
    }

    public String queryInvoiceReturnTemplate1() {
        String filename = "";
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            filename = payCenterSystemConfig.get("INVOICE_RETURN_TEMPLATE1");
        }
        return filename;
    }

    public String queryInvoiceReturnTemplate2() {
        String filename = "";
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            filename = payCenterSystemConfig.get("INVOICE_RETURN_TEMPLATE2");
        }
        return filename;
    }

    public int queryMaxSleepTime() {
        int maxSleepTime = 60;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            try {
                maxSleepTime = Integer.valueOf(payCenterSystemConfig.get("MAX_SLEEP_TIME"));
            }
            catch (Exception e) {
                logger.error("\u8bfb\u53d6\u5b57\u5178\u503c\u51fa\u9519", (Throwable)e);
            }
        }
        return maxSleepTime;
    }

    public int queryMaxThreadSize() {
        int maxThreadSize = 20;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            try {
                maxThreadSize = Integer.valueOf(payCenterSystemConfig.get("MAX_THREAD_SIZE"));
            }
            catch (Exception e) {
                logger.error("\u8bfb\u53d6\u5b57\u5178\u503c\u51fa\u9519", (Throwable)e);
            }
        }
        return maxThreadSize;
    }

    public int queryIsSendSms() {
        int isSendSms = 1;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            try {
                isSendSms = Integer.valueOf(payCenterSystemConfig.get("IS_SEND_SMS"));
            }
            catch (Exception e) {
                logger.error("\u8bfb\u53d6\u5b57\u5178\u503c\u51fa\u9519", (Throwable)e);
            }
        }
        return isSendSms;
    }

    public String queryDzcsInvoiceReturnNoticeItem() {
        String noticeItem = "";
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            noticeItem = payCenterSystemConfig.get("DZCS_INVOICE_RETURN_NOTICE_ITEM");
        }
        return noticeItem;
    }

    public Map<String, String> queryYuanGuangBillTypeConfig() {
        return null;
    }

    public String querFileTransmitYuanGuangSwitch(String source) {
        String fileSwitch = "1";
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            fileSwitch = OrderSource.ELECTRIC_MARKET.getCode().equals(source) ? payCenterSystemConfig.get("FILE_TRANSMIT_YUANGUANG_SWITCH_2") : payCenterSystemConfig.get("FILE_TRANSMIT_YUANGUANG_SWITCH_1");
        }
        return fileSwitch;
    }

    public double querAttachmentTransmitYuanGuangMaxSize() {
        double maxSize = 5.0;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            String maxSizeStr = payCenterSystemConfig.get("FILE_TRANSMIT_YUANGUANG_MAX_SIZE");
            try {
                maxSize = Double.parseDouble(maxSizeStr);
                logger.debug("\u6587\u4ef6\u4f20\u8f93\u8fdc\u5149\u8d22\u52a1\u7cfb\u7edf\u9650\u5b9a\u603b\u5927\u5c0f\u4e3a" + maxSizeStr + "MB");
            }
            catch (Exception e) {
                logger.error("\u67e5\u8be2\u6587\u4ef6\u9650\u5b9a\u5927\u5c0f\u5931\u8d25:" + e.getMessage());
            }
        }
        return maxSize;
    }

    public Map<String, Object> querHolytaxConfigInfo() {
        int tryCount = 30;
        int waitSecond = 2;
        double fileSizeCompareVal = 1000.0;
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        HashMap<String, Object> configInfoMap = new HashMap<String, Object>();
        if (payCenterSystemConfig != null) {
            String tryCountStr = payCenterSystemConfig.get("HOLY_TAX_TRY_COUNT");
            String waitSecondStr = payCenterSystemConfig.get("HOLY_TAX_WAIT_SECOND");
            String compareValStr = payCenterSystemConfig.get("HOLY_TAX_FILE_SIZE_COMPARE_VAL");
            try {
                tryCount = Integer.parseInt(tryCountStr);
                waitSecond = Integer.parseInt(waitSecondStr);
                fileSizeCompareVal = Double.parseDouble(compareValStr);
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u5408\u529b\u4e2d\u7a0e\u914d\u7f6e\u4fe1\u606f\u5931\u8d25:" + e.getMessage());
            }
        }
        configInfoMap.put("tryCount", tryCount);
        configInfoMap.put("waitSecond", waitSecond);
        configInfoMap.put("fileSizeCompareVal", fileSizeCompareVal);
        return configInfoMap;
    }

    public BigDecimal queryUnionPayAmountLimit() {
        BigDecimal limit = new BigDecimal("300000");
        Map<String, String> payCenterSystemConfig = this.queryPayCenterSystemConfig();
        if (payCenterSystemConfig != null) {
            try {
                limit = new BigDecimal(payCenterSystemConfig.get("UNION_PAY_AMOUNT_LIMIT"));
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u5b57\u5178\u5931\u8d25", (Throwable)e);
            }
        }
        return limit;
    }
}

