/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.MainAccountService;
import com.tydic.fsc.settle.atom.SubAccountService;
import com.tydic.fsc.settle.busi.api.BusiAcctCheckingListService;
import com.tydic.fsc.settle.busi.api.bo.BusiAccountCheckingReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiAccountCheckingRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiAcctCheckingListRspBO;
import com.tydic.fsc.settle.dao.AcctCheckingResultMapper;
import com.tydic.fsc.settle.dao.bo.AcctCheckingResultExt;
import com.tydic.fsc.settle.dao.po.AcctCheckingResult;
import com.tydic.fsc.settle.dao.po.MainAcctInfo;
import com.tydic.fsc.settle.dao.po.Pagination;
import com.tydic.fsc.settle.enums.OrderSource;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiAcctCheckingListServiceImpl
implements BusiAcctCheckingListService {
    private static final Logger logger = LoggerFactory.getLogger(BusiAcctCheckingListServiceImpl.class);
    @Autowired
    private AcctCheckingResultMapper mapper;
    @Autowired(required=false)
    private MainAccountService mainAccountService;
    @Autowired
    private SubAccountService subAccountService;

    public BusiAcctCheckingListRspBO listResult(BusiAccountCheckingReqBO busiAccountCheckingReqBO) {
        logger.info("\u67e5\u8be2\u5bf9\u8d26\u7ed3\u679creqBO=" + busiAccountCheckingReqBO);
        Pagination pageInfo = new Pagination();
        pageInfo.setPage(busiAccountCheckingReqBO.getPageNo());
        pageInfo.setPageSize(busiAccountCheckingReqBO.getPageSize());
        Integer dataType = busiAccountCheckingReqBO.getDataType();
        String actType = busiAccountCheckingReqBO.getActType();
        Date acDate = busiAccountCheckingReqBO.getAcDate();
        Date endAcDate = busiAccountCheckingReqBO.getEndAcDate();
        if (dataType == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8bf7\u6307\u5b9a\u9700\u8981\u67e5\u8be2\u7684\u6570\u636e\u7c7b\u578b(dataType),1=\u7d22\u5f15,2=\u660e\u7ec6");
        }
        if (dataType == 2) {
            if (acDate == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u660e\u7ec6\u9700\u8981\u63d0\u4f9b\u5bf9\u8d26\u65e5\u671f(acDate)");
            }
            endAcDate = acDate;
        }
        AcctCheckingResultExt record = new AcctCheckingResultExt();
        record.setResultType(busiAccountCheckingReqBO.getDataType());
        record.setCheckDate(acDate);
        record.setEndCheckDate(endAcDate);
        if ("1".equals(actType)) {
            record.setDataCount(0L);
        }
        int tot = this.mapper.selectForCount(record);
        logger.info("\u67e5\u8be2\u5bf9\u8d26\u7ed3\u679c\u8bb0\u5f55\u6570:" + tot);
        pageInfo.setTotalCount(tot);
        int rowIndex = pageInfo.getRowIndex();
        record.setPageSize(pageInfo.getPageSize());
        record.setRowIndex(rowIndex);
        List<AcctCheckingResult> rows = this.mapper.queryPage(record);
        BusiAcctCheckingListRspBO resp = new BusiAcctCheckingListRspBO();
        HashMap<String, MainAcctInfo> history = new HashMap<String, MainAcctInfo>();
        ArrayList<BusiAccountCheckingRspBO> outData = new ArrayList<BusiAccountCheckingRspBO>();
        for (AcctCheckingResult result : rows) {
            String subAcctNo;
            String[] inf;
            BusiAccountCheckingRspBO rspBo = new BusiAccountCheckingRspBO();
            outData.add(rspBo);
            BeanUtils.copyProperties((Object)result, (Object)rspBo);
            rspBo.setDrcr(result.getDrCr());
            rspBo.setPostDate(result.getCheckDate());
            rspBo.setResultText(result.getRemark());
            if (dataType != 2) continue;
            String mainAcctNo = result.getMainAcctNo();
            MainAcctInfo main = (MainAcctInfo)history.get(mainAcctNo);
            if (main == null && (main = this.getMainAcct(mainAcctNo)) != null) {
                history.put(mainAcctNo, main);
            }
            rspBo.setMainAcctNo(mainAcctNo);
            if (main != null) {
                rspBo.setMainAcctName(main.getMainAcctName());
                rspBo.setMainOrgNo("" + main.getOrgId());
                rspBo.setSource(main.getSource());
                OrderSource src = OrderSource.getInstance((String)main.getSource());
                rspBo.setSourceDescr(src.getDescr());
            }
            if ((inf = (subAcctNo = result.getSubAcctNo()).split("/")).length <= 1) continue;
            rspBo.setPayAcctNo(inf[0]);
            rspBo.setPayAcctName(this.subAccountService.getAcctName(rspBo.getPayAcctNo()));
            rspBo.setRecvAcctNo(inf[1]);
            rspBo.setRecvAcctName(this.subAccountService.getAcctName(rspBo.getRecvAcctNo()));
        }
        resp.setTotal(pageInfo.getPageCount().intValue());
        resp.setRecordsTotal(pageInfo.getTotalCount().intValue());
        resp.setRows(outData);
        resp.setPageNo(pageInfo.getPage().intValue());
        return resp;
    }

    private MainAcctInfo getMainAcct(String mainAcctNo) {
        MainAcctInfo param = new MainAcctInfo();
        param.setMainAcctNo(mainAcctNo);
        List<MainAcctInfo> ls = this.mainAccountService.listAccount(param);
        if (ls.size() == 0) {
            return null;
        }
        return ls.get(0);
    }
}

