/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.AccountAtomService;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.MainAccountService;
import com.tydic.fsc.settle.atom.SubAccountService;
import com.tydic.fsc.settle.busi.api.BusiAddMainAcctService;
import com.tydic.fsc.settle.busi.api.bo.BusiAddMainAcctReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiAddMainAcctRspBO;
import com.tydic.fsc.settle.dao.po.MainAcctInfo;
import com.tydic.fsc.settle.dao.po.SubAcctInfo;
import com.tydic.fsc.settle.enums.BaseEnums;
import com.tydic.fsc.settle.enums.CompanyType;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.SubAccountServiceType;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiAddMainAcctServiceImpl
implements BusiAddMainAcctService {
    private static final Logger logger = LoggerFactory.getLogger(BusiAddMainAcctServiceImpl.class);
    @Autowired
    private MainAccountService mainAccountService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private SubAccountService subAcctService;
    @Autowired
    private AccountAtomService accountAtomService;

    public BusiAddMainAcctRspBO addMainAcct(BusiAddMainAcctReqBO busiAddMainAcctReqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u65b0\u6dfb\u4e3b\u8d26\u53f7\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + busiAddMainAcctReqBO.toString());
        }
        if (null == busiAddMainAcctReqBO.getSource() || !StringUtils.hasText((String)busiAddMainAcctReqBO.getSource())) {
            throw new BusinessException("1001", "\u65b0\u6dfb\u4e3b\u8d26\u53f7\u4e1a\u52a1\u670d\u52a1-\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == busiAddMainAcctReqBO.getMainAcctNo() || !StringUtils.hasText((String)busiAddMainAcctReqBO.getMainAcctNo())) {
            throw new BusinessException("1001", "\u65b0\u6dfb\u4e3b\u8d26\u53f7\u4e1a\u52a1\u670d\u52a1-\u4e3b\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == busiAddMainAcctReqBO.getMainAcctName() || !StringUtils.hasText((String)busiAddMainAcctReqBO.getMainAcctName())) {
            throw new BusinessException("1001", "\u65b0\u6dfb\u4e3b\u8d26\u53f7\u4e1a\u52a1\u670d\u52a1-\u4e3b\u8d26\u53f7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == busiAddMainAcctReqBO.getOpenBank() || !StringUtils.hasText((String)busiAddMainAcctReqBO.getOpenBank())) {
            throw new BusinessException("1001", "\u65b0\u6dfb\u4e3b\u8d26\u53f7\u4e1a\u52a1\u670d\u52a1-\u5f00\u6237\u94f6\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == busiAddMainAcctReqBO.getCompanyId()) {
            throw new BusinessException("1001", "\u65b0\u6dfb\u4e3b\u8d26\u53f7\u4e1a\u52a1\u670d\u52a1-\u673a\u6784\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MainAcctInfo mainAcctInfo = new MainAcctInfo();
        mainAcctInfo.setSource(busiAddMainAcctReqBO.getSource());
        mainAcctInfo.setOrgId(busiAddMainAcctReqBO.getCompanyId());
        mainAcctInfo.setMainAcctNo(busiAddMainAcctReqBO.getMainAcctNo());
        mainAcctInfo.setMainAcctName(busiAddMainAcctReqBO.getMainAcctName());
        mainAcctInfo.setOpenBank(busiAddMainAcctReqBO.getOpenBank());
        MainAcctInfo returnMainAcc = this.mainAccountService.addAccount(mainAcctInfo);
        Integer srvType = SubAccountServiceType.BANK_BUSINESS.getCode();
        Long projectId = busiAddMainAcctReqBO.getPurchaserAccountUser();
        if (projectId == null) {
            logger.error("\u4e13\u4e1a\u516c\u53f8\u5efa\u7acb\u8d44\u91d1\u8d26\u53f7\u5931\u8d25,\u65e0\u6548\u7684\u8d26\u5957ID=" + projectId);
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8bf7\u6c42\u4e2d\u672a\u53d1\u73b0\u6709\u6548\u7684\u8d26\u5957ID");
        }
        Long acctOrgId = busiAddMainAcctReqBO.getCompanyId();
        Integer companyType = CompanyType.OTHER.getCode();
        String mainAcctNo = busiAddMainAcctReqBO.getMainAcctNo();
        BigDecimal overDraft = new BigDecimal("9999999999999");
        SubAcctInfo subAcct = new SubAcctInfo();
        subAcct.setLoginId(busiAddMainAcctReqBO.getUserId());
        subAcct.setCreateOrgId(busiAddMainAcctReqBO.getOrgId());
        subAcct.setMainAcctNo(mainAcctNo);
        subAcct.setOrgId(acctOrgId);
        String subAcctName = this.accountAtomService.obtainSubAccountName4Oper(mainAcctNo, srvType);
        subAcct.setSubAcctName(subAcctName);
        subAcct.setServiceType(srvType);
        subAcct.setProjectId(projectId);
        subAcct.setCompanyType(companyType);
        subAcct.setOverdraft(overDraft);
        subAcct = this.subAcctService.addSubAccount(subAcct);
        if (!"0000".equals(subAcct.getRespCode())) {
            throw new BusinessException("1002", subAcct.getRespDesc());
        }
        BusiAddMainAcctRspBO busiAddMainAcctRspBO = new BusiAddMainAcctRspBO();
        busiAddMainAcctRspBO.setCompanyId(returnMainAcc.getOrgId().longValue());
        busiAddMainAcctRspBO.setSource(returnMainAcc.getSource());
        busiAddMainAcctRspBO.setMainAcctName(returnMainAcc.getMainAcctName());
        busiAddMainAcctRspBO.setMainAcctNo(returnMainAcc.getMainAcctNo());
        busiAddMainAcctRspBO.setOpenBank(returnMainAcc.getOpenBank());
        busiAddMainAcctRspBO.setSourceDescr(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)returnMainAcc.getSource())));
        return busiAddMainAcctRspBO;
    }
}

