/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.atom.SubAccountService;
import com.tydic.fsc.settle.busi.api.BusiAddPreRecAmtConfirmService;
import com.tydic.fsc.settle.busi.api.bo.BusiAddPreHeadRecAmtConfirmRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiAddPreRecAmtConfirmReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiAddPreRecAmtConfirmRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiAddPreRowRecAmtConfirmRspBO;
import com.tydic.fsc.settle.busi.api.bo.SubAcctInfoExt;
import com.tydic.fsc.settle.dao.AdvanceReceiveMapper;
import com.tydic.fsc.settle.dao.RecAmtConfirmMapper;
import com.tydic.fsc.settle.dao.po.AdvanceReceive;
import com.tydic.fsc.settle.dao.po.RecAmtConfirm;
import com.tydic.fsc.settle.dao.vo.AdvanceReceiveVO;
import com.tydic.fsc.settle.enums.AdvanceReceiveStatus;
import com.tydic.fsc.settle.enums.BaseEnums;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.ReceiveType;
import com.tydic.fsc.settle.enums.SubAccountServiceType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiAddPreRecAmtConfirmServiceImpl
implements BusiAddPreRecAmtConfirmService {
    private static final Logger logger = LoggerFactory.getLogger(BusiAddPreRecAmtConfirmServiceImpl.class);
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private SubAccountService subAccountService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private AdvanceReceiveMapper advanceReceiveMapper;
    @Autowired
    private RecAmtConfirmMapper recAmtConfirmMapper;

    public BusiAddPreRecAmtConfirmRspBO addPreRecAmtConfirm(BusiAddPreRecAmtConfirmReqBO reqBO) {
        List seqList;
        if (logger.isDebugEnabled()) {
            logger.debug("\u9884\u751f\u6210\u6536\u6b3e\u5355\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if ((seqList = reqBO.getSeqList()) == null || seqList.isEmpty()) {
            throw new BusinessException("1001", "\u60a8\u6ca1\u6709\u52fe\u9009\u6536\u6b3e\u4fe1\u606f");
        }
        AdvanceReceiveVO adReVo = new AdvanceReceiveVO();
        adReVo.setSeqList(seqList);
        adReVo.setServiceTypeNotIn(Arrays.asList(SubAccountServiceType.DEFAULT.getCode()));
        int valCount = this.advanceReceiveMapper.selectCountBySeqList(adReVo);
        if (valCount > 0) {
            throw new BusinessException("1002", "\u975e\u91c7\u8d2d\u5355\u4f4d\u5b50\u8d26\u6237\u7684\u5230\u8d26\u6d41\u6c34\u4e0d\u80fd\u529e\u7406\u6b64\u4e1a\u52a1");
        }
        BusiAddPreRecAmtConfirmRspBO rspBO = new BusiAddPreRecAmtConfirmRspBO();
        AdvanceReceiveVO vo = new AdvanceReceiveVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)vo);
        vo.setStatus(AdvanceReceiveStatus.NO_CONFIRM.getCode());
        RecAmtConfirm recAmtConfirm = this.recAmtConfirmMapper.sumUpDetails(vo);
        BusiAddPreHeadRecAmtConfirmRspBO head = new BusiAddPreHeadRecAmtConfirmRspBO();
        BeanUtils.copyProperties((Object)recAmtConfirm, (Object)head);
        AdvanceReceive advanceReceive = this.advanceReceiveMapper.selectByPrimaryKey((Long)seqList.get(0));
        String orgName = this.organizationInfoService.queryOrgName(advanceReceive.getRecOrgId());
        head.setOrgName(orgName);
        rspBO.setHead(head);
        List<AdvanceReceive> rows = this.advanceReceiveMapper.selectByCondition(vo);
        ArrayList<BusiAddPreRowRecAmtConfirmRspBO> detailRows = new ArrayList<BusiAddPreRowRecAmtConfirmRspBO>();
        for (AdvanceReceive row : rows) {
            BusiAddPreRowRecAmtConfirmRspBO detail = new BusiAddPreRowRecAmtConfirmRspBO();
            BeanUtils.copyProperties((Object)row, (Object)detail);
            orgName = this.organizationInfoService.obtainOrgNameByAdvanceReceive(row);
            detail.setPayOrgName(orgName);
            orgName = this.organizationInfoService.queryOrgName(row.getRecOrgId());
            detail.setRecOrgName(orgName);
            detail.setRecTypeDescr(this.enumsService.getDescr(ReceiveType.getInstance(row.getRecType())));
            SubAcctInfoExt subAcctInfoExt = this.subAccountService.getWithMainAccount(row.getRecSubAcct());
            if (subAcctInfoExt != null) {
                detail.setSourceName(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)subAcctInfoExt.getSource())));
            }
            detailRows.add(detail);
        }
        rspBO.setRows(detailRows);
        return rspBO;
    }
}

