/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.bo.FscBaseRspBo;
import com.tydic.fsc.settle.busi.api.BusiAfterSaleProcessService;
import com.tydic.fsc.settle.busi.api.bo.BusiAfterSaleProcessReqBO;
import com.tydic.fsc.settle.dao.AfterSaleDetailMapper;
import com.tydic.fsc.settle.dao.AfterSaleMapper;
import com.tydic.fsc.settle.dao.BillNotificationInfoMapper;
import com.tydic.fsc.settle.dao.PayInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.PayItemInfoMapper;
import com.tydic.fsc.settle.dao.PayPurchaseOrderInfoMapper;
import com.tydic.fsc.settle.dao.SaleItemInfoMapper;
import com.tydic.fsc.settle.dao.SaleOrderInfoMapper;
import com.tydic.fsc.settle.dao.po.AfterSale;
import com.tydic.fsc.settle.dao.vo.AfterSaleVO;
import com.tydic.fsc.settle.enums.AfterSaleProcessStatus;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiAfterSaleProcessServiceImpl
implements BusiAfterSaleProcessService {
    private static final Logger logger = LoggerFactory.getLogger(BusiAfterSaleProcessServiceImpl.class);
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private AfterSaleMapper afterSaleMapper;
    @Autowired
    private AfterSaleDetailMapper afterSaleDetailMapper;
    @Autowired
    BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private EnumsService enumsService;

    public FscBaseRspBo process(BusiAfterSaleProcessReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u7535\u5b50\u8d85\u5e02\u552e\u540e\u6d88\u606f\u5904\u7406\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        Long inspectionId = reqBO.getInspectionId();
        AfterSaleVO afterSaleVO = new AfterSaleVO();
        afterSaleVO.setInspectionId(inspectionId);
        ArrayList<String> processStatusList = new ArrayList<String>();
        processStatusList.add(AfterSaleProcessStatus.NO_PROCESS.getCode());
        processStatusList.add(AfterSaleProcessStatus.PROCESS_FAILED.getCode());
        afterSaleVO.setProcessStatusList(processStatusList);
        afterSaleVO.setOrderBy(" INSPECTION_ID ASC,MESSAGE_TYPE ASC");
        List<AfterSale> afterSales = this.afterSaleMapper.selectList(afterSaleVO);
        for (AfterSale afterSale : afterSales) {
            try {
                this.processItem(afterSale);
            }
            catch (Exception e) {
                logger.error("\u5904\u7406\u552e\u540e\u6d88\u606f\u5931\u8d25", (Throwable)e);
            }
        }
        return new FscBaseRspBo();
    }

    private void processItem(AfterSale afterSale) {
    }

    private void saveProcessStatus(AfterSale afterSale, String processStatus, String processRemark) {
        AfterSaleVO afterSaleVO = new AfterSaleVO();
        afterSaleVO.setSeq(afterSale.getSeq());
        afterSaleVO.setProcessStatus(processStatus);
        processRemark = StringUtils.hasText((String)processRemark) && processRemark.length() > 500 ? processRemark.substring(0, 500) : processRemark;
        afterSaleVO.setProcessRemark(processRemark);
        afterSaleVO.setUpdateDate(new Date());
        this.afterSaleMapper.updateProcessStatus(afterSaleVO);
    }
}

