/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.bo.FscBaseRspBo;
import com.tydic.fsc.settle.busi.api.BusiCancelPushTaxSystemService;
import com.tydic.fsc.settle.busi.api.bo.BusiCancelPushTaxSystemReqBO;
import com.tydic.fsc.settle.dao.BillApplyInfoMapper;
import com.tydic.fsc.settle.dao.SaleInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.po.BillApplyInfo;
import com.tydic.fsc.settle.dao.vo.BillApplyInfoVO;
import com.tydic.fsc.settle.enums.BillStatus;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiCancelPushTaxSystemServiceImpl
implements BusiCancelPushTaxSystemService {
    private static final Logger logger = LoggerFactory.getLogger(BusiCancelPushTaxSystemServiceImpl.class);
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;

    public FscBaseRspBo update(BusiCancelPushTaxSystemReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u53d6\u6d88\u63a8\u9001\u7a0e\u63a7\u670d\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new BusinessException("1001", "\u5165\u53c2\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        }
        List applyNoList = reqBO.getApplyNoList();
        if (applyNoList == null || applyNoList.isEmpty()) {
            throw new BusinessException("1001", "\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
        billApplyInfoVO.setApplyNoList(applyNoList);
        List<BillApplyInfo> applys = this.billApplyInfoMapper.getList(billApplyInfoVO);
        for (BillApplyInfo apply : applys) {
            if (!BillStatus.APPLIED.getCode().equals(apply.getBillStatus()) && !BillStatus.SENDING_BILL.getCode().equals(apply.getBillStatus())) {
                throw new BusinessException("1002", "\u5f00\u7968\u72b6\u6001\u5fc5\u987b\u662f\u5df2\u53d7\u7406 \u3001\u5f00\u7968\u4e2d");
            }
            if (reqBO.getCompanyId().equals(apply.getOperUnitNo())) continue;
            throw new BusinessException("1002", "\u4e0d\u80fd\u529e\u7406\u5176\u4ed6\u516c\u53f8\u7684\u4e1a\u52a1");
        }
        int count = this.saleInvoiceInfoMapper.selectCountByApplyNos(applyNoList);
        if (count > 0) {
            throw new BusinessException("1002", "\u5df2\u5b58\u5728\u53d1\u7968\uff0c\u8bf7\u5148\u4f5c\u5e9f\u53d1\u7968");
        }
        billApplyInfoVO = new BillApplyInfoVO();
        billApplyInfoVO.setApplyNoList(applyNoList);
        BillApplyInfo billApplyInfo1 = new BillApplyInfo();
        billApplyInfo1.setBillStatus(BillStatus.NO_APPLY.getCode());
        this.billApplyInfoMapper.updateByCondition(billApplyInfoVO, billApplyInfo1);
        return new FscBaseRspBo();
    }
}

