/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.atom.UserInfoService;
import com.tydic.fsc.settle.busi.api.BusiExportBillApplyInvoiceService;
import com.tydic.fsc.settle.busi.api.bo.BusiBillApplyInvoiceInfoExRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryBillApplyInfoDlzqReqBO;
import com.tydic.fsc.settle.busi.api.vo.BusiQueryDetailBillApplyInfoInvoiceInfoVO;
import com.tydic.fsc.settle.dao.BillApplyInfoMapper;
import com.tydic.fsc.settle.dao.SaleInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.po.SaleInvoiceInfo;
import com.tydic.fsc.settle.dao.vo.BillApplyInfoVO;
import com.tydic.fsc.settle.dao.vo.SaleInvoiceInfoVO;
import com.tydic.fsc.settle.enums.BillStatus;
import com.tydic.fsc.settle.enums.InvoiceType;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.utils.DatesUtils;
import com.tydic.fsc.settle.utils.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiExportBillApplyInvoiceServiceImpl
implements BusiExportBillApplyInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(BusiExportBillApplyInvoiceServiceImpl.class);
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;

    public BusiBillApplyInvoiceInfoExRspBO execExport(BusiQueryBillApplyInfoDlzqReqBO billApplyInfoDlzqReqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5f00\u7968\u4fe1\u606fEXCEL\u5bfc\u51fa\u67e5\u8be2\u5165\u53c2\uff1a" + billApplyInfoDlzqReqBO.toString());
        }
        if (billApplyInfoDlzqReqBO.getApplyDateEnd() != null) {
            Date applyDateEnd = DatesUtils.obtainEndOfDay(billApplyInfoDlzqReqBO.getApplyDateEnd());
            billApplyInfoDlzqReqBO.setApplyDateEnd(applyDateEnd);
        }
        billApplyInfoDlzqReqBO.setSortName("a.APPLY_NO DESC");
        Page page = new Page(billApplyInfoDlzqReqBO.getPageNo(), billApplyInfoDlzqReqBO.getPageSize());
        List<BillApplyInfoVO> billApplyList = this.billApplyInfoMapper.getBillApplyInfoInvoiceList(billApplyInfoDlzqReqBO, (Page<Map<String, Object>>)page);
        ArrayList<BusiQueryDetailBillApplyInfoInvoiceInfoVO> resultList = new ArrayList<BusiQueryDetailBillApplyInfoInvoiceInfoVO>();
        for (BillApplyInfoVO billApplyInfoVO : billApplyList) {
            BusiQueryDetailBillApplyInfoInvoiceInfoVO billApplyInfoInvoiceInfo = new BusiQueryDetailBillApplyInfoInvoiceInfoVO();
            SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
            saleInvoiceInfoVO.setApplyNo(billApplyInfoVO.getApplyNo());
            Page page2 = new Page(1, 99999);
            List<SaleInvoiceInfo> saleInvoiceInfoList = this.saleInvoiceInfoMapper.selectListPage(saleInvoiceInfoVO, (Page<Map<String, Object>>)page2);
            if (saleInvoiceInfoList != null && saleInvoiceInfoList.size() > 0) {
                for (SaleInvoiceInfo saleInvoiceInfo : saleInvoiceInfoList) {
                    BusiQueryDetailBillApplyInfoInvoiceInfoVO billApplyInfoInvoiceInfo2 = new BusiQueryDetailBillApplyInfoInvoiceInfoVO();
                    BeanUtils.copyProperties((Object)billApplyInfoVO, (Object)billApplyInfoInvoiceInfo2);
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    billApplyInfoInvoiceInfo2.setApplyDateStr(sdf.format(billApplyInfoInvoiceInfo2.getApplyDate()));
                    sdf = new SimpleDateFormat("yyyy-MM-dd");
                    billApplyInfoInvoiceInfo2.setInvoiceDateStr(sdf.format(saleInvoiceInfo.getInvoiceDate()));
                    billApplyInfoInvoiceInfo2.setInvoiceNo(saleInvoiceInfo.getInvoiceNo());
                    billApplyInfoInvoiceInfo2.setInvoiceDate(saleInvoiceInfo.getInvoiceDate());
                    billApplyInfoInvoiceInfo2.setUntaxAmt(saleInvoiceInfo.getUntaxAmt());
                    billApplyInfoInvoiceInfo2.setTaxAmt(saleInvoiceInfo.getTaxAmt());
                    this.add(resultList, billApplyInfoVO, billApplyInfoInvoiceInfo2);
                }
                continue;
            }
            BeanUtils.copyProperties((Object)billApplyInfoVO, (Object)billApplyInfoInvoiceInfo);
            this.add(resultList, billApplyInfoVO, billApplyInfoInvoiceInfo);
        }
        BusiBillApplyInvoiceInfoExRspBO busiBillApplyInvoiceInfoExRspBO = new BusiBillApplyInvoiceInfoExRspBO();
        busiBillApplyInvoiceInfoExRspBO.setValList(resultList);
        logger.info("\u5f00\u7968\u4fe1\u606fEXCEL\u5bfc\u51fa\u51fa\u53c2:" + busiBillApplyInvoiceInfoExRspBO);
        return busiBillApplyInvoiceInfoExRspBO;
    }

    private void add(List<BusiQueryDetailBillApplyInfoInvoiceInfoVO> resultList, BillApplyInfoVO billApplyInfoVO, BusiQueryDetailBillApplyInfoInvoiceInfoVO billApplyInfoInvoiceInfo) {
        BillStatus instance;
        String invoiceTypeStr = billApplyInfoInvoiceInfo.getInvoiceType();
        Integer code = Integer.parseInt(invoiceTypeStr);
        billApplyInfoInvoiceInfo.setInvoiceType(this.enumsService.getDescr(InvoiceType.getInstance(code)));
        String userName = this.userInfoService.queryUserNameByUserId(billApplyInfoInvoiceInfo.getUserId());
        logger.info("\u6839\u636e\u7528\u6237ID(" + billApplyInfoInvoiceInfo.getUserId() + ")\u67e5\u8be2\u7528\u6237\u540d\u79f0userName:" + userName);
        billApplyInfoInvoiceInfo.setUserName(userName);
        billApplyInfoInvoiceInfo.setQuantity(null);
        String province = StringUtils.valueOf(billApplyInfoVO.getProvince());
        String city = StringUtils.valueOf(billApplyInfoVO.getCity());
        String county = StringUtils.valueOf(billApplyInfoVO.getCounty());
        String town = StringUtils.valueOf(billApplyInfoVO.getTown());
        String addrDesc = StringUtils.valueOf(billApplyInfoVO.getAddrDesc());
        String detailAddress = StringUtils.simplifyAddrdesc(province, city, county, town, addrDesc);
        billApplyInfoInvoiceInfo.setDetailAddress(detailAddress);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)billApplyInfoInvoiceInfo.getBillStatus())) {
            instance = BillStatus.getInstance(billApplyInfoInvoiceInfo.getBillStatus());
            billApplyInfoInvoiceInfo.setBillStatusStr(this.enumsService.getDescr(instance));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)billApplyInfoInvoiceInfo.getSource())) {
            instance = OrderSource.getInstance((String)billApplyInfoInvoiceInfo.getSource());
            billApplyInfoInvoiceInfo.setSourceStr(this.enumsService.getDescr(instance));
        }
        billApplyInfoInvoiceInfo.setPurchaseProjectName(this.organizationInfoService.queryProjectName(billApplyInfoInvoiceInfo.getPurchaseProjectId()));
        resultList.add(billApplyInfoInvoiceInfo);
    }
}

