/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.busi.api.BusiExportBillNotificationInfoService;
import com.tydic.fsc.settle.busi.api.bo.BusiQryNotificationListReqBO;
import com.tydic.fsc.settle.busi.api.vo.BusiExportBillNotificationInfoVO;
import com.tydic.fsc.settle.dao.BillNotificationInfoMapper;
import com.tydic.fsc.settle.dao.EntryInfoMapper;
import com.tydic.fsc.settle.dao.po.BillNotificationInfo;
import com.tydic.fsc.settle.dao.po.EntryInfoPO;
import com.tydic.fsc.settle.enums.NotificationInvoiceStatus;
import com.tydic.fsc.settle.utils.AntiSqlInjectionManage;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiExportBillNotificationInfoServiceImpl
implements BusiExportBillNotificationInfoService {
    private static final Logger logger = LoggerFactory.getLogger(BusiExportBillNotificationInfoServiceImpl.class);
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private EntryInfoMapper entryInfoMapper;

    public List<BusiExportBillNotificationInfoVO> qryNotifyList(BusiQryNotificationListReqBO reqBO) {
        logger.info("\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)reqBO);
        if (null == reqBO.getCompanyId()) {
            throw new BusinessException("1001", "\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u5217\u8868\u4e1a\u52a1\u670d\u52a1-Session\u4e13\u4e1a\u516c\u53f8[companyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSource()) {
            throw new BusinessException("1001", "\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u5217\u8868\u4e1a\u52a1\u670d\u52a1-\u6765\u6e90[source]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBO.setOperUnitNo(null);
        String orderBy = null;
        if (!StringUtils.isEmpty((CharSequence)reqBO.getSortName()) && !StringUtils.isEmpty((CharSequence)reqBO.getSortOrder())) {
            if (AntiSqlInjectionManage.sqlValidate(reqBO.getSortName()) || AntiSqlInjectionManage.sqlValidate(reqBO.getSortOrder())) {
                logger.error("\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
                throw new BusinessException("1002", "\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
            }
            orderBy = reqBO.getSortName() + " " + reqBO.getSortOrder();
        } else {
            orderBy = " APPLY_DATE desc,NOTIFICATION_NO desc";
        }
        Page page = new Page(1, 999999999);
        LinkedList<BusiExportBillNotificationInfoVO> result = new LinkedList<BusiExportBillNotificationInfoVO>();
        List<BillNotificationInfo> resultPO = this.billNotificationInfoMapper.getListPage(reqBO, true, (Page<Map<String, Object>>)page, orderBy);
        for (BillNotificationInfo notifyInfo : resultPO) {
            BusiExportBillNotificationInfoVO resultVO = new BusiExportBillNotificationInfoVO();
            resultVO.setNotificationNo(notifyInfo.getNotificationNo());
            resultVO.setInvoiceResult(notifyInfo.getInvoiceResult());
            resultVO.setMailDesc(notifyInfo.getMailDesc());
            resultVO.setAmt(notifyInfo.getAmt());
            resultVO.setApplyDate(notifyInfo.getApplyDate());
            NotificationInvoiceStatus notifInvoiceEnum = NotificationInvoiceStatus.getInstance(notifyInfo.getInvoiceStatus());
            resultVO.setNotifInvoiceStatusStr(this.enumsService.getDescr(notifInvoiceEnum));
            String supplierStr = this.organizationInfoService.querySupplierName(notifyInfo.getSupplierNo());
            resultVO.setSupplierName(supplierStr);
            if ("03".equals(notifyInfo.getInvoiceStatus())) {
                EntryInfoPO entryInfo = new EntryInfoPO();
                entryInfo.setNotificationNo(notifyInfo.getNotificationNo());
                entryInfo.setPurchaseId(notifyInfo.getSupplierNo());
                List<EntryInfoPO> list = null;
                try {
                    list = this.entryInfoMapper.getModelListBy(entryInfo);
                }
                catch (Exception e) {
                    logger.error("\u6570\u636e\u5e93\u51fa\u9519", (Throwable)e);
                    throw new BusinessException("1002", "\u7cfb\u7edf\u5f02\u5e38");
                }
                if (!list.isEmpty()) {
                    resultVO.setSignDate(list.get(0).getEntryDate());
                }
            }
            result.add(resultVO);
        }
        return result;
    }
}

