/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.atom.UserInfoService;
import com.tydic.fsc.settle.busi.api.BusiForConfirmQryPlatAndServiceFeeService;
import com.tydic.fsc.settle.busi.api.bo.BusiForConfirmQryPlatAndServiceFeeListReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiForConfirmQryPlatAndServiceFeeListRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiForConfirmQryPlatAndServiceFeeRspBO;
import com.tydic.fsc.settle.dao.InquiryPayOrderMapper;
import com.tydic.fsc.settle.dao.po.InquiryPayOrder;
import com.tydic.fsc.settle.dao.po.InquiryPayOrderExt;
import com.tydic.fsc.settle.enums.CompanyType;
import com.tydic.fsc.settle.enums.InquiryMailStatus;
import com.tydic.fsc.settle.enums.InquiryPayFeeType;
import com.tydic.fsc.settle.enums.InquiryPayPass;
import com.tydic.fsc.settle.enums.InquiryPaymentStatus;
import com.tydic.fsc.settle.enums.OrderStatus;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiForConfirmQryPlatAndServiceFeeServiceImpl
implements BusiForConfirmQryPlatAndServiceFeeService {
    private static final Logger logger = LoggerFactory.getLogger(BusiForConfirmQryPlatAndServiceFeeServiceImpl.class);
    @Autowired
    private InquiryPayOrderMapper inquiryPayOrderMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private EnumsService enumsService;

    public BusiForConfirmQryPlatAndServiceFeeListRspBO busiQryPlatUseFeeServiceFeeInfoList(BusiForConfirmQryPlatAndServiceFeeListReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5e73\u53f0\u4f7f\u7528\u6216\u8005\u6210\u4ea4\u670d\u52a1\u8d39\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (null == reqBO.getCompanyId() || reqBO.getCompanyId() <= 0L) {
            throw new BusinessException("1001", "\u4e13\u4e1a\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getPaymentStatus())) {
            throw new BusinessException("1001", "\u8bf7\u9009\u62e9\u4ed8\u6b3e\u72b6\u6001");
        }
        InquiryPayOrderExt payOrderInfoExt = new InquiryPayOrderExt();
        payOrderInfoExt.setInquiryNo(reqBO.getInquiryNo());
        payOrderInfoExt.setOperUnitNo(reqBO.getCompanyId());
        payOrderInfoExt.setSupplierId(reqBO.getSupplierId());
        payOrderInfoExt.setPayFeeType(reqBO.getPayFeeType());
        if (StringUtils.isBlank((CharSequence)reqBO.getPayFeeType())) {
            ArrayList<String> payFeeTypeList = new ArrayList<String>();
            payFeeTypeList.add(InquiryPayFeeType.TRADE_SERVICE_FEE.getCode());
            payFeeTypeList.add(InquiryPayFeeType.PURCH_SERVICE_FEE.getCode());
            payOrderInfoExt.setPayFeeTypeList(payFeeTypeList);
        }
        payOrderInfoExt.setOrderDateBegin(reqBO.getOrderTimeBegin());
        payOrderInfoExt.setOrderDateEnd(reqBO.getOrderTimeEnd());
        payOrderInfoExt.setPayFinshTimeBegin(reqBO.getPayFinshTimeBegin());
        payOrderInfoExt.setPayFinshTimeEnd(reqBO.getPayFinshTimeEnd());
        payOrderInfoExt.setPayMoney(reqBO.getPayMoney());
        payOrderInfoExt.setPaymentStatus(reqBO.getPaymentStatus());
        payOrderInfoExt.setOperator(reqBO.getOperator());
        payOrderInfoExt.setSortOrder(" PAY_FINSH_TIME DESC ");
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<InquiryPayOrder> list = this.inquiryPayOrderMapper.getListByPage(payOrderInfoExt, (Page<Map<String, Object>>)page);
        ArrayList<BusiForConfirmQryPlatAndServiceFeeRspBO> rows = new ArrayList<BusiForConfirmQryPlatAndServiceFeeRspBO>();
        BigDecimal payMoneyTotal = BigDecimal.ZERO;
        Integer matchFlag = InquiryPaymentStatus.CHECK_SUCCEED.getCode().equals(reqBO.getPaymentStatus()) ? 1 : 0;
        for (InquiryPayOrder inquiryPayOrder : list) {
            BusiForConfirmQryPlatAndServiceFeeRspBO puRspBO = new BusiForConfirmQryPlatAndServiceFeeRspBO();
            BeanUtils.copyProperties((Object)inquiryPayOrder, (Object)puRspBO);
            puRspBO.setMatchFlag(matchFlag);
            String checkingRst = InquiryPaymentStatus.CHECK_SUCCEED.getCode().equals(inquiryPayOrder.getPaymentStatus()) ? this.enumsService.getDescr(InquiryPaymentStatus.CHECK_SUCCEED) : "";
            puRspBO.setCheckingRst(checkingRst);
            puRspBO.setPayPassDesc(this.enumsService.getDescr(InquiryPayPass.getInstance(inquiryPayOrder.getPayPass())));
            puRspBO.setPaymentStatusDesc(this.enumsService.getDescr(InquiryPaymentStatus.getInstance(inquiryPayOrder.getPaymentStatus())));
            puRspBO.setOrderStatusDesc(this.enumsService.getDescr(OrderStatus.getInstance(inquiryPayOrder.getOrderStatus())));
            puRspBO.setMailStatusDesc(this.enumsService.getDescr(InquiryMailStatus.getInstance(inquiryPayOrder.getMailStatus())));
            puRspBO.setCompanyTypeDesc(this.enumsService.getDescr(CompanyType.convert(inquiryPayOrder.getCompanyType())));
            puRspBO.setSupplierName(this.organizationInfoService.querySupplierName(inquiryPayOrder.getSupplierId()));
            puRspBO.setPayFeeTypeDesc(this.enumsService.getDescr(InquiryPayFeeType.getInstance(inquiryPayOrder.getPayFeeType())));
            if (inquiryPayOrder.getOperator() != null) {
                String operatorName = this.userInfoService.queryUserNameByUserId(inquiryPayOrder.getOperator());
                puRspBO.setOperatorName(operatorName);
            }
            rows.add(puRspBO);
            payMoneyTotal = payMoneyTotal.add(inquiryPayOrder.getPayMoney());
        }
        BusiForConfirmQryPlatAndServiceFeeListRspBO rspPageBO = new BusiForConfirmQryPlatAndServiceFeeListRspBO();
        rspPageBO.setPayMoneyTotal(payMoneyTotal);
        rspPageBO.setRows(rows);
        rspPageBO.setRecordsTotal(page.getTotalCount());
        rspPageBO.setTotal(page.getTotalPages());
        rspPageBO.setPageNo(page.getPageNo());
        return rspPageBO;
    }
}

