/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.bo.FscBaseRspBo;
import com.tydic.fsc.settle.busi.api.BusiGetBillRecService;
import com.tydic.fsc.settle.busi.api.bo.BusiGetBillRecReqBO;
import com.tydic.fsc.settle.dao.BillApplyInfoMapper;
import com.tydic.fsc.settle.dao.po.BillApplyInfo;
import com.tydic.fsc.settle.enums.BillStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiGetBillRecServiceImpl
implements BusiGetBillRecService {
    private static final Logger logger = LoggerFactory.getLogger(BusiGetBillRecServiceImpl.class);
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;

    public FscBaseRspBo updateSuccBills(BusiGetBillRecReqBO reqBO) {
        logger.info("\u7a0e\u63a7\u83b7\u53d6\u5f00\u7968\u7533\u8bf7\u4fe1\u606f\u6210\u529f\u56de\u8c03\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        if (!StringUtils.hasText((String)reqBO.getBill_no())) {
            throw new BusinessException("1001", "\u5f00\u7968\u7533\u8bf7\u5355\u53f7[bill_no]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(reqBO.getBill_no());
        if (billApplyInfo == null) {
            logger.error("\u67e5\u4e0d\u5230\u5f00\u7968\u7533\u8bf7\u8bb0\u5f55[\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + reqBO.getBill_no() + "]");
            throw new BusinessException("RSP_CODE_DATA_NULL", "\u67e5\u4e0d\u5230\u5f00\u7968\u7533\u8bf7\u8bb0\u5f55[\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + reqBO.getBill_no() + "]");
        }
        if (!BillStatus.APPLIED.getCode().equals(billApplyInfo.getBillStatus())) {
            logger.error("\u5f00\u7968\u7533\u8bf7\u8bb0\u5f55[\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + reqBO.getBill_no() + "]\u7684\u72b6\u6001\u4e0d\u6b63\u786e");
            throw new BusinessException("RSP_CODE_DATA_NULL", "\u5f00\u7968\u7533\u8bf7\u8bb0\u5f55[\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + reqBO.getBill_no() + "]\u7684\u72b6\u6001\u4e0d\u6b63\u786e");
        }
        BillApplyInfo billApplyInfo1 = new BillApplyInfo();
        billApplyInfo1.setApplyNo(reqBO.getBill_no());
        billApplyInfo1.setBillStatus(BillStatus.SENDING_BILL.getCode());
        this.billApplyInfoMapper.updateByPrimaryKeySelective(billApplyInfo1);
        return new FscBaseRspBo();
    }
}

