/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.bo.FscBaseRspBo;
import com.tydic.fsc.settle.busi.api.BusiHangPayPurchaseOrderInfoService;
import com.tydic.fsc.settle.busi.api.bo.ProcessCancelHangReqBO;
import com.tydic.fsc.settle.busi.api.bo.ProcessHangReqBO;
import com.tydic.fsc.settle.dao.PayPurchaseOrderInfoMapper;
import com.tydic.fsc.settle.dao.po.PayPurchaseOrderInfo;
import com.tydic.fsc.settle.enums.OrderStatus;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiHangPayPurchaseOrderInfoServiceImpl
implements BusiHangPayPurchaseOrderInfoService {
    private static final Logger logger = LoggerFactory.getLogger(BusiHangPayPurchaseOrderInfoServiceImpl.class);
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;

    public FscBaseRspBo processHang(ProcessHangReqBO reqBO) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("\u6302\u8d77\u91c7\u8d2d\u8ba2\u5355\u670d\u52a1(\u7535\u5b50\u8d85\u5e02)\u5165\u53c2\uff1a" + reqBO);
        }
        Long inspectionId = reqBO.getInspectionId();
        String remark = reqBO.getRemark();
        if (inspectionId == null) {
            throw new BusinessException("1001", "\u5165\u53c2\u9a8c\u6536\u5355\u53f7\u3010inspectionId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PayPurchaseOrderInfo orderInfo = new PayPurchaseOrderInfo();
        orderInfo.setInspectionId(inspectionId);
        List<PayPurchaseOrderInfo> orderInfoList = this.payPurchaseOrderInfoMapper.getListByCondition(orderInfo);
        if (orderInfoList.isEmpty()) {
            throw new BusinessException("1002", "\u8ba2\u5355\u672a\u627e\u5230");
        }
        orderInfo = orderInfoList.get(0);
        if (!OrderStatus.NO_APPLY.getCode().equals(orderInfo.getOrderStatus())) {
            throw new BusinessException("1002", "\u672a\u63d0\u4ea4\u7684\u8ba2\u5355\u624d\u80fd\u6302\u8d77");
        }
        orderInfo = new PayPurchaseOrderInfo();
        orderInfo.setInspectionId(inspectionId);
        orderInfo.setOrderStatus(OrderStatus.HANGING.getCode());
        orderInfo.setRemark(remark);
        int count = this.payPurchaseOrderInfoMapper.updateBy(orderInfo);
        if (count > 0) {
            return new FscBaseRspBo();
        }
        throw new BusinessException("1002", "\u5931\u8d25");
    }

    public FscBaseRspBo processCancelHang(ProcessCancelHangReqBO reqBO) throws Exception {
        Long inspectionId;
        if (logger.isDebugEnabled()) {
            logger.debug("\u53d6\u6d88\u6302\u8d77\u91c7\u8d2d\u8ba2\u5355\u670d\u52a1(\u7535\u5b50\u8d85\u5e02)\u5165\u53c2\uff1a" + reqBO);
        }
        if ((inspectionId = reqBO.getInspectionId()) == null) {
            throw new BusinessException("1001", "\u5165\u53c2\u9a8c\u6536\u5355\u53f7\u3010inspectionId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PayPurchaseOrderInfo orderInfo = new PayPurchaseOrderInfo();
        orderInfo.setInspectionId(inspectionId);
        List<PayPurchaseOrderInfo> orderInfoList = this.payPurchaseOrderInfoMapper.getListByCondition(orderInfo);
        if (orderInfoList.isEmpty()) {
            throw new BusinessException("1002", "\u8ba2\u5355\u672a\u627e\u5230");
        }
        orderInfo = orderInfoList.get(0);
        if (!OrderStatus.HANGING.getCode().equals(orderInfo.getOrderStatus())) {
            throw new BusinessException("1002", "\u4e0d\u662f\u6302\u8d77\u72b6\u6001\uff0c\u4e0d\u80fd\u53d6\u6d88\u6302\u8d77");
        }
        orderInfo = new PayPurchaseOrderInfo();
        orderInfo.setInspectionId(inspectionId);
        orderInfo.setOrderStatus(OrderStatus.NO_APPLY.getCode());
        orderInfo.setRemark("");
        int count = this.payPurchaseOrderInfoMapper.updateBy(orderInfo);
        if (count > 0) {
            return new FscBaseRspBo();
        }
        throw new BusinessException("1002", "\u5931\u8d25");
    }
}

