/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.BillSNService;
import com.tydic.fsc.settle.atom.SequenceNoService;
import com.tydic.fsc.settle.busi.api.BusiNotificationService;
import com.tydic.fsc.settle.busi.api.BusiNotificationSplitService;
import com.tydic.fsc.settle.busi.api.NotificationSendRequestService;
import com.tydic.fsc.settle.busi.api.bo.BusiNotificationReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiNotificationRspBO;
import com.tydic.fsc.settle.busi.api.bo.NotificationSendRequestReqBO;
import com.tydic.fsc.settle.busi.api.vo.OrderInfoVO;
import com.tydic.fsc.settle.busi.api.vo.OrderItemVO;
import com.tydic.fsc.settle.dao.BillNotificationInfoMapper;
import com.tydic.fsc.settle.dao.PayItemInfoMapper;
import com.tydic.fsc.settle.dao.PayPurchaseOrderInfoMapper;
import com.tydic.fsc.settle.dao.po.BillNotificationInfoExt;
import com.tydic.fsc.settle.dao.po.PayItemInfo;
import com.tydic.fsc.settle.dao.po.PayPurchaseOrderInfo;
import com.tydic.fsc.settle.dao.vo.PayItemInfoVO;
import com.tydic.fsc.settle.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.fsc.settle.dao.vo.QueryReconcilitionOrderVO;
import com.tydic.fsc.settle.enums.BillType;
import com.tydic.fsc.settle.enums.NotificationInvoiceStatus;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.OrderStatus;
import com.tydic.fsc.settle.enums.PurchaseSaleType;
import com.tydic.fsc.settle.enums.ReconciliationStatus;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiNotificationServiceImpl
implements BusiNotificationService {
    private static final Logger logger = LoggerFactory.getLogger(BusiNotificationServiceImpl.class);
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private BillSNService billSNService;
    @Autowired(required=false)
    private BusiNotificationSplitService busiNotificationSplitService;
    private SequenceNoService billNotificationBatchNoSeq;
    @Autowired(required=false)
    private NotificationSendRequestService notificationSendRequestService;

    public BusiNotificationRspBO makeNotify(BusiNotificationReqBO reqBO) {
        List<PayPurchaseOrderInfo> payPurchaseOrderInfoPOs;
        if (logger.isDebugEnabled()) {
            logger.debug("\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        }
        List<Object> orderInfos = new LinkedList();
        String groupWay = "";
        if (null != reqBO.getVersionNo()) {
            QueryReconcilitionOrderVO queryReconcilitionOrderVO = new QueryReconcilitionOrderVO();
            queryReconcilitionOrderVO.setVersionNo(reqBO.getVersionNo());
            queryReconcilitionOrderVO.setOrderStatus(OrderStatus.NO_APPLY.getCode());
            queryReconcilitionOrderVO.setReconcilitionStatus(ReconciliationStatus.AGREEMENT.getCode());
            queryReconcilitionOrderVO.setOrderBy("orderAmt asc");
            queryReconcilitionOrderVO.setPurchaseSaleType(PurchaseSaleType.MINMARKET.getCode());
            payPurchaseOrderInfoPOs = this.payPurchaseOrderInfoMapper.getListByReconcilition(queryReconcilitionOrderVO);
            if (payPurchaseOrderInfoPOs.isEmpty()) {
                throw new BusinessException("1002", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u5165\u53c2\u5bf9\u5e94\u5f85\u5f00\u7968\u7ed3\u679c\u67e5\u8be2\u4e3a\u7a7a");
            }
            reqBO.setSource("2");
            orderInfos = this.moveOrderInfosToVO(payPurchaseOrderInfoPOs);
            groupWay = reqBO.getGroupWay();
        } else {
            if (null == reqBO.getSupplierNo()) {
                throw new BusinessException("1001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u4f9b\u5e94\u5546\u7f16\u53f7[supplierNo]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == reqBO.getSelectAllFlag()) {
                throw new BusinessException("1001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u662f\u5426\u5168\u9009\u6807\u8bc6[selectAllFlag]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == reqBO.getOrderDateEnd()) {
                throw new BusinessException("1001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u7ed3\u675f\u65e5\u671f[orderDateEnd]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == reqBO.getInvoiceInfo()) {
                throw new BusinessException("1001", "\u53d1\u7968\u4fe1\u606f\u4e0d\u6b63\u786e");
            }
            if (null == reqBO.getMailAddrInfo() || null == reqBO.getMailAddrInfo().getName()) {
                throw new BusinessException("1001", "\u90ae\u5bc4\u4fe1\u606f\u4e0d\u6b63\u786e");
            }
            if (null == reqBO.getCompanyId()) {
                throw new BusinessException("1001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-Session\u4e13\u4e1a\u516c\u53f8\u673a\u6784ID[companyId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == reqBO.getGroupWay()) {
                throw new BusinessException("1001", "\u5206\u7ec4\u65b9\u5f0f[groupWay]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == reqBO.getMaxOrderNumber() || reqBO.getMaxOrderNumber() <= 0) {
                throw new BusinessException("1001", "\u5355\u5f20\u901a\u77e5\u6700\u5927\u8ba2\u5355\u6570[maxOrderNumber]\u4e0d\u6b63\u786e");
            }
            groupWay = reqBO.getGroupWay();
            if (!("noSplitGroup".equals(groupWay) || "purchaseUnitGroup".equals(groupWay) || "orderGroup".equals(groupWay))) {
                throw new BusinessException("1001", "\u5206\u7ec4\u65b9\u5f0f\u4e0d\u6b63\u786e");
            }
            reqBO.setSource(OrderSource.ELECTRIC_MARKET.getCode());
            if (!"Y".equalsIgnoreCase(reqBO.getSelectAllFlag()) && !"N".equalsIgnoreCase(reqBO.getSelectAllFlag())) {
                throw new BusinessException("1001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u5168\u9009\u6807\u8bc6[selectAllFlag]\u53ea\u80fd\u8f93\u5165Y\u6216N");
            }
            if ("Y".equalsIgnoreCase(reqBO.getSelectAllFlag())) {
                PayPurchaseOrderInfoVO payPurchaseOrderInfoVO = new PayPurchaseOrderInfoVO();
                payPurchaseOrderInfoVO.setSource(OrderSource.ELECTRIC_MARKET.getCode());
                payPurchaseOrderInfoVO.setOperUnitNo(reqBO.getCompanyId());
                payPurchaseOrderInfoVO.setPurchaseOrderCode(reqBO.getPurchaseOrderCode());
                payPurchaseOrderInfoVO.setExtOrderId(reqBO.getExtOrderId());
                payPurchaseOrderInfoVO.setSupplierNo(reqBO.getSupplierNo());
                payPurchaseOrderInfoVO.setPurchaseNo(reqBO.getPurchaseNo());
                payPurchaseOrderInfoVO.setOrderDateStart(reqBO.getOrderDateStart());
                payPurchaseOrderInfoVO.setOrderDateEnd(reqBO.getOrderDateEnd());
                payPurchaseOrderInfoVO.setRecvDateStart(reqBO.getRecvDateStart());
                payPurchaseOrderInfoVO.setRecvDateEnd(reqBO.getRecvDateEnd());
                payPurchaseOrderInfoVO.setReconcilitionStatus(reqBO.getReconcilitionStatus());
                payPurchaseOrderInfoVO.setOrderBy("orderAmt asc");
                payPurchaseOrderInfoVO.setPurchaseSaleType(reqBO.getPurchaseSaleType());
                payPurchaseOrderInfoPOs = this.payPurchaseOrderInfoMapper.getListExt(payPurchaseOrderInfoVO);
                if (payPurchaseOrderInfoPOs.isEmpty()) {
                    throw new BusinessException("1002", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u5165\u53c2\u5bf9\u5e94\u5f85\u5f00\u7968\u7ed3\u679c\u67e5\u8be2\u4e3a\u7a7a");
                }
                orderInfos = this.moveOrderInfosToVO(payPurchaseOrderInfoPOs);
            } else if ("N".equalsIgnoreCase(reqBO.getSelectAllFlag())) {
                if (null == reqBO.getOrderInfos()) {
                    throw new BusinessException("1001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u975e\u5168\u9009\u65f6\uff0c\u8ba2\u5355\u5217\u8868\u4e0d\u5f97\u4e3a\u7a7a");
                }
                orderInfos = reqBO.getOrderInfos();
            }
        }
        if (orderInfos == null || orderInfos.isEmpty()) {
            throw new BusinessException("1001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u6ca1\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u8ba2\u5355");
        }
        String purchaseSaleType = ((OrderInfoVO)orderInfos.get(0)).getPurchaseSaleType();
        Integer maxOrderNumber = reqBO.getMaxOrderNumber();
        BigDecimal maxOrderAmt = new BigDecimal(reqBO.getMaxOrderAmt());
        if (maxOrderAmt.compareTo(new BigDecimal("500")) > 0) {
            throw new BusinessException("1001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u4e00\u5f20\u5f00\u7968\u901a\u77e5\u5355\u6700\u5927\u5141\u8bb8\u5f00\u7968\u91d1\u989d\u4e3a500\u4e07\u5143");
        }
        List invoices = this.busiNotificationSplitService.getSplitResult(orderInfos, maxOrderNumber, groupWay, maxOrderAmt);
        LinkedList<BillNotificationInfoExt> notifications = new LinkedList<BillNotificationInfoExt>();
        final String batchNo = this.billNotificationBatchNoSeq.generateSeqNoFormated(12, new SimpleDateFormat("yyyyMMdd").format(new Date()));
        for (List singleInvoice : invoices) {
            BigDecimal sumAmt = BigDecimal.ZERO;
            for (int i = 0; i < singleInvoice.size(); ++i) {
                sumAmt = sumAmt.add(((OrderInfoVO)singleInvoice.get(i)).getOrderAmt());
            }
            Date now = new Date();
            String notifyNo = this.billSNService.getSnAsString(BillType.INVOICE_NOTIFYCATION);
            BillNotificationInfoExt notifyInfo = new BillNotificationInfoExt();
            notifyInfo.setNotificationNo(notifyNo);
            notifyInfo.setAmt(sumAmt);
            notifyInfo.setApplyDate(now);
            notifyInfo.setOperNo(reqBO.getCompanyId());
            notifyInfo.setSource(String.valueOf(reqBO.getSource()));
            notifyInfo.setSupplierNo(reqBO.getSupplierNo());
            notifyInfo.setUserId(reqBO.getUserId());
            notifyInfo.setAddr(reqBO.getInvoiceInfo().getAddress());
            notifyInfo.setBankAccNo(reqBO.getInvoiceInfo().getAccount());
            notifyInfo.setBankName(reqBO.getInvoiceInfo().getBank());
            notifyInfo.setInvoceName(reqBO.getInvoiceInfo().getInvoiceTitle());
            notifyInfo.setInvoceType(reqBO.getInvoiceInfo().getInvoiceType());
            notifyInfo.setInvoiceStatus(NotificationInvoiceStatus.NO_SUBMITED.getCode());
            notifyInfo.setPhone(reqBO.getInvoiceInfo().getPhone());
            notifyInfo.setTaxNo(reqBO.getInvoiceInfo().getTaxpayerId());
            notifyInfo.setAddrDesc(reqBO.getMailAddrInfo().getAddrDesc());
            notifyInfo.setProvince(reqBO.getMailAddrInfo().getProvince());
            notifyInfo.setCity(reqBO.getMailAddrInfo().getCity());
            notifyInfo.setCounty(reqBO.getMailAddrInfo().getCounty());
            notifyInfo.setTown(reqBO.getMailAddrInfo().getTown());
            notifyInfo.setProvId(reqBO.getMailAddrInfo().getProvId());
            notifyInfo.setCityId(reqBO.getMailAddrInfo().getCityId());
            notifyInfo.setCountyId(reqBO.getMailAddrInfo().getCountyId());
            notifyInfo.setTownId(reqBO.getMailAddrInfo().getTownId());
            notifyInfo.setCompany(reqBO.getMailAddrInfo().getCompany());
            notifyInfo.setMobile(reqBO.getMailAddrInfo().getTel());
            notifyInfo.setTel(reqBO.getMailAddrInfo().getSpecialPlane());
            notifyInfo.setName(reqBO.getMailAddrInfo().getName());
            notifyInfo.setPostCode(reqBO.getMailAddrInfo().getPostCode());
            notifyInfo.setBatchNo(batchNo);
            notifyInfo.setPurchaseSaleType(purchaseSaleType);
            this.billNotificationInfoMapper.insert(notifyInfo);
            LinkedList<String> orderIdCombStr = new LinkedList<String>();
            for (OrderInfoVO singleOrder : singleInvoice) {
                PayPurchaseOrderInfo payOrderInfo = new PayPurchaseOrderInfo();
                payOrderInfo.setOrderId(Long.valueOf(singleOrder.getOrderId()));
                payOrderInfo.setInspectionId(Long.valueOf(singleOrder.getInspectionId()));
                payOrderInfo.setNotificationNo(notifyNo);
                payOrderInfo.setOrderStatus(OrderStatus.APPLIED.getCode());
                this.payPurchaseOrderInfoMapper.updateByPKUnsent(payOrderInfo);
                orderIdCombStr.add(singleOrder.getExtOrderId());
                PayItemInfo item = new PayItemInfo();
                item.setOrderId(Long.valueOf(singleOrder.getOrderId()));
                item.setInspectionId(Long.valueOf(singleOrder.getInspectionId()));
                item.setNotificationNo(notifyNo);
                item.setItemStatus(OrderStatus.APPLIED.getCode());
                this.payItemInfoMapper.updateByPKUnsent(item);
            }
            notifyInfo.setOrderIds(orderIdCombStr);
            notifications.add(notifyInfo);
        }
        BusiNotificationRspBO rspBO = new BusiNotificationRspBO();
        rspBO.setBatchNo(batchNo);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                NotificationSendRequestReqBO notificationSendRequestReqBO = new NotificationSendRequestReqBO();
                notificationSendRequestReqBO.setBatchNo(batchNo);
                BusiNotificationServiceImpl.this.notificationSendRequestService.processPushInfo(notificationSendRequestReqBO);
            }
        }).start();
        return rspBO;
    }

    private List<OrderInfoVO> moveOrderInfosToVO(List<PayPurchaseOrderInfo> orderInfos) {
        LinkedList<OrderInfoVO> infos = new LinkedList<OrderInfoVO>();
        for (PayPurchaseOrderInfo singleInfo : orderInfos) {
            OrderInfoVO singleVO = new OrderInfoVO();
            singleVO.setConfirmDate(singleInfo.getRecvDate());
            singleVO.setInspectionId(String.valueOf(singleInfo.getInspectionId()));
            singleVO.setLastConfirmDate(singleInfo.getRecvDate());
            singleVO.setOrderAmt(singleInfo.getOrderAmt());
            singleVO.setOrderCreateDate(singleInfo.getOrderDate());
            singleVO.setOrderCreator(singleInfo.getPurchaserName());
            singleVO.setOrderId(String.valueOf(singleInfo.getOrderId()));
            singleVO.setExtOrderId(singleInfo.getExtOrderId());
            singleVO.setOrderStatus(singleInfo.getOrderStatus());
            singleVO.setOrderType(singleInfo.getOrderType());
            singleVO.setPurchaseNo(singleInfo.getPurchaseNo());
            singleVO.setPurchaseProjectId(singleInfo.getPurchaseProjectId());
            singleVO.setPurchaseOrderCode(singleInfo.getPurchaseOrderCode());
            singleVO.setSupplierNo(singleInfo.getSupplierNo());
            singleVO.setPurchaseSaleType(singleInfo.getPurchaseSaleType());
            PayItemInfoVO payItemInfoVO = new PayItemInfoVO();
            payItemInfoVO.setItemStatus(OrderStatus.NO_APPLY.getCode());
            payItemInfoVO.setInspectionId(singleInfo.getInspectionId());
            List<PayItemInfo> itemInfos = this.payItemInfoMapper.selectBy(payItemInfoVO);
            if (itemInfos.isEmpty()) {
                throw new BusinessException("1002", "\u8ba2\u5355\u7f16\u53f7\uff1a" + singleInfo.getPurchaseOrderCode() + "\u6ca1\u6709\u5546\u54c1\u660e\u7ec6");
            }
            LinkedList<OrderItemVO> itemVOs = new LinkedList<OrderItemVO>();
            for (PayItemInfo itemInfo : itemInfos) {
                OrderItemVO vo = new OrderItemVO();
                vo.setItemName(itemInfo.getItemName());
                vo.setSpec(itemInfo.getSpec());
                vo.setModel(itemInfo.getModel());
                vo.setUnit(itemInfo.getUnitName());
                vo.setUnitId(itemInfo.getUnitId());
                vo.setQuantity(itemInfo.getQuantity());
                vo.setSalePrice(itemInfo.getPurchaseUnitPrice());
                vo.setSumTaxPrice(itemInfo.getUntaxAmt().add(itemInfo.getTaxAmt()));
                itemVOs.add(vo);
            }
            singleVO.setItemList(itemVOs);
            infos.add(singleVO);
        }
        return infos;
    }
}

