/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.busi.api.BusiNotificationSplitService;
import com.tydic.fsc.settle.busi.api.vo.OrderInfoVO;
import com.tydic.fsc.settle.dao.SupplierInfoMapper;
import com.tydic.fsc.settle.dao.po.SupplierInfo;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiNotificationSplitServiceImpl
implements BusiNotificationSplitService {
    private static final Logger logger = LoggerFactory.getLogger(BusiNotificationSplitServiceImpl.class);
    @Autowired
    private SupplierInfoMapper supplierInfoMapper;
    @Autowired
    private EnumsService enumsService;

    public List<List<OrderInfoVO>> getSplitResult(List<OrderInfoVO> orderInfos, Integer maxOrderNumber, String groupWay, BigDecimal maxOrderAmt) {
        LinkedList<List<OrderInfoVO>> orderInfosList = null;
        List<List<OrderInfoVO>> orderInfosVal = null;
        if ("noSplitGroup".equals(groupWay)) {
            orderInfosVal = this.noSplitGroupWay(orderInfos, maxOrderNumber, maxOrderAmt);
        } else if ("purchaseUnitGroup".equals(groupWay)) {
            orderInfosVal = this.purchaseUnitGroupWay(orderInfos, maxOrderNumber, maxOrderAmt);
        } else if ("orderGroup".equals(groupWay)) {
            orderInfosVal = this.orderGroupWay(orderInfos);
        }
        if (null != orderInfosVal && orderInfosVal.size() > 0) {
            logger.debug("\u5206\u7ec4\u65b9\u5f0f" + groupWay + "\u5bf9\u5e94\u7684\u62c6\u5206\u7ed3\u679c\u4e3a:" + orderInfosVal.toString());
            orderInfosList = new LinkedList<List<OrderInfoVO>>();
            for (List<OrderInfoVO> list : orderInfosVal) {
                if (null == list || list.size() <= 0) continue;
                orderInfosList.add(list);
            }
        }
        return orderInfosList;
    }

    private List<List<OrderInfoVO>> noSplitGroupWay(List<OrderInfoVO> orderInfos, Integer maxOrderNumber, BigDecimal maxOrderAmt) {
        List<Object> orderInfosList = new LinkedList();
        orderInfosList = this.splitByBase(orderInfos);
        orderInfosList = this.splitByMaxOrderNumber(orderInfosList, maxOrderNumber, maxOrderAmt);
        if (this.enumsService.splitBySupplierInvoiceLimit().booleanValue()) {
            orderInfosList = this.splitBySupInvLimit(orderInfosList);
        }
        return orderInfosList;
    }

    private List<List<OrderInfoVO>> purchaseUnitGroupWay(List<OrderInfoVO> orderInfos, Integer maxOrderNumber, BigDecimal maxOrderAmt) {
        List<Object> orderInfosList = new LinkedList();
        orderInfosList = this.splitByBase(orderInfos);
        orderInfosList = this.splitByPurchaseUnit(orderInfosList);
        orderInfosList = this.splitByMaxOrderNumber(orderInfosList, maxOrderNumber, maxOrderAmt);
        if (this.enumsService.splitBySupplierInvoiceLimit().booleanValue()) {
            orderInfosList = this.splitBySupInvLimit(orderInfosList);
        }
        return orderInfosList;
    }

    private List<List<OrderInfoVO>> orderGroupWay(List<OrderInfoVO> orderInfos) {
        LinkedList<List<OrderInfoVO>> orderInfosList = new LinkedList<List<OrderInfoVO>>();
        LinkedList<OrderInfoVO> orderInfoForSingleInvoice = null;
        for (OrderInfoVO orderInfoVO : orderInfos) {
            orderInfoForSingleInvoice = new LinkedList<OrderInfoVO>();
            orderInfoForSingleInvoice.add(orderInfoVO);
            orderInfosList.add(orderInfoForSingleInvoice);
        }
        return orderInfosList;
    }

    private List<List<OrderInfoVO>> splitByBase(List<OrderInfoVO> orderInfos) {
        LinkedList<List<OrderInfoVO>> orderInfosList = new LinkedList<List<OrderInfoVO>>();
        LinkedList<OrderInfoVO> allOrderInfo = new LinkedList<OrderInfoVO>();
        for (OrderInfoVO orderInfoVO : orderInfos) {
            allOrderInfo.add(orderInfoVO);
        }
        orderInfosList.add(allOrderInfo);
        return orderInfosList;
    }

    private List<List<OrderInfoVO>> splitBySupplier(List<List<OrderInfoVO>> orderInfosList) {
        LinkedList<List<OrderInfoVO>> orderInfosSplitList = new LinkedList<List<OrderInfoVO>>();
        HashMap supplierMap = new HashMap();
        for (List<OrderInfoVO> orderInfoVoList : orderInfosList) {
            for (OrderInfoVO orderInfoVO : orderInfoVoList) {
                if (supplierMap.containsKey(orderInfoVO.getSupplierNo())) {
                    ((List)supplierMap.get(orderInfoVO.getSupplierNo())).add(orderInfoVO);
                    continue;
                }
                LinkedList<OrderInfoVO> newOrderInfoList = new LinkedList<OrderInfoVO>();
                newOrderInfoList.add(orderInfoVO);
                supplierMap.put(orderInfoVO.getSupplierNo(), newOrderInfoList);
            }
        }
        for (Map.Entry entry : supplierMap.entrySet()) {
            orderInfosSplitList.add((List<OrderInfoVO>)entry.getValue());
        }
        return orderInfosSplitList;
    }

    private List<List<OrderInfoVO>> splitBySupInvLimit(List<List<OrderInfoVO>> orderInfosList) {
        LinkedList<List<OrderInfoVO>> orderInfosSplitList = new LinkedList<List<OrderInfoVO>>();
        for (List<OrderInfoVO> orderInfoVoList : orderInfosList) {
            BigDecimal totalAmt = BigDecimal.ZERO;
            Long supplierNo = null;
            for (OrderInfoVO orderInfoVO : orderInfoVoList) {
                totalAmt = totalAmt.add(orderInfoVO.getOrderAmt());
                supplierNo = orderInfoVO.getSupplierNo();
            }
            SupplierInfo supplierInfo = this.supplierInfoMapper.selectByPrimaryKey(supplierNo);
            if (supplierInfo == null) {
                throw new BusinessException("RSP_CODE_DAO_ERROR", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u4f9b\u5e94\u5546\u5f00\u7968\u9650\u989d\u914d\u7f6e\u8868\uff0c\u4f9b\u5e94\u5546ID:" + String.valueOf(supplierNo) + "\u627e\u4e0d\u5230\u5bf9\u5e94\u914d\u7f6e\u4fe1\u606f");
            }
            if (supplierInfo.getSupInvLimit().compareTo(totalAmt) < 0 && orderInfoVoList.size() > 1) {
                LinkedList<OrderInfoVO> orderInfoForSingle = new LinkedList<OrderInfoVO>();
                BigDecimal sumAmtForLoop = BigDecimal.ZERO;
                for (OrderInfoVO orderInfoVO : orderInfoVoList) {
                    if ((sumAmtForLoop = sumAmtForLoop.add(orderInfoVO.getOrderAmt())).compareTo(supplierInfo.getSupInvLimit()) > 0) {
                        orderInfosSplitList.add(orderInfoForSingle);
                        orderInfoForSingle = new LinkedList();
                        sumAmtForLoop = BigDecimal.ZERO.add(orderInfoVO.getOrderAmt());
                    }
                    orderInfoForSingle.add(orderInfoVO);
                }
                orderInfosSplitList.add(orderInfoForSingle);
                continue;
            }
            orderInfosSplitList.add(orderInfoVoList);
        }
        return orderInfosSplitList;
    }

    private List<List<OrderInfoVO>> splitByMaxOrderNumber(List<List<OrderInfoVO>> orderInfosList, Integer maxOrderNumber, BigDecimal maxOrderAmt) {
        LinkedList<List<OrderInfoVO>> orderInfosSplitList = new LinkedList<List<OrderInfoVO>>();
        for (List<OrderInfoVO> orderInfoVoList : orderInfosList) {
            LinkedList<OrderInfoVO> minOrderInfoForSingle = new LinkedList<OrderInfoVO>();
            BigDecimal amt = BigDecimal.ZERO;
            for (OrderInfoVO orderInfoVO : orderInfoVoList) {
                if ((amt = amt.add(orderInfoVO.getOrderAmt())).compareTo(maxOrderAmt.multiply(new BigDecimal("10000"))) > 0 || minOrderInfoForSingle.size() >= maxOrderNumber) {
                    if (!minOrderInfoForSingle.isEmpty() && minOrderInfoForSingle.size() > 0) {
                        orderInfosSplitList.add(minOrderInfoForSingle);
                    }
                    minOrderInfoForSingle = new LinkedList();
                    amt = orderInfoVO.getOrderAmt();
                }
                minOrderInfoForSingle.add(orderInfoVO);
            }
            orderInfosSplitList.add(minOrderInfoForSingle);
        }
        return orderInfosSplitList;
    }

    private List<List<OrderInfoVO>> splitByPurchaseUnit(List<List<OrderInfoVO>> orderInfosList) {
        LinkedList<List<OrderInfoVO>> orderInfosSplitList = new LinkedList<List<OrderInfoVO>>();
        LinkedList valList = new LinkedList();
        for (List<OrderInfoVO> list : orderInfosList) {
            HashMap purUnitMap = new HashMap();
            for (OrderInfoVO orderInfoVO : list) {
                if (purUnitMap.containsKey(orderInfoVO.getPurchaseProjectId())) {
                    ((List)purUnitMap.get(orderInfoVO.getPurchaseProjectId())).add(orderInfoVO);
                    continue;
                }
                LinkedList<OrderInfoVO> newOrderInfoVOList = new LinkedList<OrderInfoVO>();
                newOrderInfoVOList.add(orderInfoVO);
                purUnitMap.put(orderInfoVO.getPurchaseProjectId(), newOrderInfoVOList);
            }
            valList.add(purUnitMap);
        }
        for (Map map : valList) {
            for (Map.Entry entry : map.entrySet()) {
                orderInfosSplitList.add((List<OrderInfoVO>)entry.getValue());
            }
        }
        return orderInfosSplitList;
    }
}

