/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.busi.api.BusiOrderHandUpService;
import com.tydic.fsc.settle.busi.api.bo.BusiOrderHandUpReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiOrderHandUpRspBO;
import com.tydic.fsc.settle.dao.BillNotificationInfoMapper;
import com.tydic.fsc.settle.dao.PayInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.PayItemInfoMapper;
import com.tydic.fsc.settle.dao.PayPurchaseOrderInfoMapper;
import com.tydic.fsc.settle.dao.po.BillNotificationInfo;
import com.tydic.fsc.settle.dao.po.PayInvoiceInfo;
import com.tydic.fsc.settle.dao.po.PayItemInfo;
import com.tydic.fsc.settle.dao.po.PayPurchaseOrderInfo;
import com.tydic.fsc.settle.enums.NotificationInvoiceStatus;
import com.tydic.fsc.settle.enums.OrderStatus;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiOrderHandUpServiceImpl
implements BusiOrderHandUpService {
    @Autowired
    PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    PayItemInfoMapper payItemInfoMapper;
    @Autowired
    BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;

    public BusiOrderHandUpRspBO updateHandUpOrder(BusiOrderHandUpReqBO reqBo) {
        PayInvoiceInfo invoiceInfo;
        if (reqBo.getInspectionIds() == null || reqBo.getInspectionIds().isEmpty()) {
            throw new BusinessException("1001", "\u8bf7\u52fe\u9009\u8ba2\u5355");
        }
        BusiOrderHandUpRspBO rspBo = new BusiOrderHandUpRspBO();
        List inspectionIds = reqBo.getInspectionIds();
        String notificationNo = this.payPurchaseOrderInfoMapper.getNoficationNoByInspectionId((Long)inspectionIds.get(0));
        if (notificationNo == null || StringUtils.isEmpty((Object)notificationNo)) {
            throw new BusinessException("1001", "\u6839\u636e\u9a8c\u6536\u5355\u53f7[" + inspectionIds.get(0) + "]\u83b7\u53d6\u5f00\u7968\u901a\u77e5\u5355\u53f7\u5931\u8d25\u3002");
        }
        boolean flag = this.checkStatus(inspectionIds);
        if (!flag) {
            throw new BusinessException("1002", "\u8ba2\u5355\u72b6\u6001\u5fc5\u987b\u662f" + OrderStatus.APPLIED.getDescr());
        }
        this.payPurchaseOrderInfoMapper.updateHandStatusByInspectionIds(inspectionIds, OrderStatus.HANGING.getCode());
        this.payItemInfoMapper.updateHandStatusByInspectionIds(inspectionIds, OrderStatus.NO_APPLY.getCode());
        this.payPurchaseOrderInfoMapper.updateReconciliationByInspectionIds(inspectionIds, "0");
        this.billNotificationInfoMapper.updateAmtByNotificationNo(notificationNo);
        BillNotificationInfo notification = this.billNotificationInfoMapper.selectByPrimaryKey(notificationNo);
        if (notification.getAmt().compareTo(BigDecimal.ZERO) == 0) {
            notification = new BillNotificationInfo();
            notification.setNotificationNo(notificationNo);
            notification.setInvoiceStatus(NotificationInvoiceStatus.RETURN_BACK.getCode());
            this.billNotificationInfoMapper.updateByPrimaryKeySelective(notification);
            return rspBo;
        }
        List<PayInvoiceInfo> payInvoiceInfoList = this.payInvoiceInfoMapper.selectByNotifyNo(notificationNo);
        if (!payInvoiceInfoList.isEmpty() && (invoiceInfo = payInvoiceInfoList.get(0)).getAmt().compareTo(notification.getAmt()) >= 0) {
            notification = new BillNotificationInfo();
            notification.setNotificationNo(notificationNo);
            notification.setInvoiceStatus(NotificationInvoiceStatus.HAS_MAKE.getCode());
            this.billNotificationInfoMapper.updateByPrimaryKeySelective(notification);
            PayPurchaseOrderInfo payOrderUpd = new PayPurchaseOrderInfo();
            payOrderUpd.setNotificationNo(notificationNo);
            payOrderUpd.setOrderStatus(OrderStatus.SEND_BILL.getCode());
            this.payPurchaseOrderInfoMapper.updateStatus(payOrderUpd);
            PayItemInfo payItemUpd = new PayItemInfo();
            payItemUpd.setNotificationNo(notificationNo);
            payItemUpd.setItemStatus(OrderStatus.SEND_BILL.getCode());
            payItemUpd.setInvoiceCode(invoiceInfo.getInvoiceCode());
            payItemUpd.setInvoiceNo(invoiceInfo.getInvoiceNo());
            this.payItemInfoMapper.updateByPrimaryKeySelective(payItemUpd);
        }
        return rspBo;
    }

    private boolean checkStatus(List<Long> inspectionIds) {
        boolean flag = false;
        int count = this.payPurchaseOrderInfoMapper.getNotAppliedCountByInspectionIds(inspectionIds, OrderStatus.APPLIED.getCode());
        if (count == 0) {
            flag = true;
        }
        return flag;
    }
}

