/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.PayableService;
import com.tydic.fsc.settle.busi.api.BusiPayResultModifyService;
import com.tydic.fsc.settle.busi.api.bo.BusiPayResultModifyReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiPayResultModifyRspBO;
import com.tydic.fsc.settle.dao.ApplyDetailMapper;
import com.tydic.fsc.settle.dao.ApplyPayInfoMapper;
import com.tydic.fsc.settle.dao.po.ApplyDetail;
import com.tydic.fsc.settle.dao.po.ApplyPayInfoPO;
import com.tydic.fsc.settle.enums.PayResultStatus;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiPayResultModifyServiceImpl
implements BusiPayResultModifyService {
    private static final Logger logger = LoggerFactory.getLogger(BusiPayResultModifyServiceImpl.class);
    @Autowired
    private PayableService payableService;
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;

    public BusiPayResultModifyRspBO modifyResult(BusiPayResultModifyReqBO busiPayResultModifyReqBO) {
        logger.info("\u4ed8\u6b3e\u5355\u7ed3\u679c\u5f55\u5165BO=" + busiPayResultModifyReqBO);
        Long payNo = busiPayResultModifyReqBO.getPayNo();
        if (payNo == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u4ed8\u6b3e\u5355\u53f7(payNo)\u5fc5\u987b\u8f93\u5165");
        }
        String sta = busiPayResultModifyReqBO.getStatus();
        PayResultStatus newStatus = PayResultStatus.getInstance(sta);
        if (newStatus == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u4ed8\u6b3e\u7ed3\u679c\u72b6\u6001\u4e0d\u5408\u6cd5");
        }
        if (newStatus == PayResultStatus.APPLYING) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u72b6\u6001\u4e3a" + PayResultStatus.APPLYING.getDescr());
        }
        ApplyPayInfoPO applyPay = this.applyPayInfoMapper.getModelById(payNo);
        if (applyPay == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u4ed8\u6b3e\u5355" + payNo + "\u4e0d\u5b58\u5728");
        }
        PayResultStatus nowSta = PayResultStatus.getInstance(applyPay.getPayStatus());
        if (nowSta == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u4ed8\u6b3e\u5355\u7684\u72b6\u6001\u6570\u636e\u5f02\u5e38");
        }
        if (nowSta != PayResultStatus.APPLYING && nowSta != PayResultStatus.FAILED) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u4fee\u6539");
        }
        if (nowSta == PayResultStatus.FAILED && newStatus == PayResultStatus.FAILED) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u72b6\u6001\u4e3a" + PayResultStatus.FAILED.getDescr());
        }
        List<ApplyDetail> details = this.applyDetailMapper.selectPayableList(payNo);
        int size = details.size();
        if (size == 0) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u672a\u627e\u5230\u6b64\u4ed8\u6b3e\u5355\u4e0b\u7684\u5e94\u4ed8\u6b3e\u5355\u660e\u7ec6\u8bb0\u5f55");
        }
        logger.info("\u4ed8\u6b3e\u5355\u8bbe\u7f6e\u4ed8\u6b3e\u7ed3\u679c,\u6d89\u53ca\u5e94\u4ed8\u5355\u6570\u91cf=" + size + ",\u4ed8\u6b3e\u5355\u53f7=" + payNo);
        if (newStatus != PayResultStatus.FAILED) {
            for (int i = 0; i < details.size(); ++i) {
                ApplyDetail detail = details.get(i);
                BigDecimal amount = detail.getAmt();
                String payableNo = detail.getPayableNo();
                if (newStatus == PayResultStatus.CANCEL) {
                    this.payableService.cancelPay(payableNo, amount);
                    continue;
                }
                if (newStatus != PayResultStatus.SUCCESS) continue;
                this.payableService.completePay(payableNo, amount);
            }
        }
        applyPay.setPayStatus(newStatus.getCode());
        applyPay.setRemark(busiPayResultModifyReqBO.getRemark());
        applyPay.setOperatorId(busiPayResultModifyReqBO.getUserId());
        this.applyPayInfoMapper.updateStatus(applyPay);
        ApplyDetail applyDetail = new ApplyDetail();
        applyDetail.setApplyNo(payNo);
        applyDetail.setStatus(newStatus.getCode());
        this.applyDetailMapper.updateByApplyNo(applyDetail);
        logger.info("\u4ed8\u6b3e\u5355[" + payNo + "]\u7684\u72b6\u6001\u6210\u529f\u7531[" + nowSta.getCodeDescr() + "]\u53d8\u4e3a" + newStatus.getCodeDescr() + "\u64cd\u4f5c\u4eba=" + applyPay.getOperatorId());
        BusiPayResultModifyRspBO resp = new BusiPayResultModifyRspBO();
        return resp;
    }
}

