/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.atom.SubAccountRespInitService;
import com.tydic.fsc.settle.atom.SubAccountService;
import com.tydic.fsc.settle.busi.api.BusiProSubAccountAddService;
import com.tydic.fsc.settle.busi.api.bo.BusiSubAccountInfoReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiSubAccountInfoRspBO;
import com.tydic.fsc.settle.busi.api.bo.SubAcctInfoExt;
import com.tydic.fsc.settle.dao.MainAcctInfoMapper;
import com.tydic.fsc.settle.dao.PurchaseUnitInfoMapper;
import com.tydic.fsc.settle.dao.po.MainAcctInfo;
import com.tydic.fsc.settle.dao.po.PurchaseUnitInfo;
import com.tydic.fsc.settle.dao.po.SubAcctInfo;
import com.tydic.fsc.settle.enums.CompanyType;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.SubAccountServiceType;
import com.tydic.fsc.settle.enums.SubAccountStatus;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiProSubAccountAddServiceImpl
implements BusiProSubAccountAddService {
    private static final Logger logger = LoggerFactory.getLogger(BusiProSubAccountAddServiceImpl.class);
    @Autowired
    private SubAccountService subAcctService;
    @Autowired
    private SubAccountRespInitService initSerivce;
    @Autowired
    private MainAcctInfoMapper mainAcctInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private PurchaseUnitInfoMapper purchaseUnitInfoMapper;
    @Autowired
    private EnumsService enumsService;

    public BusiSubAccountInfoRspBO addSubAccount(BusiSubAccountInfoReqBO subAcctInfoBO) {
        SubAccountStatus sta;
        if (logger.isDebugEnabled()) {
            logger.debug("\u65b0\u589e\u5b50\u8d26\u53f7BO:" + subAcctInfoBO.toString());
        }
        Long oprOrgId = subAcctInfoBO.getOrgId();
        Long superiorOrgId = subAcctInfoBO.getSuperiorOrgId();
        Long companyId = subAcctInfoBO.getCompanyId();
        if (oprOrgId == null) {
            throw new BusinessException("1001", "\u65b0\u589e\u5b50\u8d26\u53f7\u5931\u8d25,\u5f53\u524d\u64cd\u4f5c\u5458\u673a\u6784\u53f7\u4e3a\u7a7a");
        }
        Integer channelType = subAcctInfoBO.getChannelType();
        if (channelType == null) {
            throw new BusinessException("1001", "\u65b0\u589e\u5b50\u8d26\u53f7\u5931\u8d25,\u6e20\u9053\u7c7b\u578bchannelType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Integer srvType = subAcctInfoBO.getServiceType();
        String mainAcctNo = subAcctInfoBO.getMainAcctNo();
        String source = subAcctInfoBO.getSource();
        Long acctOrgId = subAcctInfoBO.getAcctOrgId();
        Long projectId = subAcctInfoBO.getProjectId();
        String subAcctName = subAcctInfoBO.getSubAcctName();
        Integer companyType = subAcctInfoBO.getAcctCompanyType();
        BigDecimal overDraft = subAcctInfoBO.getOverdraft();
        SubAcctInfo subAcct = new SubAcctInfo();
        if (overDraft == null) {
            overDraft = BigDecimal.ZERO;
        }
        if (!StringUtils.hasText((String)subAcctName)) {
            throw new BusinessException("1001", "\u5b50\u8d26\u53f7\u540d\u79f0\u5fc5\u987b\u8f93\u5165");
        }
        if (channelType > 10 && channelType < 20) {
            if (companyId == null) {
                throw new BusinessException("1001", "\u8bf7\u6c42\u4e2d\u65e0\u6cd5\u627e\u5230\u516c\u53f8\u673a\u6784(companyId)");
            }
            superiorOrgId = companyId;
            if (channelType == 11) {
                if (srvType == null) {
                    throw new BusinessException("1001", "\u5b50\u8d26\u53f7\u670d\u52a1\u7c7b\u578b\u5fc5\u987b\u8f93\u5165");
                }
                if (SubAccountServiceType.DEFAULT.getCode().equals(srvType)) {
                    throw new BusinessException("1001", "\u4e0d\u5141\u8bb8\u5efa\u7acb\u6b64\u79cd\u670d\u52a1\u7c7b\u578b\u7684\u5b50\u8d26\u53f7");
                }
                projectId = subAcctInfoBO.getPurchaserAccountUser();
                if (projectId == null) {
                    logger.error("\u4e13\u4e1a\u516c\u53f8\u5efa\u7acb\u8d44\u91d1\u8d26\u53f7\u5931\u8d25,\u65e0\u6548\u7684\u8d26\u5957ID=" + projectId);
                    throw new BusinessException("1001", "\u8bf7\u6c42\u4e2d\u672a\u53d1\u73b0\u6709\u6548\u7684\u8d26\u5957ID");
                }
                acctOrgId = superiorOrgId;
                companyType = CompanyType.OTHER.getCode();
                if (!StringUtils.hasText((String)mainAcctNo)) {
                    mainAcctNo = this.getMainAcct(source, superiorOrgId);
                }
                overDraft = new BigDecimal("9999999999999");
            } else if (channelType == 12) {
                if (CompanyType.convert(companyType) == null) {
                    throw new BusinessException("1001", "\u5b50\u8d26\u53f7\u5fc5\u987b\u6307\u5b9a\u662f\u7528\u4e8e\u91c7\u8d2d\u5355\u4f4d\u6216\u4f9b\u5e94\u5546");
                }
                if (projectId == null) {
                    throw new BusinessException("1001", "\u8d26\u5957ID\u5fc5\u987b\u8f93\u5165");
                }
                srvType = SubAccountServiceType.DEFAULT.getCode();
                if (!StringUtils.hasText((String)mainAcctNo)) {
                    mainAcctNo = this.getMainAcct(source, superiorOrgId);
                }
            }
        } else if (channelType > 20 && channelType < 30) {
            if (acctOrgId == null) {
                throw new BusinessException("1001", "\u5b50\u8d26\u53f7\u6240\u5c5e\u7684\u673a\u6784ID\u5fc5\u987b\u8f93\u5165");
            }
            if (projectId == null) {
                throw new BusinessException("1001", "\u8d26\u5957ID\u5fc5\u987b\u8f93\u5165");
            }
            companyType = CompanyType.PURCHASER.getCode();
            srvType = SubAccountServiceType.DEFAULT.getCode();
            if (!StringUtils.hasText((String)mainAcctNo)) {
                mainAcctNo = this.getMainAcct(source, superiorOrgId);
            }
        } else {
            throw new BusinessException("1001", "\u672a\u77e5\u7684\u64cd\u4f5c\u6e20\u9053\u7c7b\u578bchannelType");
        }
        subAcct.setLoginId(subAcctInfoBO.getUserId());
        subAcct.setCreateOrgId(oprOrgId);
        subAcct.setMainAcctNo(mainAcctNo);
        subAcct.setOrgId(acctOrgId);
        subAcct.setSubAcctName(subAcctInfoBO.getSubAcctName());
        subAcct.setServiceType(srvType);
        subAcct.setProjectId(projectId);
        subAcct.setCompanyType(companyType);
        subAcct.setOverdraft(overDraft);
        subAcct = this.subAcctService.addSubAccount(subAcct);
        SubAcctInfoExt extInfo = this.subAcctService.getWithMainAccount(subAcct.getSubAcctNo());
        BusiSubAccountInfoRspBO respBo = new BusiSubAccountInfoRspBO();
        this.initSerivce.initRespBo(extInfo, respBo);
        if (OrderSource.ELECTRIC_MARKET.getCode().equals(subAcctInfoBO.getSource())) {
            Long queryParentAccountId = this.organizationInfoService.queryParentAccountId(projectId);
            PurchaseUnitInfo selectByPrimaryKey = this.purchaseUnitInfoMapper.selectByPrimaryKey(queryParentAccountId);
            if (selectByPrimaryKey == null) {
                respBo.setStatus(SubAccountStatus.CLOSED.getCode());
            } else {
                respBo.setStatus(SubAccountStatus.ACTIVED.getCode());
            }
        }
        if ((sta = SubAccountStatus.getCode(respBo.getStatus())) != null) {
            String name = this.enumsService.getDescr(sta);
            respBo.setStatusDescr(name);
        }
        if (!"0000".equals(subAcct.getRespCode())) {
            respBo.setRespCode("8888");
            respBo.setRespDesc(subAcct.getRespDesc());
            return respBo;
        }
        if (subAcct.getStatus().equals(SubAccountStatus.CLOSED.getCode())) {
            respBo.setRespDesc("\u8d26\u6237\u65b0\u589e\u6210\u529f\uff0c\u72b6\u6001\u4e3a\u505c\u7528\uff0c\u8bf7\u7ef4\u62a4\u5408\u540c\u4fe1\u606f");
        } else {
            respBo.setRespDesc("\u65b0\u589e\u6210\u529f");
        }
        respBo.setRespCode("0000");
        return respBo;
    }

    private String getMainAcct(String source, Long mainOrg) {
        logger.info("\u5efa\u5b50\u8d26\u53f7\u67e5\u8be2\u4e3b\u8d26\u53f7,\u6765\u6e90=" + source + ",\u4e3b\u8d26\u53f7\u673a\u6784=" + mainOrg);
        if (!StringUtils.hasText((String)source)) {
            throw new BusinessException("1001", "\u6765\u6e90\u5fc5\u987b\u8f93\u5165");
        }
        if (mainOrg == null) {
            throw new BusinessException("1001", "\u4e3b\u8d26\u53f7\u7684\u673a\u6784\u53f7\u65e0\u6548");
        }
        MainAcctInfo mainInfo = this.mainAcctInfoMapper.selectByPrimaryKey(mainOrg, source);
        if (mainInfo == null) {
            throw new BusinessException("1001", "\u6b64\u673a\u6784\u5bf9\u5e94\u7684\u4e13\u4e1a\u516c\u53f8\u672a\u5f00\u901a\u6b64\u6765\u6e90\u7684\u4e3b\u8d26\u53f7");
        }
        return mainInfo.getMainAcctNo();
    }
}

