/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.atom.SubAccountRespInitService;
import com.tydic.fsc.settle.busi.api.BusiProSubAccountListService;
import com.tydic.fsc.settle.busi.api.bo.BusiSubAccountInfoReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiSubAccountInfoRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiSubAccountListRspBO;
import com.tydic.fsc.settle.busi.api.bo.SubAcctInfoExt;
import com.tydic.fsc.settle.dao.SubAcctInfoMapper;
import com.tydic.fsc.settle.dao.po.Pagination;
import com.tydic.fsc.settle.enums.SubAccountServiceType;
import com.tydic.fsc.settle.utils.BusinessUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiProSubAccountListServiceImpl
implements BusiProSubAccountListService {
    private static final Logger logger = LoggerFactory.getLogger(BusiProSubAccountListServiceImpl.class);
    @Autowired
    private SubAcctInfoMapper mapper;
    @Autowired
    private OrganizationInfoService orgService;
    @Autowired
    private SubAccountRespInitService initSerivce;

    public BusiSubAccountListRspBO listSubAccount(BusiSubAccountInfoReqBO subAcctInfoBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5b50\u8d26\u53f7\u5217\u8868\u67e5\u8be2\u5165\u53c2:" + subAcctInfoBO);
        }
        BusiSubAccountListRspBO retBo = new BusiSubAccountListRspBO();
        String validateArgStr = this.validateArg(subAcctInfoBO);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("2002");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        Long acctOrgId = subAcctInfoBO.getAcctOrgId();
        Long superiorOrgId = subAcctInfoBO.getSuperiorOrgId();
        Long companyId = subAcctInfoBO.getCompanyId();
        Long operUnitNo = subAcctInfoBO.getOperUnitNo();
        Long oprOrgId = subAcctInfoBO.getOrgId();
        if (oprOrgId == null) {
            throw new BusinessException("6001", "\u65e0\u6cd5\u8bc6\u522b\u64cd\u4f5c\u5458\u6240\u5728\u7684\u673a\u6784\u53f7");
        }
        Integer channelType = subAcctInfoBO.getChannelType();
        Pagination pageInfo = new Pagination();
        pageInfo.setPage(subAcctInfoBO.getPageNo());
        pageInfo.setPageSize(subAcctInfoBO.getPageSize());
        SubAcctInfoExt record = new SubAcctInfoExt();
        BeanUtils.copyProperties((Object)subAcctInfoBO, (Object)record);
        record.setOrgId(subAcctInfoBO.getAcctOrgId());
        record.setCompanyType(subAcctInfoBO.getAcctCompanyType());
        BusiSubAccountListRspBO resp = new BusiSubAccountListRspBO();
        if (channelType > 10 && channelType < 20) {
            if (companyId == null) {
                throw new BusinessException("6001", "\u8bf7\u6c42\u4e2d\u627e\u4e0d\u5230\u516c\u53f8\u673a\u6784\u53f7(companyId)");
            }
            superiorOrgId = BusinessUtils.judgeOperUnitNo(operUnitNo, companyId, false);
            record.setSuperiorOrgId(superiorOrgId);
            if (channelType == 11) {
                record.setOrgId(superiorOrgId);
            } else if (channelType > 20 && channelType < 30) {
                if (acctOrgId == null) {
                    throw new BusinessException("6001", "\u673a\u6784\u53f7(acctOrgId)\u5fc5\u987b\u8f93\u5165");
                }
                record.setServiceType(SubAccountServiceType.DEFAULT.getCode());
                record.setOrgId(acctOrgId);
                List<Long> childrenOrgIds = this.orgService.getChildrenOrgIds(acctOrgId);
                record.setMultiOrgIds(childrenOrgIds);
                if (childrenOrgIds != null && childrenOrgIds.size() > 0) {
                    record.setOrgId(null);
                }
            } else {
                throw new BusinessException("6001", "\u672a\u77e5\u7684\u64cd\u4f5c\u6e20\u9053\u7c7b\u578bchannelType");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u5b50\u8d26\u53f7\u67e5\u8be2\u53c2\u6570" + record);
            }
            int tot = this.mapper.selectCountWihtMainAcct(record);
            pageInfo.setTotalCount(tot);
            int rowIndex = pageInfo.getRowIndex();
            record.setPageSize(pageInfo.getPageSize());
            record.setRowIndex(Integer.valueOf(rowIndex));
            record.setOrderBy("SUB_ACCT_NAME ASC");
            List<SubAcctInfoExt> ls = this.mapper.selectWihtMainAcct(record);
            resp.setTotal(pageInfo.getPageCount().intValue());
            resp.setRecordsTotal(pageInfo.getTotalCount().intValue());
            resp.setRows(new ArrayList());
            resp.setPageNo(pageInfo.getPage().intValue());
            Map<Object, Object> serviceDepartNameMap = new HashMap();
            if (channelType == 12) {
                HashSet<Long> accountIdsSet = new HashSet<Long>();
                for (SubAcctInfoExt subAcctInfoExt : ls) {
                    accountIdsSet.add(subAcctInfoExt.getProjectId());
                }
                serviceDepartNameMap = this.orgService.queryServiceDepartNameByAccountIds(new ArrayList<Long>(accountIdsSet));
            }
            for (int i = 0; i < ls.size(); ++i) {
                SubAcctInfoExt inf = ls.get(i);
                BusiSubAccountInfoRspBO respBo = new BusiSubAccountInfoRspBO();
                resp.getRows().add(respBo);
                this.initSerivce.initRespBo(inf, respBo);
                respBo.setServiceDepartDescr((String)serviceDepartNameMap.get(inf.getProjectId()));
            }
        }
        return resp;
    }

    private String validateArg(BusiSubAccountInfoReqBO reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getChannelType())) {
            return "channelType\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

