/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.busi.api.BusiProcessInvoiceDataInOutService;
import com.tydic.fsc.settle.busi.api.bo.BusiProcessInvoiceInOutReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiProcessInvoiceInOutRspBO;
import com.tydic.fsc.settle.busi.api.vo.BillNotificationInfoVO;
import com.tydic.fsc.settle.busi.api.vo.BusiProcessInvoiceInOutVO;
import com.tydic.fsc.settle.busi.api.vo.InvoiceDetailVO;
import com.tydic.fsc.settle.busi.api.vo.InvoiceInfoVO;
import com.tydic.fsc.settle.dao.BillNotificationInfoMapper;
import com.tydic.fsc.settle.dao.PayInvoiceDetailMapper;
import com.tydic.fsc.settle.dao.PayInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.PayItemInfoMapper;
import com.tydic.fsc.settle.dao.po.BillNotificationInfo;
import com.tydic.fsc.settle.dao.po.PayInvoiceDetail;
import com.tydic.fsc.settle.dao.po.PayInvoiceInfo;
import com.tydic.fsc.settle.dao.po.PayItemInfo;
import com.tydic.fsc.settle.dao.vo.PayItemInfoExt;
import com.tydic.fsc.settle.enums.InvoiceMailStatus;
import com.tydic.fsc.settle.enums.InvoiceStatus;
import com.tydic.fsc.settle.enums.InvoiceType;
import com.tydic.fsc.settle.enums.NotificationInvoiceStatus;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiProcessInvoiceDataInOutServiceImpl
implements BusiProcessInvoiceDataInOutService {
    private static final Logger logger = LoggerFactory.getLogger(BusiProcessInvoiceDataInOutServiceImpl.class);
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private PayInvoiceDetailMapper payInvoiceDetailMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;

    public BusiProcessInvoiceInOutRspBO processInvoiceInOut(BusiProcessInvoiceInOutReqBO reqBO) {
        BusiProcessInvoiceInOutVO data;
        if (logger.isDebugEnabled()) {
            logger.debug("\u53d1\u7968\u6570\u636e\u5bfc\u5165\u5bfc\u51fa\u5165\u53c2=" + reqBO);
        }
        if ((data = reqBO.getData()) == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u672a\u53d1\u73b0\u6709\u6548\u7684\u6570\u636e(data)");
        }
        Integer processType = data.getProcessType();
        String notificationNo = data.getNotificationNo();
        Long companyId = reqBO.getCompanyId();
        Long supplierNo = data.getSupplierNo();
        if (processType == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fc5\u987b\u6307\u5b9a\u5904\u7406\u7c7b\u578b(processType)");
        }
        if (companyId == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65e0\u6cd5\u786e\u5b9a\u4e13\u4e1a\u516c\u53f8(companyId)");
        }
        if (supplierNo == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5fc5\u987b\u6307\u5b9a\u4f9b\u5e94\u5546ID(supplierNo)");
        }
        BillNotificationInfo bill = this.billNotificationInfoMapper.selectByPrimaryAndCompany(notificationNo, companyId);
        if (bill == null) {
            logger.info("\u53d1\u7968\u5bfc\u5165\u5bfc\u51fa\u5904\u7406\u5931\u8d25,\u5f00\u7968\u901a\u77e5\u5355\u4e0d\u5b58\u5728,\u901a\u77e5\u5355=" + notificationNo + ",companyID=" + companyId);
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5f00\u7968\u901a\u77e5\u5355" + notificationNo + "\u4e0d\u5b58\u5728");
        }
        if (!bill.getSupplierNo().equals(supplierNo)) {
            logger.info("\u53d1\u7968\u5bfc\u5165\u5bfc\u51fa\u5904\u7406\u5931\u8d25,\u5f00\u7968\u901a\u77e5\u5355\u4e0d\u5c5e\u4e8e\u6307\u5b9a\u7684\u4f9b\u5e94\u5546,\u901a\u77e5\u5355=" + notificationNo + ",supplierNo=" + supplierNo);
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5f00\u7968\u901a\u77e5\u5355" + notificationNo + "\u4e0d\u5b58\u5728!!!");
        }
        NotificationInvoiceStatus iSta = NotificationInvoiceStatus.getInstance(bill.getInvoiceStatus());
        if (iSta == NotificationInvoiceStatus.RECEIVED) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5f00\u7968\u901a\u77e5\u5355\u53f7\u7684\u53d1\u7968\u5df2\u6536\u7968,\u4e0d\u5141\u8bb8\u518d\u5904\u7406");
        }
        BusiProcessInvoiceInOutRspBO resp = new BusiProcessInvoiceInOutRspBO();
        resp.setData(new BusiProcessInvoiceInOutVO());
        if (processType == 1) {
            data = resp.getData();
            BillNotificationInfoVO vo = new BillNotificationInfoVO();
            BeanUtils.copyProperties((Object)bill, (Object)vo);
            InvoiceType ivType = InvoiceType.getInstance(bill.getInvoceType());
            data.setNotification(vo);
            if (ivType != null) {
                vo.setInvoiceTypeDescr(ivType.getDescr());
            }
            if (StringUtils.hasText((String)vo.getBankAccNo())) {
                vo.setBankAccNo(vo.getBankAccNo().replaceAll(" ", ""));
            }
            data.setInvoices(new ArrayList());
            List<PayItemInfoExt> payItemExtList = this.payItemInfoMapper.selectListByNotificationNo(notificationNo);
            logger.debug("--\u5bfc\u51fa\u5f00\u7968\u901a\u77e5\u5355[" + notificationNo + "]\u6570\u636e,\u6d89\u53ca\u5546\u54c1\u660e\u7ec6\u6570\u91cf=" + payItemExtList.size());
            InvoiceInfoVO invoice = new InvoiceInfoVO();
            data.getInvoices().add(invoice);
            invoice.setNotificationNo(notificationNo);
            invoice.setInvoiceDetails(new ArrayList());
            for (PayItemInfoExt payItemInfoExt : payItemExtList) {
                InvoiceDetailVO ivDetail = new InvoiceDetailVO();
                invoice.getInvoiceDetails().add(ivDetail);
                ivDetail.setOrderId(payItemInfoExt.getPurchaseOrderCode());
                ivDetail.setItemNo(payItemInfoExt.getItemNo());
                ivDetail.setItemName(payItemInfoExt.getItemName());
                ivDetail.setSpecOrModel(payItemInfoExt.getSpec());
                ivDetail.setItemUnit(payItemInfoExt.getUnitName());
                ivDetail.setQuantity(payItemInfoExt.getQuantity());
                ivDetail.setPriceIntax(payItemInfoExt.getPurchaseUnitPrice());
                ivDetail.setIdentify(payItemInfoExt.getItemNo() + "-" + payItemInfoExt.getSeq());
                ivDetail.setInvoiceNo(payItemInfoExt.getInvoiceNo());
                ivDetail.setInvoiceCode(payItemInfoExt.getInvoiceCode());
                ivDetail.setInvoiceDate(payItemInfoExt.getInvoiceDate());
                ivDetail.setSkuId(payItemInfoExt.getSkuId());
                if (StringUtils.isEmpty((Object)ivDetail.getInvoiceNo()) || StringUtils.isEmpty((Object)ivDetail.getInvoiceCode())) {
                    BigDecimal rate = payItemInfoExt.getTaxRate();
                    ivDetail.setTaxRate(rate);
                    ivDetail.setAmount(payItemInfoExt.getAmount());
                    if (rate != null) {
                        rate = rate.add(new BigDecimal("1"));
                        BigDecimal untaxAmt = payItemInfoExt.getAmount().divide(rate, 2, 4);
                        ivDetail.setUntaxAmt(untaxAmt);
                        ivDetail.setTaxAmt(payItemInfoExt.getAmount().subtract(untaxAmt));
                        untaxAmt = untaxAmt.divide(payItemInfoExt.getQuantity(), 8, 4);
                        ivDetail.setPriceUntax(untaxAmt);
                    }
                } else {
                    ivDetail.setQuantity(payItemInfoExt.getRealQuantity());
                    ivDetail.setAmount(payItemInfoExt.getRealAmount());
                    ivDetail.setTaxRate(payItemInfoExt.getRealTaxrate());
                    ivDetail.setUntaxAmt(payItemInfoExt.getUntaxAmt());
                    ivDetail.setTaxAmt(payItemInfoExt.getTaxAmt());
                    ivDetail.setPriceUntax(payItemInfoExt.getPriceUntax());
                }
                StringBuffer specModelFigureNo = new StringBuffer();
                if (StringUtils.hasText((String)payItemInfoExt.getSpec())) {
                    specModelFigureNo.append(payItemInfoExt.getSpec()).append("\\");
                }
                if (StringUtils.hasText((String)payItemInfoExt.getModel())) {
                    specModelFigureNo.append(payItemInfoExt.getModel()).append("\\");
                }
                if (StringUtils.hasText((String)payItemInfoExt.getFigureNo())) {
                    specModelFigureNo.append(payItemInfoExt.getFigureNo()).append("\\");
                }
                if (specModelFigureNo.length() < 1) continue;
                ivDetail.setSpecModelFigureNo(specModelFigureNo.toString().substring(0, specModelFigureNo.length() - 1));
            }
        } else if (processType == 2) {
            List invoiceVoLs = data.getInvoices();
            if (invoiceVoLs == null || invoiceVoLs.size() == 0) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u672a\u53d1\u73b0\u53d1\u7968\u6570\u636e(invoices)");
            }
            logger.debug("---\u5bfc\u5165\u53d1\u7968\u6570\u636e,\u9700\u5bfc\u5165\u7684\u53d1\u7968\u6570\u91cf:" + invoiceVoLs.size());
            List<PayInvoiceInfo> oldInvoices = this.payInvoiceInfoMapper.selectByNotifyNo(notificationNo);
            for (PayInvoiceInfo oldInvoice : oldInvoices) {
                this.payInvoiceDetailMapper.deleteByInvoiceNo(oldInvoice.getInvoiceCode(), oldInvoice.getInvoiceNo(), oldInvoice.getInvoiceDate());
                this.payInvoiceInfoMapper.deleteByPrimaryKey(oldInvoice.getInvoiceCode(), oldInvoice.getInvoiceNo(), oldInvoice.getInvoiceDate());
            }
            List<PayItemInfo> sampItems = this.payItemInfoMapper.selectByNotifNo(notificationNo);
            if (sampItems.size() == 0) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u672a\u53d1\u73b0\u901a\u77e5\u5355\u76f8\u5173\u7684\u5546\u54c1\u660e\u7ec6");
            }
            ArrayList<PayInvoiceInfo> newInvoices = new ArrayList<PayInvoiceInfo>();
            ArrayList<PayInvoiceDetail> newIvDetails = new ArrayList<PayInvoiceDetail>();
            ArrayList<PayItemInfo> sampsForUpdate = new ArrayList<PayItemInfo>();
            HashSet<Long> payItemSeqSet = new HashSet<Long>();
            HashSet<String> invoiceNoSet = new HashSet<String>();
            BigDecimal amtTotal = BigDecimal.ZERO;
            for (InvoiceInfoVO ivVo : invoiceVoLs) {
                String payNotificationNo;
                Date invoiceDateLs;
                String invoiceNoLs;
                String invoiceCodeLs = ivVo.getInvoiceCode();
                PayInvoiceInfo payInvoiceData = this.payInvoiceInfoMapper.selectByPrimaryKey(invoiceCodeLs, invoiceNoLs = ivVo.getInvoiceNo(), invoiceDateLs = ivVo.getInvoiceDate());
                if (payInvoiceData != null && !notificationNo.equals(payNotificationNo = payInvoiceData.getNotificationNo())) {
                    String invoiceDateLsStr = "";
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    try {
                        invoiceDateLsStr = sdf.format(invoiceDateLs);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u53d1\u7968\u4ee3\u7801" + invoiceCodeLs + ",\u53d1\u7968\u53f7\u7801" + invoiceNoLs + ",\u5f00\u7968\u65e5\u671f" + invoiceDateLsStr + "\u5df2\u7ecf\u5728\u5f00\u7968\u901a\u77e5\u5355" + payNotificationNo + "\u4e2d\u4f7f\u7528\u3002");
                }
                logger.debug("\u5bfc\u5165\u7684\u901a\u77e5\u5355\u53f7\u3001\u53d1\u7968\u4ee3\u7801\u3001\u53d1\u7968\u53f7\u7801\u3001\u5f00\u7968\u65e5\u671f:" + notificationNo + "-" + invoiceCodeLs + "-" + invoiceNoLs + "-" + invoiceDateLs);
                PayInvoiceInfo iv = new PayInvoiceInfo();
                BeanUtils.copyProperties((Object)ivVo, (Object)iv);
                iv.setInvoiceType(bill.getInvoceType());
                iv.setAddress(bill.getAddr());
                iv.setBankName(bill.getBankName());
                iv.setBankAcNo(bill.getBankAccNo());
                iv.setAmt(ivVo.getAmt());
                iv.setNotTaxAmt(ivVo.getNotTaxAmt());
                iv.setInvoiceStatus(InvoiceStatus.HAS_MAKE.getCode());
                iv.setMailStatus(InvoiceMailStatus.NOT_SIGNED.getCode());
                List detailVoLs = ivVo.getInvoiceDetails();
                if (detailVoLs == null || detailVoLs.size() == 0) {
                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u672a\u53d1\u73b0\u53d1\u7968" + iv.getInvoiceNo() + "\u7684\u660e\u7ec6\u6570\u636e");
                }
                logger.debug("---\u5bfc\u5165\u53d1\u7968\u6570\u636e,\u53d1\u7968" + iv.getInvoiceNo() + "\u7684\u660e\u7ec6\u6570\u91cf=" + detailVoLs.size() + ",\u603b\u91d1\u989d=" + iv.getAmt());
                BigDecimal amt = BigDecimal.ZERO;
                BigDecimal untaxAmt = BigDecimal.ZERO;
                BigDecimal taxAmt = BigDecimal.ZERO;
                for (InvoiceDetailVO detailVo : detailVoLs) {
                    PayInvoiceDetail ivDetail = new PayInvoiceDetail();
                    BeanUtils.copyProperties((Object)detailVo, (Object)ivDetail);
                    newIvDetails.add(ivDetail);
                    this.zeroCheck(ivDetail.getAmount(), ivDetail.getItemName() + "\u7684\u91d1\u989d\u4e0d\u6b63\u786e(\u5fc5\u987b\u5927\u4e8e0)");
                    this.zeroCheck(ivDetail.getUntaxAmt(), ivDetail.getItemName() + "\u7684\u4e0d\u542b\u7a0e\u91d1\u989d\u4e0d\u6b63\u786e(\u5fc5\u987b\u5927\u4e8e0)");
                    this.zeroCheck(ivDetail.getTaxAmt(), ivDetail.getItemName() + "\u7684\u7a0e\u989d\u4e0d\u6b63\u786e(\u5fc5\u987b\u5927\u4e8e0)");
                    this.zeroCheck(ivDetail.getPriceUntax(), ivDetail.getItemName() + "\u7684\u4e0d\u542b\u7a0e\u5355\u4ef7\u91d1\u989d\u4e0d\u6b63\u786e(\u5fc5\u987b\u5927\u4e8e0)");
                    this.zeroCheck(ivDetail.getTaxRate(), ivDetail.getItemName() + "\u7684\u4e0d\u542b\u7a0e\u5355\u4ef7\u91d1\u989d\u4e0d\u6b63\u786e(\u5fc5\u987b\u5927\u4e8e0)");
                    if (ivDetail.getAmount().compareTo(ivDetail.getUntaxAmt().add(ivDetail.getTaxAmt())) != 0) {
                        logger.error("\u53d1\u7968\u660e\u7ec6\u91d1\u989d(\u4e0d\u542b\u7a0e)\u3001\u7a0e\u989d\u4e4b\u548c\u4e0e\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u76f8\u7b49,\u901a\u77e5\u5355\u53f7=" + bill.getNotificationNo());
                        throw new BusinessException("1002", "\u53d1\u7968\u660e\u7ec6\u91d1\u989d(\u4e0d\u542b\u7a0e)\u3001\u7a0e\u989d\u4e4b\u548c\u4e0e\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u76f8\u7b49");
                    }
                    amt = amt.add(ivDetail.getAmount());
                    untaxAmt = untaxAmt.add(ivDetail.getUntaxAmt());
                    taxAmt = taxAmt.add(ivDetail.getTaxAmt());
                    String ordId = detailVo.getOrderId();
                    String identify = detailVo.getIdentify();
                    PayItemInfo matchSamp = null;
                    for (int s = 0; s < sampItems.size(); ++s) {
                        PayItemInfo samp = sampItems.get(s);
                        String sampIdentify = samp.getItemNo() + "-" + samp.getSeq();
                        if (!sampIdentify.equals(identify)) continue;
                        matchSamp = samp;
                        payItemSeqSet.add(matchSamp.getSeq());
                        break;
                    }
                    if (matchSamp == null) {
                        logger.error("--\u5bfc\u5165\u53d1\u7968\u6570\u636e\u5931\u8d25,\u65e0\u6cd5\u627e\u5230\u53d1\u7968\u660e\u7ec6\u5bf9\u5e94\u7684\u5546\u54c1\u660e\u7ec6,\u901a\u77e5\u5355\u53f7=" + bill.getNotificationNo() + " \u5546\u54c1=" + detailVo.getItemName() + ",\u8ba2\u5355\u53f7=" + ordId + ",\u8bc6\u522b=" + identify);
                        throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65e0\u6cd5\u627e\u5230\u539f\u59cb\u5546\u54c1\u660e\u7ec6,\u5355\u53f7\u53ca\u884c\u53f7\u4e0d\u5339\u914d,\u5546\u54c1=" + detailVo.getItemName() + ",\u8ba2\u5355\u53f7=" + ordId + ",\u884c\u53f7=" + identify);
                    }
                    ivDetail.setSkuId(matchSamp.getSkuId());
                    ivDetail.setItemNo(matchSamp.getItemNo());
                    ivDetail.setOrderCode(matchSamp.getPurchaseOrderCode());
                    ivDetail.setOrderId(matchSamp.getOrderId());
                    ivDetail.setInspectionId(matchSamp.getInspectionId());
                    invoiceNoSet.add(ivDetail.getInvoiceNo());
                }
                if (amt.compareTo(untaxAmt.add(taxAmt)) != 0) {
                    logger.error("\u91d1\u989d(\u4e0d\u542b\u7a0e)\u3001\u7a0e\u989d\u4e4b\u548c\u4e0e\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u76f8\u7b49,\u901a\u77e5\u5355\u53f7=" + bill.getNotificationNo());
                    throw new BusinessException("1002", "\u91d1\u989d(\u4e0d\u542b\u7a0e)\u3001\u7a0e\u989d\u4e4b\u548c\u4e0e\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u76f8\u7b49");
                }
                iv.setAmt(amt);
                iv.setNotTaxAmt(untaxAmt);
                iv.setTaxAmt(taxAmt);
                newInvoices.add(iv);
                amtTotal = amtTotal.add(amt);
            }
            this.clearOldInvoice(bill.getNotificationNo());
            this.payInvoiceDetailMapper.insertByBatch(newIvDetails);
            this.payInvoiceInfoMapper.batchInsert(newInvoices);
            for (PayItemInfo payItemInfo : sampItems) {
                if (!payItemSeqSet.contains(payItemInfo.getSeq())) continue;
                Long itemNo = payItemInfo.getItemNo();
                Long inspectionId = payItemInfo.getInspectionId();
                BigDecimal payItemAmount = payItemInfo.getAmount();
                PayInvoiceDetail payDetailsInfo = this.payInvoiceDetailMapper.selectBySomeConditions(itemNo, inspectionId, invoiceNoSet);
                logger.debug("\u53d1\u7968\u660e\u7ec6\u91d1\u989d\u4e3a:" + payDetailsInfo.getAmount() + ",\u5546\u54c1\u91d1\u989d\u4e3a:" + payItemAmount + ", \u5546\u54c1\u660e\u7ec6\u4e3b\u952e\u4e3a\uff1a" + payItemInfo.getSeq());
                if (payItemAmount.compareTo(payDetailsInfo.getAmount()) != 0) {
                    String payItemInfoIdentify = payItemInfo.getItemNo() + "-" + payItemInfo.getSeq();
                    logger.error("--\u5546\u54c1\u7684\u5f00\u7968\u660e\u7ec6\u91d1\u989d\u4e0e\u5546\u54c1\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u5546\u54c1\u884c\u53f7-\u5546\u54c1ID\uff1a" + payItemInfoIdentify + ",\u901a\u77e5\u5355\u53f7=" + bill.getNotificationNo());
                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u7684\u5f00\u7968\u660e\u7ec6\u91d1\u989d\u4e0e\u5546\u54c1\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u5546\u54c1\u884c\u53f7-\u5546\u54c1ID\uff1a" + payItemInfoIdentify);
                }
                PayItemInfo updatePayItemInfo = new PayItemInfo();
                updatePayItemInfo.setInvoiceCode(payDetailsInfo.getInvoiceCode());
                updatePayItemInfo.setInvoiceNo(payDetailsInfo.getInvoiceNo());
                updatePayItemInfo.setItemStatus("02");
                updatePayItemInfo.setSeq(payItemInfo.getSeq());
                sampsForUpdate.add(updatePayItemInfo);
            }
            if (amtTotal.compareTo(bill.getAmt()) >= 0) {
                BillNotificationInfo forUpdate = new BillNotificationInfo();
                forUpdate.setNotificationNo(bill.getNotificationNo());
                forUpdate.setInvoiceStatus(NotificationInvoiceStatus.HAS_MAKE.getCode());
                this.billNotificationInfoMapper.updateByPrimaryKeySelective(forUpdate);
            }
            this.updateSampsInvoiceNo(notificationNo, sampsForUpdate);
            logger.info("--\u5bfc\u5165\u901a\u77e5\u5355[" + bill.getNotificationNo() + "]\u53d1\u7968\u5b8c\u6210,\u53d1\u7968\u6570\u91cf=" + newInvoices.size());
        } else {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65e0\u6cd5\u8bc6\u522b\u7684\u5904\u7406\u7c7b\u578b(processType)");
        }
        return resp;
    }

    private void clearOldInvoice(String notificationNo) {
        List<PayInvoiceInfo> ls = this.payInvoiceInfoMapper.selectByNotifyNo(notificationNo);
        logger.info("--\u901a\u77e5\u5355[" + notificationNo + "]\u6d89\u53ca\u7684\u9700\u6e05\u9664\u65e7\u53d1\u7968\u6570\u91cf=" + ls.size());
        for (PayInvoiceInfo iv : ls) {
            int cnt = this.payInvoiceDetailMapper.deleteByInvoiceNo(iv.getInvoiceCode(), iv.getInvoiceNo(), iv.getInvoiceDate());
            logger.info("--\u5220\u9664\u65e7\u53d1\u7968[" + iv.getInvoiceNo() + "]\u6570\u636e\u660e\u7ec6,\u6570\u91cf=" + cnt);
            this.payInvoiceInfoMapper.deleteByPrimaryKey(iv.getInvoiceCode(), iv.getInvoiceNo(), iv.getInvoiceDate());
        }
    }

    private void updateSampsInvoiceNo(String notificationNo, List<PayItemInfo> sampsForUpdate) {
        if (sampsForUpdate.size() == 0) {
            return;
        }
        for (PayItemInfo item : sampsForUpdate) {
            int cnt = this.payItemInfoMapper.updateByPrimaryKeySelective(item);
            logger.info("\u5bfc\u5165\u53d1\u7968,\u66f4\u65b0\u5546\u54c1\u660e\u7ec6,\u901a\u77e5\u5355\u53f7=" + notificationNo + ",\u5546\u54c1seq=" + item.getSeq() + ",\u53d1\u7968\u53f7=" + item.getInvoiceNo() + ",\u66f4\u65b0\u6570=" + cnt);
        }
    }

    private void zeroCheck(BigDecimal amt, String errMsg) {
        if (amt == null || BigDecimal.ZERO.compareTo(amt) >= 0) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", errMsg);
        }
    }
}

