/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.bo.FscPageRspBo;
import com.tydic.fsc.settle.busi.api.BusiQryNotificationListSelfUseService;
import com.tydic.fsc.settle.busi.api.bo.BusiQryNotificationListReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQryNotificationListSelfUseReqBO;
import com.tydic.fsc.settle.busi.api.vo.BillNotificationInfoVO;
import com.tydic.fsc.settle.dao.BillNotificationInfoMapper;
import com.tydic.fsc.settle.dao.EntryInfoMapper;
import com.tydic.fsc.settle.dao.po.BillNotificationInfo;
import com.tydic.fsc.settle.dao.po.EntryInfoPO;
import com.tydic.fsc.settle.enums.NotificationInvoiceStatus;
import com.tydic.fsc.settle.enums.PurchaseSaleType;
import com.tydic.fsc.settle.utils.AntiSqlInjectionManage;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiQryNotificationListSelfUseServiceImpl
implements BusiQryNotificationListSelfUseService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQryNotificationListSelfUseServiceImpl.class);
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private EntryInfoMapper entryInfoMapper;

    public FscPageRspBo<BillNotificationInfoVO> query(BusiQryNotificationListSelfUseReqBO reqBO) {
        logger.info("\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        if (null == reqBO.getCompanyId()) {
            throw new BusinessException("1001", "\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u5217\u8868\u4e1a\u52a1\u670d\u52a1-Session\u4e13\u4e1a\u516c\u53f8[companyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSource()) {
            throw new BusinessException("1001", "\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u5217\u8868\u4e1a\u52a1\u670d\u52a1-\u6765\u6e90[source]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBO.setOperUnitNo(null);
        String orderBy = null;
        if (!StringUtils.isEmpty((CharSequence)reqBO.getSortName()) && !StringUtils.isEmpty((CharSequence)reqBO.getSortOrder())) {
            if (AntiSqlInjectionManage.sqlValidate(reqBO.getSortName()) || AntiSqlInjectionManage.sqlValidate(reqBO.getSortOrder())) {
                logger.error("\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
                throw new BusinessException("1002", "\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
            }
            orderBy = reqBO.getSortName() + " " + reqBO.getSortOrder();
        } else {
            orderBy = " APPLY_DATE desc,NOTIFICATION_NO desc";
        }
        FscPageRspBo rspPageBO = new FscPageRspBo();
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        LinkedList<BillNotificationInfoVO> result = new LinkedList<BillNotificationInfoVO>();
        try {
            reqBO.setPurchaseSaleType(PurchaseSaleType.SELFUSE.getCode());
            BusiQryNotificationListReqBO billNotifReqBO = new BusiQryNotificationListReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)billNotifReqBO);
            List<BillNotificationInfo> resultPO = this.billNotificationInfoMapper.getListPage(billNotifReqBO, true, (Page<Map<String, Object>>)page, orderBy);
            for (BillNotificationInfo notifyInfo : resultPO) {
                BillNotificationInfoVO resultVO = new BillNotificationInfoVO();
                BeanUtils.copyProperties((Object)notifyInfo, (Object)resultVO);
                resultVO.setNotifInvoiceStatus(notifyInfo.getInvoiceStatus());
                NotificationInvoiceStatus notifInvoiceEnum = NotificationInvoiceStatus.getInstance(resultVO.getNotifInvoiceStatus());
                resultVO.setNotifInvoiceStatusStr(this.enumsService.getDescr(notifInvoiceEnum));
                String supplierStr = this.organizationInfoService.querySupplierName(resultVO.getSupplierNo());
                resultVO.setSupplierName(supplierStr);
                PurchaseSaleType purchaseSaleTypeEnum = PurchaseSaleType.getInstance(resultVO.getPurchaseSaleType());
                resultVO.setPurchaseSaleTypeStr(this.enumsService.getDescr(purchaseSaleTypeEnum));
                if ("03".equals(notifyInfo.getInvoiceStatus())) {
                    EntryInfoPO entryInfoPO;
                    EntryInfoPO entryInfo = new EntryInfoPO();
                    entryInfo.setNotificationNo(notifyInfo.getNotificationNo());
                    entryInfo.setPurchaseId(notifyInfo.getSupplierNo());
                    List<EntryInfoPO> list = this.entryInfoMapper.getModelListBy(entryInfo);
                    if (list != null && list.size() > 0 && (entryInfoPO = list.get(0)) != null) {
                        resultVO.setSignDate(entryInfoPO.getEntryDate());
                    }
                }
                result.add(resultVO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u5217\u8868\u4e1a\u52a1\u670d\u52a1-\u6570\u636e\u5e93\u64cd\u4f5c\u9519\u8bef");
        }
        rspPageBO.setRows(result);
        rspPageBO.setRecordsTotal(page.getTotalCount());
        rspPageBO.setTotal(page.getTotalPages());
        rspPageBO.setPageNo(page.getPageNo());
        return rspPageBO;
    }
}

