/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.atom.UserInfoService;
import com.tydic.fsc.settle.busi.api.BusiQueryBillApplyInfoService;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryBillApplyInfoDetailRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryBillApplyInfoReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryBillApplyInfoRspBO;
import com.tydic.fsc.settle.dao.BillApplyInfoMapper;
import com.tydic.fsc.settle.dao.SaleInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.po.BillApplyInfo;
import com.tydic.fsc.settle.dao.po.SaleInvoiceInfo;
import com.tydic.fsc.settle.dao.vo.BillApplyInfoVO;
import com.tydic.fsc.settle.dao.vo.SaleInvoiceInfoVO;
import com.tydic.fsc.settle.enums.BaseEnums;
import com.tydic.fsc.settle.enums.BillStatus;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.SaleInvoiceInfoInvoiceStatus;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiQueryBillApplyInfoServiceImpl
implements BusiQueryBillApplyInfoService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQueryBillApplyInfoServiceImpl.class);
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private UserInfoService userInfoService;

    public BusiQueryBillApplyInfoRspBO query(BusiQueryBillApplyInfoReqBO reqBO) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5f00\u7968\u7533\u8bf7\u670d\u52a1(\u7535\u5b50\u8d85\u5e02)(\u4e13\u4e1a\u516c\u53f8\u548c\u91c7\u8d2d\u5355\u4f4d\u5171\u7528)\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new BusinessException("1001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getIsOperUnit())) {
            throw new BusinessException("1001", "\u662f\u5426\u4e13\u4e1a\u516c\u53f8\u7528\u6237\u3010isOperUnit\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("0".equals(reqBO.getIsOperUnit()) && reqBO.getPurchaseProjectId() == null) {
            throw new BusinessException("1001", "\u91c7\u8d2d\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)billApplyInfoVO);
        billApplyInfoVO.setReturnBillNoIsNull("1");
        billApplyInfoVO.setSource(OrderSource.ELECTRIC_MARKET.getCode());
        if (null != reqBO.getUserNameLike() && StringUtils.hasText((String)reqBO.getUserNameLike())) {
            List<Long> userIdList = this.userInfoService.queryUserIdListByUserNameLike(reqBO.getUserNameLike());
            if (userIdList.isEmpty()) {
                userIdList.add(-1L);
            }
            billApplyInfoVO.setUserIdList(userIdList);
        }
        if ("1".equals(reqBO.getIsOperUnit())) {
            billApplyInfoVO.setOperUnitNo(reqBO.getCompanyId());
        }
        if (billApplyInfoVO.getApplyDateEnd() != null) {
            try {
                String applyDateEndString = new SimpleDateFormat("yyyy-MM-dd").format(billApplyInfoVO.getApplyDateEnd()) + " 23:59:59";
                billApplyInfoVO.setApplyDateEnd(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(applyDateEndString));
            }
            catch (ParseException e) {
                throw new BusinessException("1002", "\u683c\u5f0f\u5316\u65e5\u671f\u51fa\u9519");
            }
        }
        billApplyInfoVO.setOrderBy("t.APPLY_NO DESC");
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<BillApplyInfo> billApplyInfoList = null;
        billApplyInfoList = reqBO.getInvoiceNoStart() == null && reqBO.getInvoiceNoEnd() == null && reqBO.getInvoiceDateStart() == null && reqBO.getInvoiceDateEnd() == null ? this.billApplyInfoMapper.getListPage(billApplyInfoVO, (Page<Map<String, Object>>)page) : this.billApplyInfoMapper.getListPageForQryBillApply(billApplyInfoVO, (Page<Map<String, Object>>)page);
        ArrayList<BusiQueryBillApplyInfoDetailRspBO> rows = new ArrayList<BusiQueryBillApplyInfoDetailRspBO>();
        for (BillApplyInfo billApplyInfo : billApplyInfoList) {
            BusiQueryBillApplyInfoDetailRspBO row = new BusiQueryBillApplyInfoDetailRspBO();
            BeanUtils.copyProperties((Object)billApplyInfo, (Object)row);
            row.setPurchaseProjectName(this.organizationInfoService.queryProjectName(billApplyInfo.getPurchaseProjectId()));
            SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
            saleInvoiceInfoVO.setApplyNo(billApplyInfo.getApplyNo());
            List<SaleInvoiceInfo> saleInvoiceInfoList = this.saleInvoiceInfoMapper.selectBy(saleInvoiceInfoVO);
            String invoiceNos = "";
            String invoiceDates = "";
            if (saleInvoiceInfoList != null && !saleInvoiceInfoList.isEmpty()) {
                for (SaleInvoiceInfo saleInvoiceInfo : saleInvoiceInfoList) {
                    invoiceNos = SaleInvoiceInfoInvoiceStatus.CANCEL.getCode().equals(saleInvoiceInfo.getInvoiceStatus()) ? invoiceNos + "(" + saleInvoiceInfo.getInvoiceNo() + "\u4f5c\u5e9f)," : invoiceNos + saleInvoiceInfo.getInvoiceNo() + ",";
                    invoiceDates = invoiceDates + new SimpleDateFormat("yyyy-MM-dd").format(saleInvoiceInfo.getInvoiceDate()) + ",";
                }
                invoiceNos = invoiceNos.substring(0, invoiceNos.length() - 1);
                invoiceDates = invoiceDates.substring(0, invoiceDates.length() - 1);
            }
            row.setInvoiceNos(invoiceNos);
            row.setInvoiceDates(invoiceDates);
            row.setBillStatusDescr(this.enumsService.getDescr(BillStatus.getInstance(billApplyInfo.getBillStatus())));
            row.setSourceDescr(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)billApplyInfo.getSource())));
            row.setSubUserName(this.userInfoService.queryUserNameByUserId(billApplyInfo.getUserId()));
            rows.add(row);
        }
        BusiQueryBillApplyInfoRspBO rspBO = new BusiQueryBillApplyInfoRspBO();
        rspBO.setRows(rows);
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setPageNo(page.getPageNo());
        return rspBO;
    }
}

